/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.expressplus;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    public static final char FS = '\u001c';
    public static final char GS = '\u001d';
    public static final char RS = '\u001e';
    public static final String REQ = "REQ";
    public static final String IPNAME = "iPNAME";
    public static final String RTYPE = "rTYPE";
    public static final String RCUP = "rCUP";
    public static final String RPRIO = "rPRIO";
    public static final String TEST = "TS=";
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (!message.equals("") && message.length() == message.indexOf(this.getMsgEnd()) + 1) {
                message = this.getPortaCOM().removeInputString(this.getMsgEnd());
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0004');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public String parse(String message) {
        try {
            if (message.startsWith(this.getMsgStart()) && message.endsWith(this.getMsgEnd())) {
                HashMap<String, String> fields = new HashMap<String, String>();
                StringTokenizer stks = new StringTokenizer(message, String.valueOf('\u001e'));
                while (stks.hasMoreElements()) {
                    String record = (String)stks.nextElement();
                    StringTokenizer stks2 = new StringTokenizer(record, String.valueOf('\u001c'));
                    while (stks2.hasMoreElements()) {
                        String field = (String)stks2.nextElement();
                        String[] group = field.split(String.format("[%s]", String.valueOf('\u001d')));
                        if (group.length < 2) continue;
                        fields.put(group[0], group[1]);
                    }
                }
                this.parseResults(fields);
            }
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada("Erro ao receber resultado do equipamento!");
            e.printStackTrace();
        }
        return null;
    }

    private void parseResults(Map<String, String> fields) throws Exception {
        String sampleId = fields.get(REQ);
        sampleId = Funcoes.preencheZero(sampleId.trim(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo());
        String fil_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = sampleId.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = sampleId.substring(ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        if (!(Funcoes.isNumeric(fil_codigo) && Funcoes.isNumeric(req_codigo) && Funcoes.isNumeric(rec_codigo) && Integer.parseInt(fil_codigo) != 0)) {
            this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o com formato fora do padr\u00e3o %s %s %s ", fil_codigo, req_codigo, rec_codigo));
            return;
        }
        Statement st = Conexao.getStatement();
        boolean pos = false;
        for (String key : fields.keySet()) {
            String int_codigo;
            String emi_alternativo;
            block8: {
                if (!key.startsWith(TEST)) continue;
                emi_alternativo = key.substring(TEST.length());
                int_codigo = "";
                try {
                    int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                    if (int_codigo == null) {
                        this.fireExcecaoEncontrada(String.format("C\u00f3digo LIS do exame %s n\u00e3o encontrado para requisi\u00e7\u00e3o %s %s %s (Interface n\u00e3o Localizada)", emi_alternativo, fil_codigo, req_codigo, rec_codigo));
                    }
                    break block8;
                }
                catch (Exception e) {
                    this.fireExcecaoEncontrada(String.format("C\u00f3digo LIS do exame %s n\u00e3o encontrado para requisi\u00e7\u00e3o %s %s %s (Erro ao localizar Interface)", emi_alternativo, fil_codigo, req_codigo, rec_codigo));
                }
                continue;
            }
            ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
            if (exame == null) {
                this.fireExcecaoEncontrada(String.format("C\u00f3digo LIS do exame %s n\u00e3o encontrado para requisi\u00e7\u00e3o %s %s %s (Exame n\u00e3o localizado)", emi_alternativo, fil_codigo, req_codigo, rec_codigo));
                continue;
            }
            String campoQuanti = "resultado_quantitativo";
            String res = fields.get(key).replaceFirst("\\.", ",");
            int sit = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
            if (sit == 3 || sit == 2) {
                campoQuanti = "repeticao_quantitativo";
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, null, 3);
            }
            if (sit == 4) {
                this.fireExcecaoEncontrada(String.format("C\u00f3digo LIS do exame %s para requisi\u00e7\u00e3o %s %s %s (j\u00e1 repetido)", emi_alternativo, fil_codigo, req_codigo, rec_codigo));
                continue;
            }
            HashMap<String, Object> dados = new HashMap<String, Object>();
            dados.put(campoQuanti, res);
            this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
        }
    }

    public void addMsg(String message) {
        this.addListaRecebimento(message);
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            String[] exms;
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            String[] stringArray = exms = exames.split(" ", 0);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String s;
                int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, s = stringArray[i], mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, s, mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            if (this.getAbaSelecionada() == 0) {
                this.equipamento.refreshSelected();
            }
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return "";
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
                if (!InterfaceListener.this.equipamento.getStatusFecharInterfaceamento().isExportando()) {
                    InterfaceListener.this.fireAtualizarTabela(2);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

