/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.eurolinescan;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.eurolinescan.EuroLineException;
import jalis.laboratorio.interfaceamento.padroes.arquivo.InterfaceArquivoListener;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.Timer;

public class InterfaceListener
extends InterfaceArquivoListener {
    private ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
    public static final String NOME_EXAME = "IGG";
    private boolean executando = false;
    private Timer arquivo = new Timer(30000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            File[] interfaceArquivos;
            if (!InterfaceListener.this.executando && (interfaceArquivos = new File(InterfaceListener.this.c.getDiretorioImportacao()).listFiles()) != null) {
                for (File arquivo : interfaceArquivos) {
                    String nomeArquivo = arquivo.getName();
                    if (!arquivo.isFile() || !nomeArquivo.substring(nomeArquivo.lastIndexOf(".") + 1).toUpperCase().equalsIgnoreCase("xml")) continue;
                    InterfaceListener.this.parse(arquivo.getAbsolutePath());
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                System.gc();
            }
        }
    });

    public InterfaceListener() {
        this.arquivo.start();
    }

    @Override
    public void buscarResultados(Date inicio, Date termino) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String parse(String path) {
        this.executando = true;
        File file = new File(path);
        try {
            String arquivo = StringUtil.lerArquivoTexto(file.getAbsolutePath());
            String[] requisicoes = arquivo.split("\n");
            StringBuilder loteDeParametros = new StringBuilder();
            for (int i = 0; i < requisicoes.length; ++i) {
                String requisicao = requisicoes[i];
                if (i % 4 != 0 && i != 0) {
                    requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo() + 1);
                }
                loteDeParametros.append(requisicao).append(",");
                if ((i + 1) % 4 != 0 && i != requisicoes.length - 1) continue;
                if (loteDeParametros.length() > 0) {
                    loteDeParametros.setLength(loteDeParametros.length() - 2);
                }
                try {
                    this.processaResultado(loteDeParametros.toString());
                }
                catch (EuroLineException e) {
                    this.fireExcecaoEncontrada(e.getMessage());
                }
                loteDeParametros.setLength(0);
            }
            this.fireAtualizarTabela();
            File dir = new File(this.c.getDiretorioImportacao() + File.separator + "Importado" + File.separator);
            if (!dir.exists()) {
                dir.mkdir();
            }
            SimpleDateFormat formatter = new SimpleDateFormat("ddMMyyyy_HHmmss");
            Date date = new Date();
            String addData = "_" + formatter.format(date);
            int index = file.getName().toString().indexOf(".");
            String novoArquivo = file.getName().toString().substring(0, index) + addData + file.getName().substring(index);
            file.renameTo(new File(dir, novoArquivo));
            String string = "Resultados recebidos com sucesso.";
            return string;
        }
        catch (Exception e) {
            String string = "N\u00e3o foi poss\u00edvel importar o arquivo " + (null != file ? file.getName() : "");
            return string;
        }
        finally {
            this.executando = false;
        }
    }

    private void processaResultado(String requisicao) throws EuroLineException {
        HashMap<String, Object> exameResultado = new HashMap<String, Object>();
        String[] dados = requisicao.split(",");
        Integer tamanhoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        String codigoTubo = dados[0];
        if (codigoTubo.length() < tamanhoTubo) {
            throw new EuroLineException(String.format("Id da  amostra [%s] recebido inv\u00e1lido ou com tamanho incorreto, tamanho esperado %s ", codigoTubo, String.valueOf(tamanhoTubo)));
        }
        String tipoResultado = "";
        Integer posicao = 0;
        for (String linha : dados) {
            if (linha.equals(codigoTubo)) continue;
            if (linha.length() == 5) {
                tipoResultado = linha.substring(linha.length() - 1).toUpperCase();
            }
            if (posicao > 1 && linha.length() != 5) {
                String campo = linha.substring(0, linha.indexOf("[") - 1).trim().toUpperCase().trim();
                campo = tipoResultado + " - " + campo.replaceAll("-", "");
                String campoResultado = linha.substring(linha.indexOf("/") + 1, linha.length());
                String resultado = campoResultado.substring(0, campoResultado.indexOf("/")).replace(".", ",");
                exameResultado.put(campo, resultado);
            }
            Integer n = posicao;
            Integer n2 = posicao = Integer.valueOf(posicao + 1);
        }
        this.registraResultado(exameResultado, codigoTubo);
    }

    private void registraResultado(HashMap<String, Object> listaResultado, String codigoTubo) throws EuroLineException {
        String fil_codigo = codigoTubo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = codigoTubo.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        String rec_codigo = codigoTubo.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        try {
            String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, NOME_EXAME);
            if (int_codigo == null) {
                throw new EuroLineException("Nenhum exame encontrado para o alternativo: IGG");
            }
            ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, NOME_EXAME);
            Statement st = Conexao.getStatement();
            this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, listaResultado);
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada("Arquivo n\u00e3o cont\u00eam informa\u00e7\u00f5es da requisi\u00e7\u00e3o: " + codigoTubo);
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            String[] stringArray = exames.split(" ", 0);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String s;
                int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, s = stringArray[i], mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, s, mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            this.equipamento.atualizarTabela(0);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return "";
        }
    }

    @Override
    protected void encerrar() {
        super.encerrar();
        if (this.arquivo != null) {
            this.arquivo.stop();
        }
    }
}

