/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.erbaxl640;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServer;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.erbaxl640.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.erbaxl640.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.Checksum;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class InterfaceListener
extends InterfaceASTMListener {
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    InterfaceConfiguracao configuracao = new InterfaceConfiguracao();
    private List<String> tubos = new ArrayList<String>();
    private Timer porta = null;
    private boolean heartbit = false;
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;
    protected boolean hostQuery = false;
    protected boolean hostQueryVazio = false;
    private static final String MASK_DATA = "yyyyMMddHHmmss";

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.MAX_PATIENT_NAME_CHARS = 36;
        this.HOST_NAME = "HOST";
        this.INSTRUMENT_NAME = "Analyzer";
        this.porta = new Timer(100000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InterfaceListener.this.getPortaCOM() != null && !InterfaceListener.this.isTX() && !InterfaceListener.this.isRX() || InterfaceListener.this.getPortaCOM() != null && InterfaceListener.this.isRX()) {
                    try {
                        if (!InterfaceListener.this.heartbit) {
                            InterfaceListener.this.setTX(InterfaceListener.this.TIME_TX);
                            InterfaceListener.this.getPortaCOM().write(String.valueOf('\u0005'));
                            InterfaceListener.this.heartbit = true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.porta.start();
    }

    @Override
    public void fcTimedOut(EventObject e) {
        super.fcTimedOut(e);
        if (this.heartbit) {
            this.heartbit = false;
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0005': {
                    if (this.isTX() || this.tx_list.size() > 0 && this.rx_counter < this.MAX_TENTATIVAS_RX) {
                        this.getPortaCOM().write(String.valueOf('\u0015'));
                        ++this.rx_counter;
                        break;
                    }
                    this.rx_counter = 0;
                    this.tratarEnquiry();
                    break;
                }
                case '\u0006': {
                    if (this.heartbit) {
                        this.getPortaCOM().write(String.valueOf('\u0004'));
                        this.setIdle();
                        this.heartbit = false;
                        this.porta.stop();
                        this.porta.setDelay(540000);
                        this.porta.start();
                    }
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0015': {
                    this.tratarNegativeAck();
                    break;
                }
                case '\u0004': {
                    if (this.heartbit) {
                        this.heartbit = false;
                    }
                    this.tratarEndOfTX();
                    break;
                }
                default: {
                    this.caracterNaoEsperado();
                    break;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de caracter de handshake recebido");
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento: " + ex.getMessage(), 1, 5000);
            if (this.tx_list.size() > 0) {
                this.limpaDadosRequisicao();
            }
            this.setIdle();
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames, acao, null);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            ExameMaterial[] alternativos = null;
            String short_name = StringUtil.removerAcentos(pac_nome);
            String nome = null;
            String nomeDoMeio = "";
            String ultimoNome = short_name = this.removeEspacoDuplo(short_name.trim());
            if (short_name.indexOf(" ") > 0) {
                String[] names = short_name.split(" ");
                nome = names[0];
                if (names.length <= 2) {
                    ultimoNome = names[1];
                } else {
                    ultimoNome = names[names.length - 1];
                    if (names.length > 3) {
                        nomeDoMeio = String.format("%s%s", names[1].substring(0, 1), names[2].substring(0, 1));
                    } else {
                        try {
                            nomeDoMeio = names[1].substring(0, 2);
                        }
                        catch (Exception e) {
                            nomeDoMeio = "";
                        }
                    }
                }
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            if (mapaParametros != null && mapaParametros.containsKey("codigoApoiado") && !mapaParametros.get("codigoApoiado").equals(codigo.toString())) {
                codigo.setLength(0);
                codigo.append(mapaParametros.get("codigoApoiado"));
            }
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            if ((exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista)) != null) {
                alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            }
            if (exa_lista == null || alternativos == null || exa_lista.length != alternativos.length) {
                String erro = "Erro ao obter alternativos para enviar ao equipamento";
                this.fireExcecaoEncontrada(erro);
                return erro;
            }
            StringBuilder frame = new StringBuilder();
            frame.append(this.getHeaderRecord(this.configuracao.getDelimitador(), this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION, "E 1394-97"));
            String patient_id = req_codigo;
            Object laboratory_pid = null;
            Date dataNasc = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            frame.append(this.getPatientRecord(1, patient_id.toString(), short_name, pac_sexo, dataNasc));
            frame.append(this.getOrderRecord(1, codigo.toString(), alternativos, acao, tipo_amostra));
            frame.append(ASTMStandard.getDefaultTerminationRecord("N"));
            this.tx_list.add(frame.toString());
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Response 920: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Response 920: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private String removeEspacoDuplo(String short_name) {
        StringBuilder newNome = new StringBuilder();
        for (int i = 0; i < short_name.length(); ++i) {
            if (short_name.charAt(i) == ' ' && i < short_name.length() && short_name.charAt(i + 1) == ' ') continue;
            newNome.append(short_name.charAt(i));
        }
        return newNome.toString();
    }

    private String getHeaderRecord(String delimiters, String password, String sender_id_name, String sender_id_system, String control, String receiver_id_name, String receiver_id_system, String version_number) {
        StringBuilder record = new StringBuilder("H|");
        record.append((!Funcoes.textoVazio(delimiters) ? delimiters : "`") + "^&");
        record.append("||");
        record.append(password == null ? "" : password);
        record.append("|");
        record.append(sender_id_name == null ? "" : sender_id_name);
        record.append(sender_id_system == null ? "" : "^" + sender_id_system);
        record.append("||||");
        record.append(control == null ? "" : control);
        record.append("|");
        record.append(receiver_id_name == null ? "" : receiver_id_name);
        record.append(receiver_id_system == null ? "" : "^" + receiver_id_system);
        record.append("||P|");
        record.append(version_number);
        record.append("|");
        record.append(InterfaceListener.getCurrentMoment());
        record.append("|");
        record.append('\r');
        return record.toString();
    }

    public static String getCurrentMoment() {
        return new SimpleDateFormat(MASK_DATA).format(new Date(System.currentTimeMillis()));
    }

    private String getOrderRecord(int order_sequence, String sample_id, ExameMaterial[] alternativos, String acao, String tipo_amostra) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence).append("|");
        record.append(sample_id == null ? "" : sample_id).append("|");
        record.append("|");
        if (alternativos != null && alternativos[0] != null) {
            record.append("^^^");
            record.append(alternativos[0].getNomeExame());
            for (int i = 1; i < alternativos.length; ++i) {
                if (alternativos[i] == null) continue;
                record.append((!Funcoes.textoVazio(this.configuracao.getDelimitador()) ? this.configuracao.getDelimitador() : "`") + "^^^");
                record.append(alternativos[i].getNomeExame());
            }
        }
        record.append("|R|");
        record.append(StringUtil.repeteCaractere('|', 5));
        record.append(acao == null ? "" : acao);
        record.append(StringUtil.repeteCaractere('|', 4));
        record.append("|");
        record.append(tipo_amostra == null ? "" : tipo_amostra);
        record.append(StringUtil.repeteCaractere('|', 15));
        record.append('\r');
        return record.toString();
    }

    private String getPatientRecord(int patient_sequence, String patient_id, String pac_nome, String pac_sexo, Date dataNasc) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence);
        record.append("|");
        record.append(patient_id == null ? "" : patient_id);
        record.append("|||");
        record.append(pac_nome.replaceAll(" ", "^"));
        record.append("||");
        record.append(dataNasc == null ? "" : Funcoes.formataData("yyyyMMdd", dataNasc));
        record.append("||");
        record.append(pac_sexo == null ? "" : pac_sexo);
        record.append("||||||||||");
        record.append('\r');
        return record.toString();
    }

    private String getTerminationRecord() {
        StringBuilder record = new StringBuilder("L|1|N");
        record.append('\r');
        return record.toString();
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
            this.atualizaSituacaoExames();
        }
        this.interromperTimer();
        this.getPortaCOM().write(String.valueOf('\u0004'));
        this.getPortaCOM().clearInputString();
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.limpaDadosRequisicao();
        if (this.tubos.size() == 0) {
            this.fireAtualizarTabela();
        }
        this.setIdle();
    }

    private void atualizaSituacaoExames() throws SQLException {
        Statement st = Conexao.getStatement();
        if (this.exames != null) {
            for (int i = 0; i < this.exames.length; ++i) {
                int situacao;
                if (!Funcoes.textoVazio(this.rec_tuboPai) && this.curva && !this.examesFilho.isEmpty()) {
                    for (String exame : this.examesFilho) {
                        int situacao2 = BDUtil.getDesmSituacao(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai, exame, this.mco_codigo);
                        BDUtil.setExmSituacaoFilho(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, exame, this.mco_codigo, this.rec_tuboPai, situacao2 < 2 ? 1 : 3);
                    }
                    situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                    if (!BDUtil.isGrupoInteiroPendente(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai)) continue;
                    this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_tuboPai, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                    continue;
                }
                if (!this.examesFilho.isEmpty()) {
                    situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                    this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                    BDUtil.setExmSituacaoTodosFilhos(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo, situacao < 2 ? 1 : 3);
                    continue;
                }
                situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
            }
            Conexao.arquivaSQL();
            String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
            this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
        } else {
            this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
        }
    }

    @Override
    public MemoryList<String> makeFrames(MemoryList<String> raw_list) throws Exception {
        try {
            MemoryList<String> new_list = new MemoryList<String>();
            this.frame_num = 0;
            if (raw_list != null) {
                while (!raw_list.isEmpty() && raw_list.size() > 0) {
                    String[] slices = StringUtil.dividir(raw_list.remove(0), 1024);
                    for (int j = 0; j < slices.length; ++j) {
                        StringBuilder temp = new StringBuilder(String.valueOf(this.nextFrameNum()));
                        temp.append(slices[j]);
                        temp.append(j < slices.length - 1 ? String.valueOf('\u0017') : String.valueOf('\u0003'));
                        temp.append(Checksum.getChecksumMod256(temp.toString()));
                        temp = new StringBuilder(this.getMsgStart()).append((CharSequence)temp);
                        temp.append(this.getMsgEnd());
                        new_list.add(temp.toString());
                    }
                }
                return new_list;
            }
            return null;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Erro ao recuperar lista de frames (size:" + raw_list.size() + ")");
            return null;
        }
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            starting_range = starting_range.substring(1);
            starting_range = starting_range.replace("\\", "|");
            String[] tubos = starting_range.split("[|]");
            if (tubos != null && tubos.length > 0) {
                for (String tubo : tubos) {
                    if (tubo.length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                        this.tubos.add(tubo);
                        continue;
                    }
                    this.fireExcecaoEncontrada(String.format("C\u00f3digo da amostra solicitada fora do padr\u00e3o: %s", tubo));
                }
            } else {
                this.fireExcecaoEncontrada(String.format("Nenhuma amostra solicitada pelo equipamento: %s", starting_range));
                return;
            }
            this.hostQuery = true;
            this.hostQueryVazio = false;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Response 920: Host Query Response");
        }
    }

    @Override
    protected void tratarAcknowledge() throws Exception {
        if (this.isTX()) {
            if (!this.tx_list.isEmpty() && this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                this.encerrarTransmissao();
                if (this.tubos.size() > 0) {
                    this.enviaProximaAmostra();
                    this.responseHostQuery();
                }
            } else {
                this.enviarProximoFrame();
            }
        } else if (!this.isRX()) {
            this.caracterNaoEsperado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery && this.tubos.size() > 0) {
            this.enviaProximaAmostra();
            this.responseHostQuery();
        }
    }

    private void enviaProximaAmostra() {
        String amostra = this.tubos.remove(0);
        this.host_fil_codigo = amostra.substring(0, ParametrosGerais.getDigitosTuboFilial());
        amostra = amostra.substring(ParametrosGerais.getDigitosTuboFilial());
        this.host_req_codigo = amostra.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
        this.host_rec_codigo = amostra.substring(ParametrosGerais.getDigitosTuboRequisicao());
        this.hostQuery = true;
        this.hostQueryVazio = false;
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(1, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size()) {
                    message = (String)this.rx_list.get(this.rx_list.getUltimoInserido()) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                for (String msg : message.split(String.valueOf('\r'))) {
                    if (msg.length() <= 1 || !msg.contains("|")) continue;
                    this.rx_list.add(msg);
                }
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                ArrayList<String> msgResultado = new ArrayList<String>();
                while (!this.rx_list.isEmpty()) {
                    String s = (String)this.rx_list.remove(0);
                    String record = s.substring(0, s.length() - 1);
                    String record_type = ASTMStandard.getRecordTypeIdentifier(record);
                    if (record_type == null) continue;
                    if (record_type.equals(ASTMStandard.RECORD_TYPE_TERMINATION)) {
                        msgResultado.add(s);
                        ArrayList<String> resultado = new ArrayList<String>(msgResultado);
                        this.parseRes(resultado);
                        msgResultado.clear();
                        continue;
                    }
                    msgResultado.add(s);
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    private synchronized void parseRes(List<String> resultado) throws Exception {
        RecordParser recordParser = new RecordParser();
        recordParser.setInterfaceASTMListener(this);
        Map<String, Object> exameAtual = new HashMap<String, Object>();
        boolean isOrdem = false;
        for (String s : resultado) {
            exameAtual = recordParser.recordFound(s, exameAtual);
        }
        Conexao.arquivaSQL();
        RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        if (portaCOM instanceof PortaSocketServer) {
            ((PortaSocketServer)portaCOM).setEscreverEmBytes(true);
        }
        super.setPortaCOM(portaCOM);
    }

    public void responseHostQuery() {
        try {
            List<Object[]> reqs;
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String rack = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            StringBuilder pac_exames = new StringBuilder("");
            String acao = "A";
            DescritorCodigoEtiqueta dce = DescritorCodigoEtiqueta.getDescritor(this.host_fil_codigo + this.host_req_codigo + this.host_rec_codigo);
            if (dce != null) {
                fil_codigo = Funcoes.preencheZero(dce.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                req_codigo = Funcoes.preencheZero(dce.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                rec_codigo = Funcoes.preencheZero(dce.getTubo(), ParametrosGerais.getDigitosTuboTubo());
            }
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames.append((String)req[aba.getColIndice("Exame")]);
                reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
                this.getExamesRequisicao(pac_exames, aba, reqs);
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (req != null) {
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    this.getExamesRequisicao(pac_exames, aba, reqs);
                }
            }
            String situacao = null;
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                aba = this.equipamento.getTab(2);
                if (req != null) {
                    String tuboPai = Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboTubo());
                    List<Object[]> reqs2 = this.getTodasRequisicaoAba(fil_codigo, req_codigo, Integer.parseInt(tuboPai) == 0 || tuboPai.equals(rec_codigo) ? rec_codigo : tuboPai, 2);
                    for (Object[] r : reqs2) {
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) >= 7) continue;
                        situacao = (String)r[aba.getColIndice("Sit")];
                        String exame = (String)r[aba.getColIndice("Exame")];
                        mco_codigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                        int_codigo = (String)req[aba.getColIndice("Interface")];
                        if (BDUtil.isGrupoInteiroRepetido(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, tuboPai.equals(rec_codigo) ? rec_codigo : tuboPai)) {
                            pac_exames.append(exame).append(" ");
                            acao = "A";
                            continue;
                        }
                        BDExame[] filhos = BDUtil.getDesmExamesFilhos(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, tuboPai.equals(rec_codigo) ? rec_codigo : tuboPai);
                        if (filhos == null) continue;
                        for (BDExame bdExame : filhos) {
                            if (!Funcoes.preencheZero(bdExame.getRecipienteFilho(), ParametrosGerais.getDigitosTuboTubo()).equals(rec_codigo) || bdExame.getSituacao() <= 2 || bdExame.getSituacao() >= 7) continue;
                            pac_exames.append(bdExame.getExame()).append(" ");
                            acao = "A";
                        }
                    }
                }
            }
            if (req != null) {
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                String rec_codigoPai = aba.getColIndice("Tubo") >= 0 ? (String)req[aba.getColIndice("Tubo")] : null;
                this.hostQueryVazio = false;
                if ((fil_codigo + req_codigo + rec_codigo).equals(this.host_fil_codigo + this.host_req_codigo + this.host_rec_codigo)) {
                    this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.toString().trim(), acao);
                } else {
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("codigoApoiado", this.host_fil_codigo + this.host_req_codigo + this.host_rec_codigo);
                    this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.toString().trim(), acao, param);
                }
            } else {
                this.hostQueryVazio = true;
                this.fireExcecaoEncontrada(String.format("N\u00e3o localizada nenhuma requisi\u00e7\u00e3o para a amostra %s %s %s", fil_codigo, req_codigo, rec_codigo));
            }
            this.hostQuery = false;
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Response 920: Host Query Response");
        }
    }

    private void getExamesRequisicao(StringBuilder pac_exames, PanelAbaAbstrata aba, List<Object[]> reqs) {
        for (Object[] r : reqs) {
            String exame = (String)r[aba.getColIndice("Exame")];
            if (!Funcoes.textoVazio(pac_exames.toString()) && !pac_exames.toString().contains(exame)) {
                pac_exames.append(" ");
            }
            if (pac_exames.toString().contains(exame)) continue;
            pac_exames.append(exame);
        }
    }

    public void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void teste() {
        StringBuilder tmp = new StringBuilder("[ENQ]");
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado"}, null);
        if (op == 0) {
            String req = "010000056804";
            tmp.append("[STX]1H|\\^&||||||||||P|E[SP]1394-97|20130510125514[CR]");
            tmp.append("Q|1|^").append(req).append("|||S|||||||O[CR]");
            tmp.append("L|1|N[CR][ETX]2D[LINE]");
            this.parse(this.equipamento.arruma(tmp.toString()));
            this.handShakeCharReceived('\u0004');
        } else if (op == 1) {
            this.handShakeCharReceived('\u0006');
        } else if (op == 2) {
            tmp.append("[STX]1H|\\^&||||||||||P|E[SP]1394-97|20210707100247[CR]");
            tmp.append("P|1|00405813|||MOACIR[SP]PIOVESAN|||U||||||||0|0[CR]");
            tmp.append("O|1|010005095804||^^^Na\\^^^K\\^^^CL|||||||||||SERUM[CR]");
            tmp.append("R|1|^^^CL|117.00|mmol/l|^DEFAULT|N|N|F||||20210707100244[CR]");
            tmp.append("C|1|I|Instrument[SP]Flag[SP]N[CR]");
            tmp.append("R|2|^^^K|3.79|mmol/l|^DEFAULT|N|N|F||||20210707100244[CR]");
            tmp.append("C|1|I|Instrument[SP]Flag[SP]N[CR]");
            tmp.append("R|3|^^^Na|138.50|mmol/l|^DEFAULT|N|N|F||||20210707100244[CR]");
            tmp.append("C|1|I|Instrument[SP]Flag[SP]N[CR]");
            tmp.append("L|1|N[CR]");
            tmp.append("[ETX]95[LINE]");
            this.parse(this.equipamento.arruma(tmp.toString()));
        }
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.getPortaCOM().write(resultado.startsWith("Erro") ? String.valueOf('\u0015') : String.valueOf('\u0006'));
                    }
                    if (InterfaceListener.this.isRX()) {
                        InterfaceListener.this.aguardarProximoFrame();
                    }
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
                InterfaceListener.this.fireAtualizarTabela();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

