/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.erbaxl640;

import jalis.laboratorio.interfaceamento.InterfaceamentoConfiguracao;
import jalis.util.StringUtil;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;

public class InterfaceConfiguracao
extends InterfaceamentoConfiguracao {
    private static final String TAG_VARIAVEL = "variavel";
    private static final String TAG_NOME = "nome";
    private static final String TAG_VALOR = "valor";
    private static final String TAG_TIPO = "tipo";
    private static final String TAG_DELIMITADOR = "delimitador";
    private String delimitador;

    @Override
    public String getXmlVariaveis() {
        String str = super.getXmlVariaveis();
        try {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir(TAG_VARIAVEL);
            xml.escrever(TAG_NOME, TAG_DELIMITADOR);
            xml.escrever(TAG_VALOR, this.getDelimitador());
            xml.escrever(TAG_TIPO, EDIT);
            xml.fechar(TAG_VARIAVEL);
            return str + xml.getXML();
        }
        catch (XMLStringBuilderException e) {
            e.printStackTrace();
            return str;
        }
    }

    @Override
    public void setXmlVariaveis(String xml) {
        String[] variaveis;
        for (String s : variaveis = StringUtil.getValores(xml, TAG_VARIAVEL)) {
            String nome = StringUtil.getValor(s, TAG_NOME);
            String valor = StringUtil.getValor(s, TAG_VALOR);
            if (!nome.equalsIgnoreCase(TAG_DELIMITADOR)) continue;
            this.setDelimitador(valor);
        }
        super.setXmlVariaveis(xml);
    }

    @Override
    public String getNomeVariavel(String variavel) {
        if (variavel.equalsIgnoreCase(TAG_DELIMITADOR)) {
            return "Delimitador";
        }
        return super.getNomeVariavel(variavel);
    }

    public String getDelimitador() {
        return this.delimitador;
    }

    public void setDelimitador(String delimitador) {
        this.delimitador = delimitador;
    }
}

