/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.elecsys2010.remover;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultNaoEnviados;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.elecsys2010.remover.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class InterfaceListener
extends InterfaceASTMListener {
    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            if (acao.equals("C")) {
                return "";
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            String nome = short_name;
            Object sobrenome = null;
            this.tx_list.add(InterfaceListener.getHeaderRecord(this.DELIMITERS, this.HOST_NAME));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String patient_id = req_codigo;
            Object laboratory_pid = null;
            this.tx_list.add(InterfaceListener.getPatientRecord(1));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            rackposition = "^" + Funcoes.preencheZero(rackposition.substring(0, rackposition.length() - 1), 5) + "^" + rackposition.substring(rackposition.length() - 1);
            this.tx_list.add(InterfaceListener.getOrderRecord(1, codigo.toString(), alternativos, exa_lista, rackposition));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
            }
            this.tx_list.add(InterfaceListener.getTerminationRecord());
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    public void enviar() {
        try {
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    public static String getHeaderRecord(String delimiters, String sender_id_name) {
        StringBuilder record = new StringBuilder("H|");
        record.append(delimiters == null ? "" : delimiters);
        record.append("|||");
        record.append(sender_id_name == null ? "" : sender_id_name);
        record.append('\r');
        return record.toString();
    }

    public static String getPatientRecord(int patient_sequence) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence);
        record.append('\r');
        return record.toString();
    }

    public static String getOrderRecord(int order_sequence, String sample_id, ExameMaterial[] test_item_numbers, ExameMaterial[] test_item_names, String rackposition) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("|").append(rackposition).append("^^SAMPLE^NORMAL");
        record.append("|");
        if (test_item_numbers != null && test_item_numbers[0] != null) {
            record.append("^^^");
            record.append(test_item_numbers[0].getNomeExame());
            record.append("^0");
            for (int i = 1; i < test_item_numbers.length; ++i) {
                if (test_item_numbers[i] == null) continue;
                record.append("\\^^^");
                record.append(test_item_numbers[i].getNomeExame());
                record.append("^0");
            }
        }
        record.append("|R");
        record.append("||||||N||||||||||||||Q");
        record.append('\r');
        return record.toString();
    }

    public static String getTerminationRecord() {
        StringBuilder record = new StringBuilder("L|1|");
        record.append('\r');
        return record.toString();
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        String[] fields = starting_range.split("\\^");
        String req_codigo = starting_range.substring(1, 13);
        String sequence = starting_range.substring(14, 18);
        String rack = starting_range.substring(19, 21);
        String rackpos = starting_range.substring(22, 23);
        String rackPosition = "^" + sequence + "^" + rack + "^" + rackpos;
        if (req_codigo.length() != 12) {
            this.fireExcecaoEncontrada("Requisi\u00e7\u00e3o n\u00e3o encontrada ou n\u00e3o interfaceada: " + req_codigo);
            return;
        }
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
        req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
        ArrayList exames = ((AbaDefaultNaoEnviados)this.equipamento.getTab(0)).getExames();
        PanelAbaAbstrata aba = this.equipamento.getTab(0);
        for (int i = 0; i < exames.size(); ++i) {
            Object[] req = (Object[])exames.get(i);
            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
            String tubo = (String)req[aba.getColIndice("Tubo")];
            tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
            if (!fil_codigo.equalsIgnoreCase(filial) || !req_codigo.equalsIgnoreCase(requisicao) || !rec_codigo.equalsIgnoreCase(tubo)) continue;
            int cont = 1;
            while (!this.isIdle() && cont < 3) {
                try {
                    Thread.sleep(1500L);
                    ++cont;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.enviarRequisicao((String)req[aba.getColIndice("Paciente")], (String)req[aba.getColIndice("S")], (String)req[aba.getColIndice("Ide")], TempoUtil.getCurrentDateBr(), TempoUtil.getCurrentTime(), rackPosition, "", fil_codigo, (String)req[aba.getColIndice("Interface")], req_codigo, (String)req[aba.getColIndice("C\u00f3d. Mat.")], rec_codigo, (String)req[aba.getColIndice("Exame")], "N");
            return;
        }
        this.fireExcecaoEncontrada("Requisi\u00e7\u00e3o n\u00e3o encontrada ou n\u00e3o interfaceada: " + fil_codigo + req_codigo + rec_codigo);
    }
}

