/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.elecsys2010;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaCOM;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.padroes.astm2.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.padroes.astm2.Message;
import jalis.laboratorio.interfaceamento.padroes.astm2.MessageReceivedListener;
import jalis.laboratorio.interfaceamento.padroes.astm2.MessageSentCallback;
import jalis.laboratorio.interfaceamento.padroes.astm2.PacketParser;
import jalis.laboratorio.interfaceamento.padroes.astm2.Record;
import jalis.laboratorio.interfaceamento.padroes.astm2.RecordType;
import jalis.laboratorio.interfaceamento.padroes.astm2.UniversalTestId;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.Comment;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.MessageHeader;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.MessageTerminator;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.PatientInformation;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.RequestInformation;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.Result;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.TestOrder;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceASTMListener
implements MessageReceivedListener {
    private String arqLog;
    boolean exr_codigoapoiado = false;
    private Map<String, InfoExameRequisicao> exameRequisicaoPorSid = new HashMap<String, InfoExameRequisicao>();

    public InterfaceListener() {
        Statement st = Conexao.getStatement();
        String dia = Funcoes.formataData("dd", Calendar.getInstance().getTime());
        this.exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
        this.limpaLogArquivos(dia);
        this.arqLog = String.format("%s%sElecsys2010-%s.log", System.getProperty("user.home"), System.getProperty("file.separator"), dia);
    }

    private void limpaLogArquivos(final String dia) {
        File file = new File(System.getProperty("user.home"));
        File[] afile = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.startsWith("Elecsys2010") && name.endsWith(".log")) {
                    int d = Integer.parseInt(dia);
                    for (int i = 0; i < 5; ++i) {
                        if (d == 0) {
                            d = 31;
                        }
                        if (name.endsWith(String.format("%s.log", Funcoes.preencheZero(d, 2)))) {
                            return false;
                        }
                        --d;
                    }
                    return true;
                }
                return false;
            }
        });
        if (afile != null) {
            for (File arquivos : afile) {
                arquivos.delete();
            }
        }
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        ((PortaCOM)portaCOM).setBuscaHandshakeMensagemInteira(true);
        super.setPortaCOM(portaCOM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        if (acao.equals("A")) {
            Statement st = Conexao.getStatement();
            try {
                String[] stringArray = exames.split(" ");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String exame;
                    int sitAtual = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame = stringArray[i], mcoCodigo, recCodigo);
                    this.atualizarSituacaoExame(st, filCodigo, reqCodigo, recCodigo, exame, mcoCodigo, intCodigo, null, sitAtual < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        return null;
    }

    private void alteraSituacaoParaPendentes(InfoExameRequisicao exameRequisicao) {
        try {
            Statement st = Conexao.getStatement();
            for (String exame : exameRequisicao.getExames().split(" ")) {
                String fil_codigo = exameRequisicao.getFilial();
                String req_codigo = exameRequisicao.getCodigo();
                String mco_codigo = exameRequisicao.getMaterial();
                String rec_codigo = exameRequisicao.getRecipiente();
                boolean curva = exameRequisicao.isCurva();
                String tuboPai = exameRequisicao.getTuboPai();
                String int_codigo = exameRequisicao.getInterface();
                int atual = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame, mco_codigo, rec_codigo);
                if (curva) {
                    BDUtil.setDesmSituacao(st, fil_codigo, int_codigo, req_codigo, exame, mco_codigo, tuboPai, exameRequisicao.getExamesFilho().trim(), mco_codigo, atual < 2 ? 1 : 3);
                    if (BDUtil.isGrupoInteiroPendente(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, tuboPai)) {
                        this.atualizarSituacaoExame(st, fil_codigo, req_codigo, tuboPai, exame, mco_codigo, int_codigo, null, atual < 2 ? 1 : 3, curva);
                    }
                } else {
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, atual < 2 ? 1 : 3);
                }
                this.firePacienteEnviado(exameRequisicao.getCodigo(), exameRequisicao.getNome(), exameRequisicao.getSexo(), exameRequisicao.getIdade(), exameRequisicao.getData(), exameRequisicao.getHora(), exameRequisicao.getExames());
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(0);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    protected MessageReceivedListener getMessageReceivedListener() {
        return this;
    }

    @Override
    public void messageReceived(Message message) {
        for (Record record : message.getRecords()) {
            if (record.getType() == RecordType.REQUEST_INFORMATION) {
                this.testSelectionRequest(message);
                break;
            }
            if (record.getType() != RecordType.RESULT) continue;
            this.measureData(message);
            break;
        }
    }

    private void measureData(Message message) {
        try {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            if (message.getRecordsByType(RecordType.TEST_ORDER).size() == 0) {
                this.fireExcecaoEncontrada("Resultado recebido do equipamento incompleto pois est\u00e1 sem o registro da requisi\u00e7\u00e3o");
                return;
            }
            TestOrder testOrder = (TestOrder)message.getRecordsByType(RecordType.TEST_ORDER).get(0);
            String tuboId = testOrder.getSpecimenId();
            if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                Statement st = Conexao.getStatement();
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                for (Record resultRecord : message.getRecordsByType(RecordType.RESULT)) {
                    Result result = (Result)resultRecord;
                    if (result.getStatus() != Result.ResultStatus.FINAL_RESULTS) continue;
                    String emiAlternativo = result.getUniversalTestId().getTestNumber();
                    String intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                    ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
                    if (exame != null) {
                        HashMap<String, Object> dados = new HashMap<String, Object>();
                        ArrayList<String> flags = new ArrayList<String>();
                        int sit = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                        String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                        String resultado = result.getMeasurementValue().replace('.', ',');
                        String resultado1 = result.getSecondMeasurementValue().replace('.', ',');
                        for (Record commentRecord : message.getRecordsByType(RecordType.COMMET)) {
                            Comment comment = (Comment)commentRecord;
                            flags.add(comment.getCommentText().trim());
                        }
                        if (!Funcoes.textoVazio(result.getFlag())) {
                            flags.add(result.getFlag());
                        }
                        if (!Funcoes.textoVazio(resultado1)) {
                            resultado = resultado1;
                        }
                        dados.put(campo, resultado);
                        Object[] retorno = this.getRequisicao(filCodigo, reqCodigo, recCodigo, new ArrayList<String>());
                        if (retorno != null) {
                            DescritorCodigoEtiqueta codigoEtiqueta;
                            Object[] req = (Object[])retorno[1];
                            PanelAbaAbstrata aba = (PanelAbaAbstrata)retorno[0];
                            String filialCodigo = "";
                            String requisicaoCodigo = "";
                            String filialCodigoReq = (String)req[aba.getColIndice("C\u00f3digo")];
                            if (Funcoes.textoVazio(filialCodigoReq)) {
                                filialCodigoReq = (String)req[aba.getColIndice("Multiguia")];
                            }
                            if ((codigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(filialCodigoReq)) != null) {
                                requisicaoCodigo = codigoEtiqueta.getRequisicao();
                                filialCodigo = codigoEtiqueta.getFilial();
                            } else {
                                filialCodigo = StringUtil.removeZerosEsquerda(filialCodigoReq.substring(0, ParametrosGerais.getDigitosTuboFilial()));
                                requisicaoCodigo = StringUtil.removeZerosEsquerda(filialCodigoReq.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial()));
                            }
                            String tuboPai = (String)req[aba.getColIndice("Tubo")];
                            tuboPai = Funcoes.preencheZero(tuboPai, ParametrosGerais.getDigitosTuboTubo());
                            if (this.exr_codigoapoiado && !recCodigo.equalsIgnoreCase(tuboPai)) {
                                recCodigo = tuboPai;
                            }
                            if (this.exr_codigoapoiado && !filCodigo.equalsIgnoreCase(filialCodigo)) {
                                filCodigo = Funcoes.preencheZero(filialCodigo, ParametrosGerais.getDigitosTuboFilial());
                            }
                            if (this.exr_codigoapoiado && !reqCodigo.equalsIgnoreCase(requisicaoCodigo)) {
                                reqCodigo = Funcoes.preencheZero(requisicaoCodigo, ParametrosGerais.getDigitosTuboRequisicao());
                            }
                        }
                        this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados, flags);
                        continue;
                    }
                    this.fireExcecaoEncontrada(String.format("Exame n\u00e3o encontrado para : %s %s %s alternativo: %s", filCodigo, reqCodigo, recCodigo, emiAlternativo));
                    return;
                }
            } else {
                this.fireExcecaoEncontrada(String.format("Etiqueta fora do padr\u00e3o %s", tuboId));
                return;
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    private void testSelectionRequest(Message message) {
        block24: {
            try {
                Statement st = Conexao.getStatement();
                TestOrder testOrder = new TestOrder();
                PatientInformation patientInformation = new PatientInformation();
                Message messageResp = new Message();
                messageResp.addRecord(new MessageHeader());
                messageResp.addRecord(patientInformation);
                messageResp.addRecord(testOrder);
                messageResp.addRecord(new MessageTerminator());
                RequestInformation requestInformation = (RequestInformation)message.getRecordsByType(RecordType.REQUEST_INFORMATION).get(0);
                if (requestInformation.getRequestInfoStatus() != RequestInformation.RequestInfoStatus.REQUEST_TESTS_FROM_HOST) {
                    return;
                }
                final String tuboId = requestInformation.getStartingRange().getSpecimenId();
                testOrder.setSpecimenId(tuboId);
                testOrder.getInstrumentSpecificId().setSequenceNumber(requestInformation.getStartingRange().getSequenceNumber());
                testOrder.getInstrumentSpecificId().setCarrierNumber(requestInformation.getStartingRange().getCarrierNumber());
                testOrder.getInstrumentSpecificId().setPositionInCarrier(requestInformation.getStartingRange().getPositionInCarrier());
                testOrder.getInstrumentSpecificId().setDataCarrierType("SAMPLE");
                testOrder.getInstrumentSpecificId().setContainerType("NORMAL");
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (tuboId != null && !tuboId.trim().isEmpty() && tuboId != "null" && Funcoes.isNumeric(tuboId) && tuboId.length() == digitosCodigoTubo) {
                    DescritorCodigoEtiqueta codigoEtiqueta;
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    ArrayList<String> listaExames = new ArrayList<String>();
                    Object[] ret = this.getRequisicao(filCodigo, reqCodigo, recCodigo, listaExames);
                    Object[] req = (Object[])ret[1];
                    PanelAbaAbstrata aba = (PanelAbaAbstrata)ret[0];
                    if (req == null) {
                        testOrder.setReportType(TestOrder.ReportType.NO_RECORD);
                        this.addMessageToSend(messageResp);
                        return;
                    }
                    String exames = StringUtil.implode(listaExames, " ");
                    String filialCodigo = "";
                    String requisicaoCodigo = "";
                    String filialCodigoReq = (String)req[aba.getColIndice("C\u00f3digo")];
                    if (Funcoes.textoVazio(filialCodigoReq)) {
                        filialCodigoReq = (String)req[aba.getColIndice("Multiguia")];
                    }
                    if ((codigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(filialCodigoReq)) != null) {
                        requisicaoCodigo = codigoEtiqueta.getRequisicao();
                        filialCodigo = codigoEtiqueta.getFilial();
                    } else {
                        filialCodigo = StringUtil.removeZerosEsquerda(filialCodigoReq.substring(0, ParametrosGerais.getDigitosTuboFilial()));
                        requisicaoCodigo = StringUtil.removeZerosEsquerda(filialCodigoReq.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial()));
                    }
                    if (this.exr_codigoapoiado && !filCodigo.equalsIgnoreCase(filialCodigo)) {
                        filCodigo = filialCodigo;
                    }
                    if (this.exr_codigoapoiado && !reqCodigo.equalsIgnoreCase(requisicaoCodigo)) {
                        reqCodigo = requisicaoCodigo;
                    }
                    String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                    String intCodigo = (String)req[aba.getColIndice("Interface")];
                    String pacNome = (String)req[aba.getColIndice("Paciente")];
                    String pacIdade = (String)req[aba.getColIndice("Ide")];
                    String pacSexo = (String)req[aba.getColIndice("S")];
                    String tuboPai = (String)req[aba.getColIndice("Tubo")];
                    String data = TempoUtil.getCurrentDateBr();
                    String hora = TempoUtil.getCurrentTime();
                    if (this.exr_codigoapoiado && !recCodigo.equalsIgnoreCase(tuboPai)) {
                        recCodigo = tuboPai;
                    }
                    patientInformation.setLaboratoryAssignetId(tuboId);
                    patientInformation.setName(pacNome);
                    ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
                    List<ExameMaterial> examesFilhos = null;
                    for (String string : exames.toString().trim().split(" ", 0)) {
                        examesDaRequisicao.add(new ExameMaterial(string, new Integer(mcoCodigo)));
                    }
                    Date dataColeta = null;
                    ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                    for (ExameMaterial exameMaterial : examesDaRequisicao) {
                        int n;
                        if (dataColeta == null) {
                            dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        }
                        if ((n = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo)) == -1) {
                            n = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), tuboPai);
                        }
                        if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                            examesFilhos = Arrays.asList(BDUtil.getExameDesmembradosTubo(filCodigo, reqCodigo, recCodigo, intCodigo, mcoCodigo));
                            if (n == 0 || n == 1) {
                                examesParaEnviar.addAll(examesFilhos);
                                continue;
                            }
                            for (ExameMaterial exameFilho : examesFilhos) {
                                int sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                if (sitFilho != 3) continue;
                                examesParaEnviar.add(exameFilho);
                            }
                            continue;
                        }
                        if (n != 0 && n != 1 && n != 3) continue;
                        examesParaEnviar.add(exameMaterial);
                    }
                    HashSet<Integer> tests = new HashSet<Integer>();
                    for (ExameMaterial exameMaterial : examesParaEnviar) {
                        String string = BDUtil.getExmCodigoAlternativo(filCodigo, exameMaterial.getNomeExame(), mcoCodigo, intCodigo);
                        if (string == null || string.trim().isEmpty()) continue;
                        tests.add(Integer.valueOf(string));
                    }
                    if (tests.isEmpty()) {
                        testOrder.setReportType(TestOrder.ReportType.NO_RECORD);
                        this.addMessageToSend(messageResp);
                        this.fireExcecaoEncontrada(tuboId + " - Nenhum exame enviado.");
                    } else {
                        InfoExameRequisicao infoExameRequisicao = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames.trim());
                        infoExameRequisicao.setInterface(intCodigo);
                        if (!Funcoes.preencheZero(tuboPai, ParametrosGerais.getDigitosTuboTubo()).equals(recCodigo) && examesFilhos != null && examesFilhos.size() > 0) {
                            infoExameRequisicao.setTuboPai(tuboPai);
                            StringBuilder stringBuilder = new StringBuilder();
                            for (ExameMaterial exameFilho : examesFilhos) {
                                stringBuilder.append(exameFilho.getNomeExame());
                            }
                            infoExameRequisicao.setExamesFilho(stringBuilder.toString());
                            infoExameRequisicao.setCurva(true);
                        }
                        this.exameRequisicaoPorSid.put(tuboId, infoExameRequisicao);
                        for (Integer n : tests) {
                            UniversalTestId universalTestId = new UniversalTestId();
                            universalTestId.setTestNumber(String.valueOf(n));
                            universalTestId.setAutoDiluitionFactor("0");
                            testOrder.addUniversalTestId(universalTestId);
                        }
                        testOrder.setReportType(TestOrder.ReportType.RESPONSE_TO_QUERY);
                        this.addMessageToSend(messageResp, new MessageSentCallback(){

                            @Override
                            public void messageSent(Message message, MessageSentCallback.MessageSentResult result) {
                                if (result == MessageSentCallback.MessageSentResult.SUCCESS) {
                                    InterfaceListener.this.alteraSituacaoParaPendentes((InfoExameRequisicao)InterfaceListener.this.exameRequisicaoPorSid.get(tuboId));
                                    InterfaceListener.this.exameRequisicaoPorSid.remove(tuboId);
                                }
                            }
                        });
                    }
                    break block24;
                }
                testOrder.setReportType(TestOrder.ReportType.NO_RECORD);
                this.addMessageToSend(messageResp);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    private Object[] getRequisicao(String filCodigo, String reqCodigo, String recCodigo, List<String> exames) throws SQLException {
        Object[] ret = new Object[2];
        PanelAbaAbstrata aba = this.equipamento.getTab(0);
        Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
        if (req != null) {
            String exame = (String)req[aba.getColIndice("Exame")];
            if (!exames.contains(exame)) {
                exames.add(exame);
            }
        }
        if (req == null) {
            req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
            aba = this.equipamento.getTab(1);
            if (req != null) {
                this.agruparExames(filCodigo, reqCodigo, recCodigo, exames, aba, 1);
            }
        }
        if (req == null) {
            req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
            aba = this.equipamento.getTab(2);
            if (req != null) {
                this.agruparExames(filCodigo, reqCodigo, recCodigo, exames, aba, 2);
            }
        }
        if (req == null) {
            ret = this.getExamesCurva(filCodigo, reqCodigo, recCodigo, exames, req, 0);
            if (ret == null && (ret = this.getExamesCurva(filCodigo, reqCodigo, recCodigo, exames, req, 1)) == null) {
                ret = this.getExamesCurva(filCodigo, reqCodigo, recCodigo, exames, req, 2);
            }
            return ret;
        }
        ret[0] = aba;
        ret[1] = req;
        return ret;
    }

    private Object[] getExamesCurva(String filCodigo, String reqCodigo, String recCodigo, List<String> exames, Object[] req, int codigoAba) throws SQLException {
        Integer tuboPai;
        Object[] ret = new Object[2];
        PanelAbaAbstrata aba = this.equipamento.getTab(codigoAba);
        ret[0] = aba;
        String intCodigo = super.getIntCodigoCurva(filCodigo, reqCodigo, recCodigo, codigoAba);
        if (!Funcoes.textoVazio(intCodigo) && (tuboPai = BDUtil.getTuboPai(filCodigo, reqCodigo, recCodigo, intCodigo)) != null) {
            ret = this.getRequisicao(filCodigo, reqCodigo, Funcoes.preencheZero(tuboPai, ParametrosGerais.getDigitosTuboTubo()), exames);
        }
        return ret;
    }

    private void agruparExames(String filCodigo, String reqCodigo, String recCodigo, List<String> exames, PanelAbaAbstrata aba, int codigoAba) {
        List<Object[]> reqs = this.getTodasRequisicaoAba(filCodigo, reqCodigo, recCodigo, codigoAba);
        for (Object[] r : reqs) {
            String exame = (String)r[aba.getColIndice("Exame")];
            if (exames.contains(exame)) continue;
            exames.add(exame);
        }
    }

    @Override
    public void teste() {
        String idAmosta = JOptionPane.showInputDialog("Informe o Id da amostra");
        this.handShakeCharReceived('\u0005');
        this.dataChanged(this.equipamento.arruma("[STX]1H|\\^&|||Jalis|||||||||[CR][ETX]A7[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]2P|1||||CLEBER[SP]DOS[SP]SANTOS[SP]REINHARDT|||||||||||||||||||||||||||||[CR][ETX]A7[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]1O|72|STANDARTROL[SP]1|14527|^^^GGT-LA|||||||||||||||||||||Q[CR][ETX]BE[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]0R|1|^^^FAL-LA|109,6|U/L|0^0|N||F||||20171201111803[CR][ETX]14[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]2R|1|^^^GGT-LA|29,72|U/L|0^0|N||F||||20171201111856[CR][STX]3O|73|STANDARTROL[SP]1|14527|^^^GLI|||||||||||||||||||||Q[CR][ETX]01[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]4R|1|^^^GLI|87,41|MG/DL|0^0|N||F||||20171201105323[CR][ETX]EE[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]5O|74|010005431904|14523|^^^GLI|||||||||||||||||||||Q[CR][ETX]B9[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]6R|1|^^^GLI|82,42|MG/DL|0^0|N||F||||20171201110927[CR][ETX]F2[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]7O|75|STANDARTROL[SP]1|14527|^^^GPT[SP]L|||||||||||||||||||||Q[CR][ETX]82[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]0R|1|^^^GPT[SP]L|32,76|U/L|0^0|N||F||||20171201105049[CR][ETX]E5[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]1O|16||90225|^^^CA[SP]As|||||||||||||||||||||Q[CR][ETX]D8[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]7O|67|STANDARTROL[SP]1|14527|^^^BT[SP]L|||||||||||||||||||||Q[CR][ETX]D8[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]0R|1|^^^GPT[SP]L|32,76|U/L|0^0|N||F||||20171201105049[CR][ETX]E5[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]1O|76|STANDARTROL[SP]1|14527|^^^HDL[SP]-LA|||||||||||||||||||||Q[CR][ETX]D8[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]2R|1|^^^HDL[SP]-LA|46,2|MG/DL|0^0|N||F||||20171201104307[CR][ETX]D8[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]4R|1|^^^LDH[SP]L|370,5|U/L|0^0|N||F||||20171201111350[CR][ETX]CB[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]5O|78|STANDARTROL[SP]1|14527|^^^MAG-LA|||||||||||||||||||||Q[CR][ETX]BB[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]6R|1|^^^MAG-LA|3,295|MG/DL|0^0|N||F||||20171201112027[CR][ETX]A1[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]7O|79|STANDARTROL[SP]1|14527|^^^TG|||||||||||||||||||||Q[CR][ETX]CA[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]0R|1|^^^TG|163,5|MG/DL|0^0|N||F||||20171201105755[CR][ETX]AD[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]1O|80|STANDARTROL[SP]1|14527|^^^URE[SP]L|||||||||||||||||||||Q[CR][ETX]79[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]2R|1|^^^URE[SP]L|33,37|MG/DL|0^0|N||F||||20171201111406[CR][ETX]63[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]3O|81|186981|14528|^^^URE[SP]L|||||||||||||||||||||Q[CR][ETX]1F[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]4R|1|^^^URE[SP]L|69,24|MG/DL|0^0|N||F||||20171201104237[CR][ETX]6E[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]5O|82|186988|14529|^^^AUS-LA|||||||||||||||||||||Q[CR][ETX]75[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]6R|1|^^^AUS-LA|6,63|MG/DL|0^0|N||F||||20171201104221[CR][ETX]7E[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]7O|83|187002|14530|^^^BD[SP]L|||||||||||||||||||||Q[CR][ETX]A9[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]0R|1|^^^BD[SP]L|0,09951|MG/DL|0^0|N||F||||20171201104103[CR][ETX]5F[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]1O|84|187002|14530|^^^BT[SP]L|||||||||||||||||||||Q[CR][ETX]B4[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]4L|1|N[CR][ETX]07[LINE]"));
        this.handShakeCharReceived('\u0004');
    }

    @Override
    public void dataChanged(String text) {
        block5: {
            try {
                if (text == null || !this.packetParser.checkFormat(text)) break block5;
                try {
                    PacketParser.PacketParseResult result = this.packetParser.textToData(text);
                    if (result.getParseResult() == PacketParser.ParseResult.SUCCESS) {
                        this.packetRecebido(result.getData());
                        this.enviarHandShake('\u0006');
                        break block5;
                    }
                    this.enviarHandShake('\u0015');
                }
                catch (ParseException e) {
                    this.enviarHandShake('\u0015');
                }
            }
            catch (IOException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Falha na comunica\u00e7\u00e3o");
            }
        }
    }
}

