/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.dxh500;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.dxh500.Flag;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    protected static String EXAMES = "exames";
    private static final int FLAG_SUSPECT_PARAMETER_FLAGS = 0;
    private static final int FLAG_SUSPECT_POPULATION_FLAGS = 1;
    private static final int FLAG_SYSTEM_FAULTS = 2;
    private final String[] tiposFlag = new String[]{"Suspect Parameter", "Suspect Population Flags", "System Fault Flags"};
    private String starting_range = null;
    private String ending_range = null;
    private String test_id = null;
    private boolean modoHostQuery = false;
    private List<Flag> flagsExame = new ArrayList<Flag>();
    private static Map<String, String> exameCamposByTestId = new HashMap<String, String>();
    private static HashMap<String, String> exameCamposByFlag;
    boolean exr_codigoapoiado = false;

    public RecordParser() {
        Statement st = Conexao.getStatement();
        this.exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        String tipo;
        if (this.exame_atual == null) {
            return;
        }
        String action_code = (String)this.exame_atual.get(ACTION_CODE);
        String report_type = (String)this.exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                this.exame_atual = null;
                return;
            }
        }
        if (report_type != null) {
            this.equip.getClass();
            if (report_type.equals("X")) {
                this.exame_atual = null;
                return;
            }
        }
        Hashtable result_fields = ASTMStandard.parseDefaultResultRecord(record);
        String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
        String int_codigo = (String)this.exame_atual.get(INT_CODIGO);
        String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        String campoFlag = this.parseCampoFlag((String)result_fields.get(ASTMStandard.RESULT_FIELD_TEST_ID));
        campoFlag = campoFlag.substring(campoFlag.lastIndexOf("!") + 1);
        String campoHemog = this.parseCampoHemograma((String)result_fields.get(ASTMStandard.RESULT_FIELD_TEST_ID));
        String resultado = (String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE);
        String[] flagsResult = resultado.split("!");
        resultado = flagsResult[0].trim();
        String flags = flagsResult.length > 1 ? flagsResult[1].trim() : "";
        if ((resultado = resultado.replaceAll("\\.", ",")).startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.endsWith(",")) {
            resultado = resultado + "0";
        }
        if (campoHemog != null && !campoHemog.trim().isEmpty()) {
            this.exame_atual.put(campoHemog, resultado);
            if (flags != null && !flags.trim().isEmpty() && !Funcoes.textoVazio(campoFlag)) {
                this.exame_atual.put("flag_alerta", flags);
                for (int i = 0; i < flags.length(); ++i) {
                    this.flagsExame.add(new Flag(exameCamposByFlag.get(String.valueOf(flags.toCharArray()[i])), campoFlag, resultado));
                }
            }
        } else if (!Funcoes.textoVazio(campoFlag) && !Funcoes.textoVazio(tipo = exameCamposByFlag.get(campoFlag.toUpperCase()))) {
            this.flagsExame.add(new Flag(tipo, campoFlag, resultado));
        }
    }

    @Override
    public void recordFound(String record) throws Exception {
        String record_type = ASTMStandard.getRecordTypeIdentifier(record);
        if (record_type != null) {
            if (record_type.equals(ASTMStandard.RECORD_TYPE_HEADER)) {
                this.trataHeaderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_PATIENT)) {
                this.trataPatientRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_ORDER)) {
                this.trataOrderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_RESULT)) {
                this.trataResultRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_COMMENT)) {
                this.trataCommentRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_REQUEST)) {
                this.trataRequestRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_TERMINATION)) {
                this.trataTerminationRecord();
                return;
            }
        }
    }

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
        String[] flagID = req_codigo.split("!");
        if (flagID.length > 0) {
            req_codigo = flagID[0];
        }
        if (req_codigo.contains("^")) {
            req_codigo = req_codigo.substring(0, req_codigo.indexOf("^"));
        }
        if (req_codigo == null || req_codigo.equals("")) {
            req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        Map<Integer, String> components = this.equip.parseOrderTestIDField((String)order_fields.get(ASTMStandard.ORDER_FIELD_TEST_ID));
        String emi_alternativo = components.get(this.equip.TEST_ID).replace("!", "");
        Statement st = Conexao.getStatement();
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (int_codigo == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        this.exame_atual.put(INT_CODIGO, int_codigo);
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
    }

    private String parseCampoHemograma(String campo) {
        String testId = campo.substring(campo.lastIndexOf("!") + 1);
        return exameCamposByTestId.get(testId);
    }

    private String parseCampoFlag(String campo) {
        String campoFlag = campo.substring(campo.lastIndexOf("^") + 1);
        return campoFlag;
    }

    @Override
    protected void trataRequestRecord(String record) throws Exception {
        Hashtable comps = ASTMStandard.parseDefaultRequestRecord(record);
        this.starting_range = (String)comps.get(ASTMStandard.REQUEST_FIELD_STARTING_RANGE_ID);
        this.ending_range = (String)comps.get(ASTMStandard.REQUEST_FIELD_ENDING_RANGE_ID);
        this.test_id = (String)comps.get(ASTMStandard.REQUEST_FIELD_TEST_ID);
        this.modoHostQuery = true;
    }

    @Override
    protected void trataTerminationRecord() throws Exception {
        if (this.modoHostQuery) {
            this.equip.responderRequest(this.starting_range, this.ending_range, this.test_id);
            this.modoHostQuery = false;
            return;
        }
        if (this.exame_atual == null) {
            return;
        }
        this.salvaExame(this.exame_atual);
        this.exame_atual = null;
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String[] codigoJalis;
        String fil_codigo = (String)dados.remove(FIL_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String req_codigo = (String)dados.remove(REQ_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        String rec_codigo = (String)dados.remove(REC_CODIGO);
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        this.ordenaFlagsPeloTipo();
        Statement st = Conexao.getStatement();
        ArrayList<String> flags = null;
        if (!this.flagsExame.isEmpty()) {
            flags = new ArrayList<String>();
            String tipo = this.flagsExame.get((int)0).tipo;
            flags.add(tipo);
            for (Flag flag : this.flagsExame) {
                if (!Funcoes.textoVazio(flag.tipo) && !flag.tipo.equals(tipo)) {
                    tipo = flag.tipo;
                    int last = flags.size() - 1;
                    flags.set(last, (String)flags.get(last) + "                      ");
                    flags.add(tipo);
                }
                flags.add(String.format("%s = %s", flag.id, flag.valor));
            }
            this.flagsExame.clear();
        }
        if (this.exr_codigoapoiado && !Funcoes.textoVazio((codigoJalis = BDUtil.getCodigoJalis(fil_codigo, req_codigo, rec_codigo, int_codigo, exa_codigo, mco_codigo))[0]) && !Funcoes.textoVazio(codigoJalis[1]) && !Funcoes.textoVazio(codigoJalis[2])) {
            fil_codigo = codigoJalis[0];
            req_codigo = codigoJalis[1];
            rec_codigo = codigoJalis[2];
        }
        List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
        for (BDExame exame : exames) {
            this.equip.atualizarDadosExame(st, fil_codigo, exame.getRequisicao(), exame.getRecipiente(), exame.getExame(), exame.getMaterial(), int_codigo, dados, flags);
        }
    }

    private void ordenaFlagsPeloTipo() {
        Collections.sort(this.flagsExame, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o2 != null && o1 != null && o1 instanceof Flag && o2 instanceof Flag) {
                    if (((Flag)o1).tipo == null || ((Flag)o2).tipo == null) {
                        return -1;
                    }
                    return ((Flag)o1).tipo.toString().compareTo(((Flag)o2).tipo.toString());
                }
                return 0;
            }
        });
    }

    static {
        exameCamposByTestId.put("WBC", "leucocitos");
        exameCamposByTestId.put("RBC", "hemacias");
        exameCamposByTestId.put("HCT", "hct");
        exameCamposByTestId.put("MCV", "vcm");
        exameCamposByTestId.put("MCH", "hcm");
        exameCamposByTestId.put("MCHC", "chcm");
        exameCamposByTestId.put("RDW", "rdw");
        exameCamposByTestId.put("RDW-SD", "rdw_sd");
        exameCamposByTestId.put("PLT", "plaquetas");
        exameCamposByTestId.put("MPV", "vpm");
        exameCamposByTestId.put("HGB", "hgb");
        exameCamposByTestId.put("LY", "linfocitos_tipicos_percentual");
        exameCamposByTestId.put("MO", "monocitos_percentual");
        exameCamposByTestId.put("NE", "neutrofilo_percentual");
        exameCamposByTestId.put("EO", "eosinofilos_percentual");
        exameCamposByTestId.put("BA", "basofilos_percentual");
        exameCamposByTestId.put("LY#", "linfocitos_tipicos_contagem");
        exameCamposByTestId.put("MO#", "monocitos_contagem");
        exameCamposByTestId.put("NE#", "neutrofilo_contagem");
        exameCamposByTestId.put("EO#", "eosinofilos_contagem");
        exameCamposByTestId.put("BA#", "basofilos_contagem");
        exameCamposByFlag = new HashMap();
        exameCamposByFlag.put("E", "Manual edit of a primary parameter");
        exameCamposByFlag.put("e", "Automatic edit of a calculated parameter");
        exameCamposByFlag.put("M", "Results are manually matched to demographics");
        exameCamposByFlag.put("R", "Review results");
        exameCamposByFlag.put("*", "Hemoglobin and Hematocrit (H&H) check failure");
        exameCamposByFlag.put("H", "Patient results above the action limit /  Control results above the expected range");
        exameCamposByFlag.put("L", "Patient results below the action limit /  Control results below the expected range");
        exameCamposByFlag.put("h", "Patient results above the reference interval, but less than the action (H)");
        exameCamposByFlag.put("l", "Patient results below the reference interval, but less than the action (L)");
        exameCamposByFlag.put("+", "Result is above the measuring range");
        exameCamposByFlag.put("-", "Result is below the measuring range");
    }
}

