/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.dimensionxpanplus;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaCOM;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.dimensionxpanplus.MensagemRecebida;
import jalis.laboratorio.interfaceamento.interfaces.dimensionxpanplus.ThreadRecebimento;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JOptionPane;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    public static final char FIELDSEPARATOR = '\u001c';
    public static final String POLL = "P";
    public static final String SAMPLE_REQUEST = "D";
    public static final String REQUEST_ACCEPTANCE_MESSAGE = "M";
    public static final String QUERY_MESSAGE = "I";
    public static final String RESULT_MESSAGE = "R";
    public static final String CALIBRATION = "C";
    private String mensagem = "";
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento(this);

    public InterfaceListener() {
        this.threadRecebimento.start();
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        if (portaCOM instanceof PortaCOM) {
            ((PortaCOM)portaCOM).setBuscaHandshakeMensagemInteira(true);
        }
        super.setPortaCOM(portaCOM);
    }

    @Override
    public void dataChanged() {
        String message = this.getPortaCOM().getInputString();
        if (!message.equals("")) {
            this.parse(message);
            this.getPortaCOM().clearInputString();
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public String parse(String message) {
        try {
            this.getPortaCOM().write(String.valueOf('\u0006'));
            this.mensagem = this.mensagem + message;
            Integer posicaoEtx = this.mensagem.indexOf(String.valueOf('\u0003'));
            if (posicaoEtx < this.mensagem.length() - 1) {
                if (posicaoEtx > 0 && posicaoEtx + 1 < this.mensagem.length()) {
                    this.mensagem = this.mensagem.substring(posicaoEtx + 1);
                }
            } else if (this.mensagem.contains(String.valueOf('\u0002')) && this.mensagem.contains(String.valueOf('\u0003'))) {
                String msg = this.mensagem.substring(this.getMsgStart().length());
                if (msg.contains(String.valueOf('\u0002'))) {
                    msg = this.mensagem.substring(this.getMsgStart().length());
                }
                if (!Funcoes.textoVazio(msg)) {
                    msg = msg.substring(0, msg.length() - this.getMsgEnd().length());
                    String[] campos = msg.split(String.valueOf('\u001c'));
                    String checkSum = campos[campos.length - 1];
                    ArrayList<String> fields = new ArrayList<String>();
                    for (String c : campos) {
                        fields.add(c);
                    }
                    String messageType = (String)fields.remove(0);
                    if (messageType.equalsIgnoreCase(POLL)) {
                        this.responsePoll();
                    } else if (messageType.equalsIgnoreCase(RESULT_MESSAGE)) {
                        this.responseResultMessage();
                        this.threadRecebimento.addListaRecebimento(msg);
                        this.restartThreadRecebimento();
                    } else if (messageType.equalsIgnoreCase(CALIBRATION)) {
                        this.responseResultMessage();
                    } else if (messageType.equalsIgnoreCase(QUERY_MESSAGE)) {
                        this.enviarRequisicao(fields);
                    }
                }
                this.mensagem = "";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void responseResultMessage() throws IOException {
        StringBuilder resp = new StringBuilder();
        resp.append('\u0002');
        resp.append(REQUEST_ACCEPTANCE_MESSAGE);
        resp.append('\u001c');
        resp.append("A");
        resp.append('\u001c');
        resp.append("E2");
        resp.append('\u0003');
        this.getPortaCOM().write(resp.toString());
    }

    private void responsePoll() throws IOException {
        StringBuilder resp = new StringBuilder();
        resp.append('\u0002');
        resp.append("N");
        resp.append('\u001c');
        resp.append("6B");
        resp.append('\u0003');
        this.getPortaCOM().write(resp.toString());
    }

    private void enviarRequisicao(ArrayList<String> fields) {
        try {
            Object[] req;
            MensagemRecebida mensagem;
            Statement st;
            block22: {
                String exa_codigo;
                block23: {
                    Object[] reqProntos;
                    st = Conexao.getStatement();
                    String tubo = fields.remove(0);
                    if (Funcoes.textoVazio(tubo)) {
                        this.fireExcecaoEncontrada("Amostra n\u00e3o localizada.");
                        return;
                    }
                    mensagem = new MensagemRecebida();
                    ArrayList<String> listaExames = new ArrayList<String>();
                    mensagem.setFilCodigo(tubo.substring(0, ParametrosGerais.getDigitosTuboFilial()));
                    mensagem.setReqCodigo(tubo.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial()));
                    mensagem.setRecCodigo(tubo.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()));
                    mensagem.setExames(listaExames);
                    mensagem.setRepeticao(false);
                    String acao = "A";
                    req = this.getRequisicaoAba(mensagem.getFilCodigo(), mensagem.getReqCodigo(), mensagem.getRecCodigo(), 0);
                    PanelAbaAbstrata aba = this.equipamento.getTab(0);
                    if (req != null) {
                        this.buscaExamesAbaNaoEnviados(mensagem);
                    }
                    if (req == null) {
                        req = this.getRequisicaoAba(mensagem.getFilCodigo(), mensagem.getReqCodigo(), mensagem.getRecCodigo(), 1);
                        aba = this.equipamento.getTab(1);
                        if (req != null) {
                            List<Object[]> reqs = this.getTodasRequisicaoAba(mensagem.getFilCodigo(), mensagem.getReqCodigo(), mensagem.getRecCodigo(), 1);
                            for (Object[] r : reqs) {
                                this.buscaExamesAbaPendentes(mensagem);
                            }
                        }
                    }
                    if ((reqProntos = this.getRequisicaoAba(mensagem.getFilCodigo(), mensagem.getReqCodigo(), mensagem.getRecCodigo(), 2)) != null) {
                        req = reqProntos;
                        aba = this.equipamento.getTab(2);
                        if (req != null) {
                            List<Object[]> reqs = this.getTodasRequisicaoAba(mensagem.getFilCodigo(), mensagem.getReqCodigo(), mensagem.getRecCodigo(), 2);
                            for (Object[] r : reqs) {
                                String situacao = String.valueOf(r[aba.getColIndice("Sit")]);
                                if (Funcoes.textoVazio(situacao)) continue;
                                if (!situacao.equalsIgnoreCase(PanelAbaAbstrata.SIT_A_REPETIR)) continue;
                                this.buscaExamesAbaProntos(mensagem);
                            }
                        }
                    }
                    if (!mensagem.getExames().isEmpty() || reqProntos == null) break block22;
                    exa_codigo = String.valueOf(reqProntos[aba.getColIndice("Exame")]);
                    mensagem.setIntCodigo(aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null);
                    mensagem.setMcoCodigo(aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)reqProntos[aba.getColIndice("C\u00f3d. Mat.")] : null);
                    String situacao = String.valueOf(reqProntos[aba.getColIndice("Sit")]);
                    if (BDUtil.isExameCurva(mensagem.getFilCodigo(), mensagem.getIntCodigo().toString(), exa_codigo, mensagem.getMcoCodigo())) break block23;
                    if (Funcoes.textoVazio(situacao)) break block22;
                    if (!situacao.equalsIgnoreCase(PanelAbaAbstrata.SIT_A_REPETIR)) break block22;
                }
                mensagem.setExames(new ArrayList<String>());
                mensagem.getExames().add(exa_codigo);
                mensagem.setRepeticao(true);
            }
            StringBuilder message = new StringBuilder();
            ExameMaterial[] exa_lista = null;
            if (req == null) {
                message.append("N");
                message.append('\u001c');
                this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada id: %s %s %s", mensagem.getFilCodigo(), mensagem.getReqCodigo(), mensagem.getRecCodigo()));
            } else {
                exa_lista = this.enviarMensagemEquipamento(mensagem);
            }
            if (exa_lista == null) {
                this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada id: %s %s %s", mensagem.getFilCodigo(), mensagem.getReqCodigo(), mensagem.getRecCodigo()));
                return;
            }
            for (ExameMaterial e : exa_lista) {
                ArrayList<String> guias = BDUtil.getReqMultiGuias(mensagem.getFilCodigo(), mensagem.getReqCodigo());
                for (String guia : guias) {
                    if (BDUtil.existeDesmembramento(mensagem.getFilCodigo(), mensagem.getIntCodigo(), guia, mensagem.getRecCodigo(), e.getNomeExame(), e.getCodigoMaterial())) {
                        ExameMaterial[] pais;
                        for (ExameMaterial p : pais = BDUtil.getDesmExamesPai(mensagem.getFilCodigo(), mensagem.getIntCodigo(), guia, mensagem.getRecCodigo(), e.getNomeExame(), e.getCodigoMaterial())) {
                            String tuboPai = BDUtil.getExameDesmembradoTuboPai(mensagem.getFilCodigo(), guia, mensagem.getRecCodigo(), mensagem.getIntCodigo(), p.getNomeExame(), p.getCodigoMaterial());
                            int situacao = BDUtil.getDesmSituacao(mensagem.getFilCodigo(), mensagem.getIntCodigo(), guia, p.getNomeExame(), p.getCodigoMaterial(), tuboPai, e.getNomeExame(), e.getCodigoMaterial());
                            BDUtil.setDesmSituacao(st, mensagem.getFilCodigo(), mensagem.getIntCodigo(), guia, p.getNomeExame(), p.getCodigoMaterial(), tuboPai, e.getNomeExame(), e.getCodigoMaterial(), situacao == 0 ? 1 : 3);
                            if (!BDUtil.isGrupoInteiroPendente(mensagem.getFilCodigo(), mensagem.getIntCodigo(), guia, p.getNomeExame(), p.getCodigoMaterial(), tuboPai)) continue;
                            this.atualizarSituacaoExame(st, mensagem.getFilCodigo(), guia, tuboPai, p.getNomeExame(), p.getCodigoMaterial(), mensagem.getIntCodigo(), null, situacao == 0 ? 1 : 3);
                        }
                        continue;
                    }
                    int situacao = this.getExameSituacao(st, mensagem.getFilCodigo(), mensagem.getIntCodigo(), guia, e.getNomeExame(), mensagem.getMcoCodigo(), mensagem.getRecCodigo());
                    if (situacao != 0 && situacao != 1) continue;
                    this.atualizarSituacaoExame(st, mensagem.getFilCodigo(), guia, mensagem.getRecCodigo(), e.getNomeExame(), mensagem.getMcoCodigo(), mensagem.getIntCodigo(), mensagem.getRack(), 1);
                }
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DimensionRxL: Host Query Response");
        }
    }

    private ExameMaterial[] enviarMensagemEquipamento(MensagemRecebida mensagem) throws IOException, SQLException {
        Statement st = Conexao.getStatement();
        ExameMaterial[] exa_lista = null;
        exa_lista = ExamesUtil.anexarCodigoMaterial(mensagem.getExames(), mensagem.getMcoCodigo());
        exa_lista = ExamesUtil.desmembrarExames(st, mensagem.getFilCodigo(), mensagem.getIntCodigo(), exa_lista);
        if (mensagem.isRepeticao()) {
            ArrayList<ExameMaterial> tmp = new ArrayList<ExameMaterial>();
            for (ExameMaterial ex : exa_lista) {
                int situacao = BDUtil.getExmSituacao(mensagem.getFilCodigo(), mensagem.getIntCodigo(), mensagem.getReqCodigo(), ex.getNomeExame(), mensagem.getMcoCodigo(), mensagem.getRecCodigo());
                if (situacao == -1) {
                    situacao = BDUtil.getExmSituacaoFilho(mensagem.getFilCodigo(), mensagem.getIntCodigo(), mensagem.getReqCodigo(), ex.getNomeExame(), mensagem.getMcoCodigo(), mensagem.getRecCodigo());
                }
                if (situacao != 5 && situacao != 3) continue;
                tmp.add(ex);
            }
            exa_lista = tmp.toArray(new ExameMaterial[tmp.size()]);
        }
        ArrayList<ExameMaterial> exa_temp = new ArrayList<ExameMaterial>();
        for (ExameMaterial e : exa_lista) {
            if (BDUtil.existeExame(mensagem.getFilCodigo(), mensagem.getIntCodigo(), mensagem.getReqCodigo(), e.getNomeExame(), e.getCodigoMaterial(), mensagem.getRecCodigo())) {
                if (exa_temp.contains(e)) continue;
                exa_temp.add(e);
                continue;
            }
            if (BDUtil.existeDesmembramento(mensagem.getFilCodigo(), mensagem.getIntCodigo(), mensagem.getReqCodigo(), mensagem.getRecCodigo(), e.getNomeExame(), e.getCodigoMaterial())) {
                if (exa_temp.contains(e)) continue;
                exa_temp.add(e);
                continue;
            }
            ArrayList<String> guias = BDUtil.getReqMultiGuias(mensagem.getFilCodigo(), mensagem.getReqCodigo());
            for (String guia : guias) {
                if (BDUtil.existeExame(mensagem.getFilCodigo(), mensagem.getIntCodigo(), guia, e.getNomeExame(), e.getCodigoMaterial(), mensagem.getRecCodigo())) {
                    if (exa_temp.contains(e)) continue;
                    exa_temp.add(e);
                    continue;
                }
                if (!BDUtil.existeDesmembramento(mensagem.getFilCodigo(), mensagem.getIntCodigo(), guia, mensagem.getRecCodigo(), e.getNomeExame(), e.getCodigoMaterial()) || exa_temp.contains(e)) continue;
                exa_temp.add(e);
            }
        }
        exa_lista = new ExameMaterial[exa_temp.size()];
        for (int i = 0; i < exa_temp.size(); ++i) {
            exa_lista[i] = (ExameMaterial)exa_temp.get(i);
        }
        ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, mensagem.getFilCodigo(), mensagem.getIntCodigo(), exa_lista);
        ArrayList<ExameMaterial> temporario = new ArrayList<ExameMaterial>();
        for (ExameMaterial e : alternativos) {
            if (Funcoes.textoVazio(e.getNomeExame()) || Funcoes.textoVazio(e.getCodigoMaterial()) || temporario.contains(e)) continue;
            temporario.add(e);
        }
        alternativos = new ExameMaterial[temporario.size()];
        for (int i = 0; i < temporario.size(); ++i) {
            alternativos[i] = (ExameMaterial)temporario.get(i);
        }
        if (alternativos.length == 0) {
            this.fireExcecaoEncontrada(String.format("Nehnum exame para enviar para a amostra %s %s %s ", mensagem.getFilCodigo(), mensagem.getIntCodigo(), mensagem.getReqCodigo()));
        }
        if (mensagem.getPacNome() != null) {
            this.getPortaCOM().write(this.montarMensagemEnvio(mensagem, alternativos));
        } else {
            this.fireExcecaoEncontrada("paciente n\u00e3o encontrado.");
        }
        return exa_lista;
    }

    private String montarMensagemEnvio(MensagemRecebida mensagem, ExameMaterial[] alternativos) throws SQLException {
        StringBuilder message = null;
        if (mensagem != null) {
            message = new StringBuilder();
            message.append(SAMPLE_REQUEST);
            message.append('\u001c');
            message.append("0");
            message.append('\u001c');
            message.append("0");
            message.append('\u001c');
            message.append("A");
            message.append('\u001c');
            String nomePaciente = "";
            nomePaciente = mensagem.getPacNome().length() > 27 ? mensagem.getPacNome().substring(0, 27) : mensagem.getPacNome();
            message.append(nomePaciente.replaceAll(" ", ","));
            message.append('\u001c');
            message.append(mensagem.getFilCodigo()).append(mensagem.getReqCodigo()).append(mensagem.getRecCodigo());
            message.append('\u001c');
            message.append(this.getMaterialExame(mensagem));
            message.append('\u001c');
            message.append("");
            message.append('\u001c');
            message.append("0");
            message.append('\u001c');
            message.append("1");
            message.append('\u001c');
            message.append("**");
            message.append('\u001c');
            message.append("1");
            message.append('\u001c');
            message.append(alternativos.length);
            for (ExameMaterial e : alternativos) {
                message.append('\u001c');
                message.append(e.getNomeExame());
            }
            message.append('\u001c');
            message.insert(0, '\u0002');
            message.append("F5");
            message.append('\u0003');
        }
        return message.toString();
    }

    private String getMaterialExame(MensagemRecebida mensagem) throws SQLException {
        String material = "1";
        StringBuilder buf = new StringBuilder();
        buf.append("select exa_codigo, mco_codigo, emi_alternativo, emi_curva, emi_material from examematinterface ");
        buf.append("where fil_codigo =").append(mensagem.getFilCodigo());
        buf.append(" and int_codigo = ").append(mensagem.getIntCodigo());
        buf.append(" and mco_codigo = ").append(mensagem.getMcoCodigo());
        buf.append(" limit 1");
        Statement st = Conexao.getStatement();
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next() && Funcoes.textoVazio(material = rs.getString("emi_material"))) {
            material = "1";
        }
        return material;
    }

    private void buscaExamesAbaProntos(MensagemRecebida mensagem) {
        PanelAbaAbstrata aba = this.equipamento.getTab(2);
        List<Object[]> reqs = this.getTodasRequisicaoAba(mensagem.getFilCodigo(), mensagem.getReqCodigo(), mensagem.getRecCodigo(), 2);
        for (Object[] r : reqs) {
            String situacao = String.valueOf(r[aba.getColIndice("Sit")]);
            if (Funcoes.textoVazio(situacao)) continue;
            if (!situacao.equalsIgnoreCase(PanelAbaAbstrata.SIT_A_REPETIR)) continue;
            mensagem.getExames().add((String)r[aba.getColIndice("Exame")]);
            mensagem.setIntCodigo(aba.getColIndice("Interface") >= 0 ? (String)r[aba.getColIndice("Interface")] : null);
            mensagem.getExames().add((String)r[aba.getColIndice("Exame")]);
            mensagem.setMcoCodigo(aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)r[aba.getColIndice("C\u00f3d. Mat.")] : null);
            mensagem.setPacNome(aba.getColIndice("Paciente") >= 0 ? (String)r[aba.getColIndice("Paciente")] : null);
            mensagem.setPacSexo(aba.getColIndice("S") >= 0 ? (String)r[aba.getColIndice("S")] : null);
            mensagem.setData(aba.getColIndice("Data") >= 0 ? (String)r[aba.getColIndice("Data")] : null);
            mensagem.setHora(aba.getColIndice("Hora") >= 0 ? (String)r[aba.getColIndice("Hora")] : null);
            mensagem.setRack(aba.getColIndice("Rack") >= 0 ? (String)r[aba.getColIndice("Rack")] : null);
            mensagem.setRepeticao(true);
        }
    }

    private void buscaExamesAbaPendentes(MensagemRecebida mensagem) {
        Object[] req = this.getRequisicaoAba(mensagem.getFilCodigo(), mensagem.getReqCodigo(), mensagem.getRecCodigo(), 1);
        PanelAbaAbstrata aba = this.equipamento.getTab(1);
        List<String> listaExames = mensagem.getExames();
        if (req != null) {
            List<Object[]> reqs = this.getTodasRequisicaoAba(mensagem.getFilCodigo(), mensagem.getReqCodigo(), mensagem.getRecCodigo(), 1);
            for (Object[] r : reqs) {
                String examesLista = (String)r[aba.getColIndice("Exame")];
                String[] examesEnvio = examesLista.split(" ");
                for (int i = 0; i < examesEnvio.length; ++i) {
                    listaExames.add(examesEnvio[i]);
                }
            }
            mensagem.setExames(listaExames);
        }
    }

    private void buscaExamesAbaNaoEnviados(MensagemRecebida mensagem) {
        Object[] req = this.getRequisicaoAba(mensagem.getFilCodigo(), mensagem.getReqCodigo(), mensagem.getRecCodigo(), 0);
        PanelAbaAbstrata aba = this.equipamento.getTab(0);
        ArrayList<String> listaExames = new ArrayList<String>();
        if (req != null) {
            mensagem.setIntCodigo(aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null);
            String exames = (String)req[aba.getColIndice("Exame")];
            String[] examesListas = exames.split(" ");
            for (int i = 0; i < examesListas.length; ++i) {
                listaExames.add(examesListas[i]);
            }
            mensagem.setMcoCodigo(aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null);
            mensagem.setPacNome(aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null);
            mensagem.setPacSexo(aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null);
            mensagem.setData(aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null);
            mensagem.setHora(aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null);
            mensagem.setRack(aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null);
        }
        mensagem.setExames(listaExames);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            if (acao.equals("A")) {
                String[] exas = exames.split(" ");
                Statement st = Conexao.getStatement();
                PanelAbaAbstrata aba = this.getAba(2);
                boolean curva = false;
                for (String exa_codigo : exas) {
                    String tubo = this.getTuboFilho(fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, aba, exa_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, !tubo.equals(rec_codigo) ? tubo : rec_codigo, exa_codigo, mco_codigo, int_codigo, rackposition, 5);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela(2);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento(this);
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    private String getChecksumMod256(String s) {
        int sum = 0;
        for (int i = 0; i < s.length(); ++i) {
            sum += (byte)s.charAt(i);
        }
        String checksum = Integer.toHexString(sum).toUpperCase();
        checksum = StringUtil.preencheString(checksum, 2, '0', 1);
        return checksum.substring(checksum.length() - 2);
    }

    private String getTuboFilho(String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, PanelAbaAbstrata aba, String exa_codigo) throws SQLException {
        List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
        block0: for (Object[] req : reqs) {
            ExameMaterial[] filhos;
            if (req[aba.getColIndice("Tubos Filhos")] == null) continue;
            ArrayList tubosFilhos = (ArrayList)req[aba.getColIndice("Tubos Filhos")];
            if (tubosFilhos.isEmpty()) continue;
            String exa = (String)req[aba.getColIndice("Exame")];
            if (!BDUtil.isExameCurva(fil_codigo, int_codigo, exa, mco_codigo)) continue;
            for (ExameMaterial exameMaterial : filhos = BDUtil.getExamesFilhos(fil_codigo, int_codigo, exa, mco_codigo)) {
                String tubo;
                if (!exameMaterial.getNomeExame().equalsIgnoreCase(exa_codigo) || (tubo = BDUtil.getExameDesmembradoTubo(fil_codigo, req_codigo, rec_codigo, int_codigo, exameMaterial.getNomeExame(), mco_codigo)) == null) continue;
                rec_codigo = tubo;
                continue block0;
            }
        }
        return rec_codigo;
    }

    protected void parseResultado(String message) {
        try {
            String[] campos = message.split(String.valueOf('\u001c'));
            ArrayList<String> fields = new ArrayList<String>();
            for (String c : campos) {
                fields.add(c);
            }
            Statement st = Conexao.getStatement();
            fields.remove(0);
            fields.remove(0);
            String req_codigo = (String)fields.remove(0);
            if (!Funcoes.isNumeric(req_codigo)) {
                req_codigo = (String)fields.remove(0);
            }
            if (!Funcoes.isNumeric(req_codigo)) {
                this.fireExcecaoEncontrada("C\u00f3digo da  requisi\u00e7\u00e3o inv\u00e1lida: " + req_codigo);
                return;
            }
            Integer digitosTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            if (req_codigo.length() != digitosTubo.intValue()) {
                this.fireExcecaoEncontrada("Requisi\u00e7\u00e3o n\u00e3o interfaceada: " + req_codigo);
            } else {
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                int num_testes = Integer.parseInt((String)fields.remove(0));
                while (num_testes > 0) {
                    ExameMaterial exame;
                    String emi_alternativo = ((String)fields.get(0)).trim().toUpperCase();
                    String ers_resultado = ((String)fields.get(1)).trim();
                    String unidadeResultado = ((String)fields.get(2)).trim();
                    String error = "";
                    if (fields.size() > 2 && Funcoes.isNumeric((String)fields.get(3))) {
                        num_testes += Integer.valueOf(((String)fields.get(3)).trim()).intValue();
                        error = ((String)fields.get(3)).trim();
                        fields.remove(3);
                    }
                    if (Funcoes.textoVazio(ers_resultado) && !Funcoes.textoVazio(error)) {
                        this.fireExcecaoEncontrada("Resultado com exce\u00e7\u00e3o no aparelho: " + emi_alternativo + " para a requisi\u00e7\u00e3o: " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                        continue;
                    }
                    String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                    if (Funcoes.textoVazio(int_codigo)) {
                        this.fireAtualizarTabela(1);
                        int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                        if (Funcoes.textoVazio(int_codigo)) {
                            this.fireExcecaoEncontrada("Configura\u00e7\u00e3o de interfaceamento do exame " + emi_alternativo + " n\u00e3o foi encontrado para a requisi\u00e7\u00e3o: " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                            continue;
                        }
                    }
                    if ((exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo)) == null) {
                        exame = BDUtil.getReqExameFilhoLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                    }
                    if (exame == null) {
                        this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    } else {
                        this.atualizarResultadoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, ers_resultado.replaceAll("\\.", ","));
                    }
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    if (Funcoes.textoVazio((String)fields.get(0))) {
                        fields.remove(0);
                    }
                    --num_testes;
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada("Resultado n\u00e3o encontrado");
        }
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"POLL", "Solicitar requisicao", "Resultado", "EOT"}, null);
        StringBuilder message = new StringBuilder();
        String tubo = JOptionPane.showInputDialog("Informe o tubo");
        if (op == 0) {
            message.append('\u0002');
            message.append(RESULT_MESSAGE);
            message.append('\u001c');
            message.append("0");
            message.append('\u001c');
            message.append("IRENE,MANHEZI,DURANTE");
            message.append('\u001c');
            message.append(tubo);
            message.append('\u001c');
            message.append("1");
            message.append('\u001c');
            message.append('\u001c');
            message.append("0");
            message.append('\u001c');
            message.append("373516150119");
            message.append('\u001c');
            message.append("1");
            message.append('\u001c');
            message.append("1");
            message.append('\u001c');
            message.append("2");
            message.append('\u001c');
            message.append("GLUC");
            message.append('\u001c');
            message.append("33");
            message.append('\u001c');
            message.append("U/L");
            message.append('\u001c');
            message.append('\u001c');
            message.append("CRE2");
            message.append('\u001c');
            message.append("0.81");
            message.append('\u001c');
            message.append("mg/dL");
            message.append('\u001c');
            message.append('\u001c');
            message.append("E7");
            message.append('\u0003');
        } else if (op == 1) {
            message.append('\u0002');
            message.append(REQUEST_ACCEPTANCE_MESSAGE);
            message.append('\u001c');
            message.append("A");
            message.append('\u001c');
            message.append('\u001c');
            message.append("A");
            message.append('\u001c');
            message.append("1");
            message.append('\u001c');
            message.append("42");
            message.append('\u001c');
            message.append("0E");
            message.append('\u0003');
            message.append('\u0002');
            message.append(QUERY_MESSAGE);
            message.append('\u001c');
            message.append(tubo);
        } else if (op == 2) {
            message.append('\u001c');
            message.append("89");
            message.append('\u0003');
        } else if (op == 3) {
            message.append('\u0002');
            message.append(POLL);
            message.append('\u001c');
            message.append("00001");
            message.append('\u001c');
        }
        this.getPortaCOM().read(message.toString(), message.toString().length());
    }
}

