/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.dimensionrxl;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    public static final char FS = '\u001c';
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public void dataChanged() {
        String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
        if (!message.equals("")) {
            this.parse(message);
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public String parse(String message) {
        try {
            this.getPortaCOM().write(String.valueOf('\u0006'));
            String msg = message.substring(this.getMsgStart().length());
            msg = msg.substring(0, msg.length() - this.getMsgEnd().length());
            String[] campos = msg.split(String.valueOf('\u001c'));
            String checkSum = campos[campos.length - 1];
            ArrayList<String> fields = new ArrayList<String>();
            for (String c : campos) {
                fields.add(c);
            }
            String type = (String)fields.remove(0);
            if (type.equalsIgnoreCase("P")) {
                this.parsePool(fields);
            } else if (type.equalsIgnoreCase("R")) {
                StringBuilder resp = new StringBuilder();
                resp.append('\u0002').append("M").append('\u001c').append("A").append('\u001c').append('\u001c').append("E2").append('\u0003');
                this.getPortaCOM().write(resp.toString());
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
            } else if (type.equalsIgnoreCase("C")) {
                this.parseControle(fields);
            } else if (type.equalsIgnoreCase("I")) {
                this.parseQuery(fields);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void teste() {
        StringBuilder message = new StringBuilder();
        message.append("R").append('\u001c');
        message.append('\u0003');
        message.append("L").append('\u001c');
        message.append("01").append('\u001c');
        message.append("010000021604").append('\u001c');
        message.append("SERUM").append('\u001c');
        message.append('\u0003');
        message.append("BRAZIL").append('\u001c');
        message.append("1").append('\u001c');
        message.append("2024-06-04 10:50:00").append('\u001c');
        message.append("1").append('\u001c');
        message.append("0").append('\u001c');
        message.append("1").append('\u001c');
        message.append("COL").append('\u001c');
        message.append("25").append('\u001c');
        message.append("").append('\u001c');
        message.append('\u0003');
        this.parseResultado(message.toString());
        this.getPortaCOM().read(message.toString(), message.toString().length());
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            if (acao.equals("A")) {
                String[] exas = exames.split(" ");
                Statement st = Conexao.getStatement();
                PanelAbaAbstrata aba = this.getAba(2);
                boolean curva = false;
                for (String exa_codigo : exas) {
                    String tubo = this.getTuboFilho(fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, aba, exa_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, !tubo.equals(rec_codigo) ? tubo : rec_codigo, exa_codigo, mco_codigo, int_codigo, rackposition, 5);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela(2);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getTuboFilho(String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, PanelAbaAbstrata aba, String exa_codigo) throws SQLException {
        List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
        block0: for (Object[] req : reqs) {
            ExameMaterial[] filhos;
            if (req[aba.getColIndice("Tubos Filhos")] == null) continue;
            ArrayList tubosFilhos = (ArrayList)req[aba.getColIndice("Tubos Filhos")];
            if (tubosFilhos.isEmpty()) continue;
            String exa = (String)req[aba.getColIndice("Exame")];
            if (!BDUtil.isExameCurva(fil_codigo, int_codigo, exa, mco_codigo)) continue;
            for (ExameMaterial exameMaterial : filhos = BDUtil.getExamesFilhos(fil_codigo, int_codigo, exa, mco_codigo)) {
                String tubo;
                if (!exameMaterial.getNomeExame().equalsIgnoreCase(exa_codigo) || (tubo = BDUtil.getExameDesmembradoTubo(fil_codigo, req_codigo, rec_codigo, int_codigo, exameMaterial.getNomeExame(), mco_codigo)) == null) continue;
                rec_codigo = tubo;
                continue block0;
            }
        }
        return rec_codigo;
    }

    private void parseResultado(String message) {
        try {
            String[] campos = message.split(String.valueOf('\u001c'));
            ArrayList<String> fields = new ArrayList<String>();
            for (String c : campos) {
                fields.add(c);
            }
            Statement st = Conexao.getStatement();
            fields.remove(0);
            fields.remove(0);
            fields.remove(0);
            String req_codigo = ((String)fields.remove(0)).trim();
            if (req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada("Requisi\u00e7\u00e3o n\u00e3o interfaceada: " + req_codigo);
            } else {
                if (!Funcoes.isNumeric(req_codigo)) {
                    this.fireExcecaoEncontrada("C\u00f3digo da requisi\u00e7\u00e3o inv\u00e1lida: " + req_codigo);
                    return;
                }
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                int num_testes = Integer.parseInt(((String)fields.remove(0)).trim());
                while (num_testes > 0) {
                    ExameMaterial exame;
                    String emi_alternativo = ((String)fields.remove(0)).trim().toUpperCase();
                    String ers_resultado = ((String)fields.remove(0)).trim();
                    fields.remove(0);
                    String error = ((String)fields.remove(0)).trim();
                    if (Funcoes.textoVazio(ers_resultado) && !Funcoes.textoVazio(error)) {
                        this.fireExcecaoEncontrada("Resultado com exce\u00e7\u00e3o no aparelho: " + emi_alternativo + " para a requisi\u00e7\u00e3o: " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                        continue;
                    }
                    String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                    if (Funcoes.textoVazio(int_codigo)) {
                        this.fireAtualizarTabela(1);
                        int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                        if (Funcoes.textoVazio(int_codigo)) {
                            this.fireExcecaoEncontrada("Configura\u00e7\u00e3o de interfaceamento do exame " + emi_alternativo + " n\u00e3o foi encontrado para a requisi\u00e7\u00e3o: " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                            continue;
                        }
                    }
                    if ((exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo)) == null) {
                        exame = BDUtil.getReqExameFilhoLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                    }
                    if (exame == null) {
                        this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    } else {
                        int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
                        this.atualizarResultadoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, ers_resultado.replaceAll("\\.", ","));
                        this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, null, situacao > 2 ? 4 : 2);
                    }
                    --num_testes;
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela(2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void parseQuery(ArrayList<String> fields) {
        try {
            ExameMaterial[] situacao;
            PanelAbaAbstrata aba;
            Object[] req;
            boolean repeticao;
            ExameMaterial[] exa_lista;
            String pac_exames;
            String mco_codigo;
            String int_codigo;
            String rack;
            String hora;
            String data;
            String pac_sexo;
            String pac_nome;
            String rec_codigo;
            String req_codigo;
            String fil_codigo;
            Statement st;
            block37: {
                String exa_codigo;
                block38: {
                    Object[] reqProntos;
                    st = Conexao.getStatement();
                    String requisicao = fields.remove(0);
                    fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial());
                    req_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    rec_codigo = requisicao.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    pac_nome = null;
                    pac_sexo = null;
                    Object pac_idade = null;
                    data = null;
                    hora = null;
                    rack = null;
                    Object prioridade = null;
                    int_codigo = null;
                    mco_codigo = null;
                    pac_exames = "";
                    String acao = "A";
                    exa_lista = null;
                    repeticao = false;
                    req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
                    aba = this.equipamento.getTab(0);
                    if (req != null) {
                        pac_exames = (String)req[aba.getColIndice("Exame")];
                    }
                    if (req == null) {
                        req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                        aba = this.equipamento.getTab(1);
                        if (req != null) {
                            pac_exames = pac_exames + " ";
                            List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                            for (Object[] r : reqs) {
                                pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                            }
                            pac_exames = pac_exames.trim();
                        }
                    }
                    if ((reqProntos = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                        req = reqProntos;
                        aba = this.equipamento.getTab(2);
                        if (req != null) {
                            pac_exames = pac_exames + " ";
                            List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                            for (Object[] r : reqs) {
                                situacao = String.valueOf(r[aba.getColIndice("Sit")]);
                                if (Funcoes.textoVazio((String)situacao)) continue;
                                if (!situacao.equalsIgnoreCase(PanelAbaAbstrata.SIT_A_REPETIR)) continue;
                                pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                                repeticao = true;
                            }
                            pac_exames = pac_exames.trim();
                        }
                    }
                    if (!Funcoes.textoVazio(pac_exames) || reqProntos == null) break block37;
                    exa_codigo = String.valueOf(reqProntos[aba.getColIndice("Exame")]);
                    int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                    mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)reqProntos[aba.getColIndice("C\u00f3d. Mat.")] : null;
                    String situacao2 = String.valueOf(reqProntos[aba.getColIndice("Sit")]);
                    if (BDUtil.isExameCurva(fil_codigo, int_codigo, exa_codigo, mco_codigo)) break block38;
                    if (Funcoes.textoVazio(situacao2)) break block37;
                    if (!situacao2.equalsIgnoreCase(PanelAbaAbstrata.SIT_A_REPETIR)) break block37;
                }
                pac_exames = exa_codigo;
                repeticao = true;
            }
            StringBuilder message = new StringBuilder();
            String[] exames = pac_exames.trim().split(" ");
            if (req == null) {
                message.append("N");
                message.append('\u001c');
                this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada id: %s %s %s", fil_codigo, req_codigo, rec_codigo));
            } else {
                void var28_40;
                void var28_37;
                int n;
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                rack = aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                String string = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : (mco_codigo = null);
                if (pac_nome.length() > 25) {
                    pac_nome = pac_nome.substring(0, 25);
                }
                exa_lista = ExamesUtil.anexarCodigoMaterial(exames, mco_codigo);
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
                if (repeticao) {
                    void var28_35;
                    ArrayList<ExameMaterial> tmp = new ArrayList<ExameMaterial>();
                    situacao = exa_lista;
                    n = situacao.length;
                    boolean bl = false;
                    while (var28_35 < n) {
                        ExameMaterial ex = situacao[var28_35];
                        int situacao3 = BDUtil.getExmSituacao(fil_codigo, int_codigo, req_codigo, ex.getNomeExame(), mco_codigo, rec_codigo);
                        if (situacao3 == -1) {
                            situacao3 = BDUtil.getExmSituacaoFilho(fil_codigo, int_codigo, req_codigo, ex.getNomeExame(), mco_codigo, rec_codigo);
                            if (situacao3 == 5 || situacao3 == 3) {
                                tmp.add(ex);
                            }
                        } else if (situacao3 == 5 || situacao3 == 3) {
                            tmp.add(ex);
                        }
                        ++var28_35;
                    }
                    exa_lista = tmp.toArray(new ExameMaterial[tmp.size()]);
                }
                ArrayList<ExameMaterial> exa_temp = new ArrayList<ExameMaterial>();
                situacao = exa_lista;
                n = situacao.length;
                boolean bl = false;
                while (var28_37 < n) {
                    ExameMaterial e = situacao[var28_37];
                    if (BDUtil.existeExame(fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo)) {
                        exa_temp.add(e);
                    } else if (BDUtil.existeDesmembramento(fil_codigo, int_codigo, req_codigo, rec_codigo, e.getNomeExame(), e.getCodigoMaterial())) {
                        exa_temp.add(e);
                    }
                    ++var28_37;
                }
                exa_lista = new ExameMaterial[exa_temp.size()];
                for (int i = 0; i < exa_temp.size(); ++i) {
                    exa_lista[i] = (ExameMaterial)exa_temp.get(i);
                }
                ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
                ArrayList<ExameMaterial> temporario = new ArrayList<ExameMaterial>();
                for (ExameMaterial e : alternativos) {
                    if (Funcoes.textoVazio(e.getNomeExame()) || Funcoes.textoVazio(e.getCodigoMaterial()) || temporario.contains(e)) continue;
                    temporario.add(e);
                }
                alternativos = new ExameMaterial[temporario.size()];
                boolean bl2 = false;
                while (var28_40 < temporario.size()) {
                    alternativos[var28_40] = (ExameMaterial)temporario.get((int)var28_40);
                    ++var28_40;
                }
                if (alternativos.length == 0) {
                    this.fireExcecaoEncontrada(String.format("Nehnum exame para enviar para a amostra %s %s %s ", fil_codigo, req_codigo, rec_codigo));
                }
                message.append("D");
                message.append('\u001c');
                message.append("0");
                message.append('\u001c');
                message.append("0");
                message.append('\u001c');
                message.append("A");
                message.append('\u001c');
                message.append(pac_nome);
                message.append('\u001c');
                message.append(fil_codigo).append(req_codigo).append(rec_codigo);
                message.append('\u001c');
                message.append("1");
                message.append('\u001c');
                message.append("");
                message.append('\u001c');
                message.append("0");
                message.append('\u001c');
                message.append("1");
                message.append('\u001c');
                message.append("**");
                message.append('\u001c');
                message.append("1");
                message.append('\u001c');
                message.append(alternativos.length);
                message.append('\u001c');
                for (ExameMaterial e : alternativos) {
                    message.append(e.getNomeExame()).append('\u001c');
                }
            }
            message.append(this.getChecksumMod256(message.toString()));
            message.insert(0, '\u0002');
            message.append('\u0003');
            this.getPortaCOM().write(message.toString());
            if (exa_lista != null) {
                for (void var28_43 : exa_lista) {
                    if (BDUtil.existeDesmembramento(fil_codigo, int_codigo, req_codigo, rec_codigo, var28_43.getNomeExame(), var28_43.getCodigoMaterial())) {
                        ExameMaterial[] pais;
                        for (ExameMaterial p : pais = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, req_codigo, rec_codigo, var28_43.getNomeExame(), var28_43.getCodigoMaterial())) {
                            String tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, p.getNomeExame(), p.getCodigoMaterial());
                            int situacao4 = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, p.getNomeExame(), p.getCodigoMaterial(), tuboPai, var28_43.getNomeExame(), var28_43.getCodigoMaterial());
                            BDUtil.setDesmSituacao(st, fil_codigo, int_codigo, req_codigo, p.getNomeExame(), p.getCodigoMaterial(), tuboPai, var28_43.getNomeExame(), var28_43.getCodigoMaterial(), situacao4 == 0 ? 1 : 3);
                            if (!BDUtil.isGrupoInteiroPendente(fil_codigo, int_codigo, req_codigo, p.getNomeExame(), p.getCodigoMaterial(), tuboPai)) continue;
                            this.atualizarSituacaoExame(st, fil_codigo, req_codigo, tuboPai, p.getNomeExame(), p.getCodigoMaterial(), int_codigo, null, situacao4 == 0 ? 1 : 3);
                        }
                        continue;
                    }
                    int situacao5 = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, var28_43.getNomeExame(), mco_codigo, rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, var28_43.getNomeExame(), mco_codigo, int_codigo, rack, situacao5 == 0 ? 1 : 3);
                }
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DimensionRxL: Host Query Response");
        }
    }

    private void parsePool(ArrayList<String> fields) {
        StringBuilder resp = new StringBuilder();
        resp.append('\u0002');
        resp.append("N");
        resp.append('\u001c');
        resp.append("6A");
        resp.append('\u0003');
        try {
            this.getPortaCOM().write(resp.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseControle(ArrayList<String> fields) {
        StringBuilder resp = new StringBuilder();
        resp.append('\u0002');
        resp.append("M");
        resp.append('\u001c');
        resp.append("A");
        resp.append('\u001c');
        resp.append('\u001c');
        resp.append("E2");
        resp.append('\u0003');
        try {
            this.getPortaCOM().write(resp.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getChecksumMod256(String s) {
        int sum = 0;
        for (int i = 0; i < s.length(); ++i) {
            sum += (byte)s.charAt(i);
        }
        String checksum = Integer.toHexString(sum).toUpperCase();
        checksum = StringUtil.preencheString(checksum, 2, '0', 1);
        return checksum.substring(checksum.length() - 2);
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (!this.listaRecebimento.isEmpty()) {
                    String message = this.listaRecebimento.remove(0);
                    InterfaceListener.this.parseResultado(message);
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

