/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.diana;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.diana.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    private InterfaceConfiguracao config;

    public RecordParser(InterfaceASTMListener equip) {
        super(equip);
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.config = new InterfaceConfiguracao();
        this.config.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    @Override
    public void recordFound(String record) throws Exception {
        String record_type = ASTMStandard.getRecordTypeIdentifier(record);
        if (record_type != null) {
            if (record_type.equals(ASTMStandard.RECORD_TYPE_HEADER)) {
                this.trataHeaderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_PATIENT)) {
                this.trataPatientRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_ORDER)) {
                this.trataOrderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_RESULT)) {
                this.trataResultRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_COMMENT)) {
                this.trataCommentRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_REQUEST)) {
                this.trataRequestRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_TERMINATION)) {
                this.trataTerminationRecord();
                return;
            }
        }
    }

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        String[] idade;
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
        if (req_codigo == null || req_codigo.equals("")) {
            req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        if (!Funcoes.textoVazio(req_codigo) && req_codigo.contains("^")) {
            req_codigo = StringUtil.limpaString(req_codigo, new String[]{"^"});
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        Map<Integer, String> components = this.equip.parseOrderTestIDField((String)order_fields.get(ASTMStandard.ORDER_FIELD_TEST_ID));
        String emi_alternativo = components.get(this.equip.TEST_ITEM_NAME);
        if (!(Funcoes.textoVazio(this.config.getAlternativoMaiorUmAnoIdade()) || Funcoes.textoVazio(this.config.getAlternativoMenorQueUmAnoDeIdade()) || (idade = BDUtil.getIdadeNacimentoPaciente(fil_codigo, req_codigo)) == null || idade.length <= 0 || idade[0].trim().isEmpty())) {
            if (idade[1].toString().equalsIgnoreCase("A")) {
                if (Integer.valueOf(idade[0].toString()) < 1 && (emi_alternativo.equalsIgnoreCase(this.config.getAlternativoMaiorUmAnoIdade()) || emi_alternativo.equalsIgnoreCase(this.config.getAlternativoMenorQueUmAnoDeIdade()))) {
                    emi_alternativo = this.config.getAlternativoMaiorUmAnoIdade();
                }
            } else {
                emi_alternativo = this.config.getAlternativoMaiorUmAnoIdade();
            }
        }
        Statement st = Conexao.getStatement();
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        this.exame_atual.put(INT_CODIGO, int_codigo);
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
        if (int_codigo == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            return;
        }
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        String flags;
        if (this.exame_atual == null) {
            return;
        }
        String action_code = (String)this.exame_atual.get(ACTION_CODE);
        String report_type = (String)this.exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                this.exame_atual = null;
                return;
            }
        }
        if (report_type != null) {
            this.equip.getClass();
            if (report_type.equals("X")) {
                this.exame_atual = null;
                return;
            }
        }
        Hashtable result_fields = ASTMStandard.parseDefaultResultRecord(record);
        String result_status = (String)result_fields.get(ASTMStandard.RESULT_FIELD_RESULT_STATUS);
        String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
        String int_codigo = (String)this.exame_atual.get(INT_CODIGO);
        String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
        String exa_codigo = (String)this.exame_atual.get(EXA_CODIGO);
        String mco_codigo = (String)this.exame_atual.get(MCO_CODIGO);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        String posicoes = (String)result_fields.get(ASTMStandard.RESULT_FIELD_UNITS);
        String[] posicoesResultados = posicoes.split("\\^");
        String resultado = (String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE);
        String[] resultados = resultado.split("\\^");
        int posGrupoSanguineo = -1;
        for (int i = 0; i < posicoesResultados.length; ++i) {
            if (!posicoesResultados[i].equalsIgnoreCase("Grupo")) continue;
            posGrupoSanguineo = i;
            break;
        }
        int posFatorRH = -1;
        for (int i = 0; i < posicoesResultados.length; ++i) {
            if (!posicoesResultados[i].equalsIgnoreCase("Rh")) continue;
            posFatorRH = i;
            break;
        }
        int posCoombsDireto = -1;
        for (int i = 0; i < posicoesResultados.length; ++i) {
            if (!posicoesResultados[i].equalsIgnoreCase("CD")) continue;
            posCoombsDireto = i;
            break;
        }
        int posCoombsIndireto = -1;
        for (int i = 0; i < posicoesResultados.length; ++i) {
            if (!posicoesResultados[i].equalsIgnoreCase("PAI")) continue;
            posCoombsIndireto = i;
            break;
        }
        Statement st = Conexao.getStatement();
        int sit = this.equip.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
        this.exame_atual.put("tipagem_sanguinea_grupo", "");
        this.exame_atual.put("tipagem_sanguinea_fator_rh", "");
        this.exame_atual.put("tipagem_sanguinea_coombs_direto", "");
        this.exame_atual.put("tipagem_sanguinea_coombs_indireto", "");
        if (resultados != null && (posGrupoSanguineo > -1 || posFatorRH > -1 || posCoombsDireto > -1 || posCoombsIndireto > -1)) {
            if (posGrupoSanguineo > -1) {
                this.exame_atual.put("tipagem_sanguinea_grupo", resultados[posGrupoSanguineo]);
            }
            if (posFatorRH > -1) {
                this.exame_atual.put("tipagem_sanguinea_fator_rh", resultados[posFatorRH]);
            }
            if (posCoombsDireto > -1) {
                this.exame_atual.put("tipagem_sanguinea_coombs_direto", resultados[posCoombsDireto]);
            }
            if (posCoombsIndireto > -1) {
                this.exame_atual.put("tipagem_sanguinea_coombs_indireto", resultados[posCoombsIndireto]);
            }
        } else {
            this.equip.fireExcecaoEncontrada("Resultado inv\u00e1lido para a amostra " + fil_codigo + " " + req_codigo + " " + rec_codigo + "Resultado " + resultado);
        }
        if ((flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS)) != null && !flags.equals("")) {
            this.exame_atual.put("flag_alerta", flags);
        }
        try {
            this.salvaExame(this.exame_atual);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String fil_codigo = (String)dados.remove(FIL_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String req_codigo = (String)dados.remove(REQ_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        String rec_codigo = (String)dados.remove(REC_CODIGO);
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        Statement st = Conexao.getStatement();
        this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, dados);
        if (!Funcoes.textoVazio(this.config.getExamePai()) && !Funcoes.textoVazio(this.config.getExameFilho())) {
            if (!this.config.getExamePai().contains("-")) {
                this.equip.fireExcecaoEncontrada("C\u00f3digo do exame pai deve ser informado corretamente. Exemplo: C\u00d3DIGO EXAME-C\u00d3DIGO MATERIAL");
            }
            if (!this.config.getExameFilho().contains("-")) {
                this.equip.fireExcecaoEncontrada("C\u00f3digo do exame filho deve ser informado corretamente. Exemplo: C\u00d3DIGO EXAME-C\u00d3DIGO MATERIAL");
            }
            String[] examePai = this.config.getExamePai().split("-");
            String[] exameFilho = this.config.getExameFilho().split("-");
            String codigoExamePai = examePai[0];
            String codigoMaterialPai = examePai[1];
            String codigoExameFilho = exameFilho[0];
            String codigoMaterialFilho = exameFilho[1];
            if (codigoExamePai.equalsIgnoreCase(exa_codigo) && codigoMaterialPai.equalsIgnoreCase(mco_codigo)) {
                this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, codigoExameFilho, codigoMaterialFilho, int_codigo, dados);
            }
        }
    }
}

