/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.deteccaomolecular3m;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.padroes.arquivo.InterfaceArquivoListener;
import jalis.util.Funcoes;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class InterfaceListener
extends InterfaceArquivoListener {
    private ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
    private String diretorioImportacao = "";
    private final String TAG_ETIQUETA = "ID da Amostra";
    private final String TAG_ALTERNATIVO = "Tipo de ensaio";
    private final String TAG_RESULTADO = "Resultado";
    private final int LINHA_INDEX = 16;
    private final String[] tipoDeArquivo = new String[]{"xlsx", "xls"};

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.diretorioImportacao = c.getDiretorioImportacao();
    }

    @Override
    public void buscarResultados(Date inicio, Date termino) {
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser("Arquivo para importa\u00e7\u00e3o", this.diretorioImportacao);
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de Planilha de resultado", this.tipoDeArquivo));
            if (chooser.showOpenDialog(null) == 0) {
                String path = chooser.getSelectedFile().getPath();
                this.parse(path);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
    }

    @Override
    public String parse(String path) {
        File file = new File(path);
        try {
            Statement st = Conexao.getStatement();
            HashMap<String, Integer> listaIndex = new HashMap<String, Integer>();
            List<List<Object>> planilhaResultado = null;
            planilhaResultado = file.getName().toUpperCase().contains(this.tipoDeArquivo[0].toUpperCase()) ? this.lerXlsx(file, "", true, listaIndex) : this.lerXls(file, "", true, listaIndex);
            for (int i = 0; i < planilhaResultado.size(); ++i) {
                String alternativo;
                String rec_codigo;
                String req_codigo;
                List<Object> cabecalho = planilhaResultado.get(0);
                List<Object> retorno = planilhaResultado.get(i);
                String amostra = retorno.get(listaIndex.get("ID da Amostra")).toString().trim();
                Integer tamanhoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (amostra.length() < tamanhoTubo) {
                    amostra = "0" + amostra;
                }
                if (amostra.isEmpty()) continue;
                if (amostra.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                    this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada %s.", amostra));
                    continue;
                }
                String fil_codigo = amostra.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String int_codigo = this.getIntCodigo(fil_codigo, req_codigo = amostra.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()), rec_codigo = amostra.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()), alternativo = retorno.get(listaIndex.get("Tipo de ensaio")).toString());
                if (int_codigo == null) {
                    this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada %s %s %s.", fil_codigo, req_codigo, rec_codigo));
                    continue;
                }
                Map<String, Object> resultadosMap = null;
                try {
                    resultadosMap = this.resultadoMap(retorno, cabecalho, listaIndex);
                    ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, alternativo);
                    if (exame != null) {
                        this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, resultadosMap);
                        Conexao.arquivaSQL();
                    } else {
                        this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada para o exame SALIVA %s %s %s.", fil_codigo, req_codigo, rec_codigo));
                    }
                    this.fireAtualizarTabela();
                    continue;
                }
                catch (Exception e) {
                    this.fireExcecaoEncontrada("Resultado n\u00e3o encontrado " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada("Resultado n\u00e3o encontrado no arquivo " + file.getName() + e.getMessage());
        }
        return null;
    }

    private Map<String, Object> resultadoMap(List<Object> retorno, List<Object> cabecalho, HashMap<String, Integer> listaIndex) throws Exception {
        if (Funcoes.textoVazio(retorno.get(listaIndex.get("Resultado")).toString())) {
            throw new Exception(" Amostra: " + retorno.get(listaIndex.get("ID da Amostra")));
        }
        HashMap<String, Object> resultadosMap = new HashMap<String, Object>();
        resultadosMap.put("resultado_quantitativo", retorno.get(listaIndex.get("Resultado")));
        return resultadosMap;
    }

    private List<List<Object>> lerXlsx(File file, String string, boolean retornaValor, HashMap<String, Integer> listaIndex) throws Exception {
        ArrayList<List<Object>> linhas = new ArrayList<List<Object>>();
        XSSFWorkbook rb = new XSSFWorkbook((InputStream)new FileInputStream(file));
        XSSFSheet plan1 = rb.getSheetAt(0);
        this.processaLinha(linhas, listaIndex, plan1.getRow(16).cellIterator(), plan1.iterator(), retornaValor);
        return linhas;
    }

    private List<List<Object>> lerXls(File file, String string, boolean retornaValor, HashMap<String, Integer> listaIndex) throws Exception {
        ArrayList<List<Object>> linhas = new ArrayList<List<Object>>();
        Workbook workbook = WorkbookFactory.create((InputStream)new FileInputStream(file));
        Sheet plan1 = workbook.getSheetAt(0);
        this.processaLinha(linhas, listaIndex, plan1.getRow(16).cellIterator(), plan1.iterator(), retornaValor);
        return linhas;
    }

    private void processaLinha(List<List<Object>> linhas, HashMap<String, Integer> listaIndex, Iterator<Cell> iteratorCelulaIndex, Iterator<Row> iteratorLinhas, boolean retornaValor) {
        int registroAtual = 0;
        this.preencheIndexInformacoes(listaIndex, iteratorCelulaIndex);
        while (iteratorLinhas.hasNext()) {
            Row linha = iteratorLinhas.next();
            if (!Funcoes.objectIsNull(linha) && registroAtual > 16) {
                linhas.add(this.getCelulaValor(linha, retornaValor));
            }
            ++registroAtual;
        }
    }

    private List<Object> getCelulaValor(Row linha, boolean retornaValor) {
        ArrayList<Object> colunas = new ArrayList<Object>();
        for (Cell cell : linha) {
            try {
                switch (cell.getCellType()) {
                    case 3: {
                        colunas.add("");
                        break;
                    }
                    case 4: {
                        colunas.add(new Boolean(cell.getBooleanCellValue()));
                        break;
                    }
                    case 5: {
                        colunas.add(cell.getErrorCellValue());
                        break;
                    }
                    case 2: {
                        colunas.add(retornaValor ? Double.valueOf(cell.getNumericCellValue()) : cell.getCellFormula());
                        break;
                    }
                    case 0: {
                        Double valor = cell.getNumericCellValue();
                        String valorFormatado = new BigDecimal(valor).toString();
                        colunas.add(valorFormatado);
                        break;
                    }
                    case 1: {
                        colunas.add(cell.getStringCellValue());
                        break;
                    }
                    default: {
                        colunas.add(cell.getStringCellValue());
                        break;
                    }
                }
            }
            catch (Exception e) {
                colunas.add("");
            }
        }
        return colunas;
    }

    private void preencheIndexInformacoes(HashMap<String, Integer> listaIndex, Iterator<Cell> iterator) {
        int posicao = 0;
        while (iterator.hasNext()) {
            Cell celula = iterator.next();
            if (Funcoes.objectIsNull(celula)) continue;
            if (celula.toString().equals("Tipo de ensaio")) {
                listaIndex.put("Tipo de ensaio", posicao);
            }
            if (celula.toString().equals("ID da Amostra")) {
                listaIndex.put("ID da Amostra", posicao);
            }
            if (celula.toString().equals("Resultado")) {
                listaIndex.put("Resultado", posicao);
            }
            ++posicao;
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            String[] exms;
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            for (String s : exms = exames.split(" ", 0)) {
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, s, mco_codigo, int_codigo, null, 1);
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            this.equipamento.atualizarTabela(0);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return "";
        }
    }
}

