/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.denscan;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.comunicacao.PortaFILE;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.denscan.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.padroes.arquivo.InterfaceArquivoListener;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.codec.binary.Base64;

public class InterfaceListener
extends InterfaceArquivoListener {
    private InterfaceConfiguracao configuracao;
    private String DIRETORIO_EXPORTACAO = "";
    private String DIRETORIO_IMPORTACAO = "";
    private String COMANDO_EXPORTACAO = "";
    private String COMANDO_IMPORTACAO = "";
    private String NOME_EXAME = "EFRO";

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setDiretorioExportacao(c.getDiretorioExportacao());
        this.configuracao.setDiretorioImportacao(c.getDiretorioImportacao());
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.DIRETORIO_EXPORTACAO = c.getDiretorioExportacao();
        this.COMANDO_EXPORTACAO = c.getComandoExportacao();
        this.DIRETORIO_IMPORTACAO = c.getDiretorioImportacao();
        this.COMANDO_IMPORTACAO = c.getComandoImportacao();
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            String[] exms;
            String codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            codigo = codigo + Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            codigo = codigo + Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            String arquivo = codigo + ".txt";
            this.configuracao.setArquivoExportacao(arquivo);
            arquivo = this.DIRETORIO_EXPORTACAO + "\\" + arquivo;
            PortaFILE p = (PortaFILE)this.getPortaCOM();
            p.createFile(arquivo);
            StringBuilder texto = new StringBuilder();
            texto.append("P | ").append(codigo).append(";").append(pac_nome).append(";").append(";").append(";").append(pac_sexo).append(";");
            p.write(texto.toString());
            p.newLine();
            texto.setLength(0);
            texto.append("A | ").append(codigo).append(";").append(this.configuracao.getRequisitante()).append(";").append(this.configuracao.getAnalista()).append(";").append(this.configuracao.getMetodologia()).append(";").append(this.configuracao.getDepartamento()).append(";").append(data).append(";").append(";").append(";").append(";");
            p.write(texto.toString());
            p.newLine();
            p.closeFile();
            String cmd = this.configuracao.parseComando(this.COMANDO_EXPORTACAO);
            Process proc = Runtime.getRuntime().exec(cmd);
            proc.waitFor();
            Statement st = Conexao.getStatement();
            for (String s : exms = exames.split(" ", 0)) {
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, s, mco_codigo, int_codigo, null, 1);
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            this.equipamento.atualizarTabela(0);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (IOException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        catch (InterruptedException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }

    @Override
    public String parse(String message) {
        String req_codigo = message.substring(message.lastIndexOf("\\") + 1);
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.fireExcecaoEncontrada(msg.toString());
            return null;
        }
        try {
            Statement st = Conexao.getStatement();
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, this.NOME_EXAME);
            if (int_codigo == null) {
                this.fireExcecaoEncontrada("Interfaceamento do exame " + this.NOME_EXAME + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                return "Erro ao processar resultado";
            }
            ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, this.NOME_EXAME);
            if (exame == null) {
                this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + this.NOME_EXAME + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            } else {
                HashMap<String, Object> dados = new HashMap<String, Object>();
                File f = new File(message + ".txt");
                this.parseResultadoTexto(f, dados);
                f.delete();
                f = new File(message + "_g.bmp");
                this.parseResultadoImagem(f, dados, "eforese_grafico");
                f.delete();
                f = new File(message + "_i.bmp");
                this.parseResultadoImagem(f, dados, "eforese_curva");
                f.delete();
                if (exame != null) {
                    this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "Erro ao realizar parse de dados recebidos do equipamento";
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return "Erro ao realizar parse de dados recebidos do equipamento";
        }
        return "Resultados recebidos com sucesso";
    }

    private void parseResultadoTexto(File file, Map<String, Object> dados) throws Exception {
        String[] linhas;
        for (String s : linhas = StringUtil.lerArquivoTexto(file).split("\n")) {
            String[] campos;
            String l = s.substring(0, 1);
            if (l.equalsIgnoreCase("R")) {
                campos = s.split(";");
                if (campos[1].equalsIgnoreCase("albumina")) {
                    dados.put("albumina_porcentagem", this.arrumaValor(campos[2]));
                    dados.put("albumina_contagem", this.arrumaValor(campos[3]));
                    continue;
                }
                if (campos[1].equalsIgnoreCase("alfa 1")) {
                    dados.put("alfa1_porcentagem", this.arrumaValor(campos[2]));
                    dados.put("alfa1_contagem", this.arrumaValor(campos[3]));
                    continue;
                }
                if (campos[1].equalsIgnoreCase("alfa 2")) {
                    dados.put("alfa2_porcentagem", this.arrumaValor(campos[2]));
                    dados.put("alfa2_contagem", this.arrumaValor(campos[3]));
                    continue;
                }
                if (campos[1].equalsIgnoreCase("beta")) {
                    dados.put("beta_porcentagem", this.arrumaValor(campos[2]));
                    dados.put("beta_contagem", this.arrumaValor(campos[3]));
                    continue;
                }
                if (!campos[1].equalsIgnoreCase("gama")) continue;
                dados.put("gama_porcentagem", this.arrumaValor(campos[2]));
                dados.put("gama_contagem", this.arrumaValor(campos[3]));
                continue;
            }
            if (!l.equalsIgnoreCase("A")) continue;
            campos = s.split(";");
            dados.put("proteinas_totais", this.arrumaValor(campos[6]));
            dados.put("relacao_ag", this.arrumaValor(campos[8]));
        }
    }

    private String arrumaValor(String valor) {
        if (valor.startsWith("+") || valor.startsWith("-")) {
            return valor.substring(1);
        }
        return valor;
    }

    private void parseResultadoImagem(File file, Map<String, Object> dados, String campo) {
        try {
            BufferedImage image = ImageIO.read(file);
            ImageIcon ib = new ImageIcon(image);
            String foto64 = new Base64().encodeAsString(ImagemUtils.imageToByte(ib.getImage()));
            dados.put(campo, foto64);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void buscarResultados(Date inicio, Date termino) {
        try {
            this.configuracao.setDataInicial(new SimpleDateFormat("dd/MM/yyyy").format(inicio));
            this.configuracao.setDataFinal(new SimpleDateFormat("dd/MM/yyyy").format(termino));
            String cmd = this.configuracao.parseComando(this.COMANDO_IMPORTACAO);
            Process proc = Runtime.getRuntime().exec(cmd);
            proc.waitFor();
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".txt");
                }
            };
            File file = new File(this.DIRETORIO_IMPORTACAO);
            File[] files = file.listFiles(filter);
            if (files != null) {
                for (File f : files) {
                    String path = f.getAbsolutePath();
                    this.parse(path.substring(0, path.length() - 4));
                }
            }
        }
        catch (IOException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        catch (InterruptedException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
    }
}

