/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.denscan;

import jalis.laboratorio.interfaceamento.InterfaceamentoConfiguracao;
import jalis.util.StringUtil;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;

public class InterfaceConfiguracao
extends InterfaceamentoConfiguracao {
    private String ARQUIVO_EXPORTACAO = "arquivoExportacao";
    private String DIRETORIO_EXPORTACAO = "diretorioExportacao";
    private String DIRETORIO_IMPORTACAO = "diretorioImportacao";
    private String DATA_INICIAL = "dataInicial";
    private String DATA_FINAL = "dataFinal";
    private String METODOLOGIA = "metodologia";
    private String REQUISITANTE = "requisitante";
    private String ANALISTA = "analista";
    private String DEPARTAMENTO = "departamento";
    private String arquivoExportacao;
    private String diretorioExportacao;
    private String diretorioImportacao;
    private String dataInicial;
    private String dataFinal;
    private String metodologia;
    private String requisitante;
    private String analista;
    private String departamento;

    public String getAnalista() {
        return this.analista;
    }

    public void setAnalista(String analista) {
        this.analista = analista;
    }

    public String getDepartamento() {
        return this.departamento;
    }

    public void setDepartamento(String departamento) {
        this.departamento = departamento;
    }

    public String getMetodologia() {
        return this.metodologia;
    }

    public void setMetodologia(String metodologia) {
        this.metodologia = metodologia;
    }

    public String getRequisitante() {
        return this.requisitante;
    }

    public void setRequisitante(String requisitante) {
        this.requisitante = requisitante;
    }

    @Override
    public String[] getConstantes() {
        return new String[]{this.ARQUIVO_EXPORTACAO, this.DIRETORIO_EXPORTACAO, this.DIRETORIO_IMPORTACAO, this.DATA_FINAL, this.DATA_INICIAL};
    }

    @Override
    public String parseComando(String comando) {
        for (String s : this.getConstantes()) {
            if (comando.indexOf(s) < 0) continue;
            if (s.equalsIgnoreCase(this.ARQUIVO_EXPORTACAO)) {
                comando = comando.substring(0, comando.indexOf(s)) + this.getArquivoExportacao() + comando.substring(comando.indexOf(s) + this.ARQUIVO_EXPORTACAO.length());
                continue;
            }
            if (s.equalsIgnoreCase(this.DIRETORIO_EXPORTACAO)) {
                comando = comando.substring(0, comando.indexOf(s)) + this.getDiretorioExportacao() + comando.substring(comando.indexOf(s) + this.DIRETORIO_EXPORTACAO.length());
                continue;
            }
            if (s.equalsIgnoreCase(this.DIRETORIO_IMPORTACAO)) {
                comando = comando.substring(0, comando.indexOf(s)) + this.getDiretorioImportacao() + comando.substring(comando.indexOf(s) + this.DIRETORIO_IMPORTACAO.length());
                continue;
            }
            if (s.equalsIgnoreCase(this.DATA_FINAL)) {
                comando = comando.substring(0, comando.indexOf(s)) + this.getDataFinal() + comando.substring(comando.indexOf(s) + this.DATA_FINAL.length());
                continue;
            }
            if (!s.equalsIgnoreCase(this.DATA_INICIAL)) continue;
            comando = comando.substring(0, comando.indexOf(s)) + this.getDataInicial() + comando.substring(comando.indexOf(s) + this.DATA_INICIAL.length());
        }
        return comando;
    }

    public String getArquivoExportacao() {
        return this.arquivoExportacao;
    }

    public void setArquivoExportacao(String arquivoExportacao) {
        this.arquivoExportacao = arquivoExportacao;
    }

    public String getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(String dataFinal) {
        this.dataFinal = dataFinal;
    }

    public String getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(String dataInicial) {
        this.dataInicial = dataInicial;
    }

    public String getDiretorioExportacao() {
        return this.diretorioExportacao;
    }

    public void setDiretorioExportacao(String diretorioExportacao) {
        this.diretorioExportacao = diretorioExportacao;
    }

    public String getDiretorioImportacao() {
        return this.diretorioImportacao;
    }

    public void setDiretorioImportacao(String diretorioImportacao) {
        this.diretorioImportacao = diretorioImportacao;
    }

    @Override
    public String getXmlVariaveis() {
        String str = super.getXmlVariaveis();
        try {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir("variavel");
            xml.escrever("nome", this.METODOLOGIA);
            xml.escrever("valor", this.getMetodologia());
            xml.escrever("tipo", EDIT_RELACIONA);
            xml.fechar("variavel");
            xml.abrir("variavel");
            xml.escrever("nome", this.REQUISITANTE);
            xml.escrever("valor", this.getRequisitante());
            xml.escrever("tipo", EDIT_RELACIONA);
            xml.fechar("variavel");
            xml.abrir("variavel");
            xml.escrever("nome", this.ANALISTA);
            xml.escrever("valor", this.getAnalista());
            xml.escrever("tipo", EDIT_RELACIONA);
            xml.fechar("variavel");
            xml.abrir("variavel");
            xml.escrever("nome", this.DEPARTAMENTO);
            xml.escrever("valor", this.getDepartamento());
            xml.escrever("tipo", EDIT_RELACIONA);
            xml.fechar("variavel");
            return str + xml.getXML();
        }
        catch (XMLStringBuilderException e) {
            e.printStackTrace();
            return str;
        }
    }

    @Override
    public void setXmlVariaveis(String xml) {
        String[] variaveis;
        for (String s : variaveis = StringUtil.getValores(xml, "variavel")) {
            String nome = StringUtil.getValor(s, "nome");
            String valor = StringUtil.getValor(s, "valor");
            if (nome.equalsIgnoreCase(this.METODOLOGIA)) {
                this.setMetodologia(valor);
                continue;
            }
            if (nome.equalsIgnoreCase(this.REQUISITANTE)) {
                this.setRequisitante(valor);
                continue;
            }
            if (nome.equalsIgnoreCase(this.ANALISTA)) {
                this.setAnalista(valor);
                continue;
            }
            if (!nome.equalsIgnoreCase(this.DEPARTAMENTO)) continue;
            this.setDepartamento(valor);
        }
        super.setXmlVariaveis(xml);
    }

    @Override
    public String getNomeVariavel(String variavel) {
        if (variavel.equalsIgnoreCase(this.METODOLOGIA)) {
            return "Metodologia";
        }
        if (variavel.equalsIgnoreCase(this.REQUISITANTE)) {
            return "Requisitante";
        }
        if (variavel.equalsIgnoreCase(this.ANALISTA)) {
            return "Analista";
        }
        if (variavel.equalsIgnoreCase(this.DEPARTAMENTO)) {
            return "Departamento";
        }
        return super.getNomeVariavel(variavel);
    }
}

