/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.combilyzer13Human;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    protected final String NOME_EXAME = "URI";
    protected int MAX_PATIENT_NAME_CHARS = 25;
    public static final int EQUIP_TIMEOUT = 5000;
    public static final int TIPO_REQ_NOVO = 0;
    public static final int TIPO_REQ_REPETICAO = 1;
    public boolean exr_codigoapoiado = false;
    protected String int_codigo;
    protected String fil_codigo;
    protected String req_codigo;
    protected String mco_codigo;
    protected String rec_codigo;
    protected String pac_nome;
    protected String pac_exames;
    protected String pac_sexo;
    protected String req_idade;
    protected String req_data;
    protected String req_hora;
    protected String acao;
    protected String frame;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    Map<String, String> camposDecimais = new HashMap<String, String>();

    public InterfaceListener() {
        Statement st = Conexao.getStatement();
        this.exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
        this.camposDecimais.put("UBG", "URO2");
        this.camposDecimais.put("BIL", "BIL2");
        this.camposDecimais.put("URO", "URO2");
        this.camposDecimais.put("CET", "KET2");
        this.camposDecimais.put("CRE", "CRE2");
        this.camposDecimais.put("SAN", "BLD2");
        this.camposDecimais.put("ALB", "ALB2");
        this.camposDecimais.put("NIT", "NIT2");
        this.camposDecimais.put("LEU", "LEU2");
        this.camposDecimais.put("GLI", "GLU2");
        this.camposDecimais.put("DEN", "SG2");
        this.camposDecimais.put("p.H", "PH2");
        this.camposDecimais.put("VTC", "VTC2");
        this.camposDecimais.put("VC", "VC2");
        this.camposDecimais.put("PRO", "PRO2");
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    void limpaDadosRequisicao() {
        this.frame = null;
        this.fil_codigo = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        this.fil_codigo = fil_codigo;
        this.int_codigo = int_codigo;
        this.req_codigo = req_codigo;
        this.pac_nome = pac_nome;
        this.pac_sexo = pac_sexo;
        this.req_idade = pac_idade;
        this.req_data = data;
        this.req_hora = hora;
        this.mco_codigo = mco_codigo;
        this.rec_codigo = rec_codigo;
        this.pac_exames = exames;
        this.acao = acao;
        try {
            this.encerrarTransmissao();
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Override
    public synchronized String parse(String message) {
        String retorno = null;
        Object checksum = null;
        if (!message.startsWith(this.getMsgStart()) || !message.endsWith(this.getMsgEnd())) {
            return "Erro ao receber o bloco de resultados, caracter inicial ou final n\u00e3o localizado";
        }
        if (message.startsWith(this.getMsgStart())) {
            message = message.replaceFirst(this.getMsgStart(), "");
        }
        if (message.endsWith(this.getMsgEnd())) {
            message = message.replaceFirst(this.getMsgEnd(), "");
        }
        ArrayList<String> fields = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(message, new String(new char[]{'\r', '\n'}));
        while (tokenizer.hasMoreElements()) {
            fields.add(tokenizer.nextToken());
        }
        if (fields != null && !fields.isEmpty()) {
            try {
                retorno = this.parseResults(fields);
                if (retorno == null) {
                    return "";
                }
                if (retorno.startsWith("Erro")) {
                    return retorno;
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, 2000);
                return retorno;
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                    return "Erro ao inserir resultados recebidos ao banco de dados";
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    return "Erro ao anular os dados recebidos";
                }
            }
        }
        return "Erro ao realizar parse dos dados recebidos";
    }

    private String parseResults(ArrayList<String> fields) throws SQLException {
        try {
            String[] codigoJalis;
            String DATA = "Data:";
            String DATA_INGLES = "Date:";
            String NO = "No.";
            String ID2 = "ID:";
            int INDEX_COPIA = 5;
            boolean pesquisar = true;
            String data = "";
            String id = "";
            String requisicao = "";
            while (pesquisar && fields.size() > 0) {
                if (fields.get(0).indexOf("Data:") > -1 || fields.get(0).indexOf("Date:") > -1) {
                    data = fields.get(0).substring("Data:".length() + 1, fields.get(0).length());
                } else if (fields.get(0).indexOf("ID:") > -1) {
                    requisicao = fields.get(0).substring("ID:".length() + 1, fields.get(0).length());
                    if (Funcoes.textoVazio(requisicao)) {
                        requisicao = fields.get(0).trim();
                    }
                    fields.remove(0);
                    pesquisar = false;
                } else if (fields.get(0).indexOf("No.") > -1) {
                    id = fields.get(0).substring("No.".length() + 1, fields.get(0).length());
                }
                if (!pesquisar) continue;
                fields.remove(0);
            }
            if (Funcoes.textoVazio(requisicao) || !Funcoes.isNumeric(requisicao)) {
                this.fireExcecaoEncontrada("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o localizado nos dados recebidos");
                return null;
            }
            Statement st = Conexao.getStatement();
            requisicao = StringUtil.preencheString(requisicao.trim(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            this.fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            this.rec_codigo = requisicao.substring(requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            this.req_codigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            this.int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, "URI");
            HashMap<String, Object> urina = new HashMap<String, Object>();
            urina.put("ID", id);
            for (String s : fields) {
                if (Funcoes.textoVazio(s)) continue;
                String campo = s.substring(0, 5).trim();
                String resultado = s.substring(campo.length() + 1, s.length()).trim();
                String campoTraduzido = campo;
                if (campo.equals("BIL")) {
                    campoTraduzido = "BIL";
                } else if (campo.equals("KET")) {
                    campoTraduzido = "CET";
                } else if (campo.equals("BLD")) {
                    campoTraduzido = "SAN";
                } else if (campo.equals("ALB")) {
                    campoTraduzido = "ALB";
                } else if (campo.equals("NIT")) {
                    campoTraduzido = "NIT";
                } else if (campo.equals("LEU")) {
                    campoTraduzido = "LEU";
                } else if (campo.equals("GLU")) {
                    campoTraduzido = "GLI";
                } else if (campo.equals("pH")) {
                    campoTraduzido = "p.H";
                } else if (campo.equals("VC")) {
                    campoTraduzido = "VTC";
                } else if (campo.equals("A:C")) {
                    campoTraduzido = "VC";
                } else if (campo.equals("SG")) {
                    campoTraduzido = "DEN";
                }
                String resultadoDecimal = resultado.replaceAll("[a-zA-Z\\/<>]", "");
                if (Funcoes.isNumeric(resultadoDecimal.trim()) && this.camposDecimais.containsKey(campoTraduzido)) {
                    urina.put(this.camposDecimais.get(campoTraduzido), resultadoDecimal.replace('.', ',').trim());
                }
                urina.put(campoTraduzido, resultado);
            }
            ExameMaterial exame = this.getReqExameLIS(this.fil_codigo, this.int_codigo, this.req_codigo, this.rec_codigo, "URI");
            if (exame == null) {
                this.fireExcecaoEncontrada("Nenhum exame localizado nos dados recebidos");
                return null;
            }
            String exa_codigo = exame.getNomeExame();
            String mco_codigo = exame.getCodigoMaterial();
            if (this.exr_codigoapoiado && !Funcoes.textoVazio((codigoJalis = BDUtil.getCodigoJalis(this.fil_codigo, this.req_codigo, this.rec_codigo, this.int_codigo, exa_codigo, mco_codigo))[0]) && !Funcoes.textoVazio(codigoJalis[1]) && !Funcoes.textoVazio(codigoJalis[2])) {
                this.fil_codigo = codigoJalis[0];
                this.req_codigo = codigoJalis[1];
                this.rec_codigo = codigoJalis[2];
            }
            this.atualizarDadosExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, exa_codigo, mco_codigo, this.int_codigo, urina);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }

    public void encerrarTransmissao() throws Exception {
        Statement st = Conexao.getStatement();
        this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
        Conexao.arquivaSQL();
        this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + this.pac_nome, 0, 10000);
        if (this.acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.interromperTimer();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    public void requisicaoExistente() throws Exception {
        Statement st = Conexao.getStatement();
        this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
        Conexao.arquivaSQL();
        this.fireMensagemEnviada("Pedido(s) re-enviado(s) com sucesso para " + this.pac_nome + ".", 0, 10000);
        this.interromperTimer();
        this.getPortaCOM().clearInputString();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(5000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    private void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(5000);
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    private void abortarRecepcao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(3000);
    }

    public void caracterNaoEsperado() throws Exception {
    }

    private void tratarAcknowledge() throws Exception {
        if (!this.isTX()) {
            this.caracterNaoEsperado();
        }
    }

    @Override
    public void handShakeCharReceived(final char c) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    switch (c) {
                        case '\u0006': {
                            InterfaceListener.this.tratarAcknowledge();
                            break;
                        }
                        default: {
                            InterfaceListener.this.caracterNaoEsperado();
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento.", 1, 5000);
                    InterfaceListener.this.setIdle();
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void dataChanged() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    String message = InterfaceListener.this.getPortaCOM().removeInputString(InterfaceListener.this.getMsgEnd());
                    if (!message.equals("")) {
                        InterfaceListener.this.addListaRecebimento(message);
                        InterfaceListener.this.restartThreadRecebimento();
                    } else if (InterfaceListener.this.isRX()) {
                        InterfaceListener.this.aguardarProximoFrame();
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        try {
            if (this.isTX()) {
                this.abortarTransmissao();
            } else if (this.isRX()) {
                if (this.frame != null) {
                    this.abortarRecepcao();
                } else {
                    this.setIdle();
                }
            } else {
                this.setIdle();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

