/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.colorcheck;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.uricheck.InterfaceListener {
    @Override
    public String parseResults(ArrayList<String> fields) throws SQLException {
        try {
            String requisicao = "";
            fields.remove(0);
            fields.remove(0);
            fields.remove(0);
            fields.remove(0);
            int INDEX_COPIA = 7;
            HashMap<String, Object> urina = new HashMap<String, Object>();
            for (String s : fields) {
                if (Funcoes.textoVazio(s) || s.startsWith("(SN") || s.startsWith("OP(")) continue;
                if (s.startsWith("ID(")) {
                    requisicao = s.substring(3, s.indexOf(")")).trim();
                    continue;
                }
                String campo = s.substring(0, 7).trim();
                String resultado = s.substring(14, 18).trim();
                if (Funcoes.textoVazio(resultado)) {
                    resultado = s.substring(18).trim();
                }
                String campoTraduzido = campo;
                if ((campo.equals("SAN") || campo.equals("LEU")) && Funcoes.textoVazio(resultado)) {
                    resultado = s.substring(14, 17).trim();
                }
                if (campo.equals("GRA")) {
                    campoTraduzido = "DEN";
                    resultado = s.substring(17, 22).trim();
                }
                if (campo.equals("URI")) {
                    campoTraduzido = "URO";
                }
                if (campo.equals("BLD")) {
                    campoTraduzido = "SAN";
                } else if (campo.equals("BIL")) {
                    campoTraduzido = "BIL";
                } else if (campo.equals("URO")) {
                    campoTraduzido = "URO";
                } else if (campo.equals("KET")) {
                    campoTraduzido = "CET";
                } else if (campo.equals("PRO")) {
                    campoTraduzido = "PRO";
                } else if (campo.equals("NIT")) {
                    campoTraduzido = "NIT";
                } else if (campo.equals("GLU")) {
                    campoTraduzido = "GLI";
                } else if (campo.equals("pH")) {
                    campoTraduzido = "p.H";
                } else if (campo.equals("S.G")) {
                    campoTraduzido = "DEN";
                } else if (campo.equals("LEU")) {
                    campoTraduzido = "LEU";
                } else if (campo.equals("VTC")) {
                    campoTraduzido = "VTC";
                } else if (campo.equals("UBG")) {
                    campoTraduzido = "UBG";
                }
                String tmp = resultado.replaceAll("[a-zA-Z]", "");
                if (tmp.trim().length() != resultado.trim().length() && !resultado.trim().equalsIgnoreCase("NEG")) {
                    resultado = tmp;
                }
                if (campoTraduzido.equals("URO")) {
                    urina.put("URO2", resultado.replace('.', ','));
                } else if (campoTraduzido.equals("SAN")) {
                    urina.put("BLD2", resultado.replace('.', ','));
                } else if (campoTraduzido.equals("BIL")) {
                    urina.put("BIL2", resultado.replace('.', ','));
                } else if (campoTraduzido.equals("CET")) {
                    urina.put("KET2", resultado.replace('.', ','));
                } else if (campoTraduzido.equals("PRO")) {
                    urina.put("PRO2", resultado.replace('.', ','));
                } else if (campoTraduzido.equals("NIT")) {
                    urina.put("NIT2", resultado.replace('.', ','));
                } else if (campoTraduzido.equals("GLI")) {
                    urina.put("GLU2", resultado.replace('.', ','));
                } else if (campoTraduzido.equals("p.H")) {
                    urina.put("PH2", resultado.replace('.', ','));
                } else if (campoTraduzido.equals("DEN")) {
                    urina.put("SG2", resultado.replace('.', ','));
                } else if (campoTraduzido.equals("LEU")) {
                    urina.put("LEU2", resultado.replace('.', ','));
                } else if (campoTraduzido.equals("VTC")) {
                    urina.put("VTC2", resultado.replace('.', ','));
                } else if (campoTraduzido.equals("VC")) {
                    urina.put("VC2", resultado.replace('.', ','));
                }
                urina.put(campoTraduzido, resultado);
            }
            if (Funcoes.textoVazio(requisicao) || !Funcoes.isNumeric(requisicao)) {
                this.fireExcecaoEncontrada("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o localizado nos dados recebidos");
                return null;
            }
            Statement st = Conexao.getStatement();
            requisicao = StringUtil.preencheString(requisicao.trim(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            this.fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            this.rec_codigo = requisicao.substring(requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            this.req_codigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            this.int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, "URI");
            ExameMaterial exame = this.getReqExameLIS(this.fil_codigo, this.int_codigo, this.req_codigo, this.rec_codigo, "URI");
            if (exame == null) {
                this.fireExcecaoEncontrada(String.format("Nenhum exame localizado nos dados recebidos %s %s %s", this.fil_codigo, this.req_codigo, this.rec_codigo));
                return null;
            }
            String exa_codigo = exame.getNomeExame();
            String mco_codigo = exame.getCodigoMaterial();
            this.atualizarDadosExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, exa_codigo, mco_codigo, this.int_codigo, urina);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }
}

