/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cobasmp;

import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultPendentes;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.cobasmp.EnvioRackListener;
import jalis.laboratorio.interfaceamento.interfaces.cobasmp.ExameCobasMP;
import jalis.laboratorio.interfaceamento.interfaces.cobasmp.SolicitarRack;
import jalis.laboratorio.interfaceamento.interfaces.cobasmp.ThreadEnvio;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class RequisicaoRack
extends JDialog
implements ActionListener,
EnvioRackListener {
    public static final int COLUNA_REQUISICAO = 0;
    public static final int COLUNA_NOME_PACIENTE = 1;
    public static final int COLUNA_EXAME = 2;
    public static final int COLUNA_POSICAO_RACK = 3;
    public static final int COLUNA_TUBO = 4;
    public static final int COLUNA_CURVA = 5;
    public static final int COLUNA_REQUISICAO_JALIS = 6;
    public static final int COLUNA_IS_DESMEMBRADO = 7;
    public AbstractInterfaceamento equip;
    public JPanel panelRoot = new JPanel(new GridBagLayout());
    private ArrayList exames;
    private int indexRequisicao;
    private int indexNomePaciente;
    private int indexExame;
    private int indexRack;
    private int indexTubo;
    private int tuboFilho;
    private int indexAparelho;
    private int indexMaterial;
    private int indexInterface;
    private int indexCodigoApoiado;
    private int indexCodigoTemp;
    private boolean curva;
    private boolean reenvio;
    private PanelAbaAbstrata aba;
    private TTextField textCodigoBarras = ComponenteFactory.novoTTextField(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo(), 1);
    private TTextField textNomePaciente = ComponenteFactory.novoTTextField(50, 3);
    private TTextField textPosicao = ComponenteFactory.novoTTextField(6, 1);
    private JComboBox comboExames = ComponenteFactory.novoJComboBox(this);
    private JButton buttonAddRequisicao = ComponenteFactory.novoJButton("OK", 'o', this);
    private ModeloGridTable tableModel = new ModeloGridTable(new String[]{"C\u00f3digo", "Paciente", "Exame", "Rack", "Tubo"});
    private JTable tableRequisicao = new JTable(this.tableModel);
    private JScrollPane scrollTable = new JScrollPane(this.tableRequisicao);
    private JPanel panelButton = new JPanel(new FlowLayout(2));
    private JButton buttonEnviar = ComponenteFactory.novoJButton("Enviar", 'e', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'c', this);
    private ArrayList<Object[]> requisicoes = new ArrayList();

    public RequisicaoRack(JFrame parent, AbstractInterfaceamento equip, ArrayList exames, int indexRequisicao, int indexNomePaciente, int indexExame, int indexRack, int indexTubo, int indexAparelho, int indexMaterial, boolean reenvio, PanelAbaAbstrata aba, int indexInterface, int indexCodigoApoiado, int tuboFilho, int indexCodigoTemp) {
        super(parent);
        this.equip = equip;
        this.exames = exames;
        this.indexRequisicao = indexRequisicao;
        this.indexNomePaciente = indexNomePaciente;
        this.indexExame = indexExame;
        this.indexRack = indexRack;
        this.indexTubo = indexTubo;
        this.tuboFilho = tuboFilho;
        this.indexAparelho = indexAparelho;
        this.indexMaterial = indexMaterial;
        this.indexInterface = indexInterface;
        this.indexCodigoApoiado = indexCodigoApoiado;
        this.reenvio = reenvio;
        this.curva = false;
        this.aba = aba;
        this.indexCodigoTemp = indexCodigoTemp;
        this.setDefaultCloseOperation(0);
        this.configTela();
    }

    private void configTela() {
        this.setPreferredSize(new Dimension(650, 350));
        this.setTitle("Rack");
        this.setModal(true);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.tableModel.setColumnSize(new int[]{100, 0, 80, 50, 1}, this.tableRequisicao);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Requisi\u00e7\u00e3o"), c);
        ++c.gridx;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Paciente"), c);
        ++c.gridx;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Exame(s)"), c);
        ++c.gridx;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Posic\u00e3o"), c);
        this.textCodigoBarras.setPreferredSize(new Dimension(130, 20));
        this.textCodigoBarras.setMinimumSize(new Dimension(130, 20));
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        this.panelRoot.add((Component)this.textCodigoBarras, c);
        this.textNomePaciente.setPreferredSize(new Dimension(250, 20));
        this.textNomePaciente.setMinimumSize(new Dimension(250, 20));
        this.textNomePaciente.setEditable(false);
        this.textNomePaciente.setFocusable(false);
        ++c.gridx;
        this.panelRoot.add((Component)this.textNomePaciente, c);
        this.comboExames.setPreferredSize(new Dimension(100, 20));
        this.comboExames.setMinimumSize(new Dimension(100, 20));
        ++c.gridx;
        this.panelRoot.add((Component)this.comboExames, c);
        this.textPosicao.setPreferredSize(new Dimension(65, 20));
        this.textPosicao.setMinimumSize(new Dimension(65, 20));
        ++c.gridx;
        this.panelRoot.add((Component)this.textPosicao, c);
        this.buttonAddRequisicao.setPreferredSize(new Dimension(40, 20));
        this.buttonAddRequisicao.setMinimumSize(new Dimension(40, 20));
        ++c.gridx;
        this.panelRoot.add((Component)this.buttonAddRequisicao, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridwidth = 7;
        this.panelRoot.add((Component)this.scrollTable, c);
        this.panelButton.add(this.buttonEnviar);
        this.panelButton.add(this.buttonCancelar);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 0.0;
        this.panelRoot.add((Component)this.panelButton, c);
        this.textCodigoBarras.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                RequisicaoRack.this.loadExamesRequisicao();
            }
        });
        this.tableRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (RequisicaoRack.this.tableRequisicao.getSelectedRowCount() > 0 && e.getKeyCode() == 127) {
                    RequisicaoRack.this.requisicoes.remove(RequisicaoRack.this.tableRequisicao.getSelectedRow());
                    RequisicaoRack.this.populateTable();
                }
            }
        });
        this.add((Component)this.panelRoot, "Center");
        Funcoes.montaEnter((JComponent)this.panelRoot);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void alteraRack(int linha) {
        String rack = (String)this.tableRequisicao.getValueAt(linha, 3);
        SolicitarRack tela = new SolicitarRack();
        tela.setRack(rack);
        tela.setVisible(true);
        rack = tela.getRack();
        if (!Funcoes.textoVazio(rack)) {
            this.tableRequisicao.setValueAt(rack, linha, 3);
        }
    }

    private boolean validaRequisicao(boolean adicionaLista) throws SQLException {
        String requisicao = this.textCodigoBarras.getText();
        String tubo = "";
        boolean achou = false;
        if (Funcoes.textoVazio(requisicao)) {
            Funcoes.mensagem(this, "Requisi\u00e7\u00e3o n\u00e3o preenchida!", 5);
            return false;
        }
        if (requisicao.length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) {
            Funcoes.mensagem(this, "Requisi\u00e7\u00e3o informada incorretamente!", 5);
            return false;
        }
        if (this.comboExames.getSelectedItem() == null) {
            Funcoes.mensagem(this, "Exame n\u00e3o selecionado!", 5);
            return false;
        }
        if (Funcoes.textoVazio(this.textPosicao.getText())) {
            Funcoes.mensagem(this, "Posi\u00e7\u00e3o n\u00e3o informada!", 5);
            return false;
        }
        if (!this.requisicoes.isEmpty()) {
            for (int i = 0; i < this.requisicoes.size(); ++i) {
                String copiaCodigoRequisicaoREQ;
                String codigoReq;
                Object[] req = this.requisicoes.get(i);
                String r = req[0].toString();
                String rack = req[3].toString();
                String tuboReq = req[4].toString();
                String exame = req[2].toString();
                String copiaExame = req[7].toString();
                String rack_new = this.textPosicao.getText();
                if (!r.equalsIgnoreCase(requisicao) && rack_new.equalsIgnoreCase(rack)) {
                    Funcoes.mensagem(this, "Rack j\u00e1 adicionada!", 5);
                    return false;
                }
                String examesCombo = this.comboExames.getSelectedItem().toString();
                if (requisicao.length() < 9) {
                    String copiaRequisicao = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                    codigoReq = req[this.indexRequisicao].toString();
                    String string = copiaCodigoRequisicaoREQ = copiaRequisicao.length() < codigoReq.length() ? codigoReq.substring(0, codigoReq.length() - 2) : codigoReq;
                    if (!copiaCodigoRequisicaoREQ.equalsIgnoreCase(copiaRequisicao) || !examesCombo.contains(exame) && examesCombo.indexOf(exame) < 0 && !this.curva && !examesCombo.equalsIgnoreCase(copiaExame)) continue;
                    Funcoes.mensagem(this, "Requisi\u00e7\u00e3o j\u00e1 adicionada!", 5);
                    return false;
                }
                String copiaRequisicaoDigitada = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                codigoReq = req[this.indexRequisicao].toString();
                String string = copiaCodigoRequisicaoREQ = copiaRequisicaoDigitada.length() < codigoReq.length() ? copiaRequisicaoDigitada.substring(0, codigoReq.length() - 2) : copiaRequisicaoDigitada;
                if (!requisicao.equalsIgnoreCase(codigoReq) && !copiaCodigoRequisicaoREQ.equalsIgnoreCase(codigoReq) || (this.curva || !examesCombo.contains(exame)) && (!this.curva || !examesCombo.equalsIgnoreCase(copiaExame) || !requisicao.endsWith(tuboReq))) continue;
                Funcoes.mensagem(this, "Requisi\u00e7\u00e3o j\u00e1 adicionada!", 5);
                return false;
            }
        }
        String reqApoiado = "";
        if (requisicao.trim().length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            tubo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            DescritorCodigoEtiqueta dce = DescritorCodigoEtiqueta.getDescritor(requisicao);
            if (dce != null) {
                requisicao = Funcoes.preencheZero(dce.getFilial(), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(dce.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
            } else {
                Funcoes.mensagem(this, "C\u00f3digo de etiqueta n\u00e3o foi encontrado, favor efetuar a reimpress\u00e3o!", 5);
                return false;
            }
        }
        if (requisicao.trim().length() >= ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) {
            requisicao = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        }
        for (int i = 0; i < this.exames.size(); ++i) {
            Object[] linha = (Object[])this.exames.get(i);
            String req = linha[this.indexRequisicao].toString();
            String fil_codigo = req.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String int_codigo = linha[this.indexAparelho].toString();
            String exa_codigo = linha[this.indexExame].toString();
            String mco_codigo = linha[this.indexMaterial].toString();
            String tubo_codigo = linha[this.indexTubo].toString();
            String copiaExame = "";
            String codigoApoiado = linha[this.indexCodigoApoiado] != null ? linha[this.indexCodigoApoiado].toString() : null;
            String reqFilha = linha[this.indexCodigoTemp] != null ? linha[this.indexCodigoTemp].toString() : null;
            String string = reqApoiado = Funcoes.textoVazio(codigoApoiado) ? "" : codigoApoiado;
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                reqFilha = BDUtil.getReqMultiGuiasWithZeros(fil_codigo, req.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao())).toString();
                reqFilha = reqFilha.replace("[", "").replace("]", "");
            }
            if (!Funcoes.textoVazio(codigoApoiado) && codigoApoiado.length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                reqApoiado = codigoApoiado.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            }
            if (!this.adicionaRequisicao(req, requisicao, reqApoiado, reqFilha, linha)) continue;
            if (adicionaLista) {
                String exaReq = this.comboExames.getSelectedItem().toString();
                String[] exasOld = exaReq.split(" ");
                ArrayList<ExameCobasMP> examesRequisicao = new ArrayList<ExameCobasMP>();
                for (String s : exasOld) {
                    String rq = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                    String reqs = rq + ", " + reqFilha;
                    if (this.curva && !Funcoes.textoVazio(tubo)) {
                        String rec_kodigo = tubo;
                        ExameMaterial[] rec_codigo = BDUtil.getExameDesmembradoTuboPai(fil_codigo, rq, rec_kodigo, int_codigo, s, mco_codigo);
                        BDExame[] bdExames = BDUtil.getDesmExamesFilhos(fil_codigo, int_codigo, rq, s, mco_codigo, (String)rec_codigo, rec_kodigo);
                        if (bdExames.length > 0) {
                            for (BDExame bdExame : bdExames) {
                                if (!examesRequisicao.stream().noneMatch(e -> e.getExame().equalsIgnoreCase(bdExame.getExame()))) continue;
                                ExameCobasMP exaCobas = new ExameCobasMP();
                                exaCobas.setExame(bdExame.getExame());
                                exaCobas.getRecipientes().add(rec_kodigo);
                                examesRequisicao.add(exaCobas);
                            }
                        }
                    } else if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, s, mco_codigo)) {
                        ExameMaterial[] filhos;
                        for (ExameMaterial e2 : filhos = BDUtil.getExamesFilhos(fil_codigo, int_codigo, s, mco_codigo)) {
                            if (!examesRequisicao.stream().noneMatch(j -> j.getExame().equalsIgnoreCase(e2.getNomeExame()))) continue;
                            List<String> recipientesExame = BDUtil.getRecipientesExameDesm(fil_codigo, reqs, e2.getNomeExame(), mco_codigo, int_codigo);
                            if (recipientesExame.isEmpty()) {
                                Funcoes.mensagem(this, "C\u00f3digo de etiqueta n\u00e3o foi encontrado, favor efetuar a reimpress\u00e3o!", 5);
                                break;
                            }
                            ExameCobasMP exaCobas = new ExameCobasMP();
                            exaCobas.setExame(e2.getNomeExame());
                            exaCobas.setRecipientes(recipientesExame);
                            examesRequisicao.add(exaCobas);
                        }
                    } else if (examesRequisicao.stream().noneMatch(e -> e.getExame().equalsIgnoreCase(s))) {
                        List<String> recipientesExame = BDUtil.getRecipientesExame(fil_codigo, reqs, s, mco_codigo);
                        if (recipientesExame.isEmpty()) {
                            Funcoes.mensagem(this, "C\u00f3digo de etiqueta n\u00e3o foi encontrado, favor efetuar a reimpress\u00e3o!", 5);
                            break;
                        }
                        ExameCobasMP exaCobas = new ExameCobasMP();
                        exaCobas.setExame(s);
                        exaCobas.setRecipientes(recipientesExame);
                        examesRequisicao.add(exaCobas);
                    }
                    copiaExame = exa_codigo;
                }
                if (20 < examesRequisicao.size()) {
                    StringBuilder s = new StringBuilder();
                    s.append("O total de exames da requisi\u00e7\u00e3o execede o n\u00fameros de exames suportado por posi\u00e7\u00e3o de rack do aparelho!\n");
                    s.append("Os exames abaixo n\u00e3o ser\u00e3o enviados para o aparelho:\n");
                    for (int j2 = 20; j2 < examesRequisicao.size(); ++j2) {
                        s.append(examesRequisicao.get(j2)).append("\n");
                    }
                    Funcoes.mensagem(this, s.toString(), 2);
                }
                ArrayList<String> tubosFilho = new ArrayList<String>();
                HashMap<String, Integer> tubosRequisicao = new HashMap<String, Integer>();
                Integer posicaoRack = Integer.valueOf(this.textPosicao.getText()) - 1;
                for (int j3 = 0; j3 < 20 && j3 < examesRequisicao.size(); ++j3) {
                    String codigoExame = ((ExameCobasMP)examesRequisicao.get(j3)).getExame();
                    boolean existeExameTubo = false;
                    for (String recip : ((ExameCobasMP)examesRequisicao.get(j3)).getRecipientes()) {
                        Object[] line = new Object[8];
                        Object object = line[0] = requisicao.equalsIgnoreCase(reqApoiado) ? reqApoiado : req;
                        if (this.curva) {
                            line[0] = (requisicao.equalsIgnoreCase(reqApoiado) ? reqApoiado : req) + tubo;
                        }
                        line[1] = linha[this.indexNomePaciente].toString();
                        line[2] = codigoExame;
                        line[4] = recip;
                        if (tubosFilho != null) {
                            String tuboFilhoSelecionado;
                            if (examesRequisicao.size() != tubosFilho.size()) {
                                tubosFilho.add((String)linha[11]);
                            }
                            if (!tubosRequisicao.containsKey(tuboFilhoSelecionado = recip)) {
                                Integer n = posicaoRack;
                                Integer recipientesExame = posicaoRack = Integer.valueOf(posicaoRack + 1);
                                tubosRequisicao.put(tuboFilhoSelecionado, posicaoRack);
                                existeExameTubo = false;
                            } else {
                                existeExameTubo = true;
                                posicaoRack = (Integer)tubosRequisicao.get(tuboFilhoSelecionado);
                            }
                        }
                        line[3] = posicaoRack.toString();
                        line[5] = new Boolean(this.curva);
                        line[6] = req;
                        line[7] = copiaExame;
                        if (this.isExameRequisicaoAdicionado(line)) continue;
                        if (existeExameTubo) {
                            int index = 0;
                            for (Object[] requisicaoAux : this.requisicoes) {
                                if (!String.valueOf(requisicaoAux[0]).equalsIgnoreCase(String.valueOf(line[0])) || !String.valueOf(requisicaoAux[4]).equalsIgnoreCase(String.valueOf(line[4]))) continue;
                                index = this.requisicoes.indexOf(requisicaoAux);
                            }
                            this.requisicoes.add(index, line);
                            continue;
                        }
                        this.requisicoes.add(line);
                    }
                }
            }
            achou = true;
        }
        if (!achou) {
            Funcoes.mensagem(this, "Requisi\u00e7\u00e3o n\u00e3o encontrada!", 5);
        }
        return achou;
    }

    private boolean isExameRequisicaoAdicionado(Object[] exameRequisicao) {
        for (int i = 0; i < this.requisicoes.size(); ++i) {
            Object[] linha = this.requisicoes.get(i);
            if (!linha[2].equals(exameRequisicao[2]) || !linha[0].equals(exameRequisicao[0]) || !linha[7].equals(exameRequisicao[7]) || !linha[4].equals(exameRequisicao[4])) continue;
            Funcoes.mensagem(this, "Exame: " + exameRequisicao[2] + " j\u00e1 adicionado para requisi\u00e7\u00e3o: " + exameRequisicao[0], 2);
            return true;
        }
        return false;
    }

    private boolean adicionaRequisicao(String req, String requisicao, String reqApoiado, String reqFilha, Object[] linha) {
        String requisicaoFilhaSel = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        return (req.equalsIgnoreCase(requisicao) || reqApoiado.equalsIgnoreCase(requisicao) || reqFilha != null && reqFilha.contains(requisicaoFilhaSel)) && (this.comboExames.getSelectedItem().toString().trim().equals(linha[this.indexExame].toString().trim()) || this.containsExames(linha));
    }

    private boolean containsExames(Object[] linha) {
        String[] examesCombo = this.comboExames.getSelectedItem().toString().split(" ");
        boolean existeTodos = false;
        for (String exaCb : examesCombo) {
            if (!linha[this.indexExame].toString().contains(exaCb)) {
                return false;
            }
            existeTodos = true;
        }
        return existeTodos;
    }

    private void loadExamesRequisicao() {
        String requisicao = this.textCodigoBarras.getText();
        if (Funcoes.textoVazio(requisicao) || requisicao.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() && requisicao.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            return;
        }
        this.comboExames.removeAllItems();
        DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(requisicao);
        if (etiqueta != null) {
            requisicao = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao()) + Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
        }
        boolean isNaoEncontrado = true;
        for (int i = 0; i < this.exames.size(); ++i) {
            String tuboFilhoZero;
            String req;
            boolean isCodigoApoiado;
            Object[] linha = (Object[])this.exames.get(i);
            String reqInterface = linha[this.indexRequisicao].toString();
            String codigoApoiado = linha[this.indexCodigoApoiado] != null ? linha[this.indexCodigoApoiado].toString() : null;
            boolean bl = isCodigoApoiado = !Funcoes.textoVazio(codigoApoiado);
            if (requisicao.trim().length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) {
                if (!reqInterface.equalsIgnoreCase(requisicao)) continue;
                this.comboExames.addItem(linha[this.indexExame]);
                this.textNomePaciente.setText(linha[this.indexNomePaciente].toString());
                isNaoEncontrado = false;
                continue;
            }
            String tubo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            String reqRack = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            String tb = Funcoes.preencheZero(linha[this.indexTubo].toString(), ParametrosGerais.getDigitosTuboTubo());
            String treq = Funcoes.preencheZero(linha[this.indexRequisicao].toString(), ParametrosGerais.getDigitosTuboTubo());
            String fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String string = req = linha[this.indexCodigoTemp] != null ? linha[19].toString() : "";
            if (!this.validaMultiguias(linha, this.textCodigoBarras.getText()) && (!isCodigoApoiado || !requisicao.equalsIgnoreCase(codigoApoiado))) continue;
            if (tubo.equalsIgnoreCase(tb) && (treq.equalsIgnoreCase(reqRack) || reqRack.equalsIgnoreCase(req))) {
                StringBuilder exames = new StringBuilder();
                for (String exa : linha[this.indexExame].toString().split(" ")) {
                    try {
                        if (BDUtil.isExameCurva(fil_codigo, linha[this.indexInterface].toString(), exa, linha[this.indexMaterial].toString())) continue;
                        exames.append(exa).append(" ");
                        this.textNomePaciente.setText(linha[this.indexNomePaciente].toString());
                        isNaoEncontrado = false;
                        this.curva = false;
                    }
                    catch (SQLException e) {
                        ErrorLogger.mostraMensagem(this, "Erro  - " + e.getMessage(), e.getStackTrace());
                    }
                }
                exames.replace(exames.length() - 1, exames.length(), "");
                this.comboExames.addItem(exames.toString());
                continue;
            }
            if (linha[this.tuboFilho] == null || !(tuboFilhoZero = this.preencheTuboFilho(linha[this.tuboFilho].toString())).contains(tubo)) continue;
            fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            for (String exa : linha[this.indexExame].toString().split(" ")) {
                try {
                    if (!BDUtil.isExameCurva(fil_codigo, linha[this.indexInterface].toString(), exa, linha[this.indexMaterial].toString())) continue;
                    this.comboExames.addItem(exa);
                    this.textNomePaciente.setText(linha[this.indexNomePaciente].toString());
                    isNaoEncontrado = false;
                    this.curva = true;
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(this, "Erro  - " + e.getMessage(), e.getStackTrace());
                }
            }
        }
        if (isNaoEncontrado) {
            this.textNomePaciente.setText("N\u00e3o localizado");
        }
        this.comboExames.setEnabled(this.comboExames.getItemCount() > 0);
    }

    private boolean validaMultiguias(Object[] linha, String requisicao) {
        String reqInterface = linha[this.indexRequisicao].toString();
        String tubo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        String reqRack = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        String tb = Funcoes.preencheZero(linha[this.indexTubo].toString(), ParametrosGerais.getDigitosTuboTubo());
        try {
            Integer[] requisicoes;
            if (reqInterface.equalsIgnoreCase(reqRack)) {
                return true;
            }
            String req = requisicao.substring(ParametrosGerais.getDigitosTuboTubo(), ParametrosGerais.getDigitosTuboTubo() + ParametrosGerais.getDigitosTuboRequisicao());
            for (Integer req2 : requisicoes = RecepcaoUtil.verificaMultiGuias(Variaveis.filialPadrao, req, true)) {
                String reqInterfaceFormatada;
                String reqRackFormatada = reqRack.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                if (!reqRackFormatada.equalsIgnoreCase(reqInterfaceFormatada = Funcoes.preencheZero(String.valueOf(req2), ParametrosGerais.getDigitosTuboRequisicao())) || !tubo.equalsIgnoreCase(tb)) continue;
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    private String preencheTuboFilho(String tuboFilho) {
        char chaveA = ']';
        char chaveB = '[';
        String tratamentoTuboA = StringUtil.removeCaractere(tuboFilho, chaveA);
        String tratamentoTuboB = StringUtil.removeCaractere(tratamentoTuboA, chaveB);
        String[] tubosFilho = tratamentoTuboB.split(", ");
        ArrayList<String> sb = new ArrayList<String>();
        for (int i = 0; i <= tubosFilho.length - 1; ++i) {
            sb.add(Funcoes.preencheZero(tubosFilho[i], ParametrosGerais.getDigitosTuboTubo()));
        }
        return sb.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancelar) {
            this.requisicoes.clear();
            this.dispose();
        } else if (e.getSource() == this.buttonAddRequisicao) {
            this.addRequisicao();
        } else if (e.getSource() == this.buttonEnviar && (this.reenvio || this.validarLote())) {
            this.enviar();
        }
    }

    private void addRequisicao() {
        try {
            if (this.validaRequisicao(false)) {
                this.validaRequisicao(true);
                if (Funcoes.textoVazio(this.textPosicao.getText())) {
                    Funcoes.mensagem(this, "Rack n\u00e3o preenchida!", 5);
                    this.textPosicao.grabFocus();
                    this.requisicoes.removeAll(this.requisicoes);
                    return;
                }
                Integer posicao = this.populateTable();
                this.textNomePaciente.setText("");
                this.comboExames.removeAllItems();
                this.textPosicao.setText(posicao.toString());
                this.textCodigoBarras.setText("");
                this.textCodigoBarras.grabFocus();
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "RequisicaoRack (384)");
        }
        catch (SQLException e) {
            e.printStackTrace();
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "RequisicaoRack (387)");
        }
    }

    private Integer populateTable() {
        while (this.tableRequisicao.getRowCount() > 0) {
            this.tableModel.removeLine(0);
        }
        ArrayList<Integer> posicoesRack = new ArrayList<Integer>();
        for (int i = 0; i < this.requisicoes.size(); ++i) {
            Object[] o = this.requisicoes.get(i);
            posicoesRack.add(Integer.valueOf(o[3].toString()));
            this.tableModel.addLine(o);
        }
        Optional optional = posicoesRack.stream().reduce(Integer::max);
        if (optional.isPresent()) {
            Integer posicao = (Integer)optional.get();
            this.tableRequisicao.setModel(this.tableModel);
            return posicao + 1;
        }
        return 0;
    }

    private void editaRequisicao() {
        int row = this.tableRequisicao.getSelectedRow();
        Object[] req = this.requisicoes.get(row);
        this.textCodigoBarras.setText(req[this.indexRequisicao].toString());
        this.textNomePaciente.setText(req[this.indexNomePaciente].toString());
        String[] rack = req[this.indexRack].toString().split("\\^", 0);
        this.textPosicao.setText(rack[1]);
        this.textPosicao.grabFocus();
    }

    public ArrayList getRequisicoes() {
        return this.requisicoes;
    }

    private boolean validarLote() {
        ((AbaDefaultPendentes)this.equip.examesPendentes).reloadExames();
        ArrayList pendentes = ((AbaDefaultPendentes)this.equip.examesPendentes).getExames();
        for (int i = 0; i < this.requisicoes.size(); ++i) {
            String rack;
            int requisicao;
            int row;
            Object[] req = this.requisicoes.get(i);
            String req_codigo = req[6].toString();
            if (this.curva) {
                req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            }
            if ((row = this.validaExisteExame(requisicao = Integer.parseInt(req_codigo))) < 0 || req[3] == null || !this.validaExisteExamePendente(rack = req[3].toString(), pendentes)) continue;
            Funcoes.mensagem(this, "A rack " + rack + " j\u00e1 esta cadastrada\npara exame que espera retorno!", 5);
            return false;
        }
        return true;
    }

    private int validaExisteExame(int requisicao) {
        for (int i = 0; i < this.exames.size(); ++i) {
            Object[] exame = (Object[])this.exames.get(i);
            int requisicaoExame = Integer.parseInt(exame[this.indexRequisicao].toString());
            if (requisicao != requisicaoExame) continue;
            return i;
        }
        return -1;
    }

    private boolean validaExisteExamePendente(String contador, ArrayList pendentes) {
        for (int i = 0; i < pendentes.size(); ++i) {
            String contadorExame;
            Object[] pendente = (Object[])pendentes.get(i);
            if (pendente[this.indexRack] == null || !contador.equalsIgnoreCase(contadorExame = pendente[this.indexRack].toString())) continue;
            return true;
        }
        return false;
    }

    private void enviar() {
        ThreadEnvio envio = new ThreadEnvio(this.requisicoes, this.indexRequisicao, this.indexRack, this.indexTubo, this.indexCodigoApoiado, this.aba);
        this.buttonEnviar.setEnabled(false);
        this.buttonCancelar.setEnabled(false);
        envio.addEnvioRackListener(this);
        envio.start();
    }

    @Override
    public void envioFinalizado() {
        this.dispose();
    }
}

