/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cobasmp;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.Exame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.cobasmp.AbaExamesNaoEnviadosRack;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    protected int MAX_PATIENT_NAME_CHARS = 10;
    public static final int EQUIP_TIMEOUT = 10000;
    public static final int TEMPO_PAUSA = 10000;
    public static final int IDLE_BLOCK = 0;
    public static final int CONTROL_RESULTS = 1;
    public static final int PATIENT_RESULT = 3;
    public static final int QUALITY_RESULTS = 5;
    public static final int QUALITY_REQUEST = 7;
    public static final int QUALITY_RESPONSE = 8;
    public static final int RESULT_REQUEST = 9;
    public static final int WORKLIST_INPUT = 10;
    public static final int WORKLIST_RESPONSE = 11;
    public static final int WORKLIST_DELETION = 15;
    public static final int DELETION_RESPONSE = 16;
    public static final int RACK_INFORMATION = 70;
    public static final int ERROR_MESSAGE = 71;
    public static final int RACK_INFO_REQUEST = 79;
    public static final int INSTRUMENT_CONTROL = 94;
    public static final int INSTRUMENT_INFO = 95;
    private static final String WORKLIST_LINE = "50";
    protected static final String RESULT_LINE = "20";
    public static final boolean CFG_CODAPARELHO = true;
    public static final boolean CFG_CATEGORIA = false;
    public static final int REQ_TIPO_NOVO = 0;
    public static final int REQ_TIPO_REPETICAO = 1;
    public static final String SYS_ID = "JALIS           ";
    public static final String INSTRUMENT_CODE = "08";
    public static final int QTDE_EXAMES_TOTAL_RACK = 20;
    public static final int QTDE_EXAMES_ENVIO_RACK = 8;
    InfoExameRequisicao ultimo_enviado = new InfoExameRequisicao(null, null, null, null, null, null, null, null, null, null);
    InfoExameRequisicao ultimo_a_excluir = new InfoExameRequisicao(null, null, null, null, null, null, null, null, null, null);
    String ultimo_enviado_acao = null;
    private boolean curva = false;
    protected List<String> examesFilho = new LinkedList<String>();
    private String rec_tuboPai = "";
    boolean exr_codigoapoiado = false;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    public InterfaceListener() {
        Statement st = Conexao.getStatement();
        this.exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0004') + String.valueOf('\n');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0001') + String.valueOf('\n');
    }

    public void setCurva(boolean curva) {
        this.curva = curva;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames, acao, null);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao, HashMap<String, String> mapaParametros) {
        int qtdeDigitos = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        try {
            StringBuilder codigo;
            ExameMaterial[] examePai;
            if (Funcoes.textoVazio(rackposition)) {
                Funcoes.mensagem(null, "Requisi\u00e7\u00e3o sem rack definida!", 1);
                return "Erro: Requisi\u00e7\u00e3o sem rack definida!";
            }
            this.setTX(10000);
            if (acao.equals("C")) {
                String exa_codigo = exames;
                Exame exame = new Exame(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
                String priority = (String)exame.getValor("prioridade");
                return "Requisi\u00e7\u00e3o de cancelamento/exclus\u00e3o enviada ao equipamento";
            }
            this.examesFilho.clear();
            this.curva = false;
            PanelAbaAbstrata aba = this.getAba(0);
            String[] listaExames = exames.split(" ");
            if (listaExames.length > 0 && aba instanceof AbaExamesNaoEnviadosRack && ((AbaExamesNaoEnviadosRack)aba).isCurva() && (examePai = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, req_codigo, String.valueOf(((AbaExamesNaoEnviadosRack)aba).getTuboFilho()), listaExames[0], mco_codigo)).length > 0) {
                this.curva = true;
                this.rec_tuboPai = rec_codigo;
                rec_codigo = String.valueOf(((AbaExamesNaoEnviadosRack)aba).getTuboFilho());
                for (String exa : listaExames) {
                    this.examesFilho.add(exa);
                }
                exames = examePai[0].getNomeExame();
            }
            String retorno = "Enviando " + pac_nome + " para o equipamento";
            ExameMaterial[] alternativos = null;
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            req_codigo = StringUtil.preencheString(req_codigo, ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
            if (qtdeDigitos == 10) {
                rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
                codigo = new StringBuilder(fil_codigo).append(req_codigo).append(rec_codigo);
            } else {
                codigo = new StringBuilder(fil_codigo).append(req_codigo);
            }
            pac_nome = StringUtil.removerAcentos(pac_nome.length() > this.MAX_PATIENT_NAME_CHARS ? pac_nome.substring(0, this.MAX_PATIENT_NAME_CHARS) : StringUtil.preencheString(pac_nome, this.MAX_PATIENT_NAME_CHARS, ' ', 0));
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            Statement st = Conexao.getStatement();
            String codigoApoiado = "";
            if (this.curva) {
                codigoApoiado = BDUtil.getCodigoApoioRecipiente(Integer.parseInt(fil_codigo), Integer.parseInt(req_codigo), exa_lista[0].getNomeExame(), Integer.parseInt(mco_codigo), Integer.parseInt(rec_codigo));
                if (!Funcoes.textoVazio(codigoApoiado)) {
                    codigo = qtdeDigitos == 10 && ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() == 10 ? new StringBuilder(codigoApoiado.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao())) : new StringBuilder(codigoApoiado);
                }
                exa_lista = BDUtil.getExameDesmembradosTubo(fil_codigo, req_codigo, rec_codigo, int_codigo, mco_codigo);
            } else {
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            }
            alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            ArrayList<ExameMaterial> temporario = new ArrayList<ExameMaterial>();
            for (ExameMaterial e : alternativos) {
                if (temporario.contains(e)) continue;
                temporario.add(e);
            }
            alternativos = new ExameMaterial[temporario.size()];
            for (int i = 0; i < temporario.size(); ++i) {
                alternativos[i] = (ExameMaterial)temporario.get(i);
            }
            StringBuilder exas = new StringBuilder();
            for (ExameMaterial temp : alternativos) {
                exas.append(temp.getNomeExame()).append(String.valueOf(' '));
            }
            rackposition = StringUtil.preencheString(rackposition, 4, '0', 1);
            if (Funcoes.textoVazio(prioridade)) {
                prioridade = "R";
            }
            if (mapaParametros != null && !Funcoes.textoVazio(mapaParametros.get("codigoApoiado"))) {
                codigo.setLength(0);
                if (mapaParametros != null && !Funcoes.textoVazio(mapaParametros.get("codigoApoiado"))) {
                    codigo.setLength(0);
                    if (qtdeDigitos == 10) {
                        codigo.append(mapaParametros.get("codigoApoiado").substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()));
                    } else {
                        codigo.append(mapaParametros.get("codigoApoiado").substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()));
                    }
                }
            }
            String worklist = this.makeFrame(codigo.toString(), rackposition, prioridade, exas.toString().trim());
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            this.ultimo_enviado = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, exames);
            if (acao.equalsIgnoreCase("A")) {
                acao = "N";
            }
            this.ultimo_enviado_acao = acao;
            exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            if (exa_lista != null) {
                for (ExameMaterial e : exa_lista) {
                    int situacao;
                    if (!Funcoes.textoVazio(this.rec_tuboPai) && this.curva && !this.examesFilho.isEmpty()) {
                        for (String exame : this.examesFilho) {
                            int situacao2 = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), this.rec_tuboPai, exame, mco_codigo);
                            BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), exame, mco_codigo, this.rec_tuboPai, situacao2 < 2 ? 1 : 3);
                        }
                        situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo);
                        if (!BDUtil.isGrupoInteiroPendente(fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), this.rec_tuboPai)) continue;
                        this.atualizarSituacaoExame(st, fil_codigo, req_codigo, this.rec_tuboPai, e.getNomeExame(), e.getCodigoMaterial(), int_codigo, null, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    if (!this.examesFilho.isEmpty()) {
                        situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo);
                        this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, e.getNomeExame(), e.getCodigoMaterial(), int_codigo, rackposition, situacao < 2 ? 1 : 3);
                        BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, e.getNomeExame(), e.getCodigoMaterial(), int_codigo, rackposition, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                this.fireMensagemEnviada("Exame(s) " + (acao.equals("C") ? "excluido(s)" : "enviado(s)") + " com sucesso para " + pac_nome, 0, 10000);
            } else {
                this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + pac_nome, 0, 10000);
            }
            Conexao.arquivaSQL();
            this.getPortaCOM().write(worklist);
            this.setIdle();
            return retorno;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    public void requestSampleDeletion(String fil_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String rackposition, String priority) throws Exception {
        this.ultimo_a_excluir = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, null, null, null, null, null, exa_codigo);
        fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
        StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
        rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
        codigo.append(rec_codigo);
        req_codigo = fil_codigo + req_codigo + rec_codigo;
        StringBuilder message = new StringBuilder();
        message.append(this.getMsgStart());
        message.append(INSTRUMENT_CODE);
        message.append(" ");
        message.append(SYS_ID);
        message.append(" ");
        message.append(15);
        message.append(String.valueOf('\n'));
        message.append(String.valueOf('\u0002'));
        message.append(String.valueOf('\n'));
        message.append(WORKLIST_LINE);
        message.append(" ");
        message.append(rackposition);
        message.append(" ");
        message.append(req_codigo);
        message.append(" ");
        message.append(priority);
        message.append(" ");
        message.append(exa_codigo);
        message.append(String.valueOf('\n'));
        message.append(String.valueOf('\u0003'));
        message.append(String.valueOf('\n'));
        message.append(this.getMsgEnd());
        this.getPortaCOM().write(message.toString());
    }

    public String makeFrame(String codigo, String ier_rackpos, String priority_type, String requisicoes) {
        StringBuilder worklist = new StringBuilder();
        worklist.append(String.valueOf('\u0001')).append(String.valueOf('\n'));
        worklist.append(INSTRUMENT_CODE).append(String.valueOf(' ')).append(SYS_ID).append(String.valueOf(' ')).append(10).append(String.valueOf('\n'));
        worklist.append(String.valueOf('\u0002')).append(String.valueOf('\n'));
        worklist.append(WORKLIST_LINE).append(String.valueOf(' ')).append(ier_rackpos).append(String.valueOf(' ')).append(codigo.toString()).append(String.valueOf(' ')).append(priority_type).append(String.valueOf(' ')).append(requisicoes.toString()).append('\n');
        worklist.append(String.valueOf('\u0003')).append(String.valueOf('\n'));
        worklist.append(String.valueOf('\u0004')).append(String.valueOf('\n'));
        return worklist.toString();
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(10000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    void limpaDadosRequisicao() {
        this.ultimo_enviado = null;
        this.ultimo_enviado_acao = null;
        this.ultimo_a_excluir = null;
    }

    public void encerrarTransmissao() throws Exception {
        this.interromperTimer();
        this.getPortaCOM().clearInputString();
        RefreshTimer.waitAndRefresh(this, 2000);
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setPausa(1000);
    }

    private void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(3000);
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    @Override
    public synchronized String parse(String message) {
        if (message.startsWith(this.getMsgStart())) {
            String[] temp = message.split(String.valueOf('\n'));
            ArrayList<String> lines = new ArrayList<String>();
            for (String t : temp) {
                if (Funcoes.textoVazio(t)) continue;
                lines.add(t);
            }
            String heading = (String)lines.remove(0);
            int block_type = Integer.parseInt(heading.substring(heading.length() - 2));
            switch (block_type) {
                case 0: {
                    return this.parseIdleBlock(lines);
                }
                case 1: {
                    return this.parseControlResults(lines);
                }
                case 3: {
                    return this.parsePatientResult(lines);
                }
                case 5: {
                    return this.parseQualityResults(lines);
                }
                case 8: {
                    return this.parseQualityResponse(lines);
                }
                case 11: {
                    return this.parseWorklistResponse(lines);
                }
                case 16: {
                    return this.parseDeletionResponse(lines);
                }
                case 70: {
                    return this.parseRackInformation(lines);
                }
                case 71: {
                    return this.parseErrorMessage(lines);
                }
                case 94: {
                    return this.parseInstrumentControl(lines);
                }
                case 95: {
                    return this.parseInstrumentInfo(lines);
                }
            }
        }
        return null;
    }

    public String parseIdleBlock(ArrayList<String> lines) {
        return "Sem resultados no momento.";
    }

    public String parseControlResults(ArrayList<String> lines) {
        return null;
    }

    public String parseQualityResults(ArrayList<String> lines) {
        return null;
    }

    public String parseQualityResponse(ArrayList<String> lines) {
        return null;
    }

    public String parseWorklistResponse(ArrayList<String> lines) {
        this.equipamento.getAbaNaoEnviados().reloadExames();
        this.equipamento.getAbaPendentes().reloadExames();
        this.equipamento.getAbaProntos().reloadExames();
        String retorno = "";
        String line = lines.remove(0);
        if (!line.startsWith(WORKLIST_LINE)) {
            return null;
        }
        try {
            String int_codigo;
            String req;
            Statement st = Conexao.getStatement();
            String ier_rackpos = line.substring(3, 7);
            String prioridade = line.substring(19, 20);
            String req_codigo = line.substring(8, 20);
            String fil_codigo = "";
            String rec_codigo = "";
            int digitosTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            if (digitosTubo == 10) {
                req = req_codigo.substring(0, digitosTubo);
                fil_codigo = req.substring(0, ParametrosGerais.getDigitosTuboFilial());
                req_codigo = req.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                rec_codigo = req.substring(req.length() - ParametrosGerais.getDigitosTuboTubo(), req.length());
                if (Funcoes.textoVazio(rec_codigo) || !Funcoes.textoVazio(rec_codigo) && !Funcoes.isNumeric(rec_codigo)) {
                    this.fireExcecaoEncontrada("Recipiente n\u00e3o encontrado ou inv\u00e1lido. Tubo: " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    return null;
                }
            } else {
                req = this.getRequisicaoRack(ier_rackpos, req_codigo);
                if (Funcoes.textoVazio(req_codigo)) {
                    this.fireExcecaoEncontrada("N\u00e3o foi encontrada a requisi\u00e7\u00e3o para a rack :" + ier_rackpos);
                    return "Erro ao receber confirma\u00e7\u00e3o de worklist.";
                }
                fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                if (Funcoes.textoVazio(rec_codigo) || !Funcoes.textoVazio(rec_codigo) && !Funcoes.isNumeric(rec_codigo)) {
                    this.fireExcecaoEncontrada("Recipiente n\u00e3o encontrado ou inv\u00e1lido. Tubo: " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    return null;
                }
            }
            if (Funcoes.textoVazio(int_codigo = this.getIntRack(ier_rackpos)) && digitosTubo > 10) {
                this.fireExcecaoEncontrada("N\u00e3o foi encontrado nenhuma configura\u00e7\u00e3o de interface para a rack :" + ier_rackpos);
                return "Erro ao receber confirma\u00e7\u00e3o de worklist.";
            }
            String examesEnviados = "";
            examesEnviados = this.ultimo_enviado != null && this.ultimo_enviado.getCodigo() != null && this.ultimo_enviado.getFilial().equalsIgnoreCase(fil_codigo) && this.ultimo_enviado.getCodigo().equalsIgnoreCase(req_codigo) && this.ultimo_enviado.getRecipiente().equalsIgnoreCase(rec_codigo) ? this.ultimo_enviado.getExames() : this.getExamesRack(ier_rackpos);
            if (Funcoes.textoVazio(examesEnviados)) {
                this.fireExcecaoEncontrada("N\u00e3o foi encontrado os exames enviados para a rack :" + ier_rackpos);
                return "Erro ao receber confirma\u00e7\u00e3o de worklist.";
            }
            String exames = line.substring(21);
            String[] temp = exames.split(" ");
            ArrayList<String> recusados = new ArrayList<String>();
            for (String t : temp) {
                if (Funcoes.textoVazio(t)) continue;
                recusados.add(t);
            }
            if (recusados.size() > 0) {
                for (int i = 0; i < recusados.size(); ++i) {
                    String recusado = (String)recusados.get(i);
                    ExameMaterial exa_codigo = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, recusado);
                    if (exa_codigo == null) continue;
                    recusados.set(i, exa_codigo.getNomeExame());
                }
            }
            String mco_codigo = this.ultimo_enviado.getMaterial();
            ExameMaterial[] last_tests = ExamesUtil.anexarCodigoMaterial(examesEnviados.split(" ", 0), mco_codigo);
            ExameMaterial[] last_tests_alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, last_tests);
            boolean enviou = false;
            for (int i = 0; i < last_tests.length; ++i) {
                ExameMaterial exa_codigo = last_tests[i];
                if (recusados.contains(exa_codigo.getNomeExame())) {
                    StringBuilder msg = new StringBuilder("Requisi\u00e7\u00e3o (").append(req_codigo).append(") - O exame ").append(exa_codigo).append(" foi recusado pelo equipamento.");
                    this.fireExcecaoEncontrada(msg.toString());
                    continue;
                }
                int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo.getNomeExame(), exa_codigo.getCodigoMaterial(), rec_codigo);
                situacao = situacao < 2 ? 1 : 3;
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo.getNomeExame(), exa_codigo.getCodigoMaterial(), int_codigo, ier_rackpos, situacao);
                if (BDUtil.existeDesmembramento(fil_codigo, int_codigo, req_codigo, rec_codigo, exa_codigo.getNomeExame(), mco_codigo)) {
                    ExameMaterial[] exaPai;
                    for (ExameMaterial e : exaPai = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, req_codigo, rec_codigo, exa_codigo.getNomeExame(), mco_codigo)) {
                        situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo);
                        situacao = situacao < 2 ? 1 : 3;
                        this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, e.getNomeExame(), e.getCodigoMaterial(), int_codigo, ier_rackpos, situacao);
                        BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), exa_codigo.getNomeExame(), exa_codigo.getCodigoMaterial(), rec_codigo, situacao);
                    }
                }
                enviou = true;
            }
            Conexao.arquivaSQL();
            if (enviou) {
                String pac_nome = BDUtil.getNomePaciente(fil_codigo, req_codigo);
                retorno = "Exames enviados para " + (pac_nome == null ? req_codigo : pac_nome);
                if (this.ultimo_enviado_acao.equals("N")) {
                    this.firePacienteEnviado(req_codigo, pac_nome, this.ultimo_enviado.getSexo(), this.ultimo_enviado.getIdade(), this.ultimo_enviado.getData(), this.ultimo_enviado.getHora(), this.ultimo_enviado.getExames());
                }
            }
            this.fireAtualizarTabela(0);
            this.fireAtualizarTabela(1);
            this.fireAtualizarTabela(2);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex1) {
                ErrorLogger.mostraMensagem(null, ex1.getMessage(), ex1.getStackTrace());
            }
            retorno = "Erro ao receber confirma\u00e7\u00e3o de worklist.";
        }
        this.setPausa(10000);
        return retorno;
    }

    public String parseDeletionResponse(ArrayList<String> lines) {
        return null;
    }

    public String parseRackInformation(ArrayList<String> lines) {
        return null;
    }

    public String parseInstrumentControl(ArrayList<String> lines) {
        return null;
    }

    public String parseInstrumentInfo(ArrayList<String> lines) {
        return null;
    }

    public String parsePatientResult(ArrayList<String> lines) {
        try {
            String retorno = null;
            Statement st = Conexao.getStatement();
            while (!lines.isEmpty()) {
                String line = lines.remove(0);
                if (!line.startsWith(RESULT_LINE)) continue;
                String emi_alternativo = line.substring(5, 7);
                String exa_codigo = line.substring(8, 12);
                String ier_rackpos = line.substring(16, 20);
                String req_codigo = line.substring(21, 31);
                String ers_resultado = line.substring(32, 44);
                String fil_codigo = "";
                String rec_codigo = "";
                int digitosTudo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(req_codigo);
                if (etiqueta != null) {
                    fil_codigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                    req_codigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                    rec_codigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                    req_codigo = fil_codigo + req_codigo + rec_codigo;
                }
                if (digitosTudo == 10) {
                    if (Funcoes.textoVazio(req_codigo)) {
                        this.fireExcecaoEncontrada("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o localizado para a rack :" + ier_rackpos + " e o alternativo: " + emi_alternativo);
                        continue;
                    }
                    fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                    rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                } else {
                    if (Funcoes.textoVazio(req_codigo = this.getRequisicaoRack(ier_rackpos, req_codigo))) {
                        this.fireExcecaoEncontrada("N\u00e3o foi encontrada a requisi\u00e7\u00e3o para a rack :" + ier_rackpos);
                        continue;
                    }
                    fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                    rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                }
                if (!(Funcoes.isNumeric(fil_codigo) && Funcoes.isNumeric(req_codigo) && Funcoes.isNumeric(rec_codigo))) {
                    this.fireExcecaoEncontrada(String.format("Id da amostra inv\u00e1lido verifique : %s %s %s", fil_codigo, req_codigo, rec_codigo));
                    continue;
                }
                String int_codigo = this.getIntRack(ier_rackpos);
                if (digitosTudo == 10 && Funcoes.textoVazio(int_codigo) && !Funcoes.textoVazio(emi_alternativo)) {
                    int digitosEqp = fil_codigo.trim().length() + req_codigo.trim().length() + rec_codigo.trim().length();
                    if (digitosEqp != digitosTudo) {
                        this.fireExcecaoEncontrada(String.format("Id da amostra menor que o definido: (%s %s %s)", fil_codigo, req_codigo, rec_codigo));
                        continue;
                    }
                    int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                }
                if (Funcoes.textoVazio(int_codigo)) {
                    this.fireExcecaoEncontrada("N\u00e3o foi encontrado nenhuma configura\u00e7\u00e3o de interface para a rack :" + ier_rackpos);
                    continue;
                }
                if (Funcoes.textoVazio(emi_alternativo)) {
                    this.fireExcecaoEncontrada("N\u00e3o foi encontrado c\u00f3digo alternativo no resultado recebido para a rack :" + ier_rackpos);
                    continue;
                }
                ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada("N\u00e3o foi encontrada nenhum exame como o alternativo: " + emi_alternativo + " para a requisi\u00e7\u00e3o " + fil_codigo + " - " + req_codigo + " - " + rec_codigo);
                    continue;
                }
                String mco_codigo = exame.getCodigoMaterial();
                ers_resultado = Funcoes.textoVazio(ers_resultado = Funcoes.resolverDouble(ers_resultado)) ? ers_resultado : this.arrendondaValor(ers_resultado, fil_codigo, exame.getNomeExame(), mco_codigo, int_codigo);
                ers_resultado = Funcoes.textoVazio(ers_resultado) ? ers_resultado : ers_resultado.replaceAll("\\.", ",");
                req_codigo = StringUtil.preencheString(req_codigo, ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
                rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
                String string = exa_codigo = exame != null ? exame.getNomeExame() : null;
                if (exa_codigo != null) {
                    ExameMaterial[] exaPai;
                    HashMap<String, Object> dados = new HashMap<String, Object>();
                    dados.put("rack_position", ier_rackpos);
                    int sit = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
                    if (sit >= 0) {
                        String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                        dados.put(campo, ers_resultado);
                        this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, dados);
                    }
                    if (!BDUtil.existeDesmembramento(fil_codigo, int_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial())) continue;
                    for (ExameMaterial ePai : exaPai = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial())) {
                        sit = BDUtil.getExmSituacao(fil_codigo, int_codigo, req_codigo, ePai.getNomeExame(), ePai.getCodigoMaterial(), rec_codigo);
                        String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                        dados.put(campo, ers_resultado.replaceAll("\\.", ","));
                        this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
                    }
                    continue;
                }
                retorno = "Erro ao receber resultado(s) de exame(s) da requisi\u00e7\u00e3o (" + req_codigo + ").";
                String msg = "Erro ao receber resultado (" + req_codigo + ") - Nenhum exame de c\u00f3d. alternativo " + emi_alternativo + " foi encontrado no sistema.";
                this.fireExcecaoEncontrada(msg);
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(2);
            this.setPausa(100);
            return retorno;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return null;
        }
    }

    public String parseErrorMessage(ArrayList<String> lines) {
        String line = lines.remove(0);
        if (!line.startsWith("73")) {
            return null;
        }
        try {
            int erro = Integer.parseInt(line.substring(3));
            String msg = "";
            switch (erro) {
                case 1: {
                    msg = "COBAS MSG #0001: PHOTOMETER OVERFLOW";
                    break;
                }
                case 2: {
                    msg = "COBAS MSG #0002: PHOTOMETER OFFSET TOO LOW";
                    break;
                }
                case 3: {
                    msg = "COBAS MSG #0003: PHOTOMETER OVERFLOW FIX AGAIN";
                    break;
                }
                case 4: {
                    msg = "COBAS MSG #0004: PHOTOMETER TIMING INVALID";
                    break;
                }
                case 5: {
                    msg = "COBAS MSG #0005: PHOTOMETER OFFSET TOO HIGH";
                    break;
                }
                case 6: {
                    msg = "COBAS MSG #0006: PHOTOMETER NO RESPONSE";
                    break;
                }
                case 7: {
                    msg = "COBAS MSG #0007: PHOTOMETER NO INTERRUPT";
                    break;
                }
                case 8: {
                    msg = "COBAS MSG #0008: TIMEOUT CYCLIC MEASUREMENT";
                    break;
                }
                case 9: {
                    msg = "COBAS MSG #0009: TIMEOUT FILTER CHANGE";
                    break;
                }
                case 10: {
                    msg = "COBAS MSG #0010: TIMEOUT T0 MEASUREMENT";
                    break;
                }
                case 11: {
                    msg = "COBAS MSG #0011: BACKGROUND OVERFLOW SAMPLE";
                    break;
                }
                case 12: {
                    msg = "COBAS MSG #0012: BACKGROUND UNDERFLOW SAMPLE";
                    break;
                }
                case 13: {
                    msg = "COBAS MSG #0013: BACKGROUND OVERFLOW REF.";
                    break;
                }
                case 14: {
                    msg = "COBAS MSG #0014: BACKGROUND UNDERFLOW REF.";
                    break;
                }
                case 15: {
                    msg = "COBAS MSG #0015: TRANSFER NOT INITIALIZED";
                    break;
                }
                case 16: {
                    msg = "COBAS MSG #0016: P-SAMPLE NOT INITIALIZED";
                    break;
                }
                case 17: {
                    msg = "COBAS MSG #0017: P-REAGENT NOT INITIALIZED";
                    break;
                }
                case 18: {
                    msg = "COBAS MSG #0018: ANALYZER NOT INITIALIZED";
                    break;
                }
                case 19: {
                    msg = "COBAS MSG #0019: FILTER NOT INITIALIZED";
                    break;
                }
                case 20: {
                    msg = "COBAS MSG #0020: X-MOTOR INIT NOT POSSIBLE";
                    break;
                }
                case 21: {
                    msg = "COBAS MSG #0021: ANALYZER INIT NOT POSSIBLE";
                    break;
                }
                case 22: {
                    msg = "COBAS MSG #0022: FILTER INIT NOT POSSIBLE";
                    break;
                }
                case 23: {
                    msg = "COBAS MSG #0023: Y-MOTOR INIT NOT POSSIBLE";
                    break;
                }
                case 24: {
                    msg = "COBAS MSG #0024: P-SAMPLE INIT NOT POSSIBLE";
                    break;
                }
                case 27: {
                    msg = "COBAS MSG #0027: P-REAGENT INIT NOT POSSIBLE";
                    break;
                }
                case 29: {
                    msg = "COBAS MSG #0029: ANALYZER COVER OPEN";
                    break;
                }
                case 30: {
                    msg = "COBAS MSG #0030: TRANSFER AREA BLOCKED";
                    break;
                }
                case 31: {
                    msg = "COBAS MSG #0031: ANALYZER STEP ERROR";
                    break;
                }
                case 32: {
                    msg = "COBAS MSG #0032: FILTER STEP ERROR";
                    break;
                }
                case 33: {
                    msg = "COBAS MSG #0033: Y-MOTOR STEP ERROR";
                    break;
                }
                case 34: {
                    msg = "COBAS MSG #0034: P-SAMPLE STEP ERROR";
                    break;
                }
                case 35: {
                    msg = "COBAS MSG #0035: Z-SAMPLE POSITION ERROR";
                    break;
                }
                case 37: {
                    msg = "COBAS MSG #0037: P-REAGENT STEP ERROR";
                    break;
                }
                case 38: {
                    msg = "COBAS MSG #0038: Z-REAGENT POSITION ERROR";
                    break;
                }
                case 39: {
                    msg = "COBAS MSG #0039: Z-BARCODE POSITION ERROR";
                    break;
                }
                case 40: {
                    msg = "COBAS MSG #0040: MOTOR-CTRL I NO RESPONSE";
                    break;
                }
                case 41: {
                    msg = "COBAS MSG #0041: MOTOR-CTRL II NO RESPONSE";
                    break;
                }
                case 42: {
                    msg = "COBAS MSG #0042: MOTOR-CTRL II DATA ERROR";
                    break;
                }
                case 43: {
                    msg = "COBAS MSG #0043: NO SUITABLE RACKS FOUND";
                    break;
                }
                case 44: {
                    msg = "COBAS MSG #0044: NOT ENOUGH EMPTY CUVETTES";
                    break;
                }
                case 46: {
                    msg = "COBAS MSG #0046: ROM CHECK FAILED";
                    break;
                }
                case 47: {
                    msg = "COBAS MSG #0047: REFERENCE < LIMIT";
                    break;
                }
                case 48: {
                    msg = "COBAS MSG #0048: LEVEL DETECTION ERROR";
                    break;
                }
                case 49: {
                    msg = "COBAS MSG #0049: PRINTER MOTOR DEFECT";
                    break;
                }
                case 50: {
                    msg = "COBAS MSG #0050: BAD TEMPERATURES";
                    break;
                }
                case 51: {
                    msg = "COBAS MSG #0051: BAD ANALYZER TEMPERATURE";
                    break;
                }
                case 52: {
                    msg = "COBAS MSG #0052: BAD REAGENT TEMPERATURE";
                    break;
                }
                case 53: {
                    msg = "COBAS MSG #0053: ANALYZER TEMP. OUT OF RANGE";
                    break;
                }
                case 54: {
                    msg = "COBAS MSG #0054: REAGENT TEMP. OUT OF RANGE";
                    break;
                }
                case 55: {
                    msg = "COBAS MSG #0055: REAGENT/ANALYZER TEMPERATURE NOT WITHIN RANGE YET";
                    break;
                }
                case 56: {
                    msg = "COBAS MSG #0056: HOST INTERFACE NO RESPONSE";
                    break;
                }
                case 57: {
                    msg = "COBAS MSG #0057: HOST INTERFACE PROTOCOL ERROR";
                    break;
                }
                case 58: {
                    msg = "COBAS MSG #0058: SYSTEM BUSY";
                    break;
                }
                case 59: {
                    msg = "COBAS MSG #0059: COMMUNICATION-CONTROL NO RESPONSE";
                    break;
                }
                case 60: {
                    msg = "COBAS MSG #0060: INVALID SAMPLE BARCODE POSITION";
                    break;
                }
                case 61: {
                    msg = "COBAS MSG #0061: DILUENT EMPTY";
                    break;
                }
                case 62: {
                    msg = "COBAS MSG #0062: ISE ACTIVATOR EMPTY";
                    break;
                }
                case 63: {
                    msg = "COBAS MSG #0063: SAMPLE EMPTY";
                    break;
                }
                case 64: {
                    msg = "COBAS MSG #0064: CONTROL EMPTY";
                    break;
                }
                case 65: {
                    msg = "COBAS MSG #0065: PROGRAM ERROR";
                    break;
                }
                case 66: {
                    msg = "COBAS MSG #0066: REAGENT EMPTY";
                    break;
                }
                case 67: {
                    msg = "COBAS MSG #0067: ISE ELECTRODE OVERRANGE";
                    break;
                }
                case 68: {
                    msg = "COBAS MSG #0068: ISE A/D CONV TIMEOUT";
                    break;
                }
                case 69: {
                    msg = "COBAS MSG #0069: INVALID SAMPLE POSITION";
                    break;
                }
                case 70: {
                    msg = "COBAS MSG #0070: STANDARD EMPTY";
                    break;
                }
                case 71: {
                    msg = "COBAS MSG #0071: START REAG.1 EMPTY";
                    break;
                }
                case 72: {
                    msg = "COBAS MSG #0072: START REAG.2 EMPTY";
                    break;
                }
                case 73: {
                    msg = "COBAS MSG #0073: BLANK SOLUTION EMPTY";
                    break;
                }
                case 74: {
                    msg = "COBAS MSG #0074: MOTOR-CTRL II OVER CUR.";
                    break;
                }
                case 75: {
                    msg = "COBAS MSG #0075: ADJUST-WASH NOT POSSIBLE";
                    break;
                }
                case 76: {
                    msg = "COBAS MSG #0076: ADJUST-ANAL. NOT POSSIBLE";
                    break;
                }
                case 77: {
                    msg = "COBAS MSG #0077: ADJUST-BARC. NOT POSSIBLE";
                    break;
                }
                case 78: {
                    msg = "COBAS MSG #0078: ADJUST-RACK NOT POSSIBLE";
                    break;
                }
                case 79: {
                    msg = "COBAS MSG #0079: NO WORKLIST ENTRY";
                    break;
                }
                case 81: {
                    msg = "COBAS MSG #0081: ISE INTERFACE NO RESPONSE";
                    break;
                }
                case 82: {
                    msg = "COBAS MSG #0082: ISE MODULE NO RESPONSE";
                    break;
                }
                case 83: {
                    msg = "COBAS MSG #0083: ISE MODULE BUSY";
                    break;
                }
                case 84: {
                    msg = "COBAS MSG #0084: ISE INTERFACE PARITY ERROR";
                    break;
                }
                case 85: {
                    msg = "COBAS MSG #0085: ISE RAM ERROR";
                    break;
                }
                case 86: {
                    msg = "COBAS MSG #0086: ISE LEAKAGE ERROR";
                    break;
                }
                case 87: {
                    msg = "COBAS MSG #0087: ISE CLEANER EMPTY";
                    break;
                }
                case 88: {
                    msg = "COBAS MSG #0088: ISE ETCHER EMPTY";
                    break;
                }
                case 89: {
                    msg = "COBAS MSG #0089: RESULT ERROR IN TEST RESULTS!";
                    break;
                }
                case 90: {
                    msg = "COBAS MSG #0090: LEAVE TEST RESULTS, PLEASE!";
                    break;
                }
                case 91: {
                    msg = "COBAS MSG #0091: INVALID BARCODE INPUT";
                    break;
                }
                case 92: {
                    msg = "COBAS MSG #0092: INCORRECT RATIO TEST-GROUP";
                    break;
                }
                case 93: {
                    msg = "COBAS MSG #0093: INCORRECT RATIO FORMULA";
                    break;
                }
                case 94: {
                    msg = "COBAS MSG #0094: WORKLIST COMPLETED";
                    break;
                }
                case 95: {
                    msg = "COBAS MSG #0095: MISSING RACK";
                    break;
                }
                case 96: {
                    msg = "COBAS MSG #0096: TIP CLEANER EMPTY";
                    break;
                }
                case 97: {
                    msg = "COBAS MSG #0097: NO WATER AVAILABLE";
                    break;
                }
                case 98: {
                    msg = "COBAS MSG #0098: TEST RESULT OCCUPIED";
                    break;
                }
                case 99: {
                    msg = "COBAS MSG #0099: RACK READER NO RESPONSE";
                    break;
                }
                case 100: {
                    msg = "COBAS MSG #0100: MEMORY CAPACITY OVERFLOW";
                    break;
                }
                case 101: {
                    msg = "COBAS MSG #0101: SYSTEM INITIALIZED";
                    break;
                }
                case 102: {
                    msg = "COBAS MSG #0102: TEST DOESN'T EXIST";
                    break;
                }
                case 103: {
                    msg = "COBAS MSG #0103: RATIO DOESN'T EXIST";
                    break;
                }
                case 104: {
                    msg = "COBAS MSG #0104: PROFILE DOESN'T EXIST";
                    break;
                }
                case 105: {
                    msg = "COBAS MSG #0105: SAMPLE NOT FOUND";
                    break;
                }
                case 106: {
                    msg = "COBAS MSG #0106: TEST NOT FOUND";
                    break;
                }
                case 107: {
                    msg = "COBAS MSG #0107: NO RACK FOUND";
                    break;
                }
                case 108: {
                    msg = "COBAS MSG #0108: TEST/RACK PROGRAMMING ERROR";
                    break;
                }
                case 109: {
                    msg = "COBAS MSG #0109: PLACE RACK REAG 5s NO.1 ON POS.1 AND A RACK SAMP 16A ON POS.3";
                    break;
                }
                case 110: {
                    msg = "COBAS MSG #0110: LOW CPU BATTERY";
                    break;
                }
                case 111: {
                    msg = "COBAS MSG #0111: PRINTER BUSY";
                    break;
                }
                case 112: {
                    msg = "COBAS MSG #0112: PRIVILEGED ACTION";
                    break;
                }
                case 113: {
                    msg = "COBAS MSG #0113: TEST LOCKED";
                    break;
                }
                case 114: {
                    msg = "COBAS MSG #0114: TEST IN WORKLIST AND QUALITY";
                    break;
                }
                case 115: {
                    msg = "COBAS MSG #0115: RATIO IN WORKLIST";
                    break;
                }
                case 116: {
                    msg = "COBAS MSG #0116: ALL TESTS IN WORKLIST";
                    break;
                }
                case 117: {
                    msg = "COBAS MSG #0117: SYSTEM IN PROCESS";
                    break;
                }
                case 118: {
                    msg = "COBAS MSG #0118: SYSTEM CHECKS IN PROGRESS";
                    break;
                }
                case 119: {
                    msg = "COBAS MSG #0119: WORKLIST NOT EMPTY";
                    break;
                }
                case 120: {
                    msg = "COBAS MSG #0120: MULTI-IF PCB/BARCODE-READER MISSING OR NOT ADJUSTED";
                    break;
                }
                case 121: {
                    msg = "COBAS MSG #0121: TEST/DILUTION ALREADY ASSIGNED";
                    break;
                }
                case 122: {
                    msg = "COBAS MSG #0122: CONFIRM BY <ENTER>";
                    break;
                }
                case 123: {
                    msg = "COBAS MSG #0123: <ENTER> TO DELETE THE ALREADY PRINTED RESULTS";
                    break;
                }
                case 124: {
                    msg = "COBAS MSG #0124: FIRST ADJUST R-S NEEDLES";
                    break;
                }
                case 125: {
                    msg = "COBAS MSG #0125: ISE TESTS NOT ASSIGNABLE";
                    break;
                }
                case 126: {
                    msg = "COBAS MSG #0126: TEST IN WORKLIST";
                    break;
                }
                case 127: {
                    msg = "COBAS MSG #0127: TEST IN QUALITY";
                    break;
                }
                case 128: {
                    msg = "COBAS MSG #0128: PRINTER LEVER OPEN";
                    break;
                }
                case 129: {
                    msg = "COBAS MSG #0129: NO PRINTER PAPER";
                    break;
                }
                case 130: {
                    msg = "COBAS MSG #0130: SEGMENT INPUT EMPTY";
                    break;
                }
                case 131: {
                    msg = "COBAS MSG #0131: SEGMENT OUTPUT FULL";
                    break;
                }
                case 132: {
                    msg = "COBAS MSG #0132: CHANGER X-MOTOR TIMEOUT";
                    break;
                }
                case 133: {
                    msg = "COBAS MSG #0133: CHANGER Y-MOTOR TIMEOUT";
                    break;
                }
                case 134: {
                    msg = "COBAS MSG #0134: CHANGER Z-MOTOR TIMEOUT";
                    break;
                }
                case 135: {
                    msg = "COBAS MSG #0135: CHANGER X NOT IN POSITION";
                    break;
                }
                case 136: {
                    msg = "COBAS MSG #0136: CHANGER Y NOT IN POSITION";
                    break;
                }
                case 137: {
                    msg = "COBAS MSG #0137: CHANGER Z NOT IN POSITION";
                    break;
                }
                case 138: {
                    msg = "COBAS MSG #0138: CHANGER/COOLING-CONTROL NO RESPONSE";
                    break;
                }
                case 139: {
                    msg = "COBAS MSG #0139: CHANGER TIMING INVALID";
                    break;
                }
                case 140: {
                    msg = "COBAS MSG #0140: RACK TEMPERATURE TOO HIGH";
                    break;
                }
                case 141: {
                    msg = "COBAS MSG #0141: ROUTINE WORKLIST NOT COMPLETE";
                    break;
                }
                case 142: {
                    msg = "COBAS MSG #0142: STAT WORKLIST NOT COMPLETED";
                    break;
                }
                case 143: {
                    msg = "COBAS MSG #0143: INVALID INPUT";
                    break;
                }
                case 144: {
                    msg = "COBAS MSG #0144: MOTOR-CTRL II HARDWARE-ERROR";
                    break;
                }
                case 145: {
                    msg = "COBAS MSG #0145: MOTOR-CTRL II LIGHTB.-ERROR";
                    break;
                }
                case 146: {
                    msg = "COBAS MSG #0146: R-S NEEDLES NOT PARALLEL";
                    break;
                }
                case 147: {
                    msg = "COBAS MSG #0147: TOUCH ERROR";
                    break;
                }
                case 148: {
                    msg = "COBAS MSG #0148: ADJUST-RACKRS. NOT POSSIBLE";
                    break;
                }
                case 149: {
                    msg = "COBAS MSG #0149: R-S NEEDLES DISTANCE IS NOT 8mm";
                    break;
                }
                case 150: {
                    msg = "COBAS MSG #0150: LD. ERROR-SAMP - PLEASE CALL SERVICE CENTER";
                    break;
                }
                case 151: {
                    msg = "COBAS MSG #0151: LD. ERROR-REAG - PLEASE CALL SERVICE CENTER";
                    break;
                }
                case 170: {
                    msg = "COBAS MSG #0170: TRANSFER NOT ADJUSTED";
                    break;
                }
                case 171: {
                    msg = "COBAS MSG #0171: ROUTINE WORKLIST NOT COMPLETED AND/OR POST DIL./CONC. PENDING";
                    break;
                }
                case 172: {
                    msg = "COBAS MSG #0172: STAT WORKLIST NOT COMPLETED AND/OR POST DIL./CONC. PENDING";
                    break;
                }
                default: {
                    msg = null;
                }
            }
            if (msg != null) {
                this.fireExcecaoEncontrada(msg);
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void dataChanged() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    String message = InterfaceListener.this.getPortaCOM().getInputString();
                    if (!message.equals("") && message.indexOf(InterfaceListener.this.getMsgEnd()) >= 0) {
                        message = InterfaceListener.this.getPortaCOM().removeInputString(InterfaceListener.this.getMsgEnd());
                        InterfaceListener.this.addListaRecebimento(message);
                        InterfaceListener.this.restartThreadRecebimento();
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        try {
            if (this.isTX()) {
                this.abortarTransmissao();
            } else {
                this.setIdle();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void teste() {
        this.testeResultado("0101508204", "0002");
    }

    @Override
    public void atualizarSituacaoExame(Statement st, String fil_codigo, String req_codigo, String rec_codigo, String exa_codigo, String mco_codigo, String int_codigo, String rack, int situacao, boolean curva) throws SQLException {
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            ArrayList<String> requisicoes = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
            ExameMaterial exa = ExamesUtil.anexarCodigoMaterial(exa_codigo.split(" ", 0), mco_codigo)[0];
            for (String req : requisicoes) {
                ExameMaterial[] exaMat;
                if (BDUtil.existeDesmembramento(fil_codigo, int_codigo, req, rec_codigo, exa_codigo, mco_codigo) || curva) {
                    this.atualizaSitExame(st, fil_codigo, req, rec_codigo, exa_codigo, mco_codigo, int_codigo, rack, situacao, req);
                    this.atualizaSituacaoDesmembrado(st, fil_codigo, req, rec_codigo, exa_codigo, mco_codigo, int_codigo, rack, situacao, req);
                    continue;
                }
                if (BDUtil.existeExame(fil_codigo, int_codigo, req, exa.getNomeExame(), mco_codigo, rec_codigo)) {
                    this.atualizaSitExame(st, fil_codigo, req, rec_codigo, exa_codigo, mco_codigo, int_codigo, rack, situacao, req);
                    continue;
                }
                if (!BDUtil.existeDesmembramento(fil_codigo, int_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, true) || (exaMat = BDUtil.getExameMaterialRecipiente(fil_codigo, req_codigo, rec_codigo, int_codigo)) == null || exaMat.length != 1) continue;
                this.atualizaSituacaoDesmembrado(st, fil_codigo, req_codigo, rec_codigo, exaMat[0].getNomeExame(), exaMat[0].getCodigoMaterial(), int_codigo, rack, situacao, req);
            }
        } else {
            this.atualizaSitExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, rack, situacao, req_codigo);
            if (BDUtil.existeDesmembramento(fil_codigo, int_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo)) {
                this.atualizaSituacaoDesmembrado(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, rack, situacao, req_codigo);
            }
        }
    }

    private void atualizaSitExame(Statement st, String fil_codigo, String req_codigo, String rec_codigo, String exa_codigo, String mco_codigo, String int_codigo, String rack, int situacao, String req) throws SQLException {
        if (Funcoes.textoVazio(rack)) {
            BDUtil.setExmSituacao(st, fil_codigo, int_codigo, req, exa_codigo, mco_codigo, rec_codigo, situacao);
        } else {
            BDUtil.setExmSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, situacao, rack);
        }
    }

    private void atualizaSituacaoDesmembrado(Statement st, String fil_codigo, String req_codigo, String rec_codigo, String exa_codigo, String mco_codigo, String int_codigo, String rack, int situacao, String req) throws SQLException {
        ExameMaterial[] exaPai = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo);
        String exPai = null;
        String exMcoPai = null;
        for (ExameMaterial e : exaPai) {
            exPai = e.getNomeExame();
            exMcoPai = e.getCodigoMaterial();
            BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), exa_codigo, mco_codigo, rec_codigo, situacao);
        }
        if (!Funcoes.textoVazio(exPai) && !Funcoes.textoVazio(exMcoPai)) {
            if (BDUtil.existeExame(fil_codigo, int_codigo, req, exPai, exMcoPai, rec_codigo)) {
                this.atualizaSitExame(st, fil_codigo, req_codigo, rec_codigo, exPai, exMcoPai, int_codigo, rack, situacao, req_codigo);
            } else if (BDUtil.isExameCurva(fil_codigo, int_codigo, exPai, exMcoPai)) {
                String tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, exPai, exMcoPai);
                BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, exPai, exMcoPai, exa_codigo, mco_codigo, tuboPai, situacao);
                if (tuboPai != null && BDUtil.isGrupoInteiroPendente(fil_codigo, int_codigo, req_codigo, exPai, exMcoPai, tuboPai)) {
                    this.atualizaSitExame(st, fil_codigo, req_codigo, tuboPai, exPai, exMcoPai, int_codigo, rack, situacao, req_codigo);
                }
            }
        }
    }

    private void testeResultado(String req, String posRack) {
        StringBuilder tmp = new StringBuilder();
        tmp.append("[SOH][LF]08[SP]JALIS[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]10[LF][STX][LF]50[SP]0063[SP]010005385004[SP]R[SP]V1[SP]G1[LF][ETX][LF][EOT][LF]");
        this.parse(TestesInterface.arruma(tmp.toString()));
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

