/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cobasmirinha;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.cobasmp.InterfaceListener {
    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            String[] exms;
            Statement st = Conexao.getStatement();
            for (String s : exms = exames.split(" ", 0)) {
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, s, mco_codigo, int_codigo, null, acao.equals("N") ? 1 : 3);
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    public void requestSampleDeletion(String fil_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String rackposition, String priority) throws Exception {
    }

    @Override
    public String parsePatientResult(ArrayList<String> lines) {
        try {
            String retorno = null;
            Statement st = Conexao.getStatement();
            while (!lines.isEmpty()) {
                String line = lines.remove(0);
                if (!line.startsWith("20")) continue;
                String emi_alternativo = line.substring(5, 7);
                String exa_codigo = line.substring(8, 12);
                String ier_rackpos = line.substring(16, 20);
                String req_codigo = line.substring(21, 31);
                String ers_resultado = line.substring(32, 44);
                String fil_codigo = "";
                String rec_codigo = "";
                if (req_codigo.trim().length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                    this.fireExcecaoEncontrada(String.format("C\u00f3digo da requisi\u00e7\u00e3o %s, alternativo: %s", req_codigo.trim().length() > 0 ? req_codigo.trim() + " com tamanho incorreto " : "vazia", emi_alternativo));
                    continue;
                }
                fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                String int_codigo = this.getIntCodigo(fil_codigo, req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao()), rec_codigo, emi_alternativo);
                if (Funcoes.textoVazio(int_codigo)) {
                    this.fireExcecaoEncontrada("N\u00e3o foi encontrado nenhuma configura\u00e7\u00e3o de interface para o exame: " + emi_alternativo + " para a requisi\u00e7\u00e3o " + fil_codigo + " - " + req_codigo + " - " + rec_codigo);
                    continue;
                }
                ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada("N\u00e3o foi encontrada nenhum exame como o alternativo: " + emi_alternativo + " para a requisi\u00e7\u00e3o " + fil_codigo + " - " + req_codigo + " - " + rec_codigo);
                    continue;
                }
                String mco_codigo = exame.getCodigoMaterial();
                ers_resultado = Funcoes.resolverDouble(ers_resultado);
                ers_resultado = this.arrendondaValor(ers_resultado, fil_codigo, exame.getNomeExame(), mco_codigo, int_codigo);
                req_codigo = StringUtil.preencheString(req_codigo, ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
                rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
                String string = exa_codigo = exame != null ? exame.getNomeExame() : null;
                if (exa_codigo != null) {
                    this.atualizarResultadoExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, ers_resultado.replaceAll("\\.", ","));
                    continue;
                }
                retorno = "Erro ao receber resultado(s) de exame(s) da requisi\u00e7\u00e3o (" + req_codigo + ").";
                String msg = "Erro ao receber resultado (" + req_codigo + ") - Nenhum exame de c\u00f3d. alternativo " + emi_alternativo + " foi encontrado no sistema.";
                this.fireExcecaoEncontrada(msg);
            }
            Conexao.arquivaSQL();
            this.setPausa(100);
            return retorno;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return null;
        }
    }

    @Override
    public synchronized String parse(String message) {
        if (message.startsWith(this.getMsgStart())) {
            String[] temp = message.split(String.valueOf(LINE));
            ArrayList<String> lines = new ArrayList<String>();
            for (String t : temp) {
                if (Funcoes.textoVazio(t)) continue;
                lines.add(t);
            }
            String heading = (String)lines.remove(0);
            int block_type = Integer.parseInt(heading.substring(heading.length() - 2));
            switch (block_type) {
                case 0: {
                    return this.parseIdleBlock(lines);
                }
                case 1: {
                    return this.parseControlResults(lines);
                }
                case 3: {
                    return this.parsePatientResult(lines);
                }
                case 5: {
                    return this.parseQualityResults(lines);
                }
                case 8: {
                    return this.parseQualityResponse(lines);
                }
                case 11: {
                    return this.parseWorklistResponse(lines);
                }
                case 16: {
                    return this.parseDeletionResponse(lines);
                }
                case 70: {
                    return this.parseRackInformation(lines);
                }
                case 71: {
                    return this.parseErrorMessage(lines);
                }
                case 94: {
                    return this.parseInstrumentControl(lines);
                }
                case 95: {
                    return this.parseInstrumentInfo(lines);
                }
            }
        }
        return null;
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0004') + String.valueOf(LINE);
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0001') + String.valueOf(LINE);
    }
}

