/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cobasc311;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = ((String)order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID)).trim();
        DescritorCodigoEtiqueta dce = DescritorCodigoEtiqueta.getDescritor(req_codigo);
        if (dce != null) {
            String fil = Funcoes.preencheZero(dce.getFilial(), ParametrosGerais.getDigitosTuboFilial());
            String req = Funcoes.preencheZero(dce.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
            String rec = Funcoes.preencheZero(dce.getTubo(), ParametrosGerais.getDigitosTuboTubo());
            req_codigo = fil + req + rec;
        }
        if (req_codigo == null || req_codigo.equals("")) {
            req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID).trim();
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        Map<Integer, String> components = this.equip.parseOrderTestIDField((String)order_fields.get(ASTMStandard.ORDER_FIELD_TEST_ID));
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        String resultado;
        ExameMaterial exame;
        String int_codigo;
        String rec_codigo;
        String req_codigo;
        String fil_codigo;
        Hashtable result_fields;
        block26: {
            block25: {
                int not;
                String result_status;
                if (this.exame_atual == null) {
                    return;
                }
                String action_code = (String)this.exame_atual.get(ACTION_CODE);
                String report_type = (String)this.exame_atual.get(REPORT_TYPE);
                if (action_code != null) {
                    this.equip.getClass();
                    if (action_code.equals("Q")) {
                        this.exame_atual.remove(INT_CODIGO);
                        this.exame_atual.remove(EXA_CODIGO);
                        this.exame_atual.remove(MCO_CODIGO);
                        return;
                    }
                }
                if (report_type != null) {
                    this.equip.getClass();
                    if (report_type.equals("X")) {
                        this.exame_atual.remove(INT_CODIGO);
                        this.exame_atual.remove(EXA_CODIGO);
                        this.exame_atual.remove(MCO_CODIGO);
                        return;
                    }
                }
                if ((result_status = (String)(result_fields = ASTMStandard.parseDefaultResultRecord(record)).get(ASTMStandard.RESULT_FIELD_RESULT_STATUS)) != null) {
                    this.equip.getClass();
                    if (!result_status.equals("F")) {
                        this.equip.getClass();
                        if (!result_status.equals("R")) {
                            this.equip.getClass();
                            if (!result_status.equals("C")) {
                                this.exame_atual.remove(INT_CODIGO);
                                this.exame_atual.remove(EXA_CODIGO);
                                this.exame_atual.remove(MCO_CODIGO);
                                return;
                            }
                        }
                    }
                }
                fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
                req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
                rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
                this.exame_atual.remove(INT_CODIGO);
                this.exame_atual.remove(EXA_CODIGO);
                this.exame_atual.remove(MCO_CODIGO);
                String emi_alternativo = ((String)result_fields.get(ASTMStandard.RESULT_FIELD_TEST_ID)).split("\\^")[3];
                if (emi_alternativo.endsWith("/")) {
                    emi_alternativo = emi_alternativo.replaceAll("[/]", "");
                }
                if ((not = emi_alternativo.indexOf("//not")) > 0) {
                    emi_alternativo = emi_alternativo.substring(0, not);
                }
                if ((int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo)) == null) {
                    this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    return;
                }
                exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (exame == null) {
                    this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    this.exame_atual.remove(INT_CODIGO);
                    this.exame_atual.remove(EXA_CODIGO);
                    this.exame_atual.remove(MCO_CODIGO);
                    return;
                }
                resultado = (String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE);
                this.equip.getClass();
                if (result_status.equals("F")) break block25;
                this.equip.getClass();
                if (!result_status.equals("C")) break block26;
            }
            resultado = resultado.replaceAll("\\.", ",");
        }
        if (resultado.startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.charAt(resultado.length() - 1) == ',') {
            resultado = resultado + "0";
        }
        Statement st = Conexao.getStatement();
        int sit = this.equip.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
        this.exame_atual.remove("repeticao_quantitativo");
        this.exame_atual.remove("resultado_quantitativo");
        String campo = "resultado_quantitativo";
        if (sit == 3) {
            campo = "repeticao_quantitativo";
        } else if (sit <= 2) {
            campo = "resultado_quantitativo";
            this.exame_atual.remove("repeticao_quantitativo");
        } else {
            this.exame_atual.remove(INT_CODIGO);
            this.exame_atual.remove(EXA_CODIGO);
            this.exame_atual.remove(MCO_CODIGO);
            this.exame_atual.remove("resultado_quantitativo");
            this.exame_atual.remove("repeticao_quantitativo");
            return;
        }
        this.exame_atual.put(INT_CODIGO, int_codigo);
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
        this.exame_atual.put(campo, resultado);
        String flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS);
        if (flags != null && !flags.equals("") && !flags.equalsIgnoreCase("N")) {
            System.out.println(flags);
            this.exame_atual.put("flag_alerta", flags);
            StringBuilder msg = new StringBuilder();
            msg.append("Resultado anormal recebido do aparelho ").append(fil_codigo).append(" ").append(req_codigo).append(" ").append(rec_codigo).append(" (").append(exame.getNomeExame()).append(")").append(" Flag = ").append(flags);
            this.equip.fireExcecaoEncontrada(msg.toString());
        }
        try {
            this.salvaExame(this.exame_atual);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String fil_codigo = (String)dados.get(FIL_CODIGO);
        String req_codigo = (String)dados.get(REQ_CODIGO);
        String rec_codigo = (String)dados.get(REC_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        if (Funcoes.textoVazio(exa_codigo) || Funcoes.textoVazio(mco_codigo)) {
            return;
        }
        String flag = (String)dados.remove("flag");
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        ArrayList<String> flags = new ArrayList<String>();
        if (!Funcoes.textoVazio(flag)) {
            flags.add(flag);
        }
        this.salvaExame(dados, fil_codigo, req_codigo, rec_codigo, int_codigo, exa_codigo, mco_codigo, flags);
    }

    private synchronized void salvaExame(Map<String, Object> dados, String fil_codigo, String req_codigo, String rec_codigo, String int_codigo, String exa_codigo, String mco_codigo, List<String> flags) throws Exception {
        Statement st = Conexao.getStatement();
        this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, dados, flags);
    }

    @Override
    public synchronized void recordFound(String record) throws Exception {
        this.recFound(record);
    }

    public void recFound(String record) throws Exception, SQLException {
        String record_type;
        if (Funcoes.isNumeric(String.valueOf(record.charAt(0)))) {
            record = record.substring(1, record.length() - 1);
        }
        if ((record_type = ASTMStandard.getRecordTypeIdentifier(record)) != null) {
            if (record_type.equals(ASTMStandard.RECORD_TYPE_HEADER)) {
                this.trataHeaderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_PATIENT)) {
                this.trataPatientRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_ORDER)) {
                this.trataOrderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_RESULT)) {
                this.trataResultRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_COMMENT)) {
                this.trataCommentRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_REQUEST)) {
                this.trataRequestRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_TERMINATION)) {
                this.trataTerminationRecord();
                return;
            }
        }
    }

    @Override
    protected void trataCommentRecord(String record) {
        if (this.exame_atual == null) {
            return;
        }
        Hashtable comment_fields = ASTMStandard.parseDefaultCommentRecord(record);
        String type = (String)comment_fields.get(ASTMStandard.COMMENT_FIELD_TYPE);
        String exception = (String)comment_fields.get(ASTMStandard.COMMENT_FIELD_TEXT);
        if (type != null && type.equals("I")) {
            if (exception.equalsIgnoreCase("0")) {
                try {
                    this.salvaExame(this.exame_atual);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Selectra Flexor: RecordParser trataResultRecord");
                }
                return;
            }
            String erro_traduzido = this.equip.getErroTraduzido(exception);
            if (erro_traduzido != null) {
                String exa_codigo = (String)this.exame_atual.get(EXA_CODIGO);
                String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
                String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
                String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
                String exame = exa_codigo != null ? " (" + exa_codigo + ") " : "";
                String msg = fil_codigo + " " + req_codigo + " " + rec_codigo + " " + exame + " Alarme [" + exception + "] - " + erro_traduzido;
                this.exame_atual.put("flag", exception + " - " + erro_traduzido);
                try {
                    this.salvaExame(this.exame_atual);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Selectra Flexor: RecordParser trataResultRecord");
                }
                this.equip.fireExcecaoEncontrada(msg);
            }
        }
    }
}

