/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cobasc311;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.cobasc311.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.cobasc311.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class InterfaceListener
extends InterfaceASTMListener {
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;
    protected boolean repeticao = false;
    protected String rackpos = null;
    protected boolean hostQuery = false;
    private Map<String, String> alarmList = new HashMap<String, String>();
    protected static final String ENVIO_POR_QUERY = "TSDWN^REPLY";
    protected static final String ENVIO_POR_LOTE = "TSDWN^BATCH";
    protected List<InfoExameRequisicao> examesEnviados = new ArrayList<InfoExameRequisicao>();
    protected List<String> tubos = new ArrayList<String>();
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    protected InterfaceConfiguracao configuracao = new InterfaceConfiguracao();

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        this.HOST_SYSTEM_VERSION = "1";
        this.INSTRUMENT_NAME = "c311";
        this.INSTRUMENT_SYSTEM_VERSION = "1";
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.alarmList();
    }

    protected void alarmList() {
        this.alarmList.put("1", "ADC abnormal");
        this.alarmList.put("2", "Cell blank abnormal");
        this.alarmList.put("3", "Sample short");
        this.alarmList.put("4", "Reagent short");
        this.alarmList.put("5", "ABS over");
        this.alarmList.put("6", "Prozone error");
        this.alarmList.put("7", "Reaction limit over(all photometry points)");
        this.alarmList.put("8", "Reaction limit over(second and subsequent photometry points)");
        this.alarmList.put("9", "Reaction limit over(third and fourth and subsequent photometry points)");
        this.alarmList.put("10", "Linearity abnormal(nine or more)");
        this.alarmList.put("11", "Linearity abnormal(eight or less)");
        this.alarmList.put("12", "Standard Solution 1 Absorbance Abnormal");
        this.alarmList.put("13", "Duplicate Error");
        this.alarmList.put("14", "STD Error");
        this.alarmList.put("15", "Sensitivity Error");
        this.alarmList.put("16", "Calibration Error");
        this.alarmList.put("17", "Convergence Error");
        this.alarmList.put("18", "Noise error");
        this.alarmList.put("19", "Level error");
        this.alarmList.put("20", "Slope Error");
        this.alarmList.put("21", "ISE Slope Marginal");
        this.alarmList.put("22", "Internal Concentration Abnormal");
        this.alarmList.put("23", "Sample range over");
        this.alarmList.put("24", "Data error in Compensate test");
        this.alarmList.put("25", "Unable to calculate compensate test");
        this.alarmList.put("26", "PANIC value over (upper)");
        this.alarmList.put("27", "PANIC value over (lower)");
        this.alarmList.put("28", "Random Error [R-4s]");
        this.alarmList.put("29", "System Error 1 [2-2sA]");
        this.alarmList.put("30", "System Error 2 [2-2sW]");
        this.alarmList.put("31", "System Error 3 [4-1sA]");
        this.alarmList.put("32", "System Error 4 [4-1sW]");
        this.alarmList.put("33", "System Error 5 [10xA]");
        this.alarmList.put("34", "System Error 6 [10xW]");
        this.alarmList.put("35", "QC Error 1");
        this.alarmList.put("36", "QC Error 2");
        this.alarmList.put("37", "Calculated test error");
        this.alarmList.put("38", "Overflow");
        this.alarmList.put("39", "Calculation not possible");
        this.alarmList.put("40", "Outside of expected value(upper)");
        this.alarmList.put("41", "Outside of expected value(lower)");
        this.alarmList.put("42", "Edited test");
        this.alarmList.put("43", "Calibration result abnormal");
        this.alarmList.put("44", "Repeat limit over(upper)");
        this.alarmList.put("45", "Repeat limit over(lower)");
        this.alarmList.put("46", "ABS maximum over");
        this.alarmList.put("51", "Response Error 1");
        this.alarmList.put("52", "Response Error 2");
        this.alarmList.put("53", "Conditioning Error");
        this.alarmList.put("55", "ISE Range over");
        this.alarmList.put("56", "Kinetic unstable (Prozone error 2)");
        this.alarmList.put("57", "Serum index 1 interference");
        this.alarmList.put("58", "Serum index multiple interference");
        this.alarmList.put("59", "Mixing abnormal");
        this.alarmList.put("60", "Drop in ultrasonic output");
        this.alarmList.put("71", "Detergent short");
        this.alarmList.put("72", "Sample Clot");
        this.alarmList.put("101", "Expired reagent");
        this.alarmList.put("103", "Serum index interference lipaemia");
        this.alarmList.put("104", "Serum index interference hemolysis");
        this.alarmList.put("105", "Serum index interference icteric");
        this.alarmList.put("106", "Serum index interference lipaemia / hemolysis");
        this.alarmList.put("107", "Serum index interference lipaemia / icteric");
        this.alarmList.put("108", "Serum index interference hemolysis / icteric");
        this.alarmList.put("109", "Serum index interferencelipaemia / hemolysis / icteric");
    }

    @Override
    public String getErroTraduzido(String erro) {
        if (this.alarmList.containsKey(erro)) {
            return this.alarmList.get(erro);
        }
        return erro;
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        block9: {
            try {
                if (!this.configuracao.getModoHostQuery()) {
                    return;
                }
                String[] instrumentSpecimentID = starting_range.split("/");
                if (instrumentSpecimentID.length >= 5) {
                    String sampleId = instrumentSpecimentID[1].trim();
                    String sequence = instrumentSpecimentID[2];
                    String rackId = instrumentSpecimentID[3];
                    String position = instrumentSpecimentID[4];
                    String rackPos = String.format("%s^%s^%s", sequence, rackId, position);
                    this.hostQuery = true;
                    if (Funcoes.textoVazio(sampleId)) {
                        this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                        return;
                    }
                    if (sampleId.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                        this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                        return;
                    }
                    this.tubos.add(String.format("%s|%s", sampleId, rackPos));
                    break block9;
                }
                instrumentSpecimentID = starting_range.split("^");
                if (instrumentSpecimentID.length >= 5) {
                    String sampleId = instrumentSpecimentID[2].trim();
                    String sequence = instrumentSpecimentID[3];
                    String rackId = instrumentSpecimentID[4];
                    String position = instrumentSpecimentID[5];
                    String rackPos = String.format("%s^%s^%s", sequence, rackId, position);
                    this.hostQuery = true;
                    if (Funcoes.textoVazio(sampleId)) {
                        this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                        return;
                    }
                    if (sampleId.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                        this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                        return;
                    }
                    this.tubos.add(String.format("%s|%s", sampleId, rackPos));
                    break block9;
                }
                this.fireExcecaoEncontrada(String.format("Solicita\u00e7\u00e3o inv\u00e1lida do equipamento ", starting_range));
                return;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Cobas C311: Host Query Response");
            }
        }
    }

    protected void enviaProximaAmostra() {
        String[] sample = this.tubos.remove(0).split("[|]");
        String amostra = sample[0];
        this.rackpos = sample[1];
        this.host_fil_codigo = amostra.substring(0, ParametrosGerais.getDigitosTuboFilial());
        amostra = amostra.substring(ParametrosGerais.getDigitosTuboFilial());
        this.host_req_codigo = amostra.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
        this.host_rec_codigo = amostra.substring(ParametrosGerais.getDigitosTuboRequisicao());
        this.hostQuery = true;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao, null);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        try {
            this.tx_list.clear();
            this.rx_list.clear();
            this.req_codigo = req_codigo;
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            ExameMaterial[] alternativos = null;
            Object listaCurva = null;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            Date dateNascPac = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            String dtNascPac = "";
            if (dateNascPac != null) {
                dtNascPac = Funcoes.formataData("yyyyMMdd", dateNascPac);
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            if (Funcoes.textoVazio(tipo_amostra)) {
                tipo_amostra = "1";
            }
            if (!Funcoes.isNumeric(tipo_amostra)) {
                this.fireExcecaoEncontrada(String.format("Material alternativo para o equipamento deve ser num\u00e9rico %s [%s]", exa_lista[0].getString(), tipo_amostra));
            }
            if (Funcoes.textoVazio(rackposition)) {
                rackposition = String.format("^^^^S%s^SC", tipo_amostra);
            } else if (!rackposition.endsWith("^SC")) {
                rackposition = String.format("%s^^S%s^SC", rackposition, tipo_amostra);
            }
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            if (exa_lista != null) {
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            } else {
                exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
                if (this.hostQuery) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, exa_lista[0].getNomeExame(), mco_codigo);
                }
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
            }
            alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            alternativos = ExamesUtil.removeDuplicados(alternativos);
            if (!exa_listaCurva.isEmpty()) {
                if (alternativos != null && alternativos.length == 1) {
                    alternativos = null;
                }
                alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, st, exa_listaCurva, this.rec_tuboPai, this.hostQuery, this.examesFilho);
            }
            String nome = short_name;
            StringBuilder frame = new StringBuilder();
            frame.append(this.getHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION, "1", this.hostQuery ? ENVIO_POR_QUERY : ENVIO_POR_LOTE));
            StringBuilder patient_id = new StringBuilder();
            patient_id.append(fil_codigo).append(req_codigo);
            Object laboratory_pid = null;
            String t = ASTMStandard.getDefaultPatientRecord(1, "", "", "", "", pac_sexo, dtNascPac, "");
            if (!this.hostQuery) {
                t = "P|1\r";
            }
            frame.append(t);
            int tam = 13;
            if (Funcoes.isNumeric(this.configuracao.getTamanhoDoCodigoBarrasAparelho())) {
                tam = Integer.parseInt(this.configuracao.getTamanhoDoCodigoBarrasAparelho());
            }
            int seq = 0;
            if (alternativos != null && alternativos.length > 0) {
                t = this.getOrderRecord(++seq, Funcoes.preencheVazio(codigo.toString(), tam, 1), rackposition, alternativos, "R", "A", tipo_amostra, "O");
                frame.append(t);
            }
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                String cod = sample_id.toString();
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    sample_id.setLength(0);
                    sample_id.append(cod);
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    t = this.getOrderRecord(++seq, Funcoes.preencheVazio(sample_id.append(tubo).toString(), 13, 1), rackposition, alternativosCurva.get(key).toArray(new ExameMaterial[alternativosCurva.get(key).size()]), "R", "A", tipo_amostra, "O");
                    frame.append(t);
                }
            }
            StringBuilder comment = new StringBuilder("C|1|L|");
            comment.append(StringUtil.repeteCaractere(' ', 30)).append("^");
            comment.append(StringUtil.repeteCaractere(' ', 25)).append("^");
            comment.append(StringUtil.repeteCaractere(' ', 20)).append("^");
            comment.append(StringUtil.repeteCaractere(' ', 15)).append("^");
            comment.append(StringUtil.repeteCaractere(' ', 10)).append("|G").append('\r');
            t = comment.toString();
            frame.append(t);
            t = this.getTermination();
            frame.append(t);
            this.tx_list.add(frame.toString());
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            this.hostQuery = false;
            InfoExameRequisicao infoExame = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, pac_exames);
            infoExame.setInterface(int_codigo);
            infoExame.setTuboPai(this.rec_tuboPai);
            infoExame.setExamesFilho(StringUtil.implode(this.examesFilho, " "));
            infoExame.setCurva(this.curva);
            this.examesEnviados.add(infoExame);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            this.hostQuery = false;
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    public String getTermination() {
        return "L|1|N\r";
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery && this.tubos.size() == 0) {
            this.enviarRequisicaoSemExame("", "");
            this.hostQuery = false;
        }
        if (this.hostQuery && this.tubos.size() > 0) {
            this.enviaProximaAmostra();
            this.responseHostQuery();
        }
    }

    @Override
    protected void limpaDadosRequisicao() {
        if (!this.middleFrame) {
            this.rx_list.clear();
        }
        this.tx_list.clear();
        this.fil_codigo = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    @Override
    protected void tratarAcknowledge() throws Exception {
        if (this.isTX()) {
            if (!this.tx_list.isEmpty() && this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                this.encerrarTransmissao();
                if (this.tubos.size() > 0) {
                    this.enviaProximaAmostra();
                    this.responseHostQuery();
                }
            } else {
                this.enviarProximoFrame();
            }
        } else if (!this.isRX()) {
            this.caracterNaoEsperado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(2, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size()) {
                    String last = (String)this.rx_list.get(this.rx_list.getUltimoInserido());
                    message = last.substring(0, last.length() - 1) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                if (message.contains(String.valueOf('\r'))) {
                    String[] tmp;
                    for (String s : tmp = message.split(String.format("[%s]", Character.valueOf('\r')))) {
                        if (s.length() <= 1) continue;
                        this.rx_list.add(s);
                    }
                } else {
                    this.rx_list.add(message);
                }
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                while (!this.rx_list.isEmpty()) {
                    this.parseRecord((String)this.rx_list.remove(0));
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    protected synchronized void parseRecord(String s) throws Exception {
        this.recordParser.recordFound(s);
    }

    public void responseHostQuery() {
        try {
            List<Object[]> reqs;
            String sampleId = this.host_fil_codigo + this.host_req_codigo + this.host_rec_codigo;
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String rack = this.rackpos;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = null;
            String acao = "A";
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            this.repeticao = false;
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (Funcoes.textoVazio(pac_exames) && req != null && aba != null) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                if (Funcoes.textoVazio(pac_exames)) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
            if (req != null) {
                String codigoApoiado;
                String req_codigoapoio = null;
                if (req[aba.getColIndice("Cod. Apoiado")] != null) {
                    if (!Funcoes.textoVazio((String)req[aba.getColIndice("Cod. Apoiado")])) {
                        String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
                        if (ParametrosGerais.isAgruparGuiasInterface()) {
                            requisicao = (String)req[aba.getColIndice("Multiguia")];
                        }
                        String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
                        requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
                        String tubo = (String)req[aba.getColIndice("Tubo")];
                        tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
                        if (req[aba.getColIndice("Cod. Apoiado")] != null) {
                            if (!Funcoes.textoVazio((String)req[aba.getColIndice("Cod. Apoiado")])) {
                                req_codigoapoio = (String)req[aba.getColIndice("Cod. Apoiado")];
                            }
                        }
                        fil_codigo = filial;
                        req_codigo = requisicao;
                        rec_codigo = tubo;
                    }
                }
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                String string = aba.getColIndice("Cod. Apoiado") >= 0 ? (String)req[aba.getColIndice("Cod. Apoiado")] : (codigoApoiado = null);
                if (!Funcoes.textoVazio(req_codigoapoio)) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("codigoApoiado", req_codigoapoio);
                    if (!sampleId.equalsIgnoreCase(req_codigoapoio)) {
                        map.put("codigoApoiado", sampleId);
                    }
                    this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao, map);
                } else {
                    this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao, null);
                }
            } else {
                this.enviarRequisicaoSemExame(fil_codigo, req_codigo);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Cobas C311: Host Query Response");
        }
    }

    protected void enviarRequisicaoSemExame(String fil_codigo, String req_codigo) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            StringBuilder frame = new StringBuilder();
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            frame.append(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            frame.append(ASTMStandard.getDefaultTerminationRecord("N"));
            this.tx_list.add(frame.toString());
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            this.hostQuery = false;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        while (!this.examesEnviados.isEmpty()) {
            this.encerrarTransmissao(this.examesEnviados.remove(0));
        }
        this.interromperTimer();
        this.getPortaCOM().write(String.valueOf('\u0004'));
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.limpaDadosRequisicao();
        if (this.ultima_acao.equals("N")) {
            this.fireAtualizarTabela(0);
        } else if (this.ultima_acao.equals("A")) {
            this.fireAtualizarTabela(2);
        }
        this.setIdle();
    }

    protected void encerrarTransmissao(InfoExameRequisicao infoExame) throws Exception {
        Statement st = Conexao.getStatement();
        if (infoExame != null) {
            String[] exames = infoExame.getExames().split(" ");
            String fil_codigo = infoExame.getFilial();
            String int_codigo = infoExame.getInterface();
            String req_codigo = infoExame.getCodigo();
            String mco_codigo = infoExame.getMaterial();
            String rec_tuboPai = infoExame.getTuboPai();
            String rec_codigo = infoExame.getRecipiente();
            boolean curva = infoExame.isCurva();
            for (int i = 0; i < exames.length; ++i) {
                int situacao;
                String[] examesFilho = infoExame.getExamesFilho().split(" ");
                if (!Funcoes.textoVazio(rec_tuboPai) && curva && examesFilho != null && examesFilho.length > 0) {
                    for (String exame : examesFilho) {
                        int situacao2 = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_tuboPai, exame, mco_codigo);
                        BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, exame, mco_codigo, rec_tuboPai, situacao2 < 2 ? 1 : 3);
                    }
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                    if (!BDUtil.isGrupoInteiroPendente(fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_tuboPai)) continue;
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_tuboPai, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                    continue;
                }
                if (examesFilho != null && examesFilho.length > 0) {
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                    BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo, situacao < 2 ? 1 : 3);
                    continue;
                }
                situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
            }
            Conexao.arquivaSQL();
            String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
            this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
        } else {
            this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
        }
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(infoExame.getCodigo(), infoExame.getNome(), infoExame.getSexo(), infoExame.getIdade(), infoExame.getData(), infoExame.getHora(), infoExame.getExames());
        }
    }

    protected String getOrderRecord(int order_sequence, String sample_id, String sample_id_type, ExameMaterial[] test_item_numbers, String priority, String action_code, String sample_type, String report_type) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("|");
        record.append(sample_id_type == null ? "" : sample_id_type);
        record.append("|");
        if (test_item_numbers != null && test_item_numbers[0] != null) {
            record.append("^^^");
            record.append(test_item_numbers[0].getNomeExame()).append("^");
            for (int i = 1; i < test_item_numbers.length; ++i) {
                if (test_item_numbers[i] == null) continue;
                record.append("\\^^^");
                record.append(test_item_numbers[i].getNomeExame()).append("^");
            }
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("||").append(ASTMStandard.getCurrentMoment());
        record.append("||||");
        record.append(action_code == null ? "" : action_code);
        record.append("||||");
        record.append(sample_type == null ? "" : sample_type);
        record.append("||||||||||");
        record.append(report_type == null ? "" : report_type);
        record.append('\r');
        return record.toString();
    }

    protected String getHeaderRecord(String delimiters, String password, String sender_id_name, String sender_id_system, String control, String receiver_id_name, String receiver_id_system, String version_number, String modeMessage) {
        StringBuilder record = new StringBuilder("H|");
        record.append(delimiters == null ? "" : delimiters);
        record.append("||");
        record.append(password == null ? "" : password);
        record.append("|");
        record.append(sender_id_name == null ? "" : sender_id_name);
        record.append(sender_id_system == null ? "" : "^" + sender_id_system);
        record.append("||||");
        record.append(control == null ? "" : control);
        record.append("|");
        record.append(receiver_id_name == null ? "" : receiver_id_name);
        record.append(receiver_id_system == null ? "" : "^" + receiver_id_system);
        record.append("|").append(modeMessage);
        record.append("|P|");
        record.append(version_number);
        record.append('\r');
        return record.toString();
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                if (this.hostQuery) {
                    this.handShakeCharReceived('\u0004');
                    return;
                }
                this.getPortaCOM().write(String.valueOf('\u0006'));
            }
            if (!(message = this.getPortaCOM().removeInputString(this.getMsgEnd())).equals("")) {
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
                this.getPortaCOM().write(String.valueOf('\u0006'));
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void teste() {
        StringBuilder b = new StringBuilder();
        b.append("[STX]1H|\\^&|||H7600^1|||||jalis|RSUPL^BATCH|P|1[CR]");
        b.append("P|1|||||||U||||||^[CR]");
        b.append("O|1|[SP]010002636904|0^50006^006^^S1^SC|^^^989^\\^^^990^\\^^^798^\\^^^418^\\^^^435^\\^^^717^\\^^^690^\\^^^781^|R||20170406093436||||N||||1|||||||20170406110130|||F[CR]");
        b.append("C|1|I|[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][ETB]39[LINE]");
        this.parse(this.equipamento.arruma(b.toString()));
        b.setLength(0);
        b.append("[STX]2[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]^[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]^[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]^[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]^[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]|G[CR]");
        b.append("R|1|^^^989/|142|mmol/l||A||F||UNIMED|||ISE1[CR]");
        b.append("C|1|I|43|I[CR]");
        b.append("R|2|^^^990/|4.53|mmol/l||A||F||UNIMED|||ISE1[CR]");
        b.append("C|1|I|43|I[CR]");
        b.append("R|3|^^^798/|208.5|mg/dl||N||F||UNIMED|||P[ETB]0B[LINE]");
        b.append("[STX]31[CR]");
        b.append("C|1|I|0|I[CR]");
        b.append("R|4|^^^418/|27.2|mg/dl||N||F||UNIMED|||P1[CR]");
        b.append("C|1|I|0|I[CR]");
        b.append("R|5|^^^435/|48.1|mg/dl||N||F||UNIMED|||P1[CR]");
        b.append("C|1|I|0|I[CR]");
        b.append("R|6|^^^717/|83.4|mg/dl||N||F||UNIMED|||P1[CR]");
        b.append("C|1|I|0|I[CR]");
        b.append("R|7|^^^690/|0.97|mg/dl||N||F||UNIMED|||P1[CR]");
        b.append("C|1|I|0|I[CR]");
        b.append("R|8|^^^781/|107.6|mg[ETB]AE[LINE]");
        this.parse(this.equipamento.arruma(b.toString()));
        b.setLength(0);
        b.append("[STX]4/dl||N||F||UNIMED|||P1[CR]C|1|I|0|I[CR]L|1|N[CR]");
        b.append("[ETX]79[LINE]");
        this.parse(this.equipamento.arruma(b.toString()));
        b.setLength(0);
    }

    protected void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    protected void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

