/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cobasb221;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.cobasb221.InterfaceListener;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    @Override
    protected void trataOrderRecord(String record) throws Exception {
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        if (this.exame_atual == null) {
            return;
        }
        String action_code = (String)this.exame_atual.get(ACTION_CODE);
        String report_type = (String)this.exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                this.exame_atual = null;
                return;
            }
        }
        if (report_type != null) {
            this.equip.getClass();
            if (report_type.equals("X")) {
                this.exame_atual = null;
                return;
            }
        }
        Hashtable result_fields = ASTMStandard.parseDefaultResultRecord(record);
        String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
        String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        String aux = (String)result_fields.get(3);
        String[] campos = aux.split("\\^", -1);
        String campo = "";
        for (String c : campos) {
            if (Funcoes.textoVazio(c)) continue;
            campo = c;
            break;
        }
        String resultado = (String)result_fields.get(4);
        campo = this.parseCampo(campo);
        String emi_alternativo = ((InterfaceListener)this.equip).NOME_EXAME;
        boolean campoAlternativo = false;
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (Funcoes.textoVazio(int_codigo)) {
            int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, campo);
            campoAlternativo = true;
        }
        if (Funcoes.textoVazio(int_codigo)) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo INT do exame n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        this.exame_atual.put(INT_CODIGO, int_codigo);
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
        resultado = resultado.replaceAll("\\.", ",");
        if (resultado.startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.length() >= 1 && resultado.charAt(resultado.length() - 1) == ',') {
            resultado = resultado + "0";
        }
        Statement st = Conexao.getStatement();
        this.exame_atual.put(campo, resultado);
        String flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS);
        if (flags != null && !flags.equals("") && !Funcoes.textoVazio(campo)) {
            this.exame_atual.put("flag_alerta", flags);
        }
    }

    @Override
    protected void trataPatientRecord(String record) throws Exception {
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
            this.exame_atual = null;
        }
        this.exame_atual = new HashMap();
        System.out.println("rodando parseDefaultPatientRecord");
        Hashtable order_fields = ASTMStandard.parseDefaultPatientRecord(record);
        String req_codigo = (String)order_fields.get(ASTMStandard.PATIENT_FIELD_LABORATORY_PID);
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
    }

    private String parseCampo(String campo) {
        System.out.println(campo);
        if (campo.equalsIgnoreCase("pH")) {
            return "gasometria_ph";
        }
        if (campo.equalsIgnoreCase("PO2")) {
            return "gasometria_po2";
        }
        if (campo.equalsIgnoreCase("PCO2")) {
            return "gasometria_pco2";
        }
        if (campo.equalsIgnoreCase("Hct")) {
            return "gasometria_hct";
        }
        if (campo.equalsIgnoreCase("Na")) {
            return "gasometria_na";
        }
        if (campo.equalsIgnoreCase("K")) {
            return "gasometria_k";
        }
        if (campo.equalsIgnoreCase("Ca")) {
            return "gasometria_ca";
        }
        if (campo.equalsIgnoreCase("Cl")) {
            return "gasometria_cl";
        }
        if (campo.equalsIgnoreCase("tHb")) {
            return "gasometria_thb";
        }
        if (campo.equalsIgnoreCase("SO2")) {
            return "gasometria_so2";
        }
        if (campo.equalsIgnoreCase("O2Hb")) {
            return "gasometria_o2hb";
        }
        if (campo.equalsIgnoreCase("COHb")) {
            return "gasometria_cohb";
        }
        if (campo.equalsIgnoreCase("MetHb")) {
            return "gasometria_methb";
        }
        if (campo.equalsIgnoreCase("HHb")) {
            return "gasometria_hhb";
        }
        if (campo.equalsIgnoreCase("Bili")) {
            return "gasometria_bili";
        }
        if (campo.equalsIgnoreCase("Glu")) {
            return "gasometria_glu";
        }
        if (campo.equalsIgnoreCase("Lac")) {
            return "gasometria_lac";
        }
        if (campo.equalsIgnoreCase("Urea")) {
            return "gasometria_urea";
        }
        if (campo.equalsIgnoreCase("Baro")) {
            return "gasometria_baro";
        }
        if (campo.equalsIgnoreCase("H+")) {
            return "gasometria_h+";
        }
        if (campo.equalsIgnoreCase("cHCO3")) {
            return "gasometria_chco3";
        }
        if (campo.equalsIgnoreCase("CtCO2(P)")) {
            return "gasometria_ctco2p";
        }
        if (campo.equalsIgnoreCase("BE")) {
            return "gasometria_be";
        }
        if (campo.equalsIgnoreCase("BE(act)")) {
            return "gasometria_beact";
        }
        if (campo.equalsIgnoreCase("BEecf")) {
            return "gasometria_brecf";
        }
        if (campo.equalsIgnoreCase("BB")) {
            return "gasometria_bb";
        }
        if (campo.equalsIgnoreCase("SO2(c)")) {
            return "gasometria_so2c";
        }
        if (campo.equalsIgnoreCase("P50")) {
            return "gasometria_p50";
        }
        if (campo.equalsIgnoreCase("FO2Hb")) {
            return "gasometria_fo2hb";
        }
        if (campo.equalsIgnoreCase("ctO2")) {
            return "gasometria_cto2";
        }
        if (campo.equalsIgnoreCase("ctCO2(B)")) {
            return "gasometria_ctco2b";
        }
        if (campo.equalsIgnoreCase("pHst")) {
            return "gasometria_phst";
        }
        if (campo.equalsIgnoreCase("cHCO3st")) {
            return "gasometria_chco3st";
        }
        if (campo.equalsIgnoreCase("PAO2")) {
            return "gasometria_pao2";
        }
        if (campo.equalsIgnoreCase("AaDO2")) {
            return "gasometria_aado2";
        }
        if (campo.equalsIgnoreCase("a/AO2")) {
            return "gasometria_aa02";
        }
        if (campo.equalsIgnoreCase("avDO2")) {
            return "gasometria_avdo2";
        }
        if (campo.equalsIgnoreCase("RI")) {
            return "gasometria_ri";
        }
        if (campo.equalsIgnoreCase("Qs/Qt")) {
            return "gasometria_qsqt";
        }
        if (campo.equalsIgnoreCase("OER")) {
            return "gasometria_oer";
        }
        if (campo.equalsIgnoreCase("niCa")) {
            return "gasometria_nica";
        }
        if (campo.equalsIgnoreCase("AG")) {
            return "gasometria_ag";
        }
        if (campo.equalsIgnoreCase("pHt")) {
            return "gasometria_pht";
        }
        if (campo.equalsIgnoreCase("cHt")) {
            return "gasometria_cht";
        }
        if (campo.equalsIgnoreCase("PCO2t")) {
            return "gasometria_pco2t";
        }
        if (campo.equalsIgnoreCase("PO2t")) {
            return "gasometria_po2t";
        }
        if (campo.equalsIgnoreCase("PAO2t")) {
            return "gasometria_pao2t";
        }
        if (campo.equalsIgnoreCase("AaDO2t")) {
            return "gasometria_aado2t";
        }
        if (campo.equalsIgnoreCase("a/AO2t")) {
            return "gasometria_aado2t";
        }
        if (campo.equalsIgnoreCase("RIt")) {
            return "gasometria_rit";
        }
        if (campo.equalsIgnoreCase("Hct(c)")) {
            return "gasometria_hctc";
        }
        if (campo.equalsIgnoreCase("MCHC")) {
            return "gasometria_mchc";
        }
        if (campo.equalsIgnoreCase("Osm")) {
            return "gasometria_osm";
        }
        if (campo.equalsIgnoreCase("BO2")) {
            return "gasometria_bo2";
        }
        if (campo.equalsIgnoreCase("BUN")) {
            return "gasometria_bun";
        }
        if (campo.equalsIgnoreCase("Qt")) {
            return "gasometria_qt";
        }
        if (campo.equalsIgnoreCase("PFIndex")) {
            return "gasometria_pfindex";
        }
        if (campo.equalsIgnoreCase("ALLEN test")) {
            return "gasometria_allentest";
        }
        if (campo.equalsIgnoreCase("Pat.Temp")) {
            return "gasometria_pattemp";
        }
        if (campo.equalsIgnoreCase("R")) {
            return "gasometria_r";
        }
        if (campo.equalsIgnoreCase("FIO2")) {
            return "gasometria_fio2";
        }
        if (campo.equalsIgnoreCase("tHb(e)")) {
            return "gasometria_thbe";
        }
        if (campo.equalsIgnoreCase("Hb Factor")) {
            return "gasometria_hbfactor";
        }
        if (campo.equalsIgnoreCase("24h Urine")) {
            return "gasometria_24hurine";
        }
        if (campo.equalsIgnoreCase("Vent Mode")) {
            return "gasometria_ventmode";
        }
        if (campo.equalsIgnoreCase("VT")) {
            return "gasometria_vt";
        }
        if (campo.equalsIgnoreCase("MV")) {
            return "gasometria_mv";
        }
        if (campo.equalsIgnoreCase("PIP")) {
            return "gasometria_pip";
        }
        if (campo.equalsIgnoreCase("Ti")) {
            return "gasometria_ti";
        }
        if (campo.equalsIgnoreCase("Te")) {
            return "gasometria_te";
        }
        if (campo.equalsIgnoreCase("SRATE")) {
            return "gasometria_srate";
        }
        if (campo.equalsIgnoreCase("ARATE")) {
            return "gasometria_arate";
        }
        if (campo.equalsIgnoreCase("PEEP")) {
            return "gasometria_peep";
        }
        if (campo.equalsIgnoreCase("MAP")) {
            return "gasometria_map";
        }
        if (campo.equalsIgnoreCase("Flow")) {
            return "gasometria_flow";
        }
        if (campo.equalsIgnoreCase("Age (A/F)")) {
            return "gasometria_ageaf";
        }
        if (campo.equalsIgnoreCase("Date drawn")) {
            return "gasometria_datedraw";
        }
        if (campo.equalsIgnoreCase("Time drawn")) {
            return "gasometria_timedraw";
        }
        if (campo.equalsIgnoreCase("Date changed")) {
            return "gasometria_datechanged";
        }
        if (campo.equalsIgnoreCase("Time changed")) {
            return "gasometria_timechanged";
        }
        if (campo.equalsIgnoreCase("Department")) {
            return "gasometria_departament";
        }
        if (campo.equalsIgnoreCase("Accepted by")) {
            return "gasometria_acceptedby";
        }
        if (campo.equalsIgnoreCase("Billing code")) {
            return "gasometria_billingcode";
        }
        if (campo.equalsIgnoreCase("Remark")) {
            return "gasometria_remark";
        }
        return "";
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String fil_codigo = (String)dados.remove(FIL_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String req_codigo = (String)dados.remove(REQ_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        String rec_codigo = (String)dados.remove(REC_CODIGO);
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        Statement st = Conexao.getStatement();
        List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
        for (BDExame exame : exames) {
            this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getExame(), exame.getMaterial(), int_codigo, dados);
        }
    }
}

