/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cobas6000;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class RecordParser
extends jalis.laboratorio.interfaceamento.interfaces.cobasc311.RecordParser {
    @Override
    public void recFound(String record) throws Exception, SQLException {
        String record_type;
        if (Funcoes.isNumeric(String.valueOf(record.charAt(0)))) {
            record = record.substring(1, record.length() - 1);
        }
        if ((record_type = ASTMStandard.getRecordTypeIdentifier(record)) != null) {
            if (record_type.equals(ASTMStandard.RECORD_TYPE_HEADER)) {
                this.trataHeaderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_PATIENT)) {
                this.trataPatientRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_ORDER)) {
                this.trataOrderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_RESULT)) {
                this.trataResultRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_COMMENT)) {
                this.trataCommentRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_REQUEST)) {
                this.trataRequestRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_TERMINATION)) {
                this.trataTerminationRecord(record);
                return;
            }
        }
    }

    @Override
    protected void trataRequestRecord(String record) throws Exception {
        Hashtable comps = ASTMStandard.parseDefaultRequestRecord(record);
        String starting_range = (String)comps.get(ASTMStandard.REQUEST_FIELD_STARTING_RANGE_ID);
        String ending_range = (String)comps.get(ASTMStandard.REQUEST_FIELD_ENDING_RANGE_ID);
        String test_id = (String)comps.get(ASTMStandard.REQUEST_FIELD_TEST_ID);
        String status_code = (String)comps.get(ASTMStandard.REQUEST_FIELD_STATUS_CODES);
        this.equip.getClass();
        if ("A".equals(status_code)) {
            this.equip.fireExcecaoEncontrada(String.format("Equipamento abortou \u00faltima amostra que foi solicitada  %s ", starting_range));
            return;
        }
        this.equip.responderRequest(starting_range, ending_range, test_id);
    }

    protected void trataTerminationRecord(String record) throws Exception {
        Hashtable terminationFields = ASTMStandard.parseDefaultTerminationRecord(record);
        String string = (String)terminationFields.get(ASTMStandard.TERMINATION_FIELD_CODE);
        this.equip.getClass();
        if (!string.equalsIgnoreCase("N")) {
            String code;
            String fil = "";
            String req = "";
            String rec = "";
            if (this.exame_atual != null && this.exame_atual.containsKey(FIL_CODIGO) && this.exame_atual.containsKey(REQ_CODIGO) && this.exame_atual.containsKey(REC_CODIGO)) {
                fil = (String)this.exame_atual.get(FIL_CODIGO);
                req = (String)this.exame_atual.get(REQ_CODIGO);
                rec = (String)this.exame_atual.get(REC_CODIGO);
            }
            if ((code = (String)terminationFields.get(ASTMStandard.TERMINATION_FIELD_CODE)).equalsIgnoreCase(this.equip.TERMINO_TRANSMISSOR_ABORTOU)) {
                this.equip.fireExcecaoEncontrada(String.format("Termina\u00e7\u00e3o for\u00e7ada do lado do transmissor %s %s %s ", fil, req, rec));
            } else {
                this.equip.getClass();
                if (code.equalsIgnoreCase("R")) {
                    this.equip.fireExcecaoEncontrada(String.format("Termina\u00e7\u00e3o for\u00e7ada do lado recebedor %s %s %s ", fil, req, rec));
                } else if (code.equalsIgnoreCase(this.equip.TERMINO_ERRO_DESCONHECIDO)) {
                    this.equip.fireExcecaoEncontrada(String.format("Erro de sistema no aparelho %s %s %s ", fil, req, rec));
                } else {
                    this.equip.getClass();
                    if (code.equalsIgnoreCase("Q")) {
                        this.equip.fireExcecaoEncontrada(String.format("Erro de solicita\u00e7\u00e3o da \u00faltima recep\u00e7\u00e3o (o pedido \u00e9 rejeitado) %s %s %s ", fil, req, rec));
                    } else {
                        this.equip.getClass();
                        if (code.equalsIgnoreCase("I")) {
                            this.equip.fireExcecaoEncontrada(String.format("Nenhuma informa\u00e7\u00e3o que corresponda a consulta na \u00faltima recep\u00e7\u00e3o %s %s %s ", fil, req, rec));
                        }
                    }
                }
            }
        }
        if (this.exame_atual == null) {
            return;
        }
        this.salvaExame(this.exame_atual);
        this.exame_atual = null;
    }

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = ((String)order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID)).trim();
        DescritorCodigoEtiqueta dce = DescritorCodigoEtiqueta.getDescritor(req_codigo);
        if (dce != null) {
            String fil = Funcoes.preencheZero(dce.getFilial(), ParametrosGerais.getDigitosTuboFilial());
            String req = Funcoes.preencheZero(dce.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
            String rec = Funcoes.preencheZero(dce.getTubo(), ParametrosGerais.getDigitosTuboTubo());
            req_codigo = fil + req + rec;
        }
        if (req_codigo == null || req_codigo.equals("")) {
            req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID).trim();
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        Map<Integer, String> components = this.equip.parseOrderTestIDField((String)order_fields.get(ASTMStandard.ORDER_FIELD_TEST_ID));
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        String resultado;
        ExameMaterial exame;
        String int_codigo;
        String rec_codigo;
        String req_codigo;
        String fil_codigo;
        Hashtable result_fields;
        block31: {
            block30: {
                int not;
                String result_status;
                if (this.exame_atual == null) {
                    return;
                }
                String action_code = (String)this.exame_atual.get(ACTION_CODE);
                String report_type = (String)this.exame_atual.get(REPORT_TYPE);
                if (action_code != null) {
                    this.equip.getClass();
                    if (action_code.equals("Q")) {
                        this.exame_atual.remove(INT_CODIGO);
                        this.exame_atual.remove(EXA_CODIGO);
                        this.exame_atual.remove(MCO_CODIGO);
                        return;
                    }
                }
                if (report_type != null) {
                    this.equip.getClass();
                    if (report_type.equals("X")) {
                        this.exame_atual.remove(INT_CODIGO);
                        this.exame_atual.remove(EXA_CODIGO);
                        this.exame_atual.remove(MCO_CODIGO);
                        return;
                    }
                }
                if ((result_status = (String)(result_fields = ASTMStandard.parseDefaultResultRecord(record)).get(ASTMStandard.RESULT_FIELD_RESULT_STATUS)) != null) {
                    this.equip.getClass();
                    if (!result_status.equals("F")) {
                        this.equip.getClass();
                        if (!result_status.equals("R")) {
                            this.equip.getClass();
                            if (!result_status.equals("C")) {
                                this.exame_atual.remove(INT_CODIGO);
                                this.exame_atual.remove(EXA_CODIGO);
                                this.exame_atual.remove(MCO_CODIGO);
                                return;
                            }
                        }
                    }
                }
                fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
                req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
                rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
                this.exame_atual.remove(INT_CODIGO);
                this.exame_atual.remove(EXA_CODIGO);
                this.exame_atual.remove(MCO_CODIGO);
                String emi_alternativo = ((String)result_fields.get(ASTMStandard.RESULT_FIELD_TEST_ID)).split("\\^")[3];
                if (emi_alternativo.endsWith("/")) {
                    emi_alternativo = emi_alternativo.replaceAll("[/]", "");
                }
                if ((not = emi_alternativo.indexOf("//not")) > 0) {
                    emi_alternativo = emi_alternativo.substring(0, not);
                }
                String emi_alternativo_diluido = "";
                if (!Funcoes.isNumeric(emi_alternativo)) {
                    String[] alt = emi_alternativo.split("/");
                    if (alt != null && alt.length > 0 && Funcoes.isNumeric(alt[0])) {
                        emi_alternativo = alt[0];
                    }
                    if (alt != null && alt.length > 1 && Funcoes.isNumeric(alt[1])) {
                        emi_alternativo_diluido = emi_alternativo + "^" + alt[1];
                    }
                }
                if ((int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo)) == null && !Funcoes.textoVazio(emi_alternativo_diluido) && (int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo)) == null) {
                    this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo_diluido + " com dilui\u00e7\u00e3o n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    return;
                }
                if (int_codigo == null) {
                    this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    return;
                }
                exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (exame == null && !Funcoes.textoVazio(emi_alternativo_diluido) && (exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo_diluido)) == null) {
                    this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo_diluido + " com dilui\u00e7\u00e3o n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    return;
                }
                if (exame == null) {
                    this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    this.exame_atual.remove(INT_CODIGO);
                    this.exame_atual.remove(EXA_CODIGO);
                    this.exame_atual.remove(MCO_CODIGO);
                    return;
                }
                resultado = (String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE);
                this.equip.getClass();
                if (result_status.equals("F")) break block30;
                this.equip.getClass();
                if (!result_status.equals("C")) break block31;
            }
            resultado = resultado.replaceAll("\\.", ",");
        }
        if (resultado.startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.charAt(resultado.length() - 1) == ',') {
            resultado = resultado + "0";
        }
        Statement st = Conexao.getStatement();
        int sit = this.equip.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
        this.exame_atual.remove("repeticao_quantitativo");
        this.exame_atual.remove("resultado_quantitativo");
        this.exame_atual.remove("repeticao_qualitativo");
        this.exame_atual.remove("resultado_qualitativo");
        String campoQuant = "resultado_quantitativo";
        String campoQuali = "resultado_qualitativo";
        if (sit == 3) {
            campoQuant = "repeticao_quantitativo";
            campoQuali = "repeticao_qualitativo";
        } else if (sit <= 2) {
            campoQuant = "resultado_quantitativo";
            campoQuali = "resultado_qualitativo";
            this.exame_atual.remove("repeticao_quantitativo");
            this.exame_atual.remove("repeticao_qualitativo");
        } else {
            this.exame_atual.remove(INT_CODIGO);
            this.exame_atual.remove(EXA_CODIGO);
            this.exame_atual.remove(MCO_CODIGO);
            this.exame_atual.remove("resultado_quantitativo");
            this.exame_atual.remove("repeticao_quantitativo");
            return;
        }
        this.exame_atual.put(INT_CODIGO, int_codigo);
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
        if (resultado.indexOf("^") > 0) {
            String resultadoQuali = resultado.substring(0, resultado.indexOf("^") + 1).replace("^", "");
            resultado = resultado.substring(resultado.indexOf("^") + 1, resultado.length());
            this.exame_atual.put(campoQuant, resultado);
            this.exame_atual.put(campoQuali, resultadoQuali);
        } else {
            this.exame_atual.put(campoQuant, resultado);
        }
        String flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS);
        if (flags != null && !flags.equals("") && !flags.equalsIgnoreCase("N")) {
            System.out.println(flags);
            this.exame_atual.put("flag_alerta", flags);
            StringBuilder msg = new StringBuilder();
            msg.append("Resultado anormal recebido do aparelho ").append(fil_codigo).append(" ").append(req_codigo).append(" ").append(rec_codigo).append(" (").append(exame.getNomeExame()).append(")").append(" Flag = ").append(flags);
            this.equip.fireExcecaoEncontrada(msg.toString());
        }
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String fil_codigo = (String)dados.get(FIL_CODIGO);
        String req_codigo = (String)dados.get(REQ_CODIGO);
        String rec_codigo = (String)dados.get(REC_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        if (Funcoes.textoVazio(exa_codigo) || Funcoes.textoVazio(mco_codigo)) {
            return;
        }
        String flag = (String)dados.remove("flag");
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        ArrayList<String> flags = new ArrayList<String>();
        if (!Funcoes.textoVazio(flag)) {
            flags.add(flag);
        }
        this.salvaExame(dados, fil_codigo, req_codigo, rec_codigo, int_codigo, exa_codigo, mco_codigo, flags);
    }

    private synchronized void salvaExame(Map<String, Object> dados, String fil_codigo, String req_codigo, String rec_codigo, String int_codigo, String exa_codigo, String mco_codigo, List<String> flags) throws Exception {
        Statement st = Conexao.getStatement();
        this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, dados, flags);
    }

    @Override
    public synchronized void recordFound(String record) throws Exception {
        this.recFound(record);
    }

    @Override
    protected void trataCommentRecord(String record) {
        if (this.exame_atual == null) {
            return;
        }
        Hashtable comment_fields = ASTMStandard.parseDefaultCommentRecord(record);
        String type = (String)comment_fields.get(ASTMStandard.COMMENT_FIELD_TYPE);
        String exception = (String)comment_fields.get(ASTMStandard.COMMENT_FIELD_TEXT);
        if (type != null && type.equals("I")) {
            if (exception.equalsIgnoreCase("0")) {
                try {
                    this.salvaExame(this.exame_atual);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Selectra Flexor: RecordParser trataResultRecord");
                }
                return;
            }
            String erro_traduzido = this.equip.getErroTraduzido(exception);
            if (erro_traduzido != null) {
                String exa_codigo = (String)this.exame_atual.get(EXA_CODIGO);
                String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
                String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
                String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
                String exame = exa_codigo != null ? " (" + exa_codigo + ") " : "";
                String msg = fil_codigo + " " + req_codigo + " " + rec_codigo + " " + exame + " Alarme [" + exception + "] - " + erro_traduzido;
                this.exame_atual.put("flag", exception + " - " + erro_traduzido);
                try {
                    this.salvaExame(this.exame_atual);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Selectra Flexor: RecordParser trataResultRecord");
                }
                this.equip.fireExcecaoEncontrada(msg);
            }
        }
    }
}

