/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cobas6000;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaCOM;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.cobas6000.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.cobasc311.InterfaceListener {
    private ArrayList<String> mensagens = new ArrayList();
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    protected String host_fil_codigo_tmp = null;
    protected String host_req_codigo_tmp = null;
    protected String host_rec_codigo_tmp = null;
    boolean busy = false;
    protected String rackValues = null;
    private int contador = 0;
    private String rackposition;

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        this.HOST_SYSTEM_VERSION = "1";
        this.INSTRUMENT_NAME = "cobas6000";
        this.INSTRUMENT_SYSTEM_VERSION = "1";
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.alarmList();
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
            }
            if (!(message = this.getPortaCOM().removeInputString(this.getMsgEnd())).equals("")) {
                if (message.charAt(0) == '\u0005' && message.length() > 1 && message.charAt(message.length() - 1) == '\u0005') {
                    this.handShakeCharReceived('\u0005');
                } else {
                    String[] messages;
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    if (this.isRX()) {
                        this.aguardarProximoFrame();
                    }
                    if ((messages = message.split("\r")) != null && messages.length > 1 && messages[0].length() > 3 && messages[0].substring(2, 3).equals("H") && messages[1].length() > 1 && messages[1].substring(0, 1).equals("Q")) {
                        String resultado = this.parse(message);
                        if (resultado != null && resultado.startsWith("Erro")) {
                            this.fireExcecaoEncontrada(resultado);
                        }
                    } else {
                        if (message.indexOf(this.getMiddleFrameEnd()) > -1) {
                            this.mensagens.add(message);
                        } else if (message.indexOf(this.getFinalFrameEnd()) > -1) {
                            this.mensagens.add(message);
                            ArrayList<List<String>> lista = new ArrayList<List<String>>();
                            ArrayList<String> msgs = new ArrayList<String>();
                            for (int i = 0; i < this.mensagens.size(); ++i) {
                                msgs.add(this.mensagens.get(i));
                            }
                            lista.add(msgs);
                            this.addListaRecebimento(lista);
                            this.restartThreadRecebimento();
                            this.mensagens.clear();
                        }
                        this.addListaRecebimento(message);
                        this.restartThreadRecebimento();
                    }
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
                }
            });
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        ((PortaCOM)portaCOM).setBuscaHandshakeMensagemInteira(true);
        super.setPortaCOM(portaCOM);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames, acao, null);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        try {
            int rack;
            String[] rackPos;
            if (this.configuracao.getModoHostQuery() && !this.hostQuery && acao.equalsIgnoreCase("A")) {
                InfoExameRequisicao infoExame = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, pac_exames);
                infoExame.setInterface(int_codigo);
                infoExame.setTuboPai(this.rec_tuboPai);
                infoExame.setExamesFilho(StringUtil.implode(this.examesFilho, " "));
                infoExame.setCurva(this.curva);
                this.examesEnviados.add(infoExame);
                this.encerrarTransmissao(infoExame);
                return "";
            }
            if (!this.hostQuery) {
                return "";
            }
            this.tx_list.clear();
            this.req_codigo = req_codigo;
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            ExameMaterial[] alternativos = null;
            Object listaCurva = null;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            Date dateNascPac = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            String dtNascPac = "";
            if (dateNascPac != null) {
                dtNascPac = Funcoes.formataData("yyyyMMdd", dateNascPac);
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            if (mapaParametros != null && mapaParametros.containsKey("codigoApoiado") && !Funcoes.textoVazio(mapaParametros.get("codigoApoiado"))) {
                codigo.setLength(0);
                codigo.append(mapaParametros.get("codigoApoiado"));
                sample_id = new StringBuilder(codigo.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()));
            } else {
                rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
                codigo.append(rec_codigo);
            }
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            if (Funcoes.textoVazio(tipo_amostra)) {
                tipo_amostra = "1";
            }
            if (!Funcoes.isNumeric(tipo_amostra)) {
                this.fireExcecaoEncontrada(String.format("Material alternativo para o equipamento deve ser num\u00e9rico %s [%s]", exa_lista[0].getString(), tipo_amostra));
            }
            prioridade = "R";
            if (!Funcoes.textoVazio(rackposition) && (rackPos = rackposition.split("\\^")) != null && rackPos.length > 2 && Funcoes.isNumeric(rackPos[1]) && (rack = Integer.parseInt(rackPos[1])) >= 4001 && rack <= 4080) {
                prioridade = "S";
            }
            if (Funcoes.textoVazio(rackposition)) {
                rackposition = String.format("^^^^S%s^SC", tipo_amostra);
            } else if (!rackposition.endsWith("^SC")) {
                rackposition = String.format("%s^^S%s^SC", rackposition, tipo_amostra);
            }
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            if (exa_lista != null) {
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            } else {
                exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
                if (this.hostQuery) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, exa_lista[0].getNomeExame(), mco_codigo);
                }
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
            }
            alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            alternativos = this.removeVazios(alternativos);
            alternativos = ExamesUtil.removeDuplicados(alternativos);
            if (this.repeticao) {
                alternativos = this.verificaDiluicao(alternativos);
            }
            if (!exa_listaCurva.isEmpty()) {
                if (alternativos != null && alternativos.length == 1) {
                    alternativos = null;
                }
                alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, st, exa_listaCurva, this.rec_tuboPai, this.hostQuery, this.examesFilho);
            }
            String nome = short_name;
            StringBuilder frame = new StringBuilder();
            frame.append(this.getHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION, "1", this.hostQuery ? "TSDWN^REPLY" : "TSDWN^BATCH"));
            StringBuilder patient_id = new StringBuilder();
            patient_id.append(fil_codigo).append(req_codigo);
            Object laboratory_pid = null;
            String[] idade = BDUtil.getIdadeNacimentoPaciente(fil_codigo, req_codigo);
            String tipoIdade = "Y";
            if (idade != null && idade.length > 1) {
                tipoIdade = idade[1].equals("A") ? "Y" : idade[1];
            }
            String t = this.getPatientRecord(1, "", patient_id.toString(), "", "", pac_sexo, "", String.format("%s^%s", idade[0], tipoIdade));
            if (!this.hostQuery) {
                t = "P|1\r";
            }
            frame.append(t);
            int tam = 13;
            if (Funcoes.isNumeric(this.configuracao.getTamanhoDoCodigoBarrasAparelho())) {
                tam = Integer.parseInt(this.configuracao.getTamanhoDoCodigoBarrasAparelho());
            }
            int seq = 0;
            if (alternativos != null && alternativos.length > 0) {
                t = this.getOrderRecord(++seq, Funcoes.preencheVazio(codigo.toString(), tam, 1), rackposition, alternativos, prioridade, "A", tipo_amostra, "O");
                frame.append(t);
            }
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                String cod = sample_id.toString();
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    sample_id.setLength(0);
                    sample_id.append(cod);
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    t = this.getOrderRecord(++seq, Funcoes.preencheVazio(sample_id.append(tubo).toString(), 13, 1), rackposition, alternativosCurva.get(key).toArray(new ExameMaterial[alternativosCurva.get(key).size()]), prioridade, "A", tipo_amostra, "O");
                    frame.append(t);
                }
            }
            StringBuilder comment = new StringBuilder("C|1|L|");
            comment.append(short_name).append("^");
            comment.append("^");
            comment.append("^");
            comment.append("^");
            comment.append("|G").append('\r');
            t = comment.toString();
            frame.append(t);
            t = this.getTermination();
            frame.append(t);
            this.tx_list.add(frame.toString());
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            this.hostQuery = false;
            this.repeticao = false;
            InfoExameRequisicao infoExame = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, pac_exames);
            infoExame.setInterface(int_codigo);
            infoExame.setTuboPai(this.rec_tuboPai);
            infoExame.setExamesFilho(StringUtil.implode(this.examesFilho, " "));
            infoExame.setCurva(this.curva);
            this.examesEnviados.add(infoExame);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            this.hostQuery = false;
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        while (!this.examesEnviados.isEmpty()) {
            this.encerrarTransmissao((InfoExameRequisicao)this.examesEnviados.remove(0));
        }
        this.interromperTimer();
        this.getPortaCOM().write(String.valueOf('\u0004'));
        this.busy = false;
        this.host_fil_codigo_tmp = null;
        this.host_req_codigo_tmp = null;
        this.host_rec_codigo_tmp = null;
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.limpaDadosRequisicao();
        if (this.ultima_acao.equals("N")) {
            this.fireAtualizarTabela(0);
        } else if (this.ultima_acao.equals("A")) {
            this.fireAtualizarTabela(2);
        }
        this.setIdle();
    }

    @Override
    protected void encerrarTransmissao(InfoExameRequisicao infoExame) throws Exception {
        Statement st = Conexao.getStatement();
        if (infoExame != null) {
            String[] exames = infoExame.getExames().split(" ");
            String fil_codigo = infoExame.getFilial();
            String int_codigo = infoExame.getInterface();
            String req_codigo = infoExame.getCodigo();
            String mco_codigo = infoExame.getMaterial();
            String rec_tuboPai = infoExame.getTuboPai();
            String rec_codigo = infoExame.getRecipiente();
            boolean curva = infoExame.isCurva();
            for (int i = 0; i < exames.length; ++i) {
                int situacao;
                String[] examesFilho = infoExame.getExamesFilho().split(" ");
                if (!Funcoes.textoVazio(rec_tuboPai) && curva && examesFilho != null && examesFilho.length > 0) {
                    for (String exame : examesFilho) {
                        int situacao2 = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_tuboPai, exame, mco_codigo);
                        BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, exame, mco_codigo, rec_tuboPai, situacao2 < 2 ? 1 : 3);
                    }
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                    if (!BDUtil.isGrupoInteiroPendente(fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_tuboPai)) continue;
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_tuboPai, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                    continue;
                }
                if (examesFilho != null && examesFilho.length > 0) {
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                    BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo, situacao < 2 ? 1 : 3);
                    continue;
                }
                situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
            }
            Conexao.arquivaSQL();
            String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
            this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
        } else {
            this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
        }
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(infoExame.getCodigo(), infoExame.getNome(), infoExame.getSexo(), infoExame.getIdade(), infoExame.getData(), infoExame.getHora(), infoExame.getExames());
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0005': {
                    this.busy = true;
                    if (this.isTX() || this.tx_list.size() > 0 && this.rx_counter < this.MAX_TENTATIVAS_RX) {
                        this.getPortaCOM().write(String.valueOf('\u0006'));
                        this.tx_list.clear();
                        this.setIdle();
                        this.setRX();
                        this.rx_counter = 0;
                        break;
                    }
                    this.rx_counter = 0;
                    this.tratarEnquiry();
                    break;
                }
                case '\u0006': {
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0015': {
                    this.tratarNegativeAck();
                    break;
                }
                case '\u0004': {
                    this.tratarEndOfTX();
                    break;
                }
                default: {
                    this.caracterNaoEsperado();
                    break;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de caracter de handshake recebido");
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento: " + ex.getMessage(), 1, 5000);
            if (this.tx_list.size() > 0) {
                this.limpaDadosRequisicao();
            }
            this.setIdle();
        }
    }

    @Override
    protected void tratarNegativeAck() throws Exception {
        if (this.isTX()) {
            this.verificarNegacao();
        } else if (!this.isRX()) {
            this.caracterNaoEsperado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    @Override
    protected void verificarNegacao() throws Exception {
        if (this.isTX()) {
            if (this.tx_list.getUltimoLido() >= 0) {
                this.retransmitirRecusado();
            } else {
                this.abortarTransmissao();
            }
        } else if (this.isRX()) {
            this.caracterNaoEsperado();
        }
    }

    @Override
    protected void abortarTransmissao() throws Exception {
        this.busy = true;
        this.limpaDadosRequisicao();
        this.setPausa(this.TIME_TX_ABORTADO);
        this.getPortaCOM().write(String.valueOf('\u0004'));
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    @Override
    protected void limpaDadosRequisicao() {
        if (!this.middleFrame) {
            this.rx_list.clear();
        }
        this.tx_list.clear();
        this.fil_codigo = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    private ExameMaterial[] verificaDiluicao(ExameMaterial[] alternativos) {
        for (int i = 0; i < alternativos.length; ++i) {
            if (alternativos[i].getNomeExame().equalsIgnoreCase("148")) {
                alternativos[i].setString("148^100");
                continue;
            }
            if (!alternativos[i].getNomeExame().equalsIgnoreCase("253")) continue;
            alternativos[i].setString("253^Dec");
        }
        return alternativos;
    }

    private ExameMaterial[] removeVazios(ExameMaterial[] alternativos) {
        ArrayList<ExameMaterial> exames = new ArrayList<ExameMaterial>();
        for (ExameMaterial exameMaterial : alternativos) {
            if (exameMaterial == null || Funcoes.textoVazio(exameMaterial.getNomeExame())) continue;
            exames.add(exameMaterial);
        }
        return exames.toArray(new ExameMaterial[exames.size()]);
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(2, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size() && this.rx_list.getUltimoInserido() > -1 && this.rx_list.size() > 0) {
                    String last = (String)this.rx_list.get(this.rx_list.getUltimoInserido());
                    int pos = last.length() - 1;
                    if (last.length() >= 1) {
                        pos = last.length();
                    }
                    message = last.substring(0, pos) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.rx_list.add(message.substring(0, message.length() - 1));
                    this.middleFrame = true;
                    return "";
                }
                this.rx_list.add(message);
                StringBuilder buffer = new StringBuilder();
                while (!this.rx_list.isEmpty()) {
                    buffer.append((String)this.rx_list.remove(0));
                }
                ArrayList<String> lista = new ArrayList<String>();
                if (buffer.toString().contains(String.valueOf('\r'))) {
                    String[] tmp;
                    for (String s : tmp = buffer.toString().split(String.format("[%s]", Character.valueOf('\r')))) {
                        if (s.length() <= 1) continue;
                        lista.add(s);
                    }
                }
                RecordParser record = new RecordParser();
                record.setInterfaceASTMListener(this);
                super.setASTMRecordParser(record);
                while (!lista.isEmpty()) {
                    this.parseRecord((String)lista.remove(0), record);
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            this.fireExcecaoEncontrada("Erro ao executar parse da mensagen " + ex.getMessage());
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    public String parseRes(List<String> messages) {
        ArrayList<String> buffer_rx = new ArrayList<String>();
        for (String message : messages) {
            ++this.contador;
            try {
                String checksum = null;
                String termination = null;
                int stx_index = message.indexOf(this.getMsgStart());
                if (stx_index < 0 || message.length() <= 5) continue;
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) continue;
                message = message.substring(2, message.length() - 2);
                checksum = message.substring(message.length() - 2);
                termination = message.substring(message.length() - 3, message.length() - 2);
                message = message.substring(0, message.length() - 2);
                if (!this.checkCRC(message, checksum)) continue;
                if (this.middleFrame && buffer_rx.size() > 0) {
                    String last = (String)buffer_rx.get(buffer_rx.size() - 1);
                    int pos = last.length() - 1;
                    if (last.length() >= 1) {
                        pos = last.length();
                    }
                    message = last.substring(0, pos) + message;
                    buffer_rx.remove(buffer_rx.size() - 1);
                    this.middleFrame = false;
                }
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    buffer_rx.add(message.substring(0, message.length() - 1));
                    this.middleFrame = true;
                    continue;
                }
                this.rx_list.add(message);
                StringBuilder buffer = new StringBuilder();
                while (!this.rx_list.isEmpty()) {
                    buffer.append((String)this.rx_list.remove(0));
                }
                ArrayList<String> lista = new ArrayList<String>();
                if (buffer.toString().contains(String.valueOf('\r'))) {
                    String[] tmp;
                    for (String s : tmp = buffer.toString().split(String.format("[%s]", Character.valueOf('\r')))) {
                        if (s.length() <= 1) continue;
                        lista.add(s);
                    }
                }
                RecordParser record = new RecordParser();
                record.setInterfaceASTMListener(this);
                super.setASTMRecordParser(record);
                while (!lista.isEmpty()) {
                    this.parseRecord((String)lista.remove(0), record);
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
            }
            catch (Exception ex) {
                this.fireExcecaoEncontrada("Erro ao executar parse da mensagen " + ex.getMessage());
                ex.printStackTrace();
                ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
                this.interromperTimer();
                this.setIdle();
                try {
                    Conexao.anulaSQL();
                    this.fireExcecaoEncontrada("Erro ao analisar dados recebidos do equipamento.");
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                }
            }
        }
        System.out.println("mensagens recebidas: " + this.contador);
        return "";
    }

    protected synchronized void parseRecord(String s, RecordParser record) throws Exception {
        record.recordFound(s);
    }

    @Override
    protected String getOrderRecord(int order_sequence, String sample_id, String sample_id_type, ExameMaterial[] test_item_numbers, String priority, String action_code, String sample_type, String report_type) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("|");
        record.append(sample_id_type == null ? "" : sample_id_type);
        record.append("|");
        if (test_item_numbers != null && test_item_numbers[0] != null) {
            record.append("^^^");
            record.append(test_item_numbers[0].getNomeExame()).append("^");
            for (int i = 1; i < test_item_numbers.length; ++i) {
                if (test_item_numbers[i] == null || Funcoes.textoVazio(test_item_numbers[i].getNomeExame())) continue;
                record.append("\\^^^");
                record.append(test_item_numbers[i].getNomeExame()).append("^");
            }
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("||").append(ASTMStandard.getCurrentMoment());
        record.append("||||");
        record.append(action_code == null ? "" : action_code);
        record.append("||||");
        record.append(sample_type == null ? "" : sample_type);
        record.append("||||||||||");
        record.append(report_type == null ? "" : report_type);
        record.append('\r');
        return record.toString();
    }

    private String getPatientRecord(int patient_sequence, String patient_id, String laboratory_pid, String pac_nome, String pac_sobrenome, String pac_sexo, String pac_nascimento, String idade) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence);
        record.append("|");
        record.append(patient_id == null ? "" : patient_id);
        record.append("|");
        record.append(laboratory_pid == null ? "" : laboratory_pid);
        record.append("||");
        record.append(pac_sobrenome == null ? "" : pac_sobrenome);
        record.append("||");
        record.append(pac_nascimento == null ? "" : pac_nascimento);
        record.append("|");
        record.append(pac_sexo == null ? "" : pac_sexo);
        record.append("||||||");
        record.append(idade);
        record.append('\r');
        return record.toString();
    }

    @Override
    public void teste() {
        StringBuilder msg = new StringBuilder();
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado", "EOT", "NAK", "ENQ"}, null);
        if (op == 0) {
            this.query();
        } else if (op == 1) {
            this.handShakeCharReceived('\u0006');
        } else if (op == 2) {
            this.resultado();
        } else if (op == 3) {
            this.handShakeCharReceived('\u0004');
        } else if (op == 4) {
            this.handShakeCharReceived('\u0015');
        } else if (op == 5) {
            this.handShakeCharReceived('\u0005');
        }
        msg.append("[STX]1H|\\^&|||H7600^1|||||jalis|TSREQ^REAL|P|1[CR]");
        msg.append("Q|1|^^[SP]010000307004^0^50001^001^^S1^SC^R2||ALL||||||||O[CR]");
        msg.append("L|1|N[CR][ETX]0F[LINE]");
        msg.setLength(0);
        msg.append("[STX]1H|\\^&|||cobas6000^1|||||host|TSREQ^REAL|P|1[CR]");
        msg.append("Q|1|^^[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]012152166164^0^4007^1^^S1^SC||ALL||||||||A[CR]");
        msg.append("L|1|N[CR][ETX]11[LINE]");
    }

    private void query() {
        StringBuilder msg = new StringBuilder();
        msg.append("[STX]1H|\\^&|||H7600^1|||||jalis|TSREQ^REAL|P|1[CR]");
        msg.append("Q|1|^^[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]2182745^0^4020^1^^S2^SC||ALL||||||||");
        msg.append("L|1|N[CR][ETX]0F[LINE]");
        this.parse(this.equipamento.arruma(msg.toString()));
    }

    private void parseTeste(String message) {
        if (message.indexOf(this.getMiddleFrameEnd()) > -1) {
            this.mensagens.add(message);
        } else if (message.indexOf(this.getFinalFrameEnd()) > -1) {
            this.mensagens.add(message);
            ArrayList<List<String>> lista = new ArrayList<List<String>>();
            ArrayList<String> msgs = new ArrayList<String>();
            for (int i = 0; i < this.mensagens.size(); ++i) {
                msgs.add(this.mensagens.get(i));
            }
            lista.add(msgs);
            this.addListaRecebimento(lista);
            this.restartThreadRecebimento();
            this.mensagens.clear();
        }
    }

    private void resultado() {
        StringBuilder b = new StringBuilder();
        this.teste2(b);
    }

    private void teste3(StringBuilder b) throws IOException {
        this.getPortaCOM().write(this.equipamento.arruma("[STX]1H|\\^&|||cobas6000^1|||||JALIS|RSUPL^REAL|P|1[CR]P|1|||||||U||||||^[CR]O|1|[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]012156408164|0^5054^3^^S"));
        this.getPortaCOM().write(this.equipamento.arruma("1^SC|^^^418^\\^^^"));
        this.getPortaCOM().write(this.equipamento.arruma("1^|R||||||N||||1"));
        this.getPortaCOM().write(this.equipamento.arruma("|||||||2"));
        this.getPortaCOM().write(this.equipamento.arruma("0170127165915|||F[CR]C|1|I|"));
        this.getPortaCOM().write(this.equipamento.arruma("^^^^|G[CR]R|1|^^^41"));
        this.getPortaCOM().write(this.equipamento.arruma("8/|24.6|mg/dL||N"));
        this.getPortaCOM().write(this.equipamento.arruma("||F||labmed|||P1"));
        this.getPortaCOM().write(this.equipamento.arruma("[CR]C|1|I|0|I[CR]R|2|^"));
        this.getPortaCOM().write(this.equipamento.arruma("^^1//not"));
        this.getPortaCOM().write(this.equipamento.arruma("|1[ETB]B7[LINE]"));
        this.getPortaCOM().write(this.equipamento.arruma("[STX]2.90|uIU/mL||N||F||labmed|||E12[CR]C|1|I|0|I[CR]L|1|N[CR][ETX]50[LINE]"));
    }

    private void teste2(StringBuilder b) {
        b.append(this.equipamento.arruma("[STX]1H|\\^&|||cobas6000^1|||||JALIS|RSUPL^REAL|P|1[CR]P|1|||||||U||||||^[CR]O|1|[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]10000005404|0^5077^2^^S1^SC|^^^1^\\^^^20"));
        b.append(this.equipamento.arruma("1^|R||||||N||||1|||||||201701271"));
        b.append(this.equipamento.arruma("21615|||F[CR]C|1|I|"));
        b.append(this.equipamento.arruma("^^^^|G[CR]R|1|^^^21/100"));
        b.append(this.equipamento.arruma("/not|-1^0.057|uIU/m"));
        b.append(this.equipamento.arruma("L||N||F|"));
        b.append(this.equipamento.arruma("|labmed|||E22[CR]C|"));
        b.append(this.equipamento.arruma("1|I|0|I[CR]R|2|^^^201[ETB]5C[LINE]"));
        b.append(this.equipamento.arruma("[STX]2//not|2.23|ng/dL||N||F||labmed|||E22[CR]C|1|I|0|I[CR]L|1|N[CR][ETX]63[LINE]"));
        b.append(this.equipamento.arruma("[STX]1H|\\^&|||cobas6000^1|||||JALIS|RSUPL^BATCH|P|1[CR]P|1|||||||U||||||^[CR]O|1|[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]10000004904|0^5080^5^^S1^SC|^^^1^|R|||"));
        b.append(this.equipamento.arruma("|||N||||1|||||||"));
        b.append(this.equipamento.arruma("20170127"));
        b.append(this.equipamento.arruma("123745||"));
        b.append(this.equipamento.arruma("|F[CR]C|1|I|^^^^|G[CR]"));
        b.append(this.equipamento.arruma("R|1|^^^21/100|1^0."));
        b.append(this.equipamento.arruma("009|uIU/mL||LL||"));
        b.append(this.equipamento.arruma("F||labmed|||E12[CR]"));
        b.append(this.equipamento.arruma("C|1|I|27"));
        b.append(this.equipamento.arruma("|I[CR]L|1|N[CR][ETX]4C[LINE]"));
        b.append(this.equipamento.arruma("[STX]1H|\\^&|||cobas6000^1|||||JALIS|RSUPL^BATCH|P|1[CR]P|1|||||||U||||||^[CR]O|1|[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]10000004304|0^5080^5^^S1^SC|^^^1^|R|||"));
        b.append(this.equipamento.arruma("|||N||||1|||||||"));
        b.append(this.equipamento.arruma("20170127"));
        b.append(this.equipamento.arruma("123745||"));
        b.append(this.equipamento.arruma("|F[CR]C|1|I|^^^^|G[CR]"));
        b.append(this.equipamento.arruma("R|1|^^^21/100|0."));
        b.append(this.equipamento.arruma("053|uIU/mL||LL||"));
        b.append(this.equipamento.arruma("F||labmed|||E12[CR]"));
        b.append(this.equipamento.arruma("C|1|I|27"));
        b.append(this.equipamento.arruma("|I[CR]L|1|N[CR][ETX]4C[LINE]"));
        b.append(this.equipamento.arruma("[STX]1H|\\^&|||cobas6000^1|||||JALIS|RSUPL^REAL|P|1[CR]P|1|||||||U||||||^[CR]O|1|[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]10000004204|0^5077^3^^S1^SC|^^^67^\\^^^1"));
        b.append(this.equipamento.arruma("^|R|||||"));
        b.append(this.equipamento.arruma("|N||||1|"));
        b.append(this.equipamento.arruma("||||||2017012712"));
        b.append(this.equipamento.arruma("1615|||F[CR]C|1|I|^"));
        b.append(this.equipamento.arruma("^^^|G[CR]R|1|^^^21"));
        b.append(this.equipamento.arruma("/100/not|0^159.3|ng/mL"));
        b.append(this.equipamento.arruma("||N||F||"));
        b.append(this.equipamento.arruma("labmed||"));
        b.append(this.equipamento.arruma("|E22[CR]C|1"));
        b.append(this.equipamento.arruma("|I|0|I[CR]R"));
        b.append(this.equipamento.arruma("|2|^^^1//n[ETB]9C[LINE]"));
        b.append(this.equipamento.arruma("[STX]2ot|1.36|uIU/mL||N||F||labmed|||E22[CR]C|1|I|0|I[CR]L|1|N[CR][ETX]E1[LINE]"));
        this.parse(b.toString());
    }

    private void teste1(StringBuilder b) throws IOException {
        b.append("[STX]1H|\\^&|||cobas6000^1|||||JALIS|RSUPL^BATCH|P|1[CR]");
        b.append("P|1|||||||U||||||^[CR]");
        b.append("O|1|[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]012153865164|0^5065^5^^");
        b.append("S1^SC|^^^67^\\^^^");
        b.append("201^\\^^^1^\\^^^120^\\^^^14^|R|||||");
        b.append("|N||||1|||||||20");
        b.append("170125150556|||F");
        b.append("[CR]");
        b.append("C|1|I|^^^^|G[CR]");
        b.append("R|");
    }

    @Override
    public void responseHostQuery() {
        try {
            String sampleId = this.host_fil_codigo + this.host_req_codigo + this.host_rec_codigo;
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            this.host_fil_codigo_tmp = fil_codigo;
            this.host_req_codigo_tmp = req_codigo;
            this.host_rec_codigo_tmp = rec_codigo;
            String rack = this.rackpos;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            StringBuilder pac_exames = new StringBuilder("");
            String acao = "A";
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames.append((String)req[aba.getColIndice("Exame")]);
            }
            String situacao = null;
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (Funcoes.textoVazio(pac_exames.toString()) && req != null && aba != null) {
                    pac_exames.append((String)req[aba.getColIndice("Exame")]);
                }
                if (req != null) {
                    pac_exames.append(" ");
                    List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] objectArray : reqs) {
                        pac_exames.append((String)objectArray[aba.getColIndice("Exame")] + " ");
                    }
                }
            }
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                if (req != null) {
                    pac_exames.append(" ");
                    this.repeticao = true;
                    String tuboPai = Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboTubo());
                    List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) >= 7) continue;
                        situacao = (String)r[aba.getColIndice("Sit")];
                        String exame = (String)r[aba.getColIndice("Exame")];
                        mco_codigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                        int_codigo = (String)req[aba.getColIndice("Interface")];
                        if (BDUtil.isGrupoInteiroRepetido(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, tuboPai.equals(rec_codigo) ? rec_codigo : tuboPai)) {
                            pac_exames.append(exame).append(" ");
                            acao = "A";
                            continue;
                        }
                        BDExame[] filhos = BDUtil.getDesmExamesFilhos(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, tuboPai.equals(rec_codigo) ? rec_codigo : tuboPai);
                        if (filhos == null) continue;
                        for (BDExame bdExame : filhos) {
                            if (!Funcoes.preencheZero(bdExame.getRecipienteFilho(), ParametrosGerais.getDigitosTuboTubo()).equals(rec_codigo) || bdExame.getSituacao() <= 2 || bdExame.getSituacao() >= 7) continue;
                            pac_exames.append(bdExame.getExame()).append(" ");
                            acao = "A";
                        }
                    }
                }
            }
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
            if (req != null) {
                String codigoApoiado;
                String req_codigoapoio = null;
                if (req[aba.getColIndice("Cod. Apoiado")] != null) {
                    if (!Funcoes.textoVazio((String)req[aba.getColIndice("Cod. Apoiado")])) {
                        String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
                        if (ParametrosGerais.isAgruparGuiasInterface()) {
                            requisicao = (String)req[aba.getColIndice("Multiguia")];
                        }
                        String string = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
                        requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
                        String tubo = (String)req[aba.getColIndice("Tubo")];
                        tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
                        if (req[aba.getColIndice("Cod. Apoiado")] != null) {
                            if (!Funcoes.textoVazio((String)req[aba.getColIndice("Cod. Apoiado")])) {
                                req_codigoapoio = (String)req[aba.getColIndice("Cod. Apoiado")];
                            }
                        }
                        fil_codigo = string;
                        req_codigo = requisicao;
                        rec_codigo = tubo;
                    }
                }
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                String string = aba.getColIndice("Cod. Apoiado") >= 0 ? (String)req[aba.getColIndice("Cod. Apoiado")] : (codigoApoiado = null);
                if (!Funcoes.textoVazio(req_codigoapoio)) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("codigoApoiado", req_codigoapoio);
                    if (!sampleId.equalsIgnoreCase(req_codigoapoio)) {
                        hashMap.put("codigoApoiado", sampleId);
                    }
                    this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.toString().trim(), acao, hashMap);
                } else {
                    this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.toString().trim(), acao, null);
                }
            } else {
                this.enviarRequisicaoSemExame(fil_codigo, req_codigo, sampleId, rack);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Cobas C311: Host Query Response");
        }
    }

    protected void enviarRequisicaoSemExame(String fil_codigo, String req_codigo, String id, String rack) {
        try {
            int rackNumber;
            String[] rackPos;
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            StringBuilder frame = new StringBuilder();
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            int tam = 13;
            if (Funcoes.isNumeric(this.configuracao.getTamanhoDoCodigoBarrasAparelho())) {
                tam = Integer.parseInt(this.configuracao.getTamanhoDoCodigoBarrasAparelho());
            }
            String prioridade = "R";
            if (!Funcoes.textoVazio(rack) && (rackPos = rack.split("\\^")) != null && rackPos.length > 2 && Funcoes.isNumeric(rackPos[1]) && (rackNumber = Integer.parseInt(rackPos[1])) >= 4001 && rackNumber <= 4080) {
                prioridade = "S";
            }
            String tipoAmostra = "1";
            String[] values = this.rackValues.split("\\^");
            if (values != null && values.length > 2 && !values[1].equalsIgnoreCase("S1")) {
                tipoAmostra = values[1].substring(1);
            }
            frame.append(this.getHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION, "1", "TSDWN^REPLY"));
            frame.append(this.getPatientRecord(1, "", "", "", "", "", "", ""));
            int seq = 0;
            String t = this.getOrderRecord(++seq, Funcoes.preencheVazio(id, tam, 1), rack + "^" + this.rackValues, null, prioridade, "A", tipoAmostra, "O");
            frame.append(t);
            StringBuilder comment = new StringBuilder("C|1|L|");
            comment.append("^");
            comment.append("^");
            comment.append("^");
            comment.append("^");
            comment.append("|G").append('\r');
            t = comment.toString();
            frame.append(t);
            StringBuilder stringBuilder = new StringBuilder().append("L|1|");
            this.getClass();
            frame.append(stringBuilder.append("I").append('\r').toString());
            this.tx_list.add(frame.toString());
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            this.fireExcecaoEncontrada(String.format("Amostra que foi solicitada  %s %s pelo equipamento n\u00e3o localizada ou j\u00e1 possui exames prontos ou conferidos verifique", Funcoes.preencheVazio(id, tam, 1), rack + "^" + this.rackValues));
            this.hostQuery = false;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery && this.tubos.size() == 0) {
            this.enviarRequisicaoSemExame("", "");
            this.hostQuery = false;
        }
        if (this.hostQuery) {
            if (this.tubos.size() > 0) {
                this.enviaProximaAmostra();
                this.responseHostQuery();
            }
        } else if (!Funcoes.textoVazio(this.host_fil_codigo_tmp) && !Funcoes.textoVazio(this.host_req_codigo_tmp) && !Funcoes.textoVazio(this.host_rec_codigo_tmp) && this.busy) {
            this.host_fil_codigo = this.host_fil_codigo_tmp;
            this.host_req_codigo = this.host_req_codigo_tmp;
            this.host_rec_codigo = this.host_rec_codigo_tmp;
            this.busy = false;
            this.hostQuery = true;
            this.responseHostQuery();
        }
    }

    @Override
    protected void enviaProximaAmostra() {
        String[] sample = ((String)this.tubos.remove(0)).split("[|]");
        String amostra = sample[0];
        this.rackpos = sample[1];
        this.rackValues = sample[2];
        this.host_fil_codigo = amostra.substring(0, ParametrosGerais.getDigitosTuboFilial());
        amostra = amostra.substring(ParametrosGerais.getDigitosTuboFilial());
        this.host_req_codigo = amostra.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
        this.host_rec_codigo = amostra.substring(ParametrosGerais.getDigitosTuboRequisicao());
        this.hostQuery = true;
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        block9: {
            try {
                this.getClass();
                if (test_id.equalsIgnoreCase("A")) {
                    return;
                }
                String[] instrumentSpecimentID = starting_range.split("/");
                if (instrumentSpecimentID.length >= 5) {
                    String sampleId = instrumentSpecimentID[1].trim();
                    String sequence = instrumentSpecimentID[2];
                    String rackId = instrumentSpecimentID[3];
                    String position = instrumentSpecimentID[4];
                    String rackPos = String.format("%s^%s^%s", sequence, rackId, position);
                    this.hostQuery = true;
                    if (Funcoes.textoVazio(sampleId)) {
                        this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                        return;
                    }
                    if (sampleId.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                        this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                        return;
                    }
                    this.tubos.add(String.format("%s|%s", sampleId, rackPos));
                    break block9;
                }
                instrumentSpecimentID = starting_range.split("\\^");
                if (instrumentSpecimentID.length >= 5) {
                    String sampleId = instrumentSpecimentID[2].trim();
                    String sequence = instrumentSpecimentID[3];
                    String rackId = instrumentSpecimentID[4];
                    String position = instrumentSpecimentID[5];
                    String rackPos = String.format("%s^%s^%s", sequence, rackId, position);
                    String rackValues = String.format("%s^%s^%s", instrumentSpecimentID[6], instrumentSpecimentID[7], instrumentSpecimentID[8]);
                    this.hostQuery = true;
                    int tam = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                    if (Funcoes.textoVazio(sampleId)) {
                        this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                        this.tubos.add(String.format("%s|%s|%s", Funcoes.preencheVazio(sampleId, tam, 1), rackPos, rackValues));
                        return;
                    }
                    if (sampleId.trim().length() != tam) {
                        this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                        this.tubos.add(String.format("%s|%s|%s", Funcoes.preencheVazio(sampleId, tam, 1), rackPos, rackValues));
                        return;
                    }
                    this.tubos.add(String.format("%s|%s|%s", sampleId, rackPos, rackValues));
                    break block9;
                }
                this.fireExcecaoEncontrada(String.format("Solicita\u00e7\u00e3o inv\u00e1lida do equipamento ", starting_range));
                return;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Cobas C311: Host Query Response");
            }
        }
    }

    @Override
    public String getTermination() {
        return super.getTermination();
    }

    private void addListaRecebimento(ArrayList<List<String>> lista) {
        this.threadRecebimento.addListaRecebimentos(lista);
        this.restartThreadRecebimento();
    }

    @Override
    protected void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<List<String>> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<List<String>> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<List<String>> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimentos(ArrayList<List<String>> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    List<String> message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parseRes(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(50L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

