/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cmd600;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.configuracao.EquipamentoFilial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceHl7Listener {
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    public InterfaceListener() {
        super("CMD 600");
    }

    public InterfaceListener(String cmd600) {
        super(cmd600);
    }

    @Override
    protected void messageOruR01Recebida(MessageOruR01 oruR01) {
        this.processaMensagem(oruR01);
        MessageAckR01 ackR01 = new MessageAckR01();
        ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
        ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
        ackR01.getMsa().setTextMessage("Mensagem aceita");
        ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
        this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
    }

    private void processaMensagem(MessageOruR01 oruR01) {
        try {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String tuboId = oruR01.getObr().getPlacerOrderNumber();
            if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                Statement st = Conexao.getStatement();
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
                if (etiqueta != null) {
                    filCodigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                    reqCodigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                    recCodigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                }
                for (MessageSegmentObx obx : oruR01.getObxList()) {
                    String emiAlternativo = String.valueOf(obx.getObservationId());
                    String intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                    if (intCodigo == null) {
                        for (ConfiguracaoSerial c : Variaveis.equipamentos) {
                            for (EquipamentoFilial f : c.getEquipamentos()) {
                                System.out.println("Buscando para equipamento: " + f.getEquipamento());
                                StringBuilder buf = new StringBuilder();
                                buf.append("select int_codigo from interfaceexamerequisicao ");
                                buf.append("where fil_codigo = ").append(filCodigo);
                                buf.append("  and int_codigo = ").append(f.getEquipamento());
                                buf.append("  and req_codigo = ").append(reqCodigo);
                                buf.append("  and rec_codigo = ").append(recCodigo);
                                buf.append("  and ier_situacao = ").append(3);
                                Statement stTemp = Conexao.getStatement();
                                ResultSet rs = Conexao.executeQuery(stTemp, buf.toString());
                                if (rs.next()) {
                                    intCodigo = rs.getString("int_codigo");
                                }
                                Conexao.fecharStatement(stTemp);
                            }
                        }
                    }
                    if (intCodigo == null) {
                        this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada na interface id %s %s %s alternativo %s", filCodigo, reqCodigo, recCodigo, emiAlternativo));
                        continue;
                    }
                    ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
                    if (exame != null) {
                        HashMap<String, Object> dados = new HashMap<String, Object>();
                        ArrayList<String> flags = new ArrayList<String>();
                        if (obx.getAbnormalFlag() != null) {
                            flags.add(obx.getAbnormalFlag().toString());
                        }
                        int sit = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                        String campo = "resultado_quantitativo";
                        String resultado = "";
                        switch (obx.getValueType()) {
                            case NUMERIC: {
                                campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                                resultado = obx.getObservationValue();
                                resultado = this.arrendondaValor(resultado, filCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo);
                                resultado = resultado.replace('.', ',');
                                break;
                            }
                            case STRING: {
                                campo = sit < 3 ? "resultado_qualitativo" : "repeticao_qualitativo";
                                resultado = obx.getObservationValue();
                            }
                        }
                        System.out.println(String.format("situacao = %s, filCodigo = %s, reqCodigo = %s, recCodigo = %s, exame.getNomeExame() = %s, exame.getCodigoMaterial() = %s, intCodigo = %s, emiAlternativo  = %s", sit, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, emiAlternativo));
                        if (sit != 3 && sit != 5 && sit != 1 && sit != 0) continue;
                        dados.put(campo, resultado);
                        this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados);
                        continue;
                    }
                    this.fireExcecaoEncontrada(String.format("Exame n\u00e3o localizado ou j\u00e1 exportado na interface id %s %s %s alternativo %s", filCodigo, reqCodigo, recCodigo, emiAlternativo));
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            } else {
                this.fireExcecaoEncontrada(String.format("Amostra fora do padr\u00e3o utilizado ou amostra passada manualmente %s", tuboId));
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    public void addListaRecebimento(MessageOruR01 message) {
        this.threadRecebimento.addListaRecebimento(message);
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<MessageOruR01> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void teste() {
        this.cmd600Result("", false);
    }

    private void cmd600Query(String tubo) {
        StringBuilder tmp = new StringBuilder();
        tmp.append("[SB]MSH|^~\\&|Mindray|CMD600|||20121114174828||QRY^Q02|434|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("QRD|20121114174848|R|D|139|||RD|").append(tubo).append("|OTH|||T|[CR]");
        tmp.append("QRF|CMD600|20121114174828|20121114174828|||RCT|COR|ALL||[CR][EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
        tmp.setLength(0);
        tmp.append("[SB]MSH|^~\\&|Mindray|CMD600|||20121114174828||ACK^Q03|434|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("MSA|AA|434|Message[SP]accepted|||0|[CR]ERR|0|[CR][EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
    }

    private void cmd600Result(String tubo, boolean isCurva) {
        StringBuilder tmp = new StringBuilder();
        tubo = JOptionPane.showInputDialog(null, "Informe o Id da amostra?", "");
        tmp.append("[SB]MSH|^~\\&|Mindray|CMD600|||20171117161318||ORU^R01|518|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("PID|107||||JULIO[SP]CESAR[SP]LIMP[SP]PINHEIRO||19000101000000|M|||||||||||||||||||||||[CR]");
        tmp.append("OBR|107|" + tubo + "|70|Mindray^CMD600|N|||||||||20171117155053|Soro|||||||||||||||||||||||||||||||||[CR]");
        tmp.append("OBX|1|NM|1|GLIC|125.991679|mg/dL|50.000000-99.000000|H|||F||125.991679|||||[CR]");
        tmp.append("OBX|2|NM|2|COL|165.975667|mg/dL|0.000000-200.000000|N|||F||165.975667|||||[CR]");
        tmp.append("OBX|3|NM|3|TRI|145.429575|mg/dL|0.000000-200.000000|N|||F||145.429575|||||[CR]");
        tmp.append("OBX|4|NM|4|HDL|54.370979|mg/dL|35.000000-65.000000|N|||F||54.370979|||||[CR]");
        tmp.append("OBX|5|NM|5|UREA|36.613718|mg/dL|10.000000-45.000000|N|||F||36.613718|||||[CR]");
        tmp.append("OBX|6|NM|6|CRE|1.482866|mg/dL|0.400000-1.400000|H|||F||1.482866|||||[CR]");
        tmp.append("OBX|7|NM|7|URIC|5.195492|mg/dL|2.500000-7.500000|N|||F||5.195492|||||[CR]");
        tmp.append("OBX|8|NM|8|TGO|22.296190|U/L|5.000000-38.000000|N|||F||22.296190|||||[CR]");
        tmp.append("OBX|9|NM|9|TGP|24.012417|U/L|10.000000-40.000000|N|||F||24.012417|||||[CR]");
        tmp.append("OBX|10|NM|13|GGT|25.054650|U/L|12.000000-45.000000|N|||F||25.054650|||||[CR]");
        tmp.append("OBX|11|NM|16|CKT|123.939070|U/L|24.000000-195.000000|N|||F||123.939070|||||[CR]");
        tmp.append("OBX|12|NM|18|FOS|3.797200|mg/dL|2.500000-5.600000|N|||F||3.797200|||||[CR]");
        tmp.append("OBX|13|NM|20|CAL|10.169927|mg/dL|8.800000-11.000000|N|||F||10.169927|||||[CR]");
        tmp.append("OBX|14|NM|23|PROT|7.398629|g/dL|6.000000-8.000000|N|||F||7.398629|||||[CR]");
        tmp.append("OBX|15|NM|24|ALB|5.030171|g/dL|3.500000-5.500000|N|||F||5.030171|||||[CR]");
        tmp.append("[EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<MessageOruR01> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<MessageOruR01> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(MessageOruR01 message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<MessageOruR01> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    MessageOruR01 message = this.listaRecebimento.remove(0);
                    InterfaceListener.this.processaMensagem(message);
                    ThreadRecebimento.sleep(450L);
                }
                if (!InterfaceListener.this.equipamento.getStatusFecharInterfaceamento().isExportando()) {
                    InterfaceListener.this.fireAtualizarTabela();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

