/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cmd600;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultNaoEnviados;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.JFrame;

public class AbaNaoEnviados
extends AbaDefaultNaoEnviados {
    public AbaNaoEnviados(JFrame parent, AbstractInterfaceamento equip) {
        super(parent, equip);
    }

    @Override
    protected void loadExames() {
        this.setAmpulheta(true);
        PreparedStatement ps = null;
        try {
            ArrayList dados_temp = new ArrayList();
            String recente = String.valueOf(0);
            StringBuilder query = new StringBuilder();
            query.append("select a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo, a.rec_codigo, b.req_data, ");
            query.append(" b.req_hora, b.req_anomes, b.req_idade, c.pac_nome, c.pac_sexo, d.mco_abreviatura, ");
            query.append(" a.ier_rackpos, b.req_urgente, a.int_codigo, ");
            query.append(" pegaAlternativoExameInterface(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.int_codigo) as emi_alternativo, ");
            query.append(" pegaDataEntregaExame(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.req_codigo) as exr_dataentregaprev ");
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                query.append(", pegaCodigoMultiguiaMae(a.fil_codigo, a.req_codigo) as multiguia ");
            }
            query.append(", (SELECT  ARRAY (select rec_kodigo from interfaceexamerequisicaodesm");
            query.append(" where fil_codigo = a.fil_codigo and req_codigo = a.req_codigo and rec_codigo = a.rec_codigo and exa_codigo = a.exa_codigo and mco_codigo = a.mco_codigo and int_codigo = a.int_codigo)) as tubosFilhos ");
            query.append(" from ");
            query.append(" interfaceexamerequisicao a ");
            query.append(" left join requisicao b on a.fil_codigo=b.fil_codigo and a.req_codigo=b.req_codigo ");
            query.append(" left join paciente c on a.fil_codigo=c.fil_codigo and b.pac_codigo=c.pac_codigo ");
            query.append(" left join materialcoleta d on a.fil_codigo=d.fil_codigo and a.mco_codigo=d.mco_codigo ");
            query.append("where ").append(BDUtil.montaSQLEquipamentoFilial());
            query.append(" and a.ier_situacao = ");
            query.append(recente);
            if (Variaveis.equipamentos.get(0).getFiltroColetas() != null && Variaveis.equipamentos.get(0).getFiltroColetas().length > 0) {
                query.append(" and b.col_codigo in ('");
                StringUtil.implode(Variaveis.equipamentos.get(0).getFiltroColetas(), "', '", query);
                query.append("')");
            }
            if (Variaveis.equipamentos.get(0).getFiltroDestinos() != null && Variaveis.equipamentos.get(0).getFiltroDestinos().length > 0) {
                query.append(" and b.des_codigo in ('");
                StringUtil.implode(Variaveis.equipamentos.get(0).getFiltroDestinos(), "', '", query);
                query.append("')");
            }
            if (Variaveis.equipamentos.get(0).getFiltroSituacoesReq() != null && Variaveis.equipamentos.get(0).getFiltroSituacoesReq().length > 0) {
                query.append(" and b.sit_codigo in ('");
                StringUtil.implode(Variaveis.equipamentos.get(0).getFiltroSituacoesReq(), "', '", query);
                query.append("')");
            }
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                query.append(" order by a.fil_codigo, multiguia, a.rec_codigo, a.int_codigo, a.exa_codigo");
            } else {
                query.append(" order by a.fil_codigo, a.req_codigo, a.rec_codigo, a.int_codigo, a.exa_codigo");
            }
            ps = Conexao.getPreparedStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs != null && rs.next()) {
                Object[] linha = new Object[this.getColCount()];
                String req_codigo = Funcoes.preencheZero(rs.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                req_codigo = req_codigo + Funcoes.preencheZero(rs.getInt("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao());
                String idade = String.valueOf(rs.getInt("req_idade")) + " " + Tipos.tipoIdade(rs.getString("req_anomes"));
                Date ddata = rs.getDate("req_data");
                Time hhora = rs.getTime("req_hora");
                String data = ddata == null ? "" : new SimpleDateFormat("dd/MM/yyyy").format(ddata);
                String hora = hhora == null ? "" : new SimpleDateFormat("HH:mm").format(hhora);
                String nome = this.limparNomePaciente(rs.getString("pac_nome"));
                if (Funcoes.textoVazio(nome.trim())) {
                    nome = req_codigo + " Nome nao compativel com interfaceamento";
                }
                linha[this.getColIndice((String)"C\u00f3digo")] = req_codigo;
                linha[this.getColIndice((String)"Exame")] = rs.getString("exa_codigo");
                linha[this.getColIndice((String)"Paciente")] = nome;
                linha[this.getColIndice((String)"S")] = rs.getString("pac_sexo");
                linha[this.getColIndice((String)"Data")] = data;
                linha[this.getColIndice((String)"Hora")] = hora;
                linha[this.getColIndice((String)"Ide")] = idade;
                linha[this.getColIndice((String)"Mat.")] = rs.getString("mco_abreviatura");
                linha[this.getColIndice((String)"C\u00f3d. Mat.")] = rs.getString("mco_codigo");
                linha[this.getColIndice((String)"Tubo")] = rs.getString("rec_codigo");
                linha[this.getColIndice((String)"Previs\u00e3o")] = rs.getTimestamp("exr_dataentregaprev");
                linha[this.getColIndice((String)"Rack")] = rs.getString("ier_rackpos");
                linha[this.getColIndice((String)"Urgente")] = rs.getBoolean("req_urgente");
                linha[this.getColIndice((String)"Interface")] = rs.getString("int_codigo");
                linha[this.getColIndice((String)"Alternativo")] = rs.getString("emi_alternativo");
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    String multiguia = Funcoes.preencheZero(rs.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                    multiguia = multiguia + Funcoes.preencheZero(rs.getInt("multiguia"), ParametrosGerais.getDigitosTuboRequisicao());
                    linha[this.getColIndice((String)"Multiguia")] = multiguia;
                    linha[this.getColIndice((String)"C\u00f3digo Temp.")] = req_codigo;
                }
                ResultSet rsTubosFilhos = rs.getArray("tubosFilhos").getResultSet();
                boolean exameDesmembrado = false;
                ArrayList<String> tubosFilhos = new ArrayList<String>();
                if (rsTubosFilhos.next()) {
                    do {
                        tubosFilhos.add(String.valueOf(rsTubosFilhos.getInt(2)));
                    } while (rsTubosFilhos.next());
                    exameDesmembrado = true;
                }
                if (exameDesmembrado) {
                    linha[this.getColIndice((String)"Tubos Filhos")] = tubosFilhos;
                }
                dados_temp.add(linha);
            }
            dados_temp = ParametrosGerais.isAgruparGuiasInterface() ? this.agrupaExamesMultiGuia(dados_temp) : this.agrupaExamesMesmaRequisicao(dados_temp);
            this.exames = dados_temp;
            this.tabelaExames.setData(this.exames);
            this.tabelaExames.sortRowsByColumn(this.tabelaExames.getColunaOrdenada(), false, false);
            this.tabelaExames.grabFocus();
            ps.close();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setAmpulheta(false);
    }
}

