/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cm200;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.cm200.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.padroes.astm2.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.padroes.astm2.Message;
import jalis.laboratorio.interfaceamento.padroes.astm2.MessageReceivedListener;
import jalis.laboratorio.interfaceamento.padroes.astm2.MessageSentCallback;
import jalis.laboratorio.interfaceamento.padroes.astm2.RangeId;
import jalis.laboratorio.interfaceamento.padroes.astm2.Record;
import jalis.laboratorio.interfaceamento.padroes.astm2.RecordType;
import jalis.laboratorio.interfaceamento.padroes.astm2.UniversalTestId;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.MessageHeader;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.MessageTerminator;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.PatientInformation;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.RequestInformation;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.Result;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.TestOrder;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class InterfaceListener
extends InterfaceASTMListener
implements MessageReceivedListener {
    private static final String CODIGO_APOIO_FILHO = "codigoApoioFilho";
    protected List<String> examesFilho = new LinkedList<String>();
    protected String rec_tuboPai = "";
    private List<String> tuboIdEnviados;
    private List<String> listaEnviados;
    protected boolean curva = false;
    protected String[] exames;
    protected String fil_codigo;
    protected String req_codigo;
    protected String mco_codigo;
    protected String rec_codigo;
    protected String pac_nome;
    protected String pac_exames;
    protected String pac_sexo;
    protected String req_idade;
    protected String req_data;
    protected String req_hora;
    protected MemoryList<String> tx_list = new MemoryList();
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();

    public InterfaceListener() {
        this.tuboIdEnviados = new ArrayList<String>();
        this.listaEnviados = new LinkedList<String>();
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    public InterfaceConfiguracao getConfiguracao() {
        return this.configuracao;
    }

    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        return this.enviarRequisicao(pacNome, pacSexo, pacIdade, data, hora, rackposition, prioridade, filCodigo, intCodigo, reqCodigo, mcoCodigo, recCodigo, exames, acao, null);
    }

    @Override
    public String enviarRequisicao(final String pacNome, final String pacSexo, final String pacIdade, final String data, final String hora, String rackposition, String prioridade, final String filCodigo, final String intCodigo, final String reqCodigo, final String mcoCodigo, final String recCodigo, final String exames, String acao, HashMap<String, String> parametros) {
        this.exames = exames.split(" ", 0);
        Statement st = Conexao.getStatement();
        Object listaCurva = null;
        String fil_codigo = filCodigo;
        String req_codigo = reqCodigo;
        ExameMaterial[] exa_lista = null;
        String rec_codigo = Funcoes.preencheZero(recCodigo, ParametrosGerais.getDigitosTuboTubo());
        String exr_codigoapoiado = parametros != null ? parametros.get("codigoApoiado") : "";
        final String tuboId = !Funcoes.textoVazio(exr_codigoapoiado) ? exr_codigoapoiado : Funcoes.preencheZero(filCodigo, ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(reqCodigo, ParametrosGerais.getDigitosTuboRequisicao()) + Funcoes.preencheZero(recCodigo, ParametrosGerais.getDigitosTuboTubo());
        try {
            if (this.tuboIdEnviados.contains(tuboId) || this.configuracao.getManterListaDeEnviados() && this.listaEnviados.contains(tuboId)) {
                return null;
            }
            exa_lista = this.curva ? BDUtil.getExameMaterialRecipiente(fil_codigo, req_codigo, rec_codigo, intCodigo) : ExamesUtil.anexarCodigoMaterial(this.exames, mcoCodigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, intCodigo, exa_lista);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Date dataColeta = null;
        ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
        try {
            Set<String> tests;
            if (exa_lista != null) {
                for (ExameMaterial exame : exa_lista) {
                    if (dataColeta == null) {
                        dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial());
                    }
                    if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exame.getNomeExame(), exame.getCodigoMaterial())) {
                        ExameMaterial[] exameMaterialFilhos;
                        System.out.println("Enviando desmembrado " + exame.getNomeExame());
                        for (ExameMaterial exameFilho : exameMaterialFilhos = BDUtil.getExamesFilhos(filCodigo, intCodigo, exame.getString(), exame.getCodigoMaterial())) {
                            String rec_kodigo = BDUtil.getExameDesmembradoTubo(filCodigo, reqCodigo, recCodigo, intCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                            if (rec_kodigo == null) {
                                Integer req;
                                Integer[] reqs;
                                Integer[] integerArray = reqs = RecepcaoUtil.verificaMultiGuias(filCodigo, reqCodigo, false);
                                int n = integerArray.length;
                                for (int i = 0; i < n && (rec_kodigo = BDUtil.getExameDesmembradoTubo(filCodigo, (req = integerArray[i]).toString(), recCodigo, intCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial())) == null; ++i) {
                                }
                            }
                            if (rec_kodigo == null) {
                                this.fireExcecaoEncontrada(String.format("N\u00e3o encontrado o recipiente para o exame filho: %s", exameFilho.getNomeExame()));
                                continue;
                            }
                            if (rec_codigo.equalsIgnoreCase(rec_kodigo = Funcoes.preencheZero(rec_kodigo, ParametrosGerais.getDigitosTuboTubo()))) {
                                examesParaEnviar.add(exameFilho);
                                continue;
                            }
                            ArrayList<ExameMaterial> examesDaRequisicaoFilho = new ArrayList<ExameMaterial>();
                            examesDaRequisicaoFilho.add(exameFilho);
                            String codigoApoiado = BDUtil.getCodigoApoioRecipiente(Integer.parseInt(fil_codigo), Integer.parseInt(req_codigo), exame.getNomeExame(), Integer.parseInt(exame.getCodigoMaterial()), Integer.parseInt(rec_kodigo));
                            if (parametros != null) {
                                if (parametros.containsKey(CODIGO_APOIO_FILHO)) {
                                    parametros.remove(CODIGO_APOIO_FILHO);
                                    parametros.put(CODIGO_APOIO_FILHO, codigoApoiado);
                                } else {
                                    parametros.put(CODIGO_APOIO_FILHO, codigoApoiado);
                                }
                            }
                            this.enviarRequisicao(fil_codigo, req_codigo, rec_codigo, rec_kodigo, pacNome, mcoCodigo, intCodigo, pacSexo, pacIdade, data, hora, dataColeta, examesDaRequisicaoFilho, exames, parametros);
                        }
                        continue;
                    }
                    int situacao = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                    if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exame.getString(), mcoCodigo)) {
                        List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exame.getString(), mcoCodigo));
                        if (situacao == 0 || situacao == 1) {
                            examesParaEnviar.addAll(examesFilhos);
                            continue;
                        }
                        for (ExameMaterial exameFilho : examesFilhos) {
                            int sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                            if (sitFilho != 3) continue;
                            examesParaEnviar.add(exameFilho);
                        }
                        continue;
                    }
                    if (situacao != 0 && situacao != 1 && situacao != 3) continue;
                    examesParaEnviar.add(exame);
                }
            }
            TestOrder testOrder = new TestOrder();
            PatientInformation patientInfo = new PatientInformation();
            Message messageResp = new Message();
            messageResp.addRecord(new MessageHeader());
            messageResp.addRecord(patientInfo);
            messageResp.addRecord(testOrder);
            messageResp.addRecord(new MessageTerminator());
            patientInfo.setName(StringUtil.removerAcentos(pacNome));
            testOrder.setSpecimenId(tuboId);
            this.tuboIdEnviados.add(tuboId);
            if (this.configuracao.getManterListaDeEnviados()) {
                this.listaEnviados.add(tuboId);
            }
            if (!(tests = this.obtemAlternativos(filCodigo, mcoCodigo, intCodigo, examesParaEnviar)).isEmpty()) {
                for (String test : tests) {
                    UniversalTestId universalTestId = new UniversalTestId();
                    universalTestId.setTestNumber(String.valueOf(test));
                    testOrder.addUniversalTestId(universalTestId);
                }
                testOrder.setReportType(TestOrder.ReportType.FINAL_RESULTS);
                testOrder.setSpecimenDate(dataColeta);
                this.addMessageToSend(messageResp, new MessageSentCallback(){

                    @Override
                    public void messageSent(Message message, MessageSentCallback.MessageSentResult result) {
                        if (result == MessageSentCallback.MessageSentResult.SUCCESS) {
                            try {
                                Statement st = Conexao.getStatement();
                                InterfaceListener.this.tuboIdEnviados.remove(tuboId);
                                String[] stringArray = exames.split(" ");
                                int n = stringArray.length;
                                for (int i = 0; i < n; ++i) {
                                    String exame;
                                    int atual = InterfaceListener.this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame = stringArray[i], mcoCodigo, recCodigo);
                                    InterfaceListener.this.atualizarSituacaoExame(st, filCodigo, reqCodigo, recCodigo, exame, mcoCodigo, intCodigo, null, atual < 2 ? 1 : 3);
                                }
                                Conexao.arquivaSQL();
                            }
                            catch (Exception e) {
                                try {
                                    Conexao.anulaSQL();
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                            }
                            InterfaceListener.this.firePacienteEnviado(reqCodigo, pacNome, pacSexo, pacIdade, data, hora, exames);
                            InterfaceListener.this.fireAtualizarTabela(0);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return "Erro ao enviar exames: " + e.getMessage();
        }
        return null;
    }

    private void enviarRequisicao(final String fil_codigo, final String req_codigo, final String rec_codigo, String rec_kodigo, final String pac_nome, final String mco_codigo, final String int_codigo, final String pac_sexo, final String pac_idade, final String data, final String hora, Date dataColeta, List<ExameMaterial> examesParaEnviar, final String exames, HashMap<String, String> parametros) throws SQLException {
        final String tuboId = parametros != null && !Funcoes.textoVazio(parametros.get(CODIGO_APOIO_FILHO)) ? parametros.get(CODIGO_APOIO_FILHO) : Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao()) + Funcoes.preencheZero(rec_kodigo, ParametrosGerais.getDigitosTuboTubo());
        if (this.tuboIdEnviados.contains(tuboId) || this.configuracao.getManterListaDeEnviados() && this.listaEnviados.contains(tuboId)) {
            return;
        }
        TestOrder testOrder = new TestOrder();
        PatientInformation patientInfo = new PatientInformation();
        Message messageResp = new Message();
        messageResp.addRecord(new MessageHeader());
        messageResp.addRecord(patientInfo);
        messageResp.addRecord(testOrder);
        messageResp.addRecord(new MessageTerminator());
        patientInfo.setName(StringUtil.removerAcentos(pac_nome));
        testOrder.setSpecimenId(tuboId);
        this.tuboIdEnviados.add(tuboId);
        if (this.configuracao.getManterListaDeEnviados()) {
            this.listaEnviados.add(tuboId);
        }
        System.out.println(tuboId);
        Set<String> tests = this.obtemAlternativos(fil_codigo, mco_codigo, int_codigo, examesParaEnviar);
        if (tests.isEmpty()) {
            testOrder.setReportType(TestOrder.ReportType.NO_RECORD);
            this.fireExcecaoEncontrada(fil_codigo + req_codigo + rec_kodigo + " - Nenhum exame enviado.");
        } else {
            for (String test : tests) {
                UniversalTestId universalTestId = new UniversalTestId();
                universalTestId.setTestNumber(String.valueOf(test));
                testOrder.addUniversalTestId(universalTestId);
            }
            testOrder.setReportType(TestOrder.ReportType.FINAL_RESULTS);
            testOrder.setSpecimenDate(dataColeta);
            this.addMessageToSend(messageResp, new MessageSentCallback(){

                @Override
                public void messageSent(Message message, MessageSentCallback.MessageSentResult result) {
                    if (result == MessageSentCallback.MessageSentResult.SUCCESS) {
                        try {
                            Statement st = Conexao.getStatement();
                            InterfaceListener.this.tuboIdEnviados.remove(tuboId);
                            String[] stringArray = exames.split(" ");
                            int n = stringArray.length;
                            for (int i = 0; i < n; ++i) {
                                String exame;
                                int atual = InterfaceListener.this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame = stringArray[i], mco_codigo, rec_codigo);
                                InterfaceListener.this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, atual < 2 ? 1 : 3);
                            }
                            Conexao.arquivaSQL();
                        }
                        catch (Exception e) {
                            try {
                                Conexao.anulaSQL();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                        }
                        InterfaceListener.this.firePacienteEnviado(req_codigo, pac_nome, pac_sexo, pac_idade, data, hora, exames);
                        InterfaceListener.this.fireAtualizarTabela(0);
                    }
                }
            });
        }
    }

    private Set<String> obtemAlternativos(String fil_codigo, String mco_codigo, String int_codigo, List<ExameMaterial> examesParaEnviar) throws SQLException {
        HashSet<String> tests = new HashSet<String>();
        for (ExameMaterial exameParaEnviar : examesParaEnviar) {
            System.out.println(exameParaEnviar.getNomeExame());
            String test = BDUtil.getExmCodigoAlternativo(fil_codigo, exameParaEnviar.getNomeExame(), mco_codigo, int_codigo);
            if (test == null || test.trim().isEmpty()) continue;
            tests.add(test);
        }
        return tests;
    }

    @Override
    protected MessageReceivedListener getMessageReceivedListener() {
        return this;
    }

    @Override
    public void messageReceived(Message message) {
        for (Record record : message.getRecords()) {
            if (record.getType() == RecordType.RESULT) {
                this.measureData(message);
                break;
            }
            System.out.println("Registro recebido do tipo=" + record.getType().getId());
        }
    }

    public void buscarResultadosIndividuais(List<String> requisicoes) {
        for (String req : requisicoes) {
            RequestInformation r = new RequestInformation();
            RangeId range = new RangeId();
            range.setSpecimenId(req);
            r.setStartingRange(range);
            r.setEndingRange(range);
            r.setRequestInfoStatus(RequestInformation.RequestInfoStatus.REQUEST_RESULTS_PENDING);
            Message message = new Message();
            message.addRecord(new MessageHeader());
            message.addRecord(r);
            message.addRecord(new MessageTerminator());
            this.addMessageToSend(message);
        }
    }

    public void buscarResultados(Date inicio, Date fim) {
        RequestInformation requestInfo = new RequestInformation();
        requestInfo.setBeginningRequestResults(inicio);
        requestInfo.setEndingRequestResults(fim);
        requestInfo.setRequestInfoStatus(RequestInformation.RequestInfoStatus.REQUEST_RESULTS_PENDING);
        Message message = new Message();
        message.addRecord(new MessageHeader());
        message.addRecord(requestInfo);
        message.addRecord(new MessageTerminator());
        this.addMessageToSend(message);
    }

    private void measureData(Message message) {
        try {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            Statement st = Conexao.getStatement();
            String tuboId = null;
            String req_pai = null;
            for (Record record : message.getRecords()) {
                if (record.getType() == RecordType.TEST_ORDER) {
                    TestOrder testOrder = (TestOrder)record;
                    String tuboIdAtual = testOrder.getSpecimenId();
                    if (!this.matches(tuboIdAtual)) {
                        tuboId = null;
                        this.fireExcecaoEncontrada(String.format("C\u00f3digo da etiqueta est\u00e1 incorreto: %s", tuboIdAtual));
                        continue;
                    }
                    DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboIdAtual);
                    req_pai = tuboIdAtual;
                    if (etiqueta != null) {
                        tuboIdAtual = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao()) + Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                    }
                    if (tuboIdAtual != null && tuboIdAtual.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboIdAtual)) {
                        tuboId = tuboIdAtual;
                        continue;
                    }
                    this.fireExcecaoEncontrada(String.format("Id da amostra fora do padr\u00e3o: %s", tuboIdAtual));
                    tuboId = null;
                    continue;
                }
                if (record.getType() == RecordType.RESULT) {
                    ExameMaterial exame;
                    Result result = (Result)record;
                    if (tuboId == null) {
                        this.fireExcecaoEncontrada(String.format("Exame alternativo %s n\u00e3o localizado sem id da amostra", result.getUniversalTestId().getTestNumber()));
                        continue;
                    }
                    String emiAlternativo = result.getUniversalTestId().getTestNumber();
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    String intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                    if (ParametrosGerais.isAgruparGuiasInterface() && intCodigo == null) {
                        filCodigo = req_pai.substring(0, ParametrosGerais.getDigitosTuboFilial());
                        reqCodigo = req_pai.substring(ParametrosGerais.getDigitosTuboFilial());
                        recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                        reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                        intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                    }
                    if ((exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo)) != null) {
                        HashMap<String, Object> dados = new HashMap<String, Object>();
                        int sit = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                        String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                        String resultado = result.getMeasurementValue().replace('.', ',');
                        dados.put(campo, resultado);
                        this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados);
                        if (!this.configuracao.getAtualizarProntosPorResultado()) continue;
                        Conexao.arquivaSQL();
                        this.fireAtualizarTabela(2);
                        this.fireAtualizarTabela(1);
                        continue;
                    }
                    this.fireExcecaoEncontrada(String.format("Exame alternativo %s n\u00e3o localizado para amostra: %s", emiAlternativo, tuboId));
                    continue;
                }
                tuboId = null;
            }
            if (!this.configuracao.getAtualizarProntosPorResultado()) {
                Conexao.arquivaSQL();
                this.fireAtualizarTabela(2);
                this.fireAtualizarTabela(1);
            }
            st.close();
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    private boolean matches(String texto) {
        return texto.matches("[0-9]+");
    }

    @Override
    public void teste() {
        HashMap<String, String[]> maps = new HashMap<String, String[]>();
        maps.put("requisicoes", new String[]{"010005344210", "010005344204", "010005344205", "010005344208"});
        maps.put("alternativos", new String[]{"ALD", "G1", "G2", "TSH"});
        maps.put("resultados", new String[]{"10,22", "40,22", "10,78", "20,25"});
        String[] requisicoes = (String[])maps.get("requisicoes");
        String[] alternativos = (String[])maps.get("alternativos");
        String[] resultados = (String[])maps.get("resultados");
        this.handShakeCharReceived('\u0005');
        this.dataChanged(this.equipamento.arruma("[STX]1H|\\^&|||Jalis|||||||||[CR][ETX]A7[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]2P|1||||CLEBER[SP]DOS[SP]SANTOS[SP]REINHARDT|||||||||||||||||||||||||||||[CR][ETX]A7[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]1O|72|STANDARTROL[SP]1|14527|^^^GGT-LA|||||||||||||||||||||Q[CR][ETX]BE[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]0R|1|^^^FAL-LA|109,6|U/L|0^0|N||F||||20171201111803[CR][ETX]14[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]2R|1|^^^GGT-LA|29,72|U/L|0^0|N||F||||20171201111856[CR][STX]3O|73|STANDARTROL[SP]1|14527|^^^GLI|||||||||||||||||||||Q[CR][ETX]01[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]4R|1|^^^GLI|87,41|MG/DL|0^0|N||F||||20171201105323[CR][ETX]EE[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]5O|74|010070329204|14523|^^^GLI|||||||||||||||||||||Q[CR][ETX]B9[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]6R|1|^^^GLI|82,42|MG/DL|0^0|N||F||||20171201110927[CR][ETX]F2[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]7O|75|STANDARTROL[SP]1|14527|^^^GPT[SP]L|||||||||||||||||||||Q[CR][ETX]82[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]0R|1|^^^GPT[SP]L|32,76|U/L|0^0|N||F||||20171201105049[CR][ETX]E5[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]1O|16||90225|^^^CA[SP]As|||||||||||||||||||||Q[CR][ETX]D8[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]7O|67|STANDARTROL[SP]1|14527|^^^BT[SP]L|||||||||||||||||||||Q[CR][ETX]D8[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]0R|1|^^^GPT[SP]L|32,76|U/L|0^0|N||F||||20171201105049[CR][ETX]E5[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]1O|76|STANDARTROL[SP]1|14527|^^^HDL[SP]-LA|||||||||||||||||||||Q[CR][ETX]D8[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]2R|1|^^^HDL[SP]-LA|46,2|MG/DL|0^0|N||F||||20171201104307[CR][ETX]D8[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]4R|1|^^^LDH[SP]L|370,5|U/L|0^0|N||F||||20171201111350[CR][ETX]CB[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]5O|78|STANDARTROL[SP]1|14527|^^^MAG-LA|||||||||||||||||||||Q[CR][ETX]BB[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]6R|1|^^^MAG-LA|3,295|MG/DL|0^0|N||F||||20171201112027[CR][ETX]A1[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]7O|79|STANDARTROL[SP]1|14527|^^^TG|||||||||||||||||||||Q[CR][ETX]CA[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]0R|1|^^^TG|163,5|MG/DL|0^0|N||F||||20171201105755[CR][ETX]AD[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]1O|80|STANDARTROL[SP]1|14527|^^^URE[SP]L|||||||||||||||||||||Q[CR][ETX]79[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]2R|1|^^^URE[SP]L|33,37|MG/DL|0^0|N||F||||20171201111406[CR][ETX]63[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]3O|81|186981|14528|^^^URE[SP]L|||||||||||||||||||||Q[CR][ETX]1F[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]4R|1|^^^URE[SP]L|69,24|MG/DL|0^0|N||F||||20171201104237[CR][ETX]6E[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]5O|82|186988|14529|^^^AUS-LA|||||||||||||||||||||Q[CR][ETX]75[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]6R|1|^^^AUS-LA|6,63|MG/DL|0^0|N||F||||20171201104221[CR][ETX]7E[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]7O|83|187002|14530|^^^BD[SP]L|||||||||||||||||||||Q[CR][ETX]A9[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]0R|1|^^^BD[SP]L|0,09951|MG/DL|0^0|N||F||||20171201104103[CR][ETX]5F[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]1O|84|187002|14530|^^^BT[SP]L|||||||||||||||||||||Q[CR][ETX]B4[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]4L|1|N[CR][ETX]07[LINE]"));
        this.handShakeCharReceived('\u0004');
    }

    public void addExameFilho(String exame) {
        this.examesFilho.add(exame);
    }

    public void setCurva(boolean curva) {
        this.curva = curva;
    }

    public boolean isCurva() {
        return this.curva;
    }

    public void setTuboPai(String rec_tuboPai) {
        this.rec_tuboPai = rec_tuboPai;
    }
}

