/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.chemwell;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.comunicacao.PortaFILE;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.chemwell.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.chemwell.RequisicaoParaEnviar;
import jalis.laboratorio.interfaceamento.padroes.arquivo.InterfaceArquivoListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;

public class InterfaceListener
extends InterfaceArquivoListener {
    private InterfaceConfiguracao configuracao;
    private String DIRETORIO_EXPORTACAO = "";
    private String DIRETORIO_IMPORTACAO = "";
    private boolean curva = false;
    private List<String> examesFilho = new ArrayList<String>();
    private ArrayList<RequisicaoParaEnviar> requisicoesParaEnviar = new ArrayList();

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setDiretorioExportacao(c.getDiretorioExportacao());
        this.configuracao.setDiretorioImportacao(c.getDiretorioImportacao());
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.DIRETORIO_EXPORTACAO = c.getDiretorioExportacao();
        this.DIRETORIO_IMPORTACAO = c.getDiretorioImportacao();
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            String[] exms;
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            String[] stringArray = exms = exames.split(" ", 0);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String s;
                int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, s = stringArray[i], mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, s, mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                if (!this.curva || this.examesFilho.isEmpty()) continue;
                for (String exame : this.examesFilho) {
                    BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, s, mco_codigo, exame, mco_codigo, rec_codigo, situacao < 2 ? 1 : 3);
                }
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            this.equipamento.atualizarTabela(0);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return "";
        }
    }

    @Override
    public String parse(String message) {
        File file = new File(message);
        if (!file.exists()) {
            this.fireExcecaoEncontrada("Arquivo n\u00e3o localizado: " + message);
            return null;
        }
        String arquivo = "";
        try {
            arquivo = StringUtil.lerArquivoTexto(message);
        }
        catch (Exception e1) {
            this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel ler o arquivo de resultados: " + message);
            return null;
        }
        if (!arquivo.startsWith("H|") || arquivo.indexOf("OBX") < 0) {
            this.fireExcecaoEncontrada("Arquivo de resultado inv\u00e1lido: " + message);
            return null;
        }
        String[] linhasArquivo = arquivo.split("\n");
        if (!linhasArquivo[linhasArquivo.length - 1].startsWith("L|||")) {
            this.fireExcecaoEncontrada("Arquivo de resultado incompleto: " + message);
            return null;
        }
        String mensagem = "";
        try {
            if (this.parseArquivo(linhasArquivo)) {
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
                return "Resultados recebidos com sucesso.";
            }
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "Erro ao realizar parse de dados recebidos do equipamento";
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return "Erro ao realizar parse de dados recebidos do equipamento";
        }
    }

    private boolean parseArquivo(String[] linhasArquivo) throws Exception {
        int contaLinha = 0;
        Statement st = Conexao.getStatement();
        while (contaLinha < linhasArquivo.length) {
            String tmp;
            String linha = linhasArquivo[contaLinha];
            if (linha.startsWith("H|") || linha.startsWith("L|")) {
                ++contaLinha;
                continue;
            }
            String requisicao = "";
            String filial = "";
            String tubo = "";
            String paciente = "";
            String alternativoExame = "";
            String resultadoExame = "";
            if (!linha.startsWith("P|")) continue;
            String excecao = "";
            String[] linhaPaciente = linha.split("\\|");
            if (!Funcoes.isNumeric(linhaPaciente[2])) {
                this.fireExcecaoEncontrada("Interfaceamento para a requisi\u00e7\u00e3o inv\u00e1lida: " + linhaPaciente[2] + " [Requisicao n\u00e3o enviada pelo JALIS]");
                excecao = " [Requisicao n\u00e3o enviada pelo JALIS]";
                tmp = linhaPaciente[2];
                filial = "0";
                requisicao = "0";
                tubo = "0";
            } else {
                tmp = linhaPaciente[2];
                filial = tmp.substring(0, ParametrosGerais.getDigitosTuboFilial());
                requisicao = tmp.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                tubo = tmp.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            }
            if (linhaPaciente.length >= 6) {
                paciente = linhaPaciente[5].replaceAll("\\^", " ");
            }
            linha = linhasArquivo[++contaLinha];
            while (linha.startsWith("OBR") && contaLinha < linhasArquivo.length) {
                String tmpRes;
                alternativoExame = linha.split("\\|")[4].replaceAll("\r", "");
                if (!Funcoes.isNumeric(resultadoExame = (linha = linhasArquivo[++contaLinha]).split("\\|")[4]) && resultadoExame.equals("<") && Funcoes.isNumeric(tmpRes = linha.split("\\|")[5])) {
                    resultadoExame = resultadoExame + " " + tmpRes;
                }
                linha = linhasArquivo[++contaLinha];
                if (Funcoes.textoVazio(alternativoExame)) continue;
                String int_codigo = this.getIntCodigo(filial, requisicao, tubo, alternativoExame);
                if (int_codigo == null) {
                    this.fireExcecaoEncontrada("Interfaceamento do exame " + alternativoExame + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + filial + " " + requisicao + " " + tubo + excecao);
                    continue;
                }
                ExameMaterial exame = this.getReqExameLIS(filial, int_codigo, requisicao, tubo, alternativoExame);
                if (exame == null) {
                    this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + alternativoExame + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + filial + " " + requisicao + " " + tubo);
                    continue;
                }
                this.atualizarResultadoExame(st, filial, requisicao, tubo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, this.arrumaValor(resultadoExame));
            }
        }
        return true;
    }

    private String arrumaValor(String valor) {
        return valor.replaceAll("\\.", ",");
    }

    @Override
    public void buscarResultados(Date inicio, Date termino) {
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser("Arquivo para importa\u00e7\u00e3o", this.DIRETORIO_IMPORTACAO);
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de Resultado do ChemWell", "lis", "txt"));
            if (chooser.showOpenDialog(null) == 0) {
                String path = chooser.getSelectedFile().getPath();
                this.parse(path);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
    }

    public void adicionarRequisicaoParaEnviar(String filial, String requisicao, String tubo, String nomePaciente, String exames, String material, String codigoInterface) {
        if (this.requisicoesParaEnviar != null) {
            this.requisicoesParaEnviar.add(new RequisicaoParaEnviar(filial, requisicao, tubo, nomePaciente, exames, material, codigoInterface));
        }
    }

    public void enviarRequisicoes() {
        if (this.requisicoesParaEnviar.size() > 0) {
            try {
                String arquivo = "E" + Funcoes.formataData("ddMMHHmm", new Date()) + ".lis";
                this.configuracao.setArquivoExportacao(arquivo);
                arquivo = this.DIRETORIO_EXPORTACAO + System.getProperty("file.separator") + arquivo;
                PortaFILE p = (PortaFILE)this.getPortaCOM();
                p.createFile(arquivo);
                ExameMaterial[] alternativos = null;
                ArrayList<String> pacientes = new ArrayList<String>();
                int contadorLinhas = 0;
                int contadorRequisicoes = 0;
                int contadorExames = 0;
                StringBuilder texto = new StringBuilder();
                Map<String, List<ExameMaterial>> alternativosCurva = null;
                texto.append("H|^~\\$||||||||||P|A.2|").append(Funcoes.formataData("yyyyMMddHHmmss", new Date())).append("\n");
                ++contadorLinhas;
                Statement st = Conexao.getStatement();
                for (RequisicaoParaEnviar req : this.requisicoesParaEnviar) {
                    String codigo = Funcoes.preencheZero(req.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                    codigo = codigo + Funcoes.preencheZero(req.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                    codigo = codigo + Funcoes.preencheZero(req.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                    this.curva = false;
                    String cod = codigo.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                    StringBuilder tmp = new StringBuilder();
                    String nome = req.getNomePaciente().trim();
                    String[] nomeTemp = nome.split(" ");
                    if (nomeTemp.length > 3) {
                        nome = nomeTemp[0] + " " + nomeTemp[1] + " " + nomeTemp[2];
                    }
                    if (!(nome = nome.replaceAll(" ", "^")).endsWith("^") && nomeTemp.length < 3) {
                        nome = nome + "^";
                    }
                    String[] exms = req.getCodigosExames().split(" ");
                    ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
                    ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exms, req.getCodigoMaterial());
                    exa_lista = ExamesUtil.separaExamesCurva(req.getFilial(), req.getCodigoInterface(), req.getCodigoMaterial(), exa_lista, exa_listaCurva);
                    if (exa_lista != null) {
                        exa_lista = ExamesUtil.desmembrarExames(st, req.getFilial(), req.getCodigoInterface(), exa_lista);
                        alternativos = ExamesUtil.getAlternativos(st, req.getFilial(), req.getCodigoInterface(), exa_lista);
                    }
                    ArrayList<ExameMaterial> temporario = new ArrayList<ExameMaterial>();
                    if (alternativos != null) {
                        for (ExameMaterial e : alternativos) {
                            if (e == null || Funcoes.textoVazio(e.getNomeExame()) || temporario.contains(e)) continue;
                            temporario.add(e);
                        }
                    }
                    alternativos = new ExameMaterial[temporario.size()];
                    for (int i = 0; i < temporario.size(); ++i) {
                        alternativos[i] = (ExameMaterial)temporario.get(i);
                    }
                    if (alternativos != null && alternativos.length > 0) {
                        ++contadorRequisicoes;
                        if (!pacientes.contains(cod)) {
                            pacientes.add(cod);
                        }
                        tmp.append("P|").append(contadorRequisicoes).append("|").append(codigo).append("|||").append(nome).append("\n");
                        ++contadorLinhas;
                    }
                    if (!exa_listaCurva.isEmpty()) {
                        if (alternativos != null && alternativos.length == 1) {
                            alternativos = null;
                        }
                        alternativosCurva = ExamesUtil.getAlternativosCurva(req.getFilial(), req.getCodigoInterface(), req.getRequisicao(), req.getCodigoMaterial(), req.getTubo(), st, exa_listaCurva, null, false, this.examesFilho);
                    }
                    if (alternativos != null) {
                        for (ExameMaterial exa : alternativos) {
                            ++contadorLinhas;
                            tmp.append("OBR").append("|").append(++contadorExames).append("|||").append(exa.getNomeExame()).append("\n");
                            if (pacientes.contains(codigo.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()))) continue;
                            pacientes.add(codigo.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()));
                        }
                    }
                    if (alternativosCurva != null && alternativosCurva.size() > 0) {
                        StringBuilder sample_id = new StringBuilder();
                        this.curva = true;
                        for (String key : alternativosCurva.keySet()) {
                            sample_id.setLength(0);
                            sample_id.append(cod);
                            String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                            ++contadorRequisicoes;
                            if (!pacientes.contains(cod)) {
                                pacientes.add(cod);
                            }
                            ++contadorLinhas;
                            tmp.append("P|").append(contadorRequisicoes).append("|").append(sample_id.append(tubo).toString()).append("|||").append(nome).append("\n");
                            ++contadorLinhas;
                            tmp.append("OBR").append("|").append(++contadorExames).append("|||").append(alternativosCurva.get(key).toArray(new ExameMaterial[alternativosCurva.get(key).size()])[0].getNomeExame()).append("\n");
                        }
                    }
                    texto.append(tmp.toString());
                    this.enviarRequisicao(req.getNomePaciente(), "", "", "", "", "", "", req.getFilial(), req.getCodigoInterface(), req.getRequisicao(), req.getCodigoMaterial(), req.getTubo(), req.getCodigosExames(), "N");
                    contadorExames = 0;
                }
                texto.append("L|||").append(pacientes.size()).append("|").append(++contadorLinhas).append("\n");
                this.requisicoesParaEnviar.clear();
                this.examesFilho.clear();
                p.write(texto.toString());
                p.closeFile();
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }
}

