/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cdruby;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.cdruby.Flag;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    protected static String EXAMES = "exames";
    private static final int FLAG_SUSPECT_PARAMETER_FLAGS = 0;
    private static final int FLAG_SUSPECT_POPULATION_FLAGS = 1;
    private static final int FLAG_SYSTEM_FAULTS = 2;
    private final String[] tiposFlag = new String[]{"Suspect Parameter", "Suspect Population Flags", "System Fault Flags"};
    private String starting_range = null;
    private String ending_range = null;
    private String test_id = null;
    private boolean modoHostQuery = false;
    private List<Flag> flagsExame = new ArrayList<Flag>();
    private final String FLAG = "FLAG";
    private static Map<String, String> exameCamposByTestId = new HashMap<String, String>();
    private static Map<String, Integer> exameCamposByFlag;
    boolean exr_codigoapoiado = false;

    public RecordParser() {
        Statement st = Conexao.getStatement();
        this.exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        Integer tipo;
        if (this.exame_atual == null) {
            return;
        }
        String action_code = (String)this.exame_atual.get(ACTION_CODE);
        String report_type = (String)this.exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                this.exame_atual = null;
                return;
            }
        }
        if (report_type != null) {
            this.equip.getClass();
            if (report_type.equals("X")) {
                this.exame_atual = null;
                return;
            }
        }
        Hashtable result_fields = ASTMStandard.parseDefaultResultRecord(record);
        String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
        String int_codigo = (String)this.exame_atual.get(INT_CODIGO);
        String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        String campoFlag = this.parseCampoFlag((String)result_fields.get(ASTMStandard.RESULT_FIELD_TEST_ID));
        String campoHemog = this.parseCampoHemograma((String)result_fields.get(ASTMStandard.RESULT_FIELD_TEST_ID));
        String resultado = (String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE);
        String flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS);
        if ((resultado = resultado.replaceAll("\\.", ",")).startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.endsWith(",")) {
            resultado = resultado + "0";
        }
        if (!Funcoes.textoVazio(campoFlag) && resultado.equalsIgnoreCase("FLAG")) {
            Integer tipo2 = exameCamposByFlag.get(campoFlag.toUpperCase());
            if (tipo2 != null) {
                this.flagsExame.add(new Flag(tipo2, campoFlag, resultado));
            }
        } else if (campoHemog != null && !campoHemog.trim().isEmpty()) {
            this.exame_atual.put(campoHemog, resultado);
            if (flags != null && !flags.trim().isEmpty()) {
                this.exame_atual.put("flag_alerta", flags);
            }
        } else if (!Funcoes.textoVazio(campoFlag) && (tipo = exameCamposByFlag.get(campoFlag.toUpperCase())) != null) {
            this.flagsExame.add(new Flag(tipo, campoFlag, resultado));
        }
    }

    @Override
    public void recordFound(String record) throws Exception {
        String record_type = ASTMStandard.getRecordTypeIdentifier(record);
        if (record_type != null) {
            if (record_type.equals(ASTMStandard.RECORD_TYPE_HEADER)) {
                this.trataHeaderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_PATIENT)) {
                this.trataPatientRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_ORDER)) {
                this.trataOrderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_RESULT)) {
                this.trataResultRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_COMMENT)) {
                this.trataCommentRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_REQUEST)) {
                this.trataRequestRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_TERMINATION)) {
                this.trataTerminationRecord();
                return;
            }
        }
    }

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
        }
        HashMap exame_atual = new HashMap();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
        if (req_codigo.contains("^")) {
            req_codigo = req_codigo.substring(0, req_codigo.indexOf("^"));
        }
        if (req_codigo == null || req_codigo.equals("")) {
            req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        Map<Integer, String> components = this.equip.parseOrderTestIDField((String)order_fields.get(ASTMStandard.ORDER_FIELD_TEST_ID));
        String emi_alternativo = components.get(this.equip.TEST_ITEM_NUMBER);
        Statement st = Conexao.getStatement();
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (int_codigo == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            exame_atual = null;
            return;
        }
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        exame_atual.put(INT_CODIGO, int_codigo);
        exame_atual.put(FIL_CODIGO, fil_codigo);
        exame_atual.put(REC_CODIGO, rec_codigo);
        exame_atual.put(REQ_CODIGO, req_codigo);
        exame_atual.put(EXA_ALTERNATIVO, emi_alternativo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            exame_atual = null;
            return;
        }
        exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
        this.exame_atual = new HashMap(exame_atual);
    }

    private String parseCampoHemograma(String campo) {
        String testId = campo.substring(campo.lastIndexOf("^") + 1);
        return exameCamposByTestId.get(testId);
    }

    private String parseCampoFlag(String campo) {
        String campoFlag = campo.substring(campo.lastIndexOf("^") + 1);
        return campoFlag;
    }

    @Override
    protected void trataRequestRecord(String record) throws Exception {
        Hashtable comps = ASTMStandard.parseDefaultRequestRecord(record);
        this.starting_range = (String)comps.get(ASTMStandard.REQUEST_FIELD_STARTING_RANGE_ID);
        this.ending_range = (String)comps.get(ASTMStandard.REQUEST_FIELD_ENDING_RANGE_ID);
        this.test_id = (String)comps.get(ASTMStandard.REQUEST_FIELD_TEST_ID);
        this.modoHostQuery = true;
    }

    @Override
    protected void trataTerminationRecord() throws Exception {
        if (this.modoHostQuery) {
            this.equip.responderRequest(this.starting_range, this.ending_range, this.test_id);
            this.modoHostQuery = false;
            return;
        }
        if (this.exame_atual == null) {
            return;
        }
        this.salvaExame(this.exame_atual);
        this.exame_atual = null;
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String[] codigoJalis;
        String fil_codigo = (String)dados.remove(FIL_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String req_codigo = (String)dados.remove(REQ_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        String rec_codigo = (String)dados.remove(REC_CODIGO);
        String emiAlternativo = (String)dados.remove(EXA_ALTERNATIVO);
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        Statement st = Conexao.getStatement();
        ArrayList<String> flags = null;
        if (!this.flagsExame.isEmpty()) {
            this.ordenaFlagsPeloTipo();
            flags = new ArrayList<String>();
            Integer tipo = this.flagsExame.get((int)0).tipo;
            flags.add(this.tiposFlag[tipo]);
            for (Flag flag : this.flagsExame) {
                if (!flag.tipo.equals(tipo)) {
                    tipo = flag.tipo;
                    int last = flags.size() - 1;
                    flags.set(last, (String)flags.get(last) + "                      ");
                    flags.add(this.tiposFlag[tipo]);
                }
                flags.add(String.format("%s = %s", flag.id, flag.valor));
            }
            this.flagsExame.clear();
        }
        if (this.exr_codigoapoiado && !Funcoes.textoVazio((codigoJalis = BDUtil.getCodigoJalis(fil_codigo, req_codigo, rec_codigo, int_codigo, exa_codigo, mco_codigo))[0]) && !Funcoes.textoVazio(codigoJalis[1]) && !Funcoes.textoVazio(codigoJalis[2])) {
            fil_codigo = codigoJalis[0];
            req_codigo = codigoJalis[1];
            rec_codigo = codigoJalis[2];
        }
        List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
        for (BDExame exame : exames) {
            String alternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exame.getExame(), exame.getMaterial(), int_codigo);
            if (Funcoes.textoVazio(emiAlternativo) || Funcoes.textoVazio(alternativo) || !alternativo.equalsIgnoreCase(emiAlternativo)) continue;
            this.equip.atualizarDadosExame(st, fil_codigo, exame.getRequisicao(), exame.getRecipiente(), exame.getExame(), exame.getMaterial(), int_codigo, dados, flags);
        }
    }

    private void ordenaFlagsPeloTipo() {
        Collections.sort(this.flagsExame, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof Flag && o2 instanceof Flag) {
                    return ((Flag)o1).tipo.toString().compareTo(((Flag)o2).tipo.toString());
                }
                return 0;
            }
        });
    }

    static {
        exameCamposByTestId.put("WBC", "leucocitos");
        exameCamposByTestId.put("NEU", "neutrofilo_contagem");
        exameCamposByTestId.put("LYM", "linfocitos_atipicos_contagem");
        exameCamposByTestId.put("MONO", "monocitos_contagem");
        exameCamposByTestId.put("EOS", "eosinofilos_contagem");
        exameCamposByTestId.put("BASO", "basofilos_contagem");
        exameCamposByTestId.put("RBC", "hemacias");
        exameCamposByTestId.put("HGB", "hgb");
        exameCamposByTestId.put("HCT", "hct");
        exameCamposByTestId.put("MCV", "vcm");
        exameCamposByTestId.put("MCH", "hcm");
        exameCamposByTestId.put("MCHC", "chcm");
        exameCamposByTestId.put("RDW", "rdw");
        exameCamposByTestId.put("PLT", "plaquetas");
        exameCamposByTestId.put("MPV", "vpm");
        exameCamposByTestId.put("PCT", "pct");
        exameCamposByTestId.put("PDW", "pdw");
        exameCamposByTestId.put("%N", "neutrofilo_percentual");
        exameCamposByTestId.put("%L", "linfocitos_tipicos_percentual");
        exameCamposByTestId.put("%M", "monocitos_percentual");
        exameCamposByTestId.put("%E", "eosinofilos_percentual");
        exameCamposByTestId.put("%B", "basofilos_percentual");
        exameCamposByTestId.put("%R", "reticulocitos_percentual");
        exameCamposByTestId.put("RETC", "reticulocitos_contagem");
        exameCamposByFlag = new HashMap<String, Integer>();
        exameCamposByFlag.put("WBC", 0);
        exameCamposByFlag.put("DFLT(N)", 0);
        exameCamposByFlag.put("DFLT(L)", 0);
        exameCamposByFlag.put("DFLT(M)", 0);
        exameCamposByFlag.put("DFLT(E)", 0);
        exameCamposByFlag.put("DFLT(B)", 0);
        exameCamposByFlag.put("MCHC", 0);
        exameCamposByFlag.put("LRI", 0);
        exameCamposByFlag.put("URI", 0);
        exameCamposByFlag.put("FRAGILE RBC", 0);
        exameCamposByFlag.put("TOO FEW EVENTS", 0);
        exameCamposByFlag.put("ERL", 0);
        exameCamposByFlag.put("BAND", 1);
        exameCamposByFlag.put("IG", 1);
        exameCamposByFlag.put("BLAST", 1);
        exameCamposByFlag.put("VAR LYM", 1);
        exameCamposByFlag.put("FWBC", 1);
        exameCamposByFlag.put("NWBC", 1);
        exameCamposByFlag.put("NRBC", 1);
        exameCamposByFlag.put("RRBC", 1);
        exameCamposByFlag.put("RBC MORPH", 1);
        exameCamposByFlag.put("ATYP DEP", 1);
        exameCamposByFlag.put("SAMPLING ERROR", 2);
        exameCamposByFlag.put("WOC FLOW ERROR", 2);
        exameCamposByFlag.put("NOC FLOW ERROR", 2);
        exameCamposByFlag.put("RBC FLOW ERROR", 2);
        exameCamposByFlag.put("RETC FLOW ERROR", 2);
        exameCamposByFlag.put("WOC HEATER ERROR", 2);
        exameCamposByFlag.put("HGB HEATER ERROR", 2);
    }
}

