/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cdruby;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.cdruby.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceASTMListener {
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;
    protected boolean hostQuery = false;
    boolean exr_codigoapoiado = false;
    private ThreadRecebimento threadRecebimento = null;

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        Statement st = Conexao.getStatement();
        this.exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
        this.threadRecebimento = new ThreadRecebimento(this);
        this.threadRecebimento.setPriority(10);
        this.threadRecebimento.start();
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (!this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento(this);
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        this.threadRecebimento.start();
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            if (this.exr_codigoapoiado && rackposition != null && rackposition.length() == 12) {
                codigo.setLength(0);
                codigo.append(rackposition);
            }
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            alternativos = this.pegaAlternativoUnico(alternativos);
            String nome = null;
            String sobrenome = short_name;
            this.tx_list.add("H|\\^&||||||||||P|LIS2-A\r");
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String patient_id = req_codigo;
            String laboratory_pid = null;
            String pac_nascimento = "";
            String med_nome = "";
            String[] idadeNasc = BDUtil.getIdadeNacimentoPaciente(fil_codigo, req_codigo);
            if (idadeNasc[2] != null && !idadeNasc[2].trim().isEmpty()) {
                Date nascimento = Funcoes.stringToDate(idadeNasc[2]);
                pac_nascimento = Funcoes.formataData("yyyyMMdd", nascimento);
            } else if (idadeNasc[0] != null && !idadeNasc[0].trim().isEmpty() && idadeNasc[1] != null) {
                Date dataReq = Funcoes.stringToDate("dd/MM/yyyy", this.req_data);
                int calendarField = idadeNasc[1].equalsIgnoreCase("A") ? 1 : (idadeNasc[1].equalsIgnoreCase("M") ? 2 : 5);
                GregorianCalendar nascimento = new GregorianCalendar();
                nascimento.setTime(dataReq);
                ((Calendar)nascimento).add(calendarField, -Integer.parseInt(idadeNasc[0]));
                pac_nascimento = Funcoes.formataData("yyyyMMdd", nascimento.getTime());
            }
            med_nome = BDUtil.buscaMedicoRequisicao(fil_codigo, req_codigo);
            if (med_nome.length() > 22) {
                med_nome = med_nome.substring(0, 22);
            }
            this.tx_list.add(ASTMStandard.getDefaultPatientRecord(1, patient_id, laboratory_pid, nome, sobrenome, pac_sexo, pac_nascimento, med_nome));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro do paciente");
            }
            this.tx_list.add(this.getDefaultOrderRecord(1, codigo.toString(), alternativos, exa_lista, null, "R", acao, tipo_amostra, "O"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
            }
            this.tx_list.add("L|1|N\r");
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private ExameMaterial[] pegaAlternativoUnico(ExameMaterial[] alternativos) {
        if (alternativos != null && alternativos.length > 1) {
            ExameMaterial[] tmp = new ExameMaterial[1];
            for (ExameMaterial exameMaterial : alternativos) {
                if (!exameMaterial.getNomeExame().equalsIgnoreCase("CBC")) continue;
                tmp[0] = exameMaterial;
            }
            alternativos = tmp;
        }
        return alternativos;
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
            }
            if (!(message = this.getPortaCOM().removeInputString(this.getMsgEnd())).equals("")) {
                if (this.validaMensagemQuery(message)) {
                    String string = this.parse(message);
                } else {
                    this.addListaRecebimento(message);
                    this.restartThreadRecebimento();
                }
                this.getPortaCOM().write(String.valueOf('\u0006'));
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private boolean validaMensagemQuery(String message) {
        String[] messages = message.split(String.valueOf('\r'));
        return messages != null && messages.length > 3 && messages[1].startsWith("Q");
    }

    public String getDefaultOrderRecord(int order_sequence, String sample_id, ExameMaterial[] test_item_numbers, ExameMaterial[] test_item_names, String dilution, String priority, String action_code, String sample_type, String report_type) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("||");
        if (test_item_numbers != null && test_item_numbers[0] != null) {
            for (int i = 0; i < test_item_numbers.length; ++i) {
                if (test_item_numbers[i] == null) continue;
                if (i > 0) {
                    record.append("\\");
                }
                record.append("^^^");
                record.append(Funcoes.textoVazio(test_item_numbers[i].getNomeExame()) ? "CBC" : test_item_numbers[i].getNomeExame());
                record.append("^4");
                record.append(dilution == null ? "" : "^" + dilution);
            }
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("||||||");
        record.append(action_code == null ? "" : action_code);
        record.append("||||");
        record.append(sample_type == null ? "" : sample_type);
        record.append("||||||||||");
        record.append(report_type == null ? "" : report_type);
        record.append("|");
        record.append('\r');
        return record.toString();
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(1, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size()) {
                    message = (String)this.rx_list.get(this.rx_list.getUltimoInserido()) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                this.rx_list.add(message);
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                while (!this.rx_list.isEmpty()) {
                    String[] records;
                    String recordsString = (String)this.rx_list.remove(0);
                    recordsString = recordsString.substring(1, recordsString.length() - 1);
                    for (String record : records = recordsString.split("\r")) {
                        if (record.trim().isEmpty()) continue;
                        this.recordParser.recordFound(record);
                    }
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            if (Funcoes.textoVazio(starting_range)) {
                return;
            }
            if ((starting_range = starting_range.substring(1)).length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                return;
            }
            this.host_fil_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboFilial());
            starting_range = starting_range.substring(ParametrosGerais.getDigitosTuboFilial());
            this.host_req_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.host_rec_codigo = starting_range.substring(ParametrosGerais.getDigitosTuboRequisicao());
            this.hostQuery = true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "CellDyn Ruby: Host Query Response");
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery) {
            this.responseHostQuery();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void responseHostQuery() {
        try {
            block16: {
                block15: {
                    fil_codigo = this.host_fil_codigo;
                    req_codigo = this.host_req_codigo;
                    rec_codigo = this.host_rec_codigo;
                    pac_nome = null;
                    pac_sexo = null;
                    pac_idade = null;
                    data = null;
                    hora = null;
                    rack = null;
                    prioridade = null;
                    int_codigo = null;
                    mco_codigo = null;
                    pac_exames = null;
                    acao = "A";
                    req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
                    aba = this.equipamento.getTab(0);
                    if (req != null) {
                        pac_exames = (String)req[aba.getColIndice("Exame")];
                    }
                    if (req == null) {
                        req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                        aba = this.equipamento.getTab(1);
                        if (req != null) {
                            pac_exames = pac_exames + " ";
                            reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                            for (Object[] r : reqs) {
                                pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                            }
                            pac_exames.trim();
                        }
                    }
                    if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                        aba = this.equipamento.getTab(2);
                        if (req != null) {
                            pac_exames = pac_exames + " ";
                            reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                            for (Object[] r : reqs) {
                                pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                            }
                            pac_exames.trim();
                        }
                    }
                    if (req == null) break block15;
                    if (this.exr_codigoapoiado) {
                        if (req[aba.getColIndice("Cod. Apoiado")] != null) {
                            if (!Funcoes.textoVazio((String)req[aba.getColIndice("Cod. Apoiado")])) {
                                requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
                                if (ParametrosGerais.isAgruparGuiasInterface()) {
                                    requisicao = (String)req[aba.getColIndice("Multiguia")];
                                }
                                filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
                                requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
                                tubo = (String)req[aba.getColIndice("Tubo")];
                                tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
                                fil_codigo = filial;
                                req_codigo = requisicao;
                                rec_codigo = tubo;
                            }
                        }
                    }
                    pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                    pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                    data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                    v0 = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : (hora = null);
                    if (this.exr_codigoapoiado) ** GOTO lbl-1000
                    if (req[aba.getColIndice("Cod. Apoiado")] == null) ** GOTO lbl-1000
                    if (!Funcoes.textoVazio((String)req[aba.getColIndice("Cod. Apoiado")])) {
                        rack = aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null;
                    } else lbl-1000:
                    // 3 sources

                    {
                        rack = (String)req[aba.getColIndice("Cod. Apoiado")];
                    }
                    int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                    break block16;
                }
                return;
            }
            mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
            this.hostQuery = false;
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
            this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "CellDyn Ruby: Host Query Response");
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
            Statement st = Conexao.getStatement();
            if (this.exames != null) {
                for (int i = 0; i < this.exames.length; ++i) {
                    int situacao;
                    if (!Funcoes.textoVazio(this.rec_tuboPai) && this.curva && !this.examesFilho.isEmpty()) {
                        for (String exame : this.examesFilho) {
                            int situacao2 = BDUtil.getDesmSituacao(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai, exame, this.mco_codigo);
                            BDUtil.setExmSituacaoFilho(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, exame, this.mco_codigo, this.rec_tuboPai, situacao2 < 2 ? 1 : 3);
                        }
                        situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                        if (!BDUtil.isGrupoInteiroPendente(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai)) continue;
                        this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_tuboPai, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    if (!this.examesFilho.isEmpty()) {
                        situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                        this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                        BDUtil.setExmSituacaoTodosFilhos(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                    this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
                this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
            } else {
                this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
            }
        }
        this.interromperTimer();
        this.getPortaCOM().write(String.valueOf('\u0004'));
        this.getPortaCOM().clearInputString();
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.limpaDadosRequisicao();
        this.setIdle();
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado", "EOT"}, null);
        if (op == 0) {
            this.query();
        } else if (op == 1) {
            this.confirmacaoACK();
        } else if (op == 2) {
            this.resultado();
        } else if (op == 3) {
            this.finalizaTransmissao();
        }
    }

    private void query() {
        String idAmostra = JOptionPane.showInputDialog(null, "Informe o Id da amostra?", "01000");
        if (Funcoes.textoVazio(idAmostra)) {
            return;
        }
        StringBuilder tmp = new StringBuilder();
        tmp.append("[STX]1H|\\^&|||[SP][SP]36830BG^CDRuby^2.0ML^1.0|||||||P|LIS2-A[CR]");
        tmp.append("Q|1|^").append(idAmostra).append("[CR]");
        tmp.append("L|1|N[CR]");
        tmp.append("[ETX]05[LINE]");
        this.parse(this.equipamento.arruma(tmp.toString()));
    }

    private void finalizaTransmissao() {
        this.handShakeCharReceived('\u0004');
    }

    private void resultado() {
        String idAmostra = JOptionPane.showInputDialog(null, "Informe o Id da amostra?", "01000");
        if (Funcoes.textoVazio(idAmostra)) {
            return;
        }
        String alternativo = JOptionPane.showInputDialog(null, "Informe o  alternativo do exame?", "CBC");
        if (Funcoes.textoVazio(alternativo)) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("[STX]1H|\\^&|||[SP][SP]36001BG^CDRuby^2.2[SP]ML^1.0|||||||P|LIS2-A[CR]");
        buf.append("P|1||||DONIZETI[SP]DA[SP]MOTA[SP]LOP||19780915|M|||||Paulo[SP]Sergio[SP]Hussne[SP]Ca||^[CR]");
        buf.append("O|1|").append(idAmostra).append("|4642|^^^").append(alternativo).append("^4^2|||||||||||Patient^||||||||||F[CR]");
        buf.append("R|1|^^^CBC^^^WBC|7.27|||||W||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|2|^^^CBC^^^NEU|4.44|||||W||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|3|^^^CBC^^^LYM|2.26|||||W||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|4|^^^CBC^^^MONO|.415|||||W||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|5|^^^CBC^^^EOS|.045|||||W||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|6|^^^CBC^^^BASO|.112|||||W||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|7|^^^CBC^^^RBC|5.95|||||F||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|8|^^^CBC^^^HGB|17.6|||||F||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|9|^^^CBC^^^HCT|54.1|||||F||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|10|^^^CBC^^^MCV|91.0|||||F||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|11|^^^CBC^^^MCH|29.5|||||F||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|12|^^^CBC^^^MCHC|32.5|||||F||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|13|^^^CBC^^^RDW|10.9|||||F||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|14|^^^CBC^^^PLT|178.|||||F||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|15|^^^CBC^^^MPV|10.3|||||F||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|16|^^^CBC^^^PCT|.184|||||F||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|17|^^^CBC^^^PDW|20.6|||||F||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|18|^^^CBC^^^%N|61.1|||||W||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|19|^^^CBC^^^%L|31.1|||||W||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|20|^^^CBC^^^%M|5.71|||||W||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|21|^^^CBC^^^%E|.620|||||W||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|22|^^^CBC^^^%B|1.53|||||W||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|23|^^^CBC^^^DFLT(N)|FLAG|||||||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|24|^^^CBC^^^DFLT(E)|FLAG|||||||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|25|^^^CBC^^^DFLT(L)|FLAG|||||||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|26|^^^CBC^^^DFLT(M)|FLAG|||||||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|27|^^^CBC^^^DFLT(B)|FLAG|||||||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|28|^^^CBC^^^WBC|FLAG|||||||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|29|^^^CBC^^^NRBC|FLAG|||||||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("R|30|^^^CBC^^^RRBC|FLAG|||||||Admin|20220512100205||[SP][SP]36001BG[CR]");
        buf.append("L|1|N[CR]");
        buf.append("[ETX]69[LINE]");
        this.parse(this.equipamento.arruma(buf.toString()));
    }

    private void confirmacaoACK() {
        this.handShakeCharReceived('\u0006');
    }
}

