/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cdemerald;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    public static final int EQUIP_TIMEOUT = 5000;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    private String restoMsgAnterior = "";
    private static final String FRAME_HEADER = "FRAME HEADER";
    private static final String FRAME_CONNECT = "CONNECT";
    private static final String FRAME_ACK_CONNECT = "ACK_CONNECT";
    private static final String FRAME_NAK_CONNECT = "NAK_CONNECT";
    private static final String FRAME_RESULT_READY = "RESULT_READY";
    private static final String FRAME_RESULT = "RESULT";
    private static final String FRAME_ACK_RESULT_READY = "ACK_RESULT_READY";
    private static final String FRAME_ACK_RESULT = "ACK_RESULT;OK";
    private static final String FRAME_CALIBRATION = "CALIBRATION";
    private static final String FRAME_ACK_CALI = "ACK_CALI";
    private static final String FRAME_END_CALI = "END_CALI";
    private static final String TOKEN_MSG_BEGIN = String.format("%s%s", "FRAME HEADER", String.valueOf('\r'));
    private static final String TOKEN_MSG_END = "END_RESULT";
    private static final String MODE_NORMAL = "NORMAL";
    private static final String MODE_REPEATABILITY = "REPEATABILITY";
    private static final String MODE_CALIBRATION = "CALIBRATION";
    private static final String MODE_QC = "QC";
    private static final String DATE = "DATE";
    private static final String TIME = "TIME";
    private static final String MODE = "MODE";
    private static final String UNIT = "UNIT";
    private static final String SEQ = "SEQ";
    private static final String SID = "SID";
    private static final String PID = "PID";
    private static final String ID = "ID";
    private static final String TYPE = "TYPE";
    private static final String TEST = "TEST";
    private static final String OPERATOR = "OPERATOR";
    private static final String WBC = "WBC";
    private static final String RBC = "RBC";
    private static final String HGB = "HGB";
    private static final String HCT = "HCT";
    private static final String MCV = "MCV";
    private static final String MCH = "MCH";
    private static final String MCHC = "MCHC";
    private static final String RDW = "RDW";
    private static final String PLT = "PLT";
    private static final String MPV = "MPV";
    private static final String LYM_PER = "LYM%";
    private static final String MID_PER = "MID%";
    private static final String GRA_PER = "GRA%";
    private static final String LYM_ABS = "LYM";
    private static final String MID_ABS = "MID";
    private static final String GRA_ABS = "GRA";
    private static final String WBC_CURVE = "WBC CURVE";
    private static final String WBC_THRESHOLDS = "WBC THRESHOLDS ";
    private static final String RBC_CURVE = "RBC CURVE";
    private static final String RBC_THRESHOLDS = "RBC THRESHOLDS";
    private static final String PLT_CURVE = "PLT CURVE";
    private static final String PLT_THRESHOLDS = "PLT THRESHOLDS";
    private static final String ALARMS = "ALARMS";
    private static final String INTERPRETIVE_WBC = "INTERPRETIVE_WBC";
    private static final String INTERPRETIVE_RBC = "INTERPRETIVE_RBC";
    private static final String INTERPRETIVE_PLT = "INTERPRETIVE_PLT";
    private static final String COMMENT = "COMMENT";
    private Map<String, String> parametros = new HashMap<String, String>();

    public InterfaceListener() {
        this.parametros.put(WBC, "leucocitos");
        this.parametros.put(RBC, "hemacias");
        this.parametros.put(HGB, "hgb");
        this.parametros.put(HCT, "hct");
        this.parametros.put(MCV, "celulas_media_contagem");
        this.parametros.put(MCH, "hcm");
        this.parametros.put(MCHC, "mchc");
        this.parametros.put(RDW, "rdw");
        this.parametros.put(PLT, "plaquetas");
        this.parametros.put(MPV, "vpm");
        this.parametros.put(LYM_PER, "linfocitos_tipicos_percentual");
        this.parametros.put(MID_PER, "mr");
        this.parametros.put(GRA_PER, "granulocitos_percentual");
        this.parametros.put(LYM_ABS, "linfocitos_tipicos_contagem");
        this.parametros.put(MID_ABS, "ma");
        this.parametros.put(GRA_ABS, "granulocitos_contagem");
    }

    @Override
    public void dataChanged() {
        try {
            String msg = this.getPortaCOM().getInputString();
            String frame = this.getFrameId(msg);
            if (frame.startsWith(FRAME_CONNECT) && msg.endsWith(String.valueOf('\r'))) {
                Map<String, String[]> fields = this.getFields(msg);
                if (fields.containsKey(FRAME_CONNECT) && fields.get(FRAME_CONNECT).length == 2) {
                    String reply = String.format("%s;%s", FRAME_ACK_CONNECT, fields.get(FRAME_CONNECT)[1]);
                    this.getPortaCOM().clearInputString();
                    this.getPortaCOM().write(reply);
                }
            } else if (frame.startsWith(FRAME_RESULT_READY)) {
                String reply = String.format("%s;%s", FRAME_ACK_RESULT_READY, String.valueOf('\r'));
                this.getPortaCOM().clearInputString();
                this.getPortaCOM().write(reply);
            } else if (frame.startsWith(FRAME_RESULT)) {
                String msgEnd = this.validaFinalMsg(msg);
                if (!Funcoes.textoVazio(msgEnd)) {
                    if (this.checksum(msgEnd)) {
                        String message = this.getPortaCOM().removeInputString(msgEnd);
                        Map<String, String[]> fields = this.getFields(message);
                        if (fields.containsKey(MODE) && fields.get(MODE).length > 0 && (fields.get(MODE)[0].trim().equalsIgnoreCase(MODE_NORMAL) || fields.get(MODE)[0].trim().equalsIgnoreCase(MODE_REPEATABILITY))) {
                            this.addListaRecebimento(message);
                            this.restartThreadRecebimento();
                        }
                        this.getPortaCOM().write(String.format("%s%s", FRAME_ACK_RESULT, String.valueOf('\r')));
                    }
                    if (this.isRX()) {
                        this.aguardarProximoFrame();
                    }
                } else if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (!frame.startsWith("CALIBRATION") && this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private String getFrameId(String msg) {
        int p1 = msg.indexOf(13);
        int p2 = msg.indexOf(13, p1 + 1);
        if (p1 > 0 && p1 < p2) {
            return msg.substring(p1 + 1, p2);
        }
        return "";
    }

    private String validaFinalMsg(String message) {
        String bufferMessage;
        String ret = "";
        StringBuilder bui = new StringBuilder();
        boolean endBlock = false;
        String endMsg = new StringBuilder(this.getMsgEnd()).reverse().toString();
        for (int i = message.length() - 1; i > 0; --i) {
            bui.append(message.charAt(i));
            if (!bui.toString().contains(endMsg)) continue;
            endBlock = true;
            break;
        }
        if (!endBlock) {
            return ret;
        }
        bui.reverse();
        int pos = bui.indexOf(this.getMsgEnd()) + this.getMsgEnd().length();
        if (pos > bui.length()) {
            pos = bui.length();
        }
        if (!(bufferMessage = bui.substring(0, pos)).contains(this.getMsgEnd())) {
            return ret;
        }
        String check = bufferMessage.substring(bufferMessage.indexOf(this.getMsgEnd()) + this.getMsgEnd().length());
        ret = bui.substring(0, bui.indexOf(String.valueOf('\r')) + 1);
        return ret;
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public String getMsgEnd() {
        return TOKEN_MSG_END;
    }

    @Override
    public String getMsgStart() {
        return TOKEN_MSG_BEGIN;
    }

    @Override
    public String parse(String message) {
        Map<String, String[]> fields = this.getFields(message);
        String retorno = null;
        if (!fields.isEmpty()) {
            try {
                retorno = this.parseResults(fields);
                return retorno;
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                    return "Erro ao inserir resultados recebidos ao banco de dados";
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    return "Erro ao inserir resultados recebidos ao banco de dados";
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.toString() + "\n" + e.getMessage(), e.getStackTrace());
                return "Erro ao realizar parse dos dados recebidos";
            }
        }
        return null;
    }

    private Map<String, String[]> getFields(String message) {
        HashMap<String, String[]> fields = new HashMap<String, String[]>();
        StringTokenizer stk = new StringTokenizer(message, String.valueOf('\r'));
        while (stk.hasMoreElements()) {
            String[] elements = ((String)stk.nextElement()).split(";");
            if (elements.length <= 0) continue;
            fields.put(elements[0], ArraysUtil.remover(elements, 0));
        }
        return fields;
    }

    private String parseResults(Map<String, String[]> fields) throws SQLException, Exception {
        boolean repeticao = false;
        String id = "";
        if (fields.containsKey(ID) && fields.get(ID).length > 0 && !Funcoes.textoVazio(fields.get(ID)[0])) {
            id = fields.get(ID)[0];
        }
        if (!Funcoes.isNumeric(id)) {
            id = fields.get(SID)[0];
        }
        if (Funcoes.textoVazio(id) || id.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            id = fields.get(SID)[0];
        }
        if (Funcoes.textoVazio(id) || id.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo() || !Funcoes.isNumeric(id)) {
            this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + id);
            return null;
        }
        if (!fields.containsKey(TEST) || fields.get(TEST).length <= 0) {
            this.fireExcecaoEncontrada(String.format("Resultados recebidos para requisi\u00e7\u00e3o %s sem o alternativo", id));
            return null;
        }
        String emi_alternativo = fields.get(TEST)[0];
        String fil_codigo = id.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = id.substring(id.length() - ParametrosGerais.getDigitosTuboTubo());
        String req_codigo = id.substring(ParametrosGerais.getDigitosTuboFilial(), id.length() - ParametrosGerais.getDigitosTuboTubo());
        String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        Statement st = Conexao.getStatement();
        ExameMaterial exameLis = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (int_codigo == null && exameLis != null) {
            int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, emi_alternativo, exameLis.getCodigoMaterial(), rec_codigo);
            StringBuilder s = new StringBuilder();
            s.append("N\u00e3o foi poss\u00edvel encontrar o exame! O exame encontra-se ");
            if (situacao == 8) {
                s.append("exportado!");
            } else {
                s.append("sem situa\u00e7\u00e3o!");
            }
            s.append("(").append(id).append(")");
            this.fireExcecaoEncontrada(s.toString());
            return null;
        }
        if (exameLis == null) {
            this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o n\u00e3o interfaceada ou j\u00e1 se encontra com situa\u00e7\u00e3o de pronto %s ", id));
            return null;
        }
        int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exameLis.getNomeExame(), exameLis.getCodigoMaterial(), rec_codigo);
        if ((situacao == 1 || situacao == 0) && repeticao) {
            this.fireExcecaoEncontrada("Resultado retornado pelo equipamento \u00e9 uma repeti\u00e7\u00e3o mas o exame ainda n\u00e3o recebeu o resultado normal");
            return null;
        }
        HashMap<String, Object> hemograma = new HashMap<String, Object>();
        for (String key : fields.keySet()) {
            this.parseParameter(fields, hemograma, key, this.parametros.get(key));
        }
        List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
        for (BDExame exame : exames) {
            this.atualizarDadosExame(st, fil_codigo, exame.getRequisicao(), exame.getRecipiente(), exame.getExame(), exame.getMaterial(), int_codigo, hemograma);
        }
        Conexao.arquivaSQL();
        return "";
    }

    private void parseParameter(Map<String, String[]> fields, Map<String, Object> hemograma, String parametroInterface, String parametroJalis) {
        if (fields.containsKey(parametroInterface) && fields.get(parametroInterface).length > 0 && !Funcoes.textoVazio(fields.get(parametroInterface)[0])) {
            hemograma.put(parametroJalis, fields.get(parametroInterface)[0].replace('.', ',').trim());
        }
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(5000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    public boolean checksum(String bufferMessage) {
        return true;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            String[] exms;
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            String[] stringArray = exms = exames.split(" ", 0);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String s;
                int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, s = stringArray[i], mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, s, mco_codigo, int_codigo, null, situacao < 2 ? 1 : 5);
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            this.equipamento.atualizarTabela(0);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return "";
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

