/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cd3700;

import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoFactory;
import jalis.laboratorio.interfaceamento.interfaces.cd3700.CD3700;
import jalis.laboratorio.interfaceamento.util.Checksum;
import jalis.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFrame;

public class InterfaceamentoFactory
implements AbstractInterfaceamentoFactory {
    @Override
    public AbstractInterfaceamento getInterfaceamento(JFrame parent) {
        return new CD3700(parent);
    }

    @Override
    public String getNomeInterfaceamento() {
        return "Abbott Cell-Dyn 3700";
    }

    @Override
    public String getEnvioRequisicao() {
        String fil_codigo = "01";
        String req_codigo = "23456789";
        String rec_codigo = "10";
        String pac_nome = "Paciente Thread Teste";
        int max_patient_name_chars = 16;
        char ETX = '\u0003';
        char STX = '\u0002';
        fil_codigo = StringUtil.preencheString(fil_codigo, 2, '0', 1);
        StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
        rec_codigo = StringUtil.preencheString(rec_codigo, 2, '0', 1);
        codigo.append(rec_codigo);
        pac_nome = StringUtil.removerAcentos(pac_nome.length() > max_patient_name_chars ? pac_nome.substring(0, max_patient_name_chars) : StringUtil.preencheString(pac_nome, max_patient_name_chars, ' ', 0));
        String bar_code = new SimpleDateFormat("HHmm").format(new Date(System.currentTimeMillis()));
        StringBuilder worklist = new StringBuilder("\"").append(bar_code).append("\",\"");
        worklist.append(codigo.toString()).append("\",\"").append(pac_nome).append("\",").append("0,0,");
        String checksum = Checksum.getChecksumMod256(worklist.toString());
        worklist = new StringBuilder(String.valueOf(STX)).append((CharSequence)worklist).append(checksum).append(String.valueOf(ETX));
        return worklist.toString();
    }

    @Override
    public String getRetornoRequisicao() {
        return "";
    }

    @Override
    public String getSerialInfo() {
        return "/jalis/laboratorio/interfaceamento/ajuda/celldyn3500.html";
    }

    @Override
    public int getTipoComunicacao() {
        return 0;
    }
}

