/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cd3700;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.Checksum;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.cd3500.InterfaceListener {
    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        this.fil_codigo = fil_codigo;
        this.int_codigo = int_codigo;
        this.req_codigo = req_codigo;
        this.pac_nome = pac_nome;
        this.pac_sexo = pac_sexo;
        this.req_idade = pac_idade;
        this.req_data = data;
        this.req_hora = hora;
        this.mco_codigo = mco_codigo;
        this.rec_codigo = rec_codigo;
        this.pac_exames = exames;
        this.acao = acao;
        try {
            if (this.configuracao.getModoUnidirecional()) {
                this.encerrarTransmissao();
                return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            if (codigo.length() < 12) {
                int digitos = 12 - codigo.length();
                codigo.append(StringUtil.repeteCaractere(' ', digitos));
            }
            pac_nome = StringUtil.removerAcentos(pac_nome.length() > this.MAX_PATIENT_NAME_CHARS ? pac_nome.substring(0, this.MAX_PATIENT_NAME_CHARS) : StringUtil.preencheString(pac_nome, this.MAX_PATIENT_NAME_CHARS, ' ', 0));
            String bar_code = new SimpleDateFormat("HHmm").format(new Date(System.currentTimeMillis()));
            String medico = BDUtil.buscaMedicoRequisicao(fil_codigo, req_codigo) + StringUtil.repeteCaractere(' ', 22);
            String[] idade = BDUtil.getIdadeNacimentoPaciente(fil_codigo, req_codigo);
            String dataNasc = "--/--/--";
            if (idade != null && idade.length == 3) {
                if (!Funcoes.textoVazio(idade[2])) {
                    dataNasc = idade[2];
                }
                if (!Funcoes.textoVazio(dataNasc) && dataNasc.trim().length() == 10) {
                    dataNasc = Funcoes.formataData("MM/dd/yy", Funcoes.stringToDate("dd/MM/yyyy", dataNasc));
                }
            }
            StringBuilder worklist = new StringBuilder();
            worklist.append("\"").append("----").append("\",");
            worklist.append("\"").append(codigo.toString()).append("\",");
            worklist.append("\"").append(pac_nome).append("\",");
            worklist.append("0,");
            worklist.append("0,");
            worklist.append("\"").append(medico.length() > 22 ? medico.subSequence(0, 22) : medico).append("\",");
            worklist.append("\"").append(dataNasc).append("\",");
            String checksum = Checksum.getChecksumMod256(worklist.toString());
            worklist = new StringBuilder(this.getMsgStart()).append((CharSequence)worklist).append(checksum).append(this.getMsgEnd());
            this.frame = worklist.toString();
            this.setTX(5000);
            this.tx_counter = 0;
            this.getPortaCOM().write(worklist.toString());
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }
}

