/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cd3500;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.configuracao.EquipamentoFilial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.cd3500.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.Checksum;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private String NOME_EXAME = "HEMOG";
    protected int MAX_PATIENT_NAME_CHARS = 16;
    public static final int EQUIP_TIMEOUT = 5000;
    public static final int MAX_TENTATIVAS = 2;
    public static final int TIPO_REQ_NOVO = 0;
    public static final int TIPO_REQ_REPETICAO = 1;
    protected String int_codigo;
    protected String fil_codigo;
    protected String req_codigo;
    protected String mco_codigo;
    protected String rec_codigo;
    protected String pac_nome;
    protected String pac_exames;
    protected String pac_sexo;
    protected String req_idade;
    protected String req_data;
    protected String req_hora;
    protected String acao;
    protected String frame;
    protected int tx_counter = 0;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    protected InterfaceConfiguracao configuracao = new InterfaceConfiguracao();

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    public String getErroTraduzido(String erro) {
        return erro;
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    void limpaDadosRequisicao() {
        this.frame = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames, acao, null);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao, HashMap<String, String> mapaParametros) {
        if (this.isRX()) {
            return "Aguardando t\u00e9rmino do recebimento de resultado para envio de novos pacientes";
        }
        this.fil_codigo = fil_codigo;
        this.int_codigo = int_codigo;
        this.req_codigo = req_codigo;
        this.pac_nome = pac_nome;
        this.pac_sexo = pac_sexo;
        this.req_idade = pac_idade;
        this.req_data = data;
        this.req_hora = hora;
        this.mco_codigo = mco_codigo;
        this.rec_codigo = rec_codigo;
        this.pac_exames = exames;
        this.acao = acao;
        try {
            if (this.configuracao.getModoUnidirecional()) {
                this.encerrarTransmissao();
                return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            pac_nome = StringUtil.removerAcentos(pac_nome.length() > this.MAX_PATIENT_NAME_CHARS ? pac_nome.substring(0, this.MAX_PATIENT_NAME_CHARS) : StringUtil.preencheString(pac_nome, this.MAX_PATIENT_NAME_CHARS, ' ', 0));
            String bar_code = new SimpleDateFormat("HHmm").format(new Date(System.currentTimeMillis()));
            String medico = BDUtil.buscaMedicoRequisicao(fil_codigo, req_codigo);
            String[] idade = BDUtil.getIdadeNacimentoPaciente(fil_codigo, req_codigo);
            String dataNasc = "--/--/--";
            if (idade != null && idade.length == 3 && !Funcoes.textoVazio(dataNasc = idade[2]) && dataNasc.trim().length() == 10) {
                dataNasc = Funcoes.formataData("MM/dd/yy", Funcoes.stringToDate("dd/MM/yyyy", dataNasc));
            }
            StringBuilder worklist = new StringBuilder();
            worklist.append("\"").append(bar_code).append("\",");
            if (mapaParametros != null && mapaParametros.containsKey("codigoApoiado") && !Funcoes.textoVazio(mapaParametros.get("codigoApoiado"))) {
                worklist.append("\"").append(mapaParametros.get("codigoApoiado")).append("\",");
            } else {
                worklist.append("\"").append(codigo.toString()).append("\",");
            }
            worklist.append("\"").append(pac_nome).append("\",");
            worklist.append("0,");
            worklist.append("0,");
            String checksum = Checksum.getChecksumMod256(worklist.toString());
            worklist = new StringBuilder(this.getMsgStart()).append((CharSequence)worklist).append(checksum).append(this.getMsgEnd());
            this.frame = worklist.toString();
            this.setTX(5000);
            this.tx_counter = 0;
            this.getPortaCOM().write(worklist.toString());
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    public synchronized String parse(String message) {
        String retorno = null;
        String checksum = null;
        if (message.startsWith(this.getMsgStart())) {
            message = message.replaceFirst(this.getMsgStart(), "");
        }
        if (message.endsWith(this.getMsgEnd())) {
            message = message.replaceFirst(this.getMsgEnd(), "");
        }
        try {
            checksum = message.substring(message.length() - 2);
            message = message.substring(0, message.length() - 2);
        }
        catch (StringIndexOutOfBoundsException e) {
            return "Erro ao verificar Checksum. \u00cdndice fora do tamanho do bloco de dados.";
        }
        if (this.checksum(message, checksum)) {
            ArrayList<String> fields = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(message, ",");
            while (tokenizer.hasMoreElements()) {
                fields.add(tokenizer.nextToken());
            }
            if (fields != null && !fields.isEmpty()) {
                try {
                    String test_type = (String)fields.remove(0);
                    test_type = test_type.replaceAll("\"", "");
                    if (test_type.equals("   ")) {
                        retorno = this.parseResults(fields);
                        if (retorno == null) {
                            return "";
                        }
                        if (retorno.startsWith("Erro")) {
                            return retorno;
                        }
                        Conexao.arquivaSQL();
                        RefreshTimer.waitAndRefresh(this, 2000);
                    } else if (test_type.equalsIgnoreCase("WB1")) {
                        retorno = this.parseImagem("WB1", fields);
                        Conexao.arquivaSQL();
                        RefreshTimer.waitAndRefresh(this, 2000);
                    } else if (test_type.equalsIgnoreCase("WB2")) {
                        retorno = this.parseImagem("WB2", fields);
                        Conexao.arquivaSQL();
                        RefreshTimer.waitAndRefresh(this, 2000);
                    } else if (test_type.equalsIgnoreCase("RBC")) {
                        retorno = this.parseImagem("RBC", fields);
                        Conexao.arquivaSQL();
                        RefreshTimer.waitAndRefresh(this, 2000);
                    } else if (test_type.equalsIgnoreCase("PLT")) {
                        retorno = this.parseImagem("PLT", fields);
                        Conexao.arquivaSQL();
                        RefreshTimer.waitAndRefresh(this, 2000);
                    } else if (test_type.equalsIgnoreCase("WIC")) {
                        retorno = this.parseImagem("WIC", fields);
                        Conexao.arquivaSQL();
                        RefreshTimer.waitAndRefresh(this, 2000);
                    } else {
                        return "";
                    }
                    return retorno;
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
                    try {
                        Conexao.anulaSQL();
                        return "Erro ao inserir resultados recebidos ao banco de dados";
                    }
                    catch (SQLException e) {
                        ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                        return "Erro ao inserir resultados recebidos ao banco de dados";
                    }
                }
            }
            return "Erro ao realizar parse dos dados recebidos";
        }
        return "Erro ao receber resultado: CRC Mismatch!";
    }

    private String parseResults(ArrayList<String> fields) throws SQLException {
        try {
            String int_codigo;
            String id;
            String ier_rackpos = fields.remove(0).trim();
            if (this.configuracao.getModoCompatibilidadeCD3000()) {
                fields.remove(0);
                id = fields.remove(0);
                if (id.length() == 1) {
                    id = fields.remove(0);
                }
                id = id.replaceAll("\"", "").trim();
                fields.remove(0);
                fields.remove(0);
            } else {
                fields.remove(0);
                fields.remove(0);
                id = fields.remove(0).replaceAll("\"", "").trim();
                fields.remove(0);
                fields.remove(0);
            }
            String date = fields.remove(0).replaceAll("\"", "");
            String time = fields.remove(0).replaceAll("\"", "");
            try {
                Long.parseLong(id);
            }
            catch (Exception ex) {
                if (id.equals("BACKGROUND")) {
                    return null;
                }
                this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + id);
                return null;
            }
            Statement st = Conexao.getStatement();
            if (id.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + id);
                return null;
            }
            String fil_codigo = id.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = id.substring(id.length() - ParametrosGerais.getDigitosTuboTubo());
            String req_codigo = id.substring(ParametrosGerais.getDigitosTuboFilial(), id.length() - ParametrosGerais.getDigitosTuboTubo());
            DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(id);
            if (etiqueta != null) {
                fil_codigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                req_codigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                rec_codigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
            }
            if ((int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, this.NOME_EXAME)) == null) {
                this.fireExcecaoEncontrada("Interface n\u00e3o localizada para o ID: " + id);
                return null;
            }
            ExameMaterial ex = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, this.NOME_EXAME);
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
            if (ex == null && (exames == null || exames.size() == 0)) {
                this.fireExcecaoEncontrada("Exame n\u00e3o localizado para o ID: " + id);
                return null;
            }
            HashMap<String, Object> hemograma = new HashMap<String, Object>();
            hemograma.put("rack_position", ier_rackpos);
            ArrayList<String> flags = new ArrayList<String>();
            if (this.configuracao.getModoCompatibilidadeCD3000()) {
                String result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 4) + "," + result.substring(4);
                hemograma.put("leucocitos", result);
                result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 4) + "," + result.substring(4);
                hemograma.put("segmentados_contagem", result);
                result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 4) + "," + result.substring(4);
                hemograma.put("linfocitos_tipicos_contagem", result);
                result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 4) + "," + result.substring(4);
                hemograma.put("monocitos_contagem", result);
                result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 4) + "," + result.substring(4);
                hemograma.put("eosinofilos_contagem", result);
                result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 4) + "," + result.substring(4);
                hemograma.put("basofilos_contagem", result);
                result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 3) + "," + result.substring(3);
                hemograma.put("hemacias", result);
                result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 4) + "," + result.substring(4);
                hemograma.put("hgb", result);
                result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 4) + "," + result.substring(4);
                hemograma.put("hct", result);
                result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 4) + "," + result.substring(4);
                hemograma.put("vcm", result);
                result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 4) + "," + result.substring(4);
                hemograma.put("hcm", result);
                result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 4) + "," + result.substring(4);
                hemograma.put("chcm", result);
                result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 4) + "," + result.substring(4);
                hemograma.put("rdw", result);
                result = fields.remove(0).replaceFirst("\\.", ",");
                hemograma.put("plaquetas", result);
                result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 4) + "," + result.substring(4);
                hemograma.put("vpm", result);
                result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 4) + "," + result.substring(4);
                hemograma.put("pct", result);
                result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 4) + "," + result.substring(4);
                hemograma.put("pdw", result);
                result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 4) + "," + result.substring(4);
                hemograma.put("segmentados_percentual", result);
                result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 4) + "," + result.substring(4);
                hemograma.put("linfocitos_tipicos_percentual", result);
                result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 4) + "," + result.substring(4);
                hemograma.put("monocitos_percentual", result);
                result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 4) + "," + result.substring(4);
                hemograma.put("eosinofilos_percentual", result);
                result = fields.remove(0);
                result = result.indexOf(".") >= 0 ? result.replaceFirst("\\.", ",") : result.substring(0, 4) + "," + result.substring(4);
                hemograma.put("basofilos_percentual", result);
                fields.remove(0);
                if (fields.remove(0).equals("1")) {
                    flags.add("Diff");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("Blast");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("Variant Lym");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("DFLT Flag Neutrophil Qualifier");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("DFLT Flag Eosinophil Qualifier");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("DFLT Flag Lymphocyte Qualifier");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("IG");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("Band");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("DFLT Flag Monocyte Qualifier");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("DFLT Flag Basophil Qualifier");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("IG/Bands");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("FWBC");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("WBC count");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("Nucleated RBC");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("NWBC");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("RBC morphology flag");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("RRBC");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("PLT");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("HGB");
                }
                fields.remove(0);
                fields.remove(0);
                if (fields.remove(0).equals("1")) {
                    flags.add("LRI");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("URI");
                }
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                if (fields.remove(0).equals("1")) {
                    flags.add("Metering Fault");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("Sampling error/incomplete aspiration");
                }
            } else {
                hemograma.put("leucocitos", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("segmentados_contagem", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("linfocitos_tipicos_contagem", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("monocitos_contagem", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("eosinofilos_contagem", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("basofilos_contagem", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("hemacias", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("hgb", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("hct", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("vcm", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("hcm", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("chcm", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("rdw", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("plaquetas", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("vpm", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("pct", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("pdw", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("segmentados_percentual", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("linfocitos_tipicos_percentual", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("monocitos_percentual", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("eosinofilos_percentual", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("basofilos_percentual", fields.remove(0).replaceFirst("\\.", ","));
                hemograma.put("promielocitos_contagem", "0");
                hemograma.put("promielocitos_percentual", "0");
                hemograma.put("mielocitos_contagem", "0");
                hemograma.put("mielocitos_percentual", "0");
                hemograma.put("metamielocitos_contagem", "0");
                hemograma.put("metamielocitos_percentual", "0");
                hemograma.put("bastonados_contagem", "0");
                hemograma.put("bastonados_percentual", "0");
                hemograma.put("linfocitos_atipicos_contagem", "0");
                hemograma.put("linfocitos_atipicos_percentual", "0");
                fields.remove(0);
                if (fields.remove(0).equals("1")) {
                    flags.add("DFLT");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("Blast");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("Variant Lymph");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("DFLT Flag Neutrophil Qualifier");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("DFLT Flag Eosinophil Qualifier");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("DFLT Flag Lymphocyte Qualifier");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("IG");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("Band");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("DFLT Flag Monocyte Qualifier");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("DFLT Flag Basophil Qualifier");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("IG/Bands");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("FWBC");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("WBC count");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("Nucleated RBC");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("DLTA");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("NWBC");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("RBC morphology flag");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("RRBC");
                }
                fields.remove(0);
                if (fields.remove(0).equals("1")) {
                    flags.add("Platelet Recount");
                }
                fields.remove(0);
                if (fields.remove(0).equals("1")) {
                    flags.add("LRI");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("URI");
                }
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                fields.remove(0);
                if (fields.remove(0).equals("1")) {
                    flags.add("RBC metering fault");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("WIC metering fault");
                }
                if (fields.remove(0).equals("1")) {
                    flags.add("Sampling error/incomplete aspiration");
                }
            }
            for (BDExame exame : exames) {
                this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getExame(), exame.getMaterial(), int_codigo, hemograma, flags);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }

    @Override
    public void teste() {
    }

    public boolean checksum(String message, String sum) {
        String checksum = Checksum.getChecksumMod256(message);
        return checksum.equals(sum);
    }

    public void encerrarTransmissao() throws Exception {
        if (this.tx_counter < 2) {
            Statement st = Conexao.getStatement();
            this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + this.pac_nome, 0, 10000);
            if (this.acao.equals("N")) {
                this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
            }
        }
        this.interromperTimer();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    private void retransmitirRecusado() throws Exception {
        if (this.tx_counter >= 2) {
            this.encerrarTransmissao();
            return;
        }
        this.setTX(5000);
        this.getPortaCOM().write(this.frame);
        ++this.tx_counter;
    }

    public void requisicaoExistente() throws Exception {
        Statement st = Conexao.getStatement();
        this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
        Conexao.arquivaSQL();
        this.fireMensagemEnviada("Pedido(s) re-enviado(s) com sucesso para " + this.pac_nome + ".", 0, 10000);
        this.interromperTimer();
        this.getPortaCOM().clearInputString();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    public void alertarWorklistFull() throws Exception {
        this.tx_counter = 2;
        this.encerrarTransmissao();
        this.fireMensagemEnviada("Erro: O worklist est\u00e1 cheio ou o c\u00f3digo de barras est\u00e1 desligado.", 1, 5000);
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(5000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    private void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(5000);
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    private void abortarRecepcao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(3000);
    }

    public void caracterNaoEsperado() throws Exception {
    }

    private void tratarAcknowledge() throws Exception {
        if (this.isTX()) {
            this.encerrarTransmissao();
        } else {
            this.caracterNaoEsperado();
        }
    }

    private void tratarNegativeAck() throws Exception {
        if (this.isTX()) {
            this.retransmitirRecusado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    private void tratarCancel() throws Exception {
        if (this.isTX()) {
            this.alertarWorklistFull();
        } else {
            this.caracterNaoEsperado();
        }
    }

    private void tratarDelete() throws Exception {
        if (this.isTX()) {
            this.requisicaoExistente();
        } else {
            this.caracterNaoEsperado();
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0006': {
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0015': {
                    this.tratarNegativeAck();
                    break;
                }
                case '\u0018': {
                    this.tratarCancel();
                    break;
                }
                case '\u007f': {
                    this.tratarDelete();
                    break;
                }
                default: {
                    this.caracterNaoEsperado();
                    break;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento.", 1, 5000);
            this.setIdle();
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!message.equals("")) {
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
                this.getPortaCOM().write(String.valueOf('\u0006'));
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        try {
            if (this.isTX()) {
                this.abortarTransmissao();
            } else if (this.isRX()) {
                if (this.frame != null) {
                    this.abortarRecepcao();
                } else {
                    this.setIdle();
                }
            } else {
                this.setIdle();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    private String parseImagem(String tipo, ArrayList<String> fields) {
        try {
            String ier_rackpos = fields.remove(0).trim();
            fields.remove(0);
            fields.remove(0);
            String id = fields.remove(0).replaceAll("\"", "").trim();
            fields.remove(0);
            fields.remove(0);
            String date = fields.remove(0).replaceAll("\"", "");
            String time = fields.remove(0).replaceAll("\"", "");
            try {
                Long.parseLong(id);
            }
            catch (Exception ex) {
                if (id.equals("BACKGROUND")) {
                    return null;
                }
                this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + id);
                return null;
            }
            Statement st = Conexao.getStatement();
            if (id.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + id);
                return null;
            }
            String fil_codigo = id.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = id.substring(id.length() - ParametrosGerais.getDigitosTuboTubo());
            String req_codigo = id.substring(ParametrosGerais.getDigitosTuboFilial(), id.length() - ParametrosGerais.getDigitosTuboTubo());
            String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, this.NOME_EXAME);
            if (int_codigo == null) {
                for (ConfiguracaoSerial c : Variaveis.equipamentos) {
                    for (EquipamentoFilial f : c.getEquipamentos()) {
                        System.out.println("Buscando para equipamento: " + f.getEquipamento());
                        StringBuilder buf = new StringBuilder();
                        buf.append("select int_codigo from interfaceexamerequisicao ");
                        buf.append("where fil_codigo = ").append(fil_codigo);
                        buf.append("  and int_codigo = ").append(f.getEquipamento());
                        buf.append("  and req_codigo = ").append(req_codigo);
                        buf.append("  and rec_codigo = ").append(rec_codigo);
                        Statement stTemp = Conexao.getStatement();
                        ResultSet rs = Conexao.executeQuery(stTemp, buf.toString());
                        if (rs.next()) {
                            int_codigo = rs.getString("int_codigo");
                        }
                        Conexao.fecharStatement(stTemp);
                        if (int_codigo == null) continue;
                        break;
                    }
                    if (int_codigo == null) continue;
                    break;
                }
                StringBuilder s = new StringBuilder();
                if (int_codigo != null) {
                    int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, this.NOME_EXAME, this.mco_codigo, rec_codigo);
                    s.append("N\u00e3o foi poss\u00edvel encontrar o exame! O exame encontra-se ");
                    if (situacao == 8) {
                        s.append("exportado!");
                    } else {
                        s.append("sem situa\u00e7\u00e3o!");
                    }
                    s.append("(").append(id).append(")");
                    this.fireExcecaoEncontrada(s.toString());
                } else {
                    s.append("Equipamento n\u00e3o localizado para a amostra: ").append(fil_codigo).append(" ").append(req_codigo);
                    this.fireExcecaoEncontrada(s.toString());
                }
                return int_codigo;
            }
            String scaleFactor = fields.remove(0);
            BufferedImage b = this.criarImagem(fields);
            Image i = Toolkit.getDefaultToolkit().createImage(b.getSource());
            String foto64 = new Base64().encodeAsString(ImagemUtils.imageToByte(i));
            HashMap<String, Object> dados = new HashMap<String, Object>();
            if (tipo.equalsIgnoreCase("WB1")) {
                dados.put("celldyn_histograma_wb1", foto64);
            } else if (tipo.equalsIgnoreCase("WB2")) {
                dados.put("celldyn_histograma_wb2", foto64);
            } else if (tipo.equalsIgnoreCase("PLT")) {
                dados.put("celldyn_histograma_plt", foto64);
            } else if (tipo.equalsIgnoreCase("RBC")) {
                dados.put("celldyn_histograma_rbc", foto64);
            } else if (tipo.equalsIgnoreCase("WIC")) {
                dados.put("celldyn_histograma_wic", foto64);
            }
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
            for (BDExame exame : exames) {
                this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getExame(), exame.getMaterial(), int_codigo, dados);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }

    private BufferedImage criarImagem(ArrayList<String> channels) {
        int width = 133;
        int height = 133;
        BufferedImage b = new BufferedImage(width, height, 1);
        Graphics2D g = b.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.BLACK);
        g.drawLine(2, 0, 2, 133);
        g.drawLine(0, 131, 133, 131);
        int x = 2;
        int x1 = 2;
        int y = 0;
        int y1 = 0;
        int v = 0;
        for (int i = 0; i < channels.size(); ++i) {
            try {
                v = Integer.parseInt(channels.get(i));
            }
            catch (NumberFormatException e) {
                v = 0;
            }
            y1 = height - v / 2 - 5;
            if (i == 0) {
                y = y1;
            }
            g.drawLine(x, y, x1, y1);
            x = x1;
            x1 += 2;
            y = y1;
        }
        return b;
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

