/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cd3500;

import jalis.laboratorio.interfaceamento.InterfaceamentoConfiguracao;
import jalis.util.StringUtil;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;

public class InterfaceConfiguracao
extends InterfaceamentoConfiguracao {
    private boolean modoCompatibilidadeCD3000 = false;
    private boolean modoUniderecional = false;
    private String MODO_UNIDIRECIONAL = "modoUnidirecional";
    private String MODO_COMPATIBILIDADE_CD3000 = "modoCompatibilidadeCD3000";

    @Override
    public String getXmlVariaveis() {
        String str = super.getXmlVariaveis();
        try {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir("variavel");
            xml.escrever("nome", this.MODO_COMPATIBILIDADE_CD3000);
            xml.escrever("valor", this.getModoCompatibilidadeCD3000() ? "1" : "0");
            xml.escrever("tipo", CHECK);
            xml.fechar("variavel");
            xml.abrir("variavel");
            xml.escrever("nome", this.MODO_UNIDIRECIONAL);
            xml.escrever("valor", this.getModoUnidirecional() ? "1" : "0");
            xml.escrever("tipo", CHECK);
            xml.fechar("variavel");
            return str + xml.getXML();
        }
        catch (XMLStringBuilderException e) {
            e.printStackTrace();
            return str;
        }
    }

    @Override
    public void setXmlVariaveis(String xml) {
        String[] variaveis;
        for (String s : variaveis = StringUtil.getValores(xml, "variavel")) {
            String nome = StringUtil.getValor(s, "nome");
            String valor = StringUtil.getValor(s, "valor");
            if (nome.equalsIgnoreCase(this.MODO_COMPATIBILIDADE_CD3000)) {
                this.setModoCompatibilidadeCD3000(StringUtil.getValor(s, "valor").equalsIgnoreCase("1"));
                continue;
            }
            if (!nome.equalsIgnoreCase(this.MODO_UNIDIRECIONAL)) continue;
            this.setModoUniderecional(StringUtil.getValor(s, "valor").equalsIgnoreCase("1"));
        }
        super.setXmlVariaveis(xml);
    }

    @Override
    public String getNomeVariavel(String variavel) {
        if (variavel.equalsIgnoreCase(this.MODO_COMPATIBILIDADE_CD3000)) {
            return "Modo Compatibilidade CD-3000";
        }
        if (variavel.equalsIgnoreCase(this.MODO_UNIDIRECIONAL)) {
            return "Modo Unidirecional";
        }
        return super.getNomeVariavel(variavel);
    }

    public boolean getModoCompatibilidadeCD3000() {
        return this.modoCompatibilidadeCD3000;
    }

    public void setModoCompatibilidadeCD3000(boolean modoCompatibilidadeCD3000) {
        this.modoCompatibilidadeCD3000 = modoCompatibilidadeCD3000;
    }

    public boolean getModoUnidirecional() {
        return this.modoUniderecional;
    }

    public void setModoUniderecional(boolean modoUniderecional) {
        this.modoUniderecional = modoUniderecional;
    }
}

