/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cd3200;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.Checksum;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import org.apache.commons.codec.binary.Base64;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private String NOME_EXAME = "HEMOG";
    protected int MAX_PATIENT_NAME_CHARS = 28;
    public static final int EQUIP_TIMEOUT = 5000;
    public static final int MAX_TENTATIVAS = 2;
    public static final int TIPO_REQ_NOVO = 0;
    public static final int TIPO_REQ_REPETICAO = 1;
    String int_codigo;
    String fil_codigo;
    String req_codigo;
    String mco_codigo;
    String rec_codigo;
    String pac_nome;
    String pac_exames;
    String pac_sexo;
    String req_idade;
    String req_data;
    String req_hora;
    String acao;
    String frame;
    int tx_counter = 0;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    public String getErroTraduzido(String erro) {
        return erro;
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    void limpaDadosRequisicao() {
        this.frame = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        this.fil_codigo = fil_codigo;
        this.int_codigo = int_codigo;
        this.req_codigo = req_codigo;
        this.pac_nome = pac_nome;
        this.pac_sexo = pac_sexo;
        this.req_idade = pac_idade;
        this.req_data = data;
        this.req_hora = hora;
        this.mco_codigo = mco_codigo;
        this.rec_codigo = rec_codigo;
        this.pac_exames = exames;
        this.acao = acao;
        try {
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            pac_nome = StringUtil.removerAcentos(pac_nome.length() > this.MAX_PATIENT_NAME_CHARS ? pac_nome.substring(0, this.MAX_PATIENT_NAME_CHARS) : StringUtil.preencheString(pac_nome, this.MAX_PATIENT_NAME_CHARS, ' ', 0));
            String medico = BDUtil.buscaMedicoRequisicao(fil_codigo, req_codigo);
            if (Funcoes.textoVazio(medico)) {
                medico = "----------------------";
            }
            if (medico.length() > 22) {
                medico = medico.substring(0, 21);
            }
            if (medico.length() < 22) {
                medico = StringUtil.preencheString(medico, 22, ' ', 0);
            }
            String[] idade = BDUtil.getIdadeNacimentoPaciente(fil_codigo, req_codigo);
            String dataNasc = "--/--/----";
            if (idade != null && idade.length == 3 && !Funcoes.textoVazio(dataNasc = idade[2]) && dataNasc.trim().length() == 10) {
                dataNasc = Funcoes.formataData("MM/dd/yyyy", Funcoes.stringToDate("dd/MM/yyyy", dataNasc));
            }
            String dataColeta = "--/--/----";
            String horaColeta = "--:--";
            Date dtColeta = BDUtil.getExmColeta(fil_codigo, req_codigo, this.NOME_EXAME, mco_codigo);
            if (dtColeta != null) {
                dataColeta = Funcoes.formataData("MM/dd/yyyy", dtColeta);
                horaColeta = Funcoes.formataData("HH:mm", dtColeta);
            }
            StringBuilder worklist = new StringBuilder();
            worklist.append("\"").append(StringUtil.preencheString(codigo.toString(), 12, ' ', 0)).append("\",");
            worklist.append("\"").append(pac_nome).append("\",");
            worklist.append("\"").append(StringUtil.preencheString(codigo.toString(), 16, ' ', 0)).append("\",");
            if (Funcoes.textoVazio(pac_sexo)) {
                worklist.append("\"-\",");
            } else {
                worklist.append("\"").append(pac_sexo).append("\",");
            }
            worklist.append("\"").append(dataNasc).append("\",");
            worklist.append("\"").append(dataColeta).append("\",");
            worklist.append("\"").append(horaColeta).append("\",");
            if (Funcoes.textoVazio(medico)) {
                worklist.append("\"----------------------\",");
            } else {
                worklist.append("\"").append(medico).append("\",");
            }
            worklist.append("1,1,");
            String checksum = Checksum.getChecksumMod256(worklist.toString());
            worklist = new StringBuilder(this.getMsgStart()).append((CharSequence)worklist).append(checksum).append(this.getMsgEnd());
            this.frame = worklist.toString();
            this.setTX(5000);
            this.tx_counter = 0;
            this.getPortaCOM().write(worklist.toString());
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    public synchronized String parse(String message) {
        String retorno = null;
        String checksum = null;
        if (message.startsWith(this.getMsgStart())) {
            message = message.replaceFirst(this.getMsgStart(), "");
        }
        if (message.endsWith(this.getMsgEnd())) {
            message = message.replaceFirst(this.getMsgEnd(), "");
        }
        try {
            checksum = message.substring(message.length() - 2);
            message = message.substring(0, message.length() - 2);
        }
        catch (StringIndexOutOfBoundsException e) {
            return "Erro ao verificar Checksum. \u00cdndice fora do tamanho do bloco de dados.";
        }
        if (this.checksum(message, checksum)) {
            ArrayList<String> fields = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(message, ",");
            while (tokenizer.hasMoreElements()) {
                fields.add(tokenizer.nextToken());
            }
            if (fields != null && !fields.isEmpty()) {
                try {
                    String test_type = (String)fields.remove(0);
                    test_type = test_type.replaceAll("\"", "");
                    fields.remove(0);
                    fields.remove(0);
                    String ier_rackpos = ((String)fields.remove(0)).trim();
                    fields.remove(0);
                    fields.remove(0);
                    String id = ((String)fields.remove(0)).replaceAll("\"", "").trim();
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    fields.remove(0);
                    if (test_type.equals("   ")) {
                        retorno = this.parseResults(fields, id, ier_rackpos);
                        if (retorno == null) {
                            return "";
                        }
                        if (retorno.startsWith("Erro")) {
                            return retorno;
                        }
                        Conexao.arquivaSQL();
                        RefreshTimer.waitAndRefresh(this, 2000);
                    } else if (test_type.equalsIgnoreCase("WB1")) {
                        retorno = this.parseImagem("WB1", fields, id, ier_rackpos);
                        Conexao.arquivaSQL();
                        RefreshTimer.waitAndRefresh(this, 2000);
                    } else if (test_type.equalsIgnoreCase("WB2")) {
                        retorno = this.parseImagem("WB2", fields, id, ier_rackpos);
                        Conexao.arquivaSQL();
                        RefreshTimer.waitAndRefresh(this, 2000);
                    } else if (test_type.equalsIgnoreCase("RBC")) {
                        retorno = this.parseImagem("RBC", fields, id, ier_rackpos);
                        Conexao.arquivaSQL();
                        RefreshTimer.waitAndRefresh(this, 2000);
                    } else if (test_type.equalsIgnoreCase("PLT")) {
                        retorno = this.parseImagem("PLT", fields, id, ier_rackpos);
                        Conexao.arquivaSQL();
                        RefreshTimer.waitAndRefresh(this, 2000);
                    } else if (test_type.equalsIgnoreCase("NOC")) {
                        retorno = this.parseImagem("NOC", fields, id, ier_rackpos);
                        Conexao.arquivaSQL();
                        RefreshTimer.waitAndRefresh(this, 2000);
                    } else {
                        return "";
                    }
                    return retorno;
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
                    try {
                        Conexao.anulaSQL();
                        return "Erro ao inserir resultados recebidos ao banco de dados";
                    }
                    catch (SQLException e) {
                        ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                        return "Erro ao inserir resultados recebidos ao banco de dados";
                    }
                }
            }
            return "Erro ao realizar parse dos dados recebidos";
        }
        return "Erro ao receber resultado: CRC Mismatch!";
    }

    private String parseResults(ArrayList<String> fields, String id, String ier_rackpos) throws SQLException {
        try {
            try {
                Long.parseLong(id);
            }
            catch (Exception ex) {
                if (id.equals("BACKGROUND")) {
                    return null;
                }
                this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + id);
                return null;
            }
            Statement st = Conexao.getStatement();
            if (id.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + id);
                return null;
            }
            this.fil_codigo = id.substring(0, ParametrosGerais.getDigitosTuboFilial());
            this.rec_codigo = id.substring(id.length() - ParametrosGerais.getDigitosTuboTubo());
            this.req_codigo = id.substring(ParametrosGerais.getDigitosTuboFilial(), id.length() - ParametrosGerais.getDigitosTuboTubo());
            this.int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, this.NOME_EXAME);
            if (this.int_codigo == null) {
                int situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.NOME_EXAME, this.mco_codigo, this.rec_codigo);
                StringBuilder s = new StringBuilder();
                s.append("N\u00e3o foi poss\u00edvel encontrar o exame! O exame encontra-se ");
                if (situacao == 8) {
                    s.append("exportado!");
                } else {
                    s.append("sem situa\u00e7\u00e3o!");
                }
                s.append("(").append(id).append(")");
                this.fireExcecaoEncontrada(s.toString());
                return null;
            }
            HashMap<String, Object> hemograma = new HashMap<String, Object>();
            hemograma.put("rack_position", ier_rackpos);
            hemograma.put("leucocitos", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("segmentados_contagem", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("linfocitos_tipicos_contagem", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("monocitos_contagem", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("eosinofilos_contagem", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("basofilos_contagem", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("hemacias", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("hgb", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("hct", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("vcm", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("hcm", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("chcm", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("rdw", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("plaquetas", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("vpm", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("pct", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("pdw", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("segmentados_percentual", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("linfocitos_tipicos_percentual", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("monocitos_percentual", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("eosinofilos_percentual", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("basofilos_percentual", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("promielocitos_contagem", "0");
            hemograma.put("promielocitos_percentual", "0");
            hemograma.put("mielocitos_contagem", "0");
            hemograma.put("mielocitos_percentual", "0");
            hemograma.put("metamielocitos_contagem", "0");
            hemograma.put("metamielocitos_percentual", "0");
            hemograma.put("bastonados_contagem", "0");
            hemograma.put("bastonados_percentual", "0");
            hemograma.put("linfocitos_atipicos_contagem", "0");
            hemograma.put("linfocitos_atipicos_percentual", "0");
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(this.fil_codigo, this.int_codigo, this.req_codigo, this.rec_codigo);
            for (BDExame exame : exames) {
                this.atualizarDadosExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, exame.getExame(), exame.getMaterial(), this.int_codigo, hemograma);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }

    public boolean checksum(String message, String sum) {
        String checksum = Checksum.getChecksumMod256(message);
        return checksum.equals(sum);
    }

    public void encerrarTransmissao() throws Exception {
        if (this.tx_counter < 2) {
            Statement st = Conexao.getStatement();
            this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + this.pac_nome, 0, 10000);
            if (this.acao.equals("N")) {
                this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
            }
        }
        this.interromperTimer();
        this.getPortaCOM().clearInputString();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    private void retransmitirRecusado() throws Exception {
        if (this.tx_counter >= 2) {
            this.encerrarTransmissao();
            return;
        }
        this.setTX(5000);
        this.getPortaCOM().write(this.frame);
        ++this.tx_counter;
    }

    public void requisicaoExistente() throws Exception {
        Statement st = Conexao.getStatement();
        this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
        Conexao.arquivaSQL();
        this.fireMensagemEnviada("Pedido(s) re-enviado(s) com sucesso para " + this.pac_nome + ".", 0, 10000);
        this.interromperTimer();
        this.getPortaCOM().clearInputString();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    public void alertarWorklistFull() throws Exception {
        this.tx_counter = 2;
        this.encerrarTransmissao();
        this.fireMensagemEnviada("Erro: O worklist est\u00e1 cheio ou o c\u00f3digo de barras est\u00e1 desligado.", 1, 5000);
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(5000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    private void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(5000);
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    private void abortarRecepcao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(3000);
    }

    public void caracterNaoEsperado() throws Exception {
    }

    private void tratarAcknowledge() throws Exception {
        if (this.isTX()) {
            this.encerrarTransmissao();
        } else {
            this.caracterNaoEsperado();
        }
    }

    private void tratarNegativeAck() throws Exception {
        if (this.isTX()) {
            this.retransmitirRecusado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    private void tratarCancel() throws Exception {
        if (this.isTX()) {
            this.alertarWorklistFull();
        } else {
            this.caracterNaoEsperado();
        }
    }

    private void tratarDelete() throws Exception {
        if (this.isTX()) {
            this.requisicaoExistente();
        } else {
            this.caracterNaoEsperado();
        }
    }

    @Override
    public void handShakeCharReceived(final char c) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    switch (c) {
                        case '\u0006': {
                            InterfaceListener.this.tratarAcknowledge();
                            break;
                        }
                        case '\u0015': {
                            InterfaceListener.this.tratarNegativeAck();
                            break;
                        }
                        case '\u0018': {
                            InterfaceListener.this.tratarCancel();
                            break;
                        }
                        case '\u007f': {
                            InterfaceListener.this.tratarDelete();
                            break;
                        }
                        default: {
                            InterfaceListener.this.caracterNaoEsperado();
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento.", 1, 5000);
                    InterfaceListener.this.setIdle();
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void dataChanged() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    String message = InterfaceListener.this.getPortaCOM().removeInputString(InterfaceListener.this.getMsgEnd());
                    if (!message.equals("")) {
                        InterfaceListener.this.addListaRecebimento(message);
                        InterfaceListener.this.restartThreadRecebimento();
                        InterfaceListener.this.getPortaCOM().write(String.valueOf('\u0006'));
                        if (InterfaceListener.this.isRX()) {
                            InterfaceListener.this.aguardarProximoFrame();
                        }
                    } else if (InterfaceListener.this.isRX()) {
                        InterfaceListener.this.aguardarProximoFrame();
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        try {
            if (this.isTX()) {
                this.abortarTransmissao();
            } else if (this.isRX()) {
                if (this.frame != null) {
                    this.abortarRecepcao();
                } else {
                    this.setIdle();
                }
            } else {
                this.setIdle();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    private String parseImagem(String tipo, ArrayList<String> fields, String id, String ier_rackpos) {
        try {
            try {
                Long.parseLong(id);
            }
            catch (Exception ex) {
                if (id.equals("BACKGROUND")) {
                    return null;
                }
                this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + id);
                return null;
            }
            Statement st = Conexao.getStatement();
            if (id.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + id);
                return null;
            }
            this.fil_codigo = id.substring(0, ParametrosGerais.getDigitosTuboFilial());
            this.rec_codigo = id.substring(id.length() - ParametrosGerais.getDigitosTuboTubo());
            this.req_codigo = id.substring(ParametrosGerais.getDigitosTuboFilial(), id.length() - ParametrosGerais.getDigitosTuboTubo());
            this.int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, this.NOME_EXAME);
            if (this.int_codigo == null) {
                int situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.NOME_EXAME, this.mco_codigo, this.rec_codigo);
                StringBuilder s = new StringBuilder();
                s.append("N\u00e3o foi poss\u00edvel encontrar o exame! O exame encontra-se ");
                if (situacao == 8) {
                    s.append("exportado!");
                } else {
                    s.append("sem situa\u00e7\u00e3o!");
                }
                s.append("(").append(id).append(")");
                this.fireExcecaoEncontrada(s.toString());
                return null;
            }
            String scaleFactor = fields.remove(0);
            BufferedImage b = this.criarImagem(fields);
            Image i = Toolkit.getDefaultToolkit().createImage(b.getSource());
            String foto64 = new Base64().encodeAsString(ImagemUtils.imageToByte(i));
            HashMap<String, Object> dados = new HashMap<String, Object>();
            if (tipo.equalsIgnoreCase("WB1")) {
                dados.put("celldyn_histograma_wb1", foto64);
            } else if (tipo.equalsIgnoreCase("WB2")) {
                dados.put("celldyn_histograma_wb2", foto64);
            } else if (tipo.equalsIgnoreCase("PLT")) {
                dados.put("celldyn_histograma_plt", foto64);
            } else if (tipo.equalsIgnoreCase("RBC")) {
                dados.put("celldyn_histograma_rbc", foto64);
            } else if (tipo.equalsIgnoreCase("NOC")) {
                dados.put("celldyn_histograma_wic", foto64);
            }
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(this.fil_codigo, this.int_codigo, this.req_codigo, this.rec_codigo);
            for (BDExame exame : exames) {
                this.atualizarDadosExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, exame.getExame(), exame.getMaterial(), this.int_codigo, dados);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }

    private BufferedImage criarImagem(ArrayList<String> channels) {
        int width = 133;
        int height = 133;
        BufferedImage b = new BufferedImage(width, height, 1);
        Graphics2D g = b.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.BLACK);
        g.drawLine(2, 0, 2, 133);
        g.drawLine(0, 131, 133, 131);
        int x = 2;
        int x1 = 2;
        int y = 0;
        int y1 = 0;
        int v = 0;
        for (int i = 0; i < channels.size(); ++i) {
            try {
                v = Integer.parseInt(channels.get(i));
            }
            catch (NumberFormatException e) {
                v = 0;
            }
            y1 = height - v / 2 - 5;
            if (i == 0) {
                y = y1;
            }
            g.drawLine(x, y, x1, y1);
            x = x1;
            x1 += 2;
            y = y1;
        }
        return b;
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

