/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cd3000;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.interfaces.cd3000.FrameEnvio;
import jalis.laboratorio.interfaceamento.interfaces.cd3000.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.Checksum;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private String NOME_EXAME = "HEMOG";
    protected int MAX_PATIENT_NAME_CHARS = 16;
    public static final int EQUIP_TIMEOUT = 5000;
    public static final int MAX_TENTATIVAS = 2;
    public static final int TIPO_REQ_NOVO = 0;
    public static final int TIPO_REQ_REPETICAO = 1;
    String int_codigo;
    String fil_codigo;
    String req_codigo;
    String mco_codigo;
    String rec_codigo;
    String pac_nome;
    String pac_exames;
    String pac_sexo;
    String req_idade;
    String req_data;
    String req_hora;
    String acao;
    FrameEnvio frame = null;
    int tx_counter = 0;
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento(this, 150);

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    public String getErroTraduzido(String erro) {
        return erro;
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    public void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento(this);
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    void limpaDadosRequisicao() {
        this.frame = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        this.fil_codigo = fil_codigo;
        this.int_codigo = int_codigo;
        this.req_codigo = req_codigo;
        this.pac_nome = pac_nome;
        this.pac_sexo = pac_sexo;
        this.req_idade = pac_idade;
        this.req_data = data;
        this.req_hora = hora;
        this.mco_codigo = mco_codigo;
        this.rec_codigo = rec_codigo;
        this.pac_exames = exames;
        this.acao = acao;
        try {
            if (this.configuracao.getModoUnidirecional()) {
                this.encerrarTransmissao();
                return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            pac_nome = StringUtil.removerAcentos(pac_nome.length() > this.MAX_PATIENT_NAME_CHARS ? pac_nome.substring(0, this.MAX_PATIENT_NAME_CHARS) : StringUtil.preencheString(pac_nome, this.MAX_PATIENT_NAME_CHARS, ' ', 0));
            String bar_code = new SimpleDateFormat("HHmm").format(new Date(System.currentTimeMillis()));
            this.frame = new FrameEnvio(bar_code, codigo.toString(), pac_nome, this.getMsgStart(), this.getMsgEnd());
            this.setTX(5000);
            this.tx_counter = 0;
            this.getPortaCOM().write(this.frame.getStringFrame());
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    public synchronized String parse(String message) {
        String retorno = null;
        String checksum = null;
        if (message.startsWith(this.getMsgStart())) {
            message = message.replaceFirst(this.getMsgStart(), "");
        }
        if (message.endsWith(this.getMsgEnd())) {
            message = message.substring(0, message.length() - 1) + "";
        }
        if (message.indexOf(this.getMsgStart()) > 0 && message.indexOf(this.getMsgEnd()) > 0 && message.indexOf(this.getMsgEnd()) < message.length()) {
            message = message.substring(0, message.indexOf(this.getMsgStart())) + message.substring(message.indexOf(this.getMsgEnd()) + 1);
        }
        try {
            checksum = message.substring(message.length() - 2);
            message = message.substring(0, message.length() - 2);
        }
        catch (StringIndexOutOfBoundsException e) {
            return "Erro ao verificar Checksum. \u00cdndice fora do tamanho do bloco de dados.";
        }
        String testeCheckSum = Checksum.getChecksumMod256(message);
        if (this.checksum(message, checksum)) {
            ArrayList<String> fields = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(message, ",");
            while (tokenizer.hasMoreElements()) {
                fields.add(tokenizer.nextToken());
            }
            if (fields != null && !fields.isEmpty()) {
                try {
                    String test_type = (String)fields.remove(0);
                    test_type = test_type.replaceAll("\"", "").replaceAll(String.valueOf('\u007f'), "");
                    if (test_type.equals("   ")) {
                        retorno = this.parseResults(fields);
                        if (retorno == null) {
                            return "";
                        }
                        if (retorno.startsWith("Erro")) {
                            return retorno;
                        }
                        Conexao.arquivaSQL();
                        RefreshTimer.waitAndRefresh(this, 2000);
                        return retorno;
                    }
                    return "";
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
                    try {
                        Conexao.anulaSQL();
                        return "Erro ao inserir resultados recebidos ao banco de dados";
                    }
                    catch (SQLException e) {
                        ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                        return "Erro ao inserir resultados recebidos ao banco de dados";
                    }
                }
            }
            return "Erro ao realizar parse dos dados recebidos";
        }
        return "Ocorreu algum erro durante a comunica\u00e7\u00e3o tente restransmitir novamente : Valida\u00e7\u00e3o da mensagem falhou! (Encontrado: " + checksum + "  Esperado: " + testeCheckSum + ")";
    }

    private String parseResults(ArrayList<String> fields) throws SQLException {
        try {
            String ier_rackpos = fields.remove(0).trim();
            fields.remove(0);
            String id = fields.remove(0).replaceAll("\"", "").trim();
            fields.remove(0);
            fields.remove(0);
            String date = fields.remove(0).replaceAll("\"", "");
            String time = fields.remove(0).replaceAll("\"", "");
            try {
                Long.parseLong(id);
            }
            catch (Exception ex) {
                if (id.equals("BACKGROUND")) {
                    return null;
                }
                this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + id);
                return null;
            }
            Statement st = Conexao.getStatement();
            if (id.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada("C\u00f3digo " + id + " recebido com a quantidade de d\u00edgitos inv\u00e1lida");
                return null;
            }
            this.fil_codigo = id.substring(0, ParametrosGerais.getDigitosTuboFilial());
            this.rec_codigo = id.substring(id.length() - ParametrosGerais.getDigitosTuboTubo());
            this.req_codigo = id.substring(ParametrosGerais.getDigitosTuboFilial(), id.length() - ParametrosGerais.getDigitosTuboTubo());
            this.int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, this.NOME_EXAME);
            if (this.int_codigo == null) {
                this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel encontrar a interface! Verifique configura\u00e7\u00e3o do exame!");
                return null;
            }
            HashMap<String, Object> hemograma = new HashMap<String, Object>();
            hemograma.put("rack_position", ier_rackpos);
            String result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 4) + "," + result.substring(4);
            hemograma.put("leucocitos", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 4) + "," + result.substring(4);
            hemograma.put("segmentados_contagem", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 4) + "," + result.substring(4);
            hemograma.put("linfocitos_tipicos_contagem", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 4) + "," + result.substring(4);
            hemograma.put("monocitos_contagem", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 4) + "," + result.substring(4);
            hemograma.put("eosinofilos_contagem", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 4) + "," + result.substring(4);
            hemograma.put("basofilos_contagem", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 3) + "," + result.substring(3);
            hemograma.put("hemacias", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 4) + "," + result.substring(4);
            hemograma.put("hgb", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 4) + "," + result.substring(4);
            hemograma.put("hct", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 4) + "," + result.substring(4);
            hemograma.put("vcm", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 4) + "," + result.substring(4);
            hemograma.put("hcm", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 4) + "," + result.substring(4);
            hemograma.put("chcm", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 4) + "," + result.substring(4);
            hemograma.put("rdw", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            hemograma.put("plaquetas", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 4) + "," + result.substring(4);
            hemograma.put("vpm", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 4) + "," + result.substring(4);
            hemograma.put("pct", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 4) + "," + result.substring(4);
            hemograma.put("pdw", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 4) + "," + result.substring(4);
            hemograma.put("segmentados_percentual", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 4) + "," + result.substring(4);
            hemograma.put("linfocitos_tipicos_percentual", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 4) + "," + result.substring(4);
            hemograma.put("monocitos_percentual", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 4) + "," + result.substring(4);
            hemograma.put("eosinofilos_percentual", result);
            result = fields.remove(0).replaceFirst("\\.", ",");
            result = result.substring(0, 4) + "," + result.substring(4);
            hemograma.put("basofilos_percentual", result);
            hemograma.put("promielocitos_contagem", "0");
            hemograma.put("promielocitos_percentual", "0");
            hemograma.put("mielocitos_contagem", "0");
            hemograma.put("mielocitos_percentual", "0");
            hemograma.put("metamielocitos_contagem", "0");
            hemograma.put("metamielocitos_percentual", "0");
            hemograma.put("bastonados_contagem", "0");
            hemograma.put("bastonados_percentual", "0");
            hemograma.put("linfocitos_atipicos_contagem", "0");
            hemograma.put("linfocitos_atipicos_percentual", "0");
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(this.fil_codigo, this.int_codigo, this.req_codigo, this.rec_codigo);
            for (BDExame exame : exames) {
                this.atualizarDadosExame(st, this.fil_codigo, exame.getRequisicao(), exame.getRecipiente(), exame.getExame(), exame.getMaterial(), this.int_codigo, hemograma);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }

    public boolean checksum(String message, String sum) {
        String checksum = Checksum.getChecksumMod256(message);
        return checksum.equals(sum);
    }

    public void encerrarTransmissao() throws Exception {
        if (this.tx_counter < 2) {
            Statement st = Conexao.getStatement();
            this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + this.pac_nome, 0, 10000);
            if (this.acao.equals("N")) {
                this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
            }
        }
        this.interromperTimer();
        this.getPortaCOM().clearInputString();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    private void retransmitirRecusado() throws Exception {
        if (this.tx_counter >= 2) {
            this.encerrarTransmissao();
            return;
        }
        this.setTX(5000);
        this.frame.incrementarBarcodeID();
        this.getPortaCOM().write(this.frame.getStringFrame());
        ++this.tx_counter;
    }

    public void requisicaoExistente() throws Exception {
        Statement st = Conexao.getStatement();
        this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
        Conexao.arquivaSQL();
        this.fireMensagemEnviada("Pedido(s) re-enviado(s) com sucesso para " + this.pac_nome + ".", 0, 10000);
        this.interromperTimer();
        this.getPortaCOM().clearInputString();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela();
        this.setIdle();
    }

    public void alertarWorklistFull() throws Exception {
        this.tx_counter = 2;
        this.encerrarTransmissao();
        this.fireMensagemEnviada("Erro: O worklist est\u00e1 cheio ou o c\u00f3digo de barras est\u00e1 desligado.", 1, 5000);
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(5000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    private void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(5000);
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    private void abortarRecepcao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(3000);
    }

    public void caracterNaoEsperado() throws Exception {
        this.fireMensagemEnviada("Caracter n\u00e3o esperado localizado, aguardando timeout", 0, 10000);
    }

    private void tratarAcknowledge() throws Exception {
        if (this.isTX()) {
            this.encerrarTransmissao();
        } else {
            this.caracterNaoEsperado();
        }
    }

    private void tratarNegativeAck() throws Exception {
        if (this.isTX()) {
            this.retransmitirRecusado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    private void tratarCancel() throws Exception {
        if (this.isTX()) {
            this.alertarWorklistFull();
        } else {
            this.caracterNaoEsperado();
        }
    }

    private void tratarDelete() throws Exception {
        if (this.isTX()) {
            this.requisicaoExistente();
        } else {
            this.caracterNaoEsperado();
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0006': {
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0015': {
                    this.tratarNegativeAck();
                    break;
                }
                case '\u0018': {
                    this.tratarCancel();
                    break;
                }
                case '\u007f': {
                    this.tratarDelete();
                    break;
                }
                default: {
                    this.caracterNaoEsperado();
                    break;
                }
            }
        }
        catch (Exception ex) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                }
            };
            SwingUtilities.invokeLater(run);
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento.", 1, 5000);
            this.setIdle();
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!message.equals("")) {
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
                this.getPortaCOM().write(String.valueOf('\u0006'));
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                }
            };
            SwingUtilities.invokeLater(run);
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void dataChanged(String message) {
        try {
            if (!message.equals("")) {
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
                this.getPortaCOM().write(String.valueOf('\u0006'));
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                }
            };
            SwingUtilities.invokeLater(run);
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        try {
            if (this.isTX()) {
                this.abortarTransmissao();
            } else if (this.isRX()) {
                if (this.frame != null) {
                    this.abortarRecepcao();
                } else {
                    this.setIdle();
                }
            } else {
                this.setIdle();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    @Override
    public void teste() {
        this.dataChanged(this.equipamento.arruma("[STX]\"   \",3779,0,\"0101193601[SP][SP]\",\"----------------\",\"5[SP][SP]\",\"03/13/16\",\"03:34\",00055,00023,00024,00005,00002,00001,00479,00150,00431,00900,00313,00348,00123,00149,00095,00014,00162,00411,00440,00096,00033,00020,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,06380,04070,00000,00000,1,0,0,0,3D[ETX]"));
        this.dataChanged(this.equipamento.arruma("[STX]\"WB1\",3779,0,\"13001636333[SP]\",\"----------------\",\"5[SP][SP]\",\"03/13/16\",\"03:34\",00000,000,000,000,000,001,008,015,018,031,062,108,175,231,246,244,203,141,083,048,027,023,023,026,026,026,029,032,033,031,031,030,026,024,017,014,008,004,002,001,001,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,F9[ETX]"));
        this.dataChanged(this.equipamento.arruma("[STX]\"WB2\",3779,0,\"0101193601[SP][SP]\",\"----------------\",\"5[SP][SP]\",\"03/13/16\",\"03:34\",00000,000,000,000,002,010,037,117,223,248,165,079,042,037,031,023,018,010,006,005,005,006,009,016,027,039,052,064,074,078,075,067,058,056,046,042,034,023,017,014,012,009,006,003,003,002,002,001,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,52[ETX]"));
        this.dataChanged(this.equipamento.arruma("[STX]\"RBC\",3779,0,\"13001636333[SP]\",\"----------------\",\"5[SP][SP]\",\"03/13/16\",\"03:34\",00000,000,000,000,000,000,000,000,000,001,002,002,001,001,001,001,003,006,013,030,056,092,142,194,235,253,249,217,169,130,099,067,044,027,018,013,009,007,006,004,003,003,002,001,001,001,001,001,001,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,01[ETX]"));
        this.dataChanged(this.equipamento.arruma("[STX]\"PLT\",3779,0,\"13001636333[SP]\",\"----------------\",\"5[SP][SP]\",\"03/13/16\",\"03:34\",00000,000,000,007,018,029,043,060,077,091,104,113,119,122,121,118,114,109,103,097,089,082,075,069,062,057,052,047,043,040,036,033,030,026,023,021,018,015,013,011,010,008,008,007,007,007,008,008,008,008,007,007,006,006,005,005,004,004,004,004,004,004,004,004,004,E8[ETX]"));
        super.teste();
    }
}

