/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cd1600;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.cd1700.InterfaceListener {
    @Override
    public String parseResults(ArrayList<String> fields) throws SQLException {
        try {
            BDExame[] exames;
            String ier_rackpos = fields.remove(0).trim();
            String id = fields.remove(0).replaceAll("\"", "").trim();
            fields.remove(0);
            String date = fields.remove(0).replaceAll("\"", "");
            String time = fields.remove(0).replaceAll("\"", "");
            try {
                Long.parseLong(id);
            }
            catch (Exception ex) {
                if (id.equals("BACKGROUND")) {
                    return null;
                }
                this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + id);
                return null;
            }
            Statement st = Conexao.getStatement();
            this.fil_codigo = id.substring(0, ParametrosGerais.getDigitosTuboFilial());
            this.req_codigo = id.substring(ParametrosGerais.getDigitosTuboFilial());
            this.rec_codigo = this.req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
            this.req_codigo = this.req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, this.NOME_EXAME);
            if (this.int_codigo == null) {
                this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel encontrar a interface! Verifique configura\u00e7\u00e3o do exame!");
                return null;
            }
            HashMap<String, Object> hemograma = new HashMap<String, Object>();
            hemograma.put("rack_position", ier_rackpos);
            hemograma.put("leucocitos", this.parseValor(fields));
            hemograma.put("linfocitos_tipicos_contagem", this.parseValor(fields));
            hemograma.put("monocitos_contagem", this.parseValor(fields));
            hemograma.put("eosinofilos_contagem", this.parseValor(fields));
            hemograma.put("hemacias", this.parseValor(fields, 3));
            hemograma.put("hgb", this.parseValor(fields));
            hemograma.put("hct", this.parseValor(fields));
            hemograma.put("vcm", this.parseValor(fields));
            hemograma.put("hcm", this.parseValor(fields));
            hemograma.put("chcm", this.parseValor(fields));
            hemograma.put("rdw", this.parseValor(fields));
            hemograma.put("plaquetas", fields.remove(0).replaceFirst("\\.", ","));
            hemograma.put("vpm", this.parseValor(fields));
            hemograma.put("pct", this.parseValor(fields));
            hemograma.put("pdw", this.parseValor(fields));
            hemograma.put("linfocitos_tipicos_percentual", this.parseValor(fields));
            hemograma.put("monocitos_percentual", this.parseValor(fields));
            hemograma.put("eosinofilos_percentual", this.parseValor(fields));
            hemograma.put("segmentados_percentual", "0");
            hemograma.put("segmentados_contagem", "0");
            hemograma.put("basofilos_contagem", "0");
            hemograma.put("basofilos_percentual", "0");
            hemograma.put("promielocitos_contagem", "0");
            hemograma.put("promielocitos_percentual", "0");
            hemograma.put("mielocitos_contagem", "0");
            hemograma.put("mielocitos_percentual", "0");
            hemograma.put("metamielocitos_contagem", "0");
            hemograma.put("metamielocitos_percentual", "0");
            hemograma.put("bastonados_contagem", "0");
            hemograma.put("bastonados_percentual", "0");
            hemograma.put("linfocitos_atipicos_contagem", "0");
            hemograma.put("linfocitos_atipicos_percentual", "0");
            for (BDExame exame : exames = BDUtil.getReqExames(this.fil_codigo, this.int_codigo, this.req_codigo, this.rec_codigo)) {
                this.atualizarDadosExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, exame.getExame(), exame.getMaterial(), this.int_codigo, hemograma);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }

    private String parseValor(ArrayList<String> fields) {
        return this.parseValor(fields, 4);
    }

    private String parseValor(ArrayList<String> fields, int pos) {
        String result = fields.remove(0).replaceFirst("\\.", ",");
        result = result.substring(0, pos) + "," + result.substring(pos);
        return result;
    }
}

