/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.cb350i;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.cb350i.Mensagem;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final String LISTA_EXAMES = "exames";
    private static final int EQUIP_TIMEOUT = 15000;
    private static final int MAX_TENTATIVAS = 2;
    private static final int TIPO_REQ_NOVO = 0;
    private static final int TIPO_REQ_REPETICAO = 1;
    private static final String PATIENT_CODE = "PATIENTCODE";
    private static final String PATIENT_NAME = "PATIENTNAME";
    private static final String PATIENT_SURNAME = "PATIENTSURNAME";
    private static final String PATIENT_LIST_TYPE = "PATIENTLISTTYPE";
    private static final String PATIENT_GROUP = "PATIENTGROUP";
    private static final String PATIENT_TYPE = "PATIENTTYPE";
    private static final String PATIENT_NOTE = "PATIENTNOTE";
    private static final String PATIENT_IS_CONTROL = "PATIENTISCONTROL";
    private static final String PATIENT_CLONE = "PATIENTCLONE";
    private static final String PATIENT_CUP_POSITION = "PATIENTCUPPOSITION";
    private static final String PATIENT_NUMBER_TEST = "PATIENTNUMBERTEST";
    private static final String PATIENT_TO_REPEAT = "PATIENTTOREPEAT";
    private static final String CHECKSUM = "CHECKSUM";
    private static final String ANALYSES_CODE = "ANALYSESCODE";
    private static final String ANALYSE_NAME = "ANALYSENAME";
    private static final String ANALYSE_TYPE = "ANALYSETYPE";
    private static final String ANALYSE_CONCENTRATION1 = "ANALYSECONCENTRATION1";
    private static final String ANALYSE_CONCENTRATION2 = "ANALYSECONCENTRATION2";
    private static final String ANALYSE_FLAG1 = "ANALYSEFLAG1";
    private static final String ANALYSE_FLAG2 = "ANALYSEFLAG2";
    private static final String ANALYSE_MINVALUE = "ANALYSEMINVALUE";
    private static final String ANALYSE_MAXVALUE = "ANALYSEMAXVALUE";
    private static final String ANALYSE_SUM1 = "ANALYSESUM1";
    private static final String ANALYSE_SUM2 = "ANALYSESUM2";
    private static final String ANALYSE_SUMFACTOR = "ANALYSESUMFACTOR";
    private static final String ANALYSES_2RESULT = "ANALYSES2RESULT";
    private static final String ANALYSE_SERUM = "ANALYSESERUM";
    private static final String ANALYSE_URINE24H = "ANALYSEURINE24H";
    private static final char TAB = '\t';
    public static final char VTAB = '\u000b';
    public static final int QTDE_EXAMES_TOTAL_RACK = 52;
    public static final int QTDE_EXAMES_ENVIO_RACK = 52;
    private List<String> camposExame = new ArrayList<String>();
    private String ultimaRequisicao = "";
    private Map<Integer, String> msgErros = new HashMap<Integer, String>();
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    String int_codigo;
    String fil_codigo;
    String req_codigo;
    String mco_codigo;
    String rec_codigo;
    String pac_nome;
    String pac_exames;
    String pac_sexo;
    String req_idade;
    String req_data;
    String req_hora;
    String acao;
    int tx_counter = 0;
    Mensagem ultimoFrame;
    List<Mensagem> frames = new ArrayList<Mensagem>();
    private boolean solicitadoResultado = false;
    private Timer timerResultados = new Timer(60000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (InterfaceListener.this.getPortaCOM() != null && !InterfaceListener.this.isTX() && !InterfaceListener.this.isRX()) {
                try {
                    InterfaceListener.this.buscarResultados("R");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    });

    public InterfaceListener() {
        this.msgErros.put(1, "Erro de Check-Sum");
        this.msgErros.put(2, "Comando Desconhecido");
        this.msgErros.put(3, "Erro no campo \"Rotina / STAT\"");
        this.msgErros.put(4, "Erro no campo \"Soro / Urina\"");
        this.msgErros.put(5, "Erro no campo \"Clone Yes / No\"");
        this.msgErros.put(6, "Erro na posi\u00e7\u00e3o do soro");
        this.msgErros.put(7, "Erro no campo \"N\u00famero de testes\"");
        this.msgErros.put(8, "N\u00famero do teste errado");
        this.msgErros.put(9, "Posi\u00e7\u00e3o j\u00e1 em execu\u00e7\u00e3o");
        this.msgErros.put(10, "Clonagem imposs\u00edvel");
        this.msgErros.put(11, "C\u00f3digo repetido");
        this.msgErros.put(12, "Uma an\u00e1lise ou mais n\u00e3o presentes no analisador ");
        this.msgErros.put(13, "Uma an\u00e1lise ou mais n\u00e3o presentes no prato atual");
        this.msgErros.put(14, "Demasiadas an\u00e1lises para o paciente");
        this.timerResultados.start();
        this.camposExame = new ArrayList<String>();
        this.camposExame.add(ANALYSES_CODE);
        this.camposExame.add(ANALYSE_NAME);
        this.camposExame.add(ANALYSE_TYPE);
        this.camposExame.add(ANALYSE_CONCENTRATION1);
        this.camposExame.add(ANALYSE_CONCENTRATION2);
        this.camposExame.add(ANALYSE_FLAG1);
        this.camposExame.add(ANALYSE_FLAG2);
        this.camposExame.add(ANALYSE_MINVALUE);
        this.camposExame.add(ANALYSE_MAXVALUE);
        this.camposExame.add(ANALYSE_SUM1);
        this.camposExame.add(ANALYSE_SUM2);
        this.camposExame.add(ANALYSE_SUMFACTOR);
        this.camposExame.add(ANALYSES_2RESULT);
        this.camposExame.add(ANALYSE_SERUM);
        this.camposExame.add(ANALYSE_URINE24H);
    }

    public String getErroTraduzido(String erro) {
        return erro;
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0004');
    }

    @Override
    public String getMsgStart() {
        return "";
    }

    void limpaDadosRequisicao() {
        this.ultimoFrame = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        if (acao.equals("R")) {
            this.requisitarResultado();
            return "";
        }
        this.frames.clear();
        this.fil_codigo = fil_codigo;
        this.int_codigo = int_codigo;
        this.req_codigo = req_codigo;
        this.pac_nome = pac_nome;
        this.pac_sexo = pac_sexo;
        this.req_idade = pac_idade;
        this.req_data = data;
        this.req_hora = hora;
        this.mco_codigo = mco_codigo;
        this.rec_codigo = rec_codigo;
        this.pac_exames = exames;
        this.acao = acao;
        try {
            String mat;
            if (acao.equalsIgnoreCase("C")) {
                return "";
            }
            String nome = pac_nome;
            String sobreNome = "";
            if (pac_nome.indexOf(32) > 0) {
                nome = pac_nome.substring(0, pac_nome.indexOf(32));
                sobreNome = pac_nome.substring(pac_nome.indexOf(32) + 1);
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            req_codigo = StringUtil.preencheString(Integer.toString(Integer.parseInt(req_codigo)), ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo).append(rec_codigo);
            String emi_material = "S";
            String[] temp = exames.split(" ", 0);
            ArrayList<Object> exa_lista = new ArrayList<Object>();
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            int i = -1;
            for (String string : temp) {
                ExameMaterial exa = new ExameMaterial(string, new Integer(mco_codigo));
                Object exas = null;
                ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
                if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa.getString(), mco_codigo)) {
                    exas = BDUtil.getExamesFilhos(fil_codigo, int_codigo, exa.getString(), mco_codigo);
                    if (BDUtil.isExameCurva(fil_codigo, int_codigo, exa.getString(), mco_codigo)) {
                        exas = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, new ExameMaterial[]{exa}, exa_listaCurva);
                        ExamesUtil.desmembrarExames(Conexao.getStatement(), fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
                        alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, String.valueOf(Integer.parseInt(rec_codigo)), Conexao.getStatement(), exa_listaCurva, rec_codigo, true, new ArrayList<String>());
                        if (Funcoes.objectIsNull(exas)) {
                            exas = new ExameMaterial[]{};
                        }
                    }
                } else {
                    exas = new ExameMaterial[]{new ExameMaterial(exa.getString(), Integer.parseInt(mco_codigo))};
                }
                for (Object e : exas) {
                    if (exa_lista.contains(e)) continue;
                    exa_lista.add(e);
                }
            }
            if (!(exa_lista.isEmpty() || Funcoes.textoVazio(((ExameMaterial)exa_lista.get(0)).getNomeExame()) || Funcoes.textoVazio(mat = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((ExameMaterial)exa_lista.get(0)).getNomeExame(), mco_codigo, int_codigo)))) {
                emi_material = mat;
            }
            String clone = "N";
            ArrayList<String> alternativos = new ArrayList<String>();
            for (ExameMaterial exameMaterial : exa_lista) {
                String exa_alternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exameMaterial.getNomeExame(), mco_codigo, int_codigo);
                if (alternativos.contains(exa_alternativo)) continue;
                alternativos.add(exa_alternativo);
            }
            String posicaoBandeja = Funcoes.textoVazio(rackposition) ? "00" : rackposition;
            String string = acao.equals("N") ? "N" : "Y";
            Mensagem[] mensages = new Mensagem[]{};
            if (!Funcoes.objectIsNull(alternativosCurva) && alternativosCurva.size() > 0) {
                for (String key : alternativosCurva.keySet()) {
                    String codigoTubo = StringUtil.preencheString(key, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
                    StringBuilder etiquetaCurva = new StringBuilder(fil_codigo);
                    etiquetaCurva.append(req_codigo);
                    etiquetaCurva.append(codigoTubo);
                    ArrayList<String> listaAlternativoCurva = new ArrayList<String>();
                    listaAlternativoCurva.add(((ExameMaterial)((List)alternativosCurva.get(key)).get(0)).getString());
                    String mensagemAlternativoCurva = this.montaMensagemEnvio(etiquetaCurva.toString(), nome, sobreNome, "R", pac_sexo, pac_idade, false, "N", emi_material, posicaoBandeja, string, listaAlternativoCurva);
                    mensages = ArraysUtil.concatenar(mensages, new Mensagem[]{new Mensagem(mensagemAlternativoCurva, fil_codigo, int_codigo, req_codigo, codigoTubo, alternativosCurva.get(key).get(0).getCodigoMaterial(), alternativosCurva.get(key).get(0).getString())});
                }
            }
            String mensagem = null;
            if (!alternativos.contains(null)) {
                if (!alternativos.isEmpty()) {
                    mensagem = this.montaMensagemEnvio(codigo.toString(), nome, sobreNome, "R", pac_sexo, pac_idade, false, "N", emi_material, posicaoBandeja, string, alternativos);
                    mensages = ArraysUtil.concatenar(mensages, new Mensagem[]{new Mensagem(mensagem, fil_codigo, int_codigo, req_codigo, rec_codigo, mco_codigo, exames)});
                }
            } else {
                String req = fil_codigo + req_codigo;
                req = req + Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
                this.equipamento.addLinhaErro(req, this.pac_exames);
                this.fireExcecaoEncontrada("Existe c\u00f3digo alternativo nulo na requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo + " com os exames " + this.pac_exames);
                return null;
            }
            for (Mensagem m : mensages) {
                this.frames.add(m);
                this.setTX(15000);
                this.tx_counter = 0;
                this.getPortaCOM().write(String.valueOf('\u0002'));
            }
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private String montaMensagemEnvio(String codigo, String nome, String sobreNome, String listType, String sexo, String notas, boolean controle, String clone, String tipoAmostra, String posicaoBandeja, String repeticao, List<String> alternativos) {
        StringBuilder worklist = new StringBuilder();
        worklist.append(codigo);
        worklist.append(Funcoes.preencheVazio(nome, 20, 2));
        worklist.append(Funcoes.preencheVazio(sobreNome, 40, 2));
        worklist.append(sexo);
        worklist.append(listType);
        worklist.append(tipoAmostra);
        worklist.append(clone);
        worklist.append(posicaoBandeja);
        worklist.append(Funcoes.preencheZero(alternativos.size(), 2));
        for (String alternativo : alternativos) {
            worklist.append(Funcoes.preencheVazio(alternativo, 4, 2));
        }
        String checkSum = this.getChecksumMod256(worklist.toString());
        worklist.append(checkSum).append(this.getMsgEnd());
        return worklist.toString();
    }

    private void requisitarResultado() {
        try {
            if (!this.isRX() && !this.isTX()) {
                TelaBuscaResultado telaBuscaResultado = new TelaBuscaResultado(this.getAba(1));
                telaBuscaResultado.setVisible(true);
                if (telaBuscaResultado.isOk()) {
                    this.buscarResultados(telaBuscaResultado.getTipoSolicitacao());
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, "Erro  - " + e.getMessage(), e.getStackTrace());
        }
    }

    private void buscarResultados(String tipoSolicitacao) throws IOException {
        this.frames.clear();
        this.solicitadoResultado = true;
        this.frames.add(new Mensagem(tipoSolicitacao + '\u0004'));
        this.getPortaCOM().clearInputString();
        this.getPortaCOM().write(String.valueOf('\u0002'));
    }

    public void addRequisicaoLote(String requisicao, String tubo, String exames, String int_codigo, String mco_codigo) {
        try {
            String mat;
            String codigo = requisicao + StringUtil.preencheString(tubo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            String fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = tubo;
            String emi_material = "S";
            String[] temp = exames.split(" ", 0);
            ArrayList<ExameMaterial> exa_lista = new ArrayList<ExameMaterial>();
            int i = -1;
            for (String t : temp) {
                ExameMaterial exa = new ExameMaterial(t, new Integer(mco_codigo));
                ExameMaterial[] exas = null;
                exas = BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa.getString(), mco_codigo) ? BDUtil.getExamesFilhos(fil_codigo, int_codigo, exa.getString(), mco_codigo) : new ExameMaterial[]{new ExameMaterial(exa.getString(), Integer.parseInt(mco_codigo))};
                for (ExameMaterial e : exas) {
                    if (exa_lista.contains(e)) continue;
                    exa_lista.add(e);
                }
            }
            if (!Funcoes.textoVazio(((ExameMaterial)exa_lista.get(0)).getNomeExame()) && !Funcoes.textoVazio(mat = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((ExameMaterial)exa_lista.get(0)).getNomeExame(), mco_codigo, int_codigo))) {
                emi_material = mat;
            }
            String clone = "N";
            StringBuilder worklist = new StringBuilder(Funcoes.preencheZero(codigo.toString(), 15)).append("T").append(emi_material).append(clone).append("00");
            worklist.append(StringUtil.preencheString(Integer.toString(exa_lista.size()), 2, '0', 1));
            for (ExameMaterial exa : exa_lista) {
                String exa_alternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exa.getNomeExame(), mco_codigo, int_codigo);
                worklist.append(Funcoes.preencheVazio(exa_alternativo, 4, 2));
            }
            worklist.append(this.getChecksumMod256(worklist.toString()));
            worklist.append(this.getMsgEnd());
            this.frames.add(new Mensagem(String.valueOf('\u0002')));
            this.frames.add(new Mensagem(worklist.toString(), fil_codigo, int_codigo, req_codigo, rec_codigo, mco_codigo, exames));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    public void enviarLote() throws IOException {
        this.setTX(15000);
        this.tx_counter = 0;
        Mensagem m = this.frames.remove(0);
        if (!m.isHandShake().booleanValue()) {
            this.fil_codigo = m.getFil_codigo();
            this.int_codigo = m.getInt_codigo();
            this.req_codigo = m.getReq_codigo();
            this.rec_codigo = m.getRec_codigo();
            this.mco_codigo = m.getMco_codigo();
            this.pac_exames = m.getPac_exames();
            this.acao = "N";
        }
        this.getPortaCOM().write(m.getMensagem());
    }

    @Override
    public String parse(String msg) {
        try {
            if (this.validaMsg(msg)) {
                Statement st = Conexao.getStatement();
                int digTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                Map<String, Object> fields = this.parseFields(msg);
                String req_codigo = this.ultimaRequisicao = (String)fields.get(PATIENT_CODE);
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                String rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                try {
                    Long.parseLong(req_codigo);
                }
                catch (Exception ex) {
                    StringBuilder ms = new StringBuilder();
                    ms.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                    ms.append(req_codigo);
                    this.fireExcecaoEncontrada(msg.toString());
                    return "";
                }
                Map resultados = (Map)fields.get(LISTA_EXAMES);
                for (String key : resultados.keySet()) {
                    String emi_alternativo = key.trim();
                    String resultado = ((String)resultados.get(key)).trim();
                    String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                    if (Funcoes.textoVazio(int_codigo)) {
                        this.fireExcecaoEncontrada("Interfaceamento do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                        continue;
                    }
                    ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                    if (exame == null) {
                        this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                        continue;
                    }
                    HashMap<String, Object> dados = new HashMap<String, Object>();
                    int sit = -1;
                    if (BDUtil.existeDesmembramento(fil_codigo, int_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial())) {
                        ExameMaterial[] examesPais;
                        for (ExameMaterial examePai : examesPais = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial())) {
                            sit = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, examePai.getNomeExame(), examePai.getCodigoMaterial(), rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial());
                        }
                    } else {
                        sit = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
                    }
                    if (sit == 2 || sit == 7) continue;
                    String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                    dados.put(campo, resultado.replaceAll("\\.", ","));
                    this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
                }
            }
            Conexao.arquivaSQL();
            return "";
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, String.format("Erro ao inserir resultados recebidos ao banco de dados %s\n", this.ultimaRequisicao) + ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
                return String.format("Erro ao inserir resultados recebidos ao banco de dados %s", this.ultimaRequisicao);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                return String.format("Erro ao inserir resultados recebidos ao banco de dados %s", this.ultimaRequisicao);
            }
        }
    }

    private Map<String, Object> parseFields(String message) {
        String msg = message.substring(0);
        if (msg.startsWith(String.valueOf('\u0002'))) {
            msg = message.substring(1);
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        HashMap<String, String> exames = new HashMap<String, String>();
        fields.put(LISTA_EXAMES, exames);
        int digTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        fields.put(PATIENT_CODE, msg.substring(0, digTubo));
        int qtExames = 0;
        try {
            qtExames = Integer.parseInt(msg.substring(digTubo + 1, digTubo + 3));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage() + "\n " + msg, e.getStackTrace());
        }
        for (int i = 0; i < qtExames; ++i) {
            int pos = i * 11;
            String resultado = msg.substring(digTubo + 3 + pos, digTubo + 3 + pos + 11);
            String emi_alternativo = resultado.substring(0, 4);
            String valorResultado = resultado.substring(4);
            exames.put(emi_alternativo, valorResultado);
        }
        return fields;
    }

    private boolean validaMsg(String message) {
        String checkSum = Funcoes.preencheZero(message.substring(message.length() - 4, message.length() - 1), 3);
        String msg = message.substring(0, message.length() - 4);
        String calcCheckSum = this.getChecksumMod256(msg);
        boolean ret = calcCheckSum.equals(checkSum);
        if (!ret) {
            this.fireExcecaoEncontrada(String.format("Erro de comunica\u00e7\u00e3o Check Sum recebido (%s) diferente do calculado (%s)", checkSum, calcCheckSum));
        }
        return ret;
    }

    public void encerrarTransmissao() throws Exception {
        if (this.tx_counter < 2) {
            Statement st = Conexao.getStatement();
            for (String exame : this.pac_exames.split(" ")) {
                int sitAtual;
                String int_codigo = this.int_codigo;
                if (int_codigo == null) {
                    int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, exame, this.mco_codigo);
                }
                int novaSit = (sitAtual = this.getExameSituacao(st, this.fil_codigo, int_codigo, this.req_codigo, exame, this.mco_codigo, this.rec_codigo)) < 2 ? 1 : 3;
                this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, exame, this.mco_codigo, int_codigo, null, novaSit);
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + this.pac_nome, 0, 10000);
            if (this.acao.equals("N")) {
                this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
            }
        }
        this.interromperTimer();
        this.getPortaCOM().clearInputString();
        this.limpaDadosRequisicao();
        this.setIdle();
        this.fireAtualizarTabela(0);
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(15000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    public void caracterNaoEsperado(String message) throws Exception {
        String mensagem = "comando desconhecido";
        if (message != null && message.startsWith("N")) {
            String errorCode = message.substring(1);
            char erro = errorCode.charAt(0);
            if (erro > '\u0000') {
                switch (erro) {
                    case '\u0001': {
                        mensagem = "N\u00famero de an\u00e1lises inv\u00e1lido";
                        break;
                    }
                    case '\u0002': {
                        mensagem = "Dados Inv\u00e1lidos (n\u00e3o por meio de vari\u00e1veis)";
                        break;
                    }
                    case '\u0003': {
                        mensagem = "Dados Inv\u00e1lidos (atrav\u00e9s de vari\u00e1veis)";
                        break;
                    }
                    case '\u0004': {
                        mensagem = "Uma vari\u00e1vel de an\u00e1lise est\u00e1 fora do BEGIN SET / END relativa para a an\u00e1lise";
                        break;
                    }
                    case '\u0012': {
                        mensagem = "O paciente n\u00e3o deve ser repetido";
                        break;
                    }
                    case '\u0013': {
                        mensagem = "O campo correspondente ao soro/urina diferente do paciente na mem\u00f3ria";
                        break;
                    }
                    case '\u0014': {
                        mensagem = "Lista de pacientes completa";
                        break;
                    }
                    case '\u0015': {
                        mensagem = "Lista transmitida diferente da original";
                        break;
                    }
                    case '\u0016': {
                        mensagem = "Um paciente foi enviado depois de atribuir-lhe uma determinada posi\u00e7\u00e3o, que j\u00e1 est\u00e1 ocupada.";
                        break;
                    }
                    case '\u0017': {
                        mensagem = "O paciente j\u00e1 est\u00e1 na lista (ou que tenha sido executado), o campo Clone n\u00e3o est\u00e1 habilitado, mas a lista de atribui\u00e7\u00e3o diferente em compara\u00e7\u00e3o com a do paciente armazenado no analisador.";
                        break;
                    }
                    case '\u0018': {
                        mensagem = "O c\u00f3digo transmitido pertence a um paciente executado, mas nem os campos Repeti\u00e7\u00e3o e Clone foram ativados.";
                        break;
                    }
                    default: {
                        mensagem = "repeti\u00e7\u00e3o n\u00e3o permitida";
                    }
                }
            }
            this.fireMensagemEnviada("Erro ao enviar (" + mensagem + ")...", 0, 10000);
            this.encerrarTransmissao();
        }
    }

    private void tratarAcknowledge() throws Exception {
        if (this.isTX() || this.frames.size() > 0) {
            this.enviarProximoFrame();
        }
    }

    private void tratarStx() throws Exception {
        this.getPortaCOM().write(String.valueOf('\u0006'));
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0006': {
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0002': {
                    this.tratarStx();
                    break;
                }
                case '\u0015': {
                    this.tratarNak();
                    break;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento.", 1, 5000);
            this.setIdle();
        }
    }

    private void tratarNak() {
        if (this.solicitadoResultado) {
            this.solicitadoResultado = false;
            this.frames.clear();
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (this.isTX()) {
                if (message.length() == 1 && message.equalsIgnoreCase("Y")) {
                    this.encerrarTransmissao();
                    return;
                }
                if (message.length() == 2 && message.startsWith("Y") && message.substring(1).equalsIgnoreCase(String.valueOf('\u0000'))) {
                    this.encerrarTransmissao();
                    return;
                }
                if (message.length() == 2 && message.startsWith(String.valueOf('\u0006')) && message.substring(1).equalsIgnoreCase("Y")) {
                    this.encerrarTransmissao();
                    return;
                }
                if (message.length() == 2 && message.equalsIgnoreCase("N")) {
                    this.caracterNaoEsperado(message);
                    return;
                }
            }
            if (!(message = this.getPortaCOM().removeInputString(this.getMsgEnd())).equals("") && message.endsWith(this.getMsgEnd())) {
                this.addListaRecebimento(message);
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void envioRecusado(String message) {
        Integer errorCode = message.charAt(1);
        if (this.msgErros.containsKey(errorCode)) {
            this.fireExcecaoEncontrada(String.format("Aparelho recusou o envio (%s - %s)", String.valueOf(errorCode), this.msgErros.get(errorCode)));
        } else {
            this.fireExcecaoEncontrada(String.format("Aparelho recusou o envio (Erro desconhecido)", String.valueOf(errorCode), this.msgErros.get(errorCode)));
        }
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        try {
            if (this.isTX()) {
                this.limpaDadosRequisicao();
                this.setPausa(5000);
                this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
                this.setIdle();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    @Override
    protected void encerrar() {
        super.encerrar();
        if (this.timerResultados != null) {
            this.timerResultados.stop();
        }
    }

    @Override
    public void teste() {
        String req = "010005334702";
        req = Funcoes.preencheZero(req, 15);
        req = Funcoes.preencheVazio(req, 15, 2);
        this.handShakeCharReceived('\u0006');
    }

    private void enviarProximoFrame() throws IOException {
        if (this.frames.size() > 0) {
            this.ultimoFrame = this.frames.remove(0);
            if (!this.ultimoFrame.isHandShake().booleanValue()) {
                this.fil_codigo = this.ultimoFrame.getFil_codigo();
                this.int_codigo = this.ultimoFrame.getInt_codigo();
                this.req_codigo = this.ultimoFrame.getReq_codigo();
                this.rec_codigo = this.ultimoFrame.getRec_codigo();
                this.mco_codigo = this.ultimoFrame.getMco_codigo();
                this.pac_exames = this.ultimoFrame.getPac_exames();
                this.acao = "N";
            }
            this.getPortaCOM().clearInputString();
            this.getPortaCOM().write(this.ultimoFrame.getMensagem());
            if (this.solicitadoResultado) {
                this.solicitadoResultado = false;
            }
        }
    }

    public String getChecksumMod256(String s) {
        int sum = 0;
        for (int i = 0; i < s.length(); ++i) {
            sum += (byte)s.charAt(i);
        }
        int checksum = sum % 256;
        return Funcoes.preencheZero(checksum, 3);
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
                InterfaceListener.this.fireAtualizarTabela();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private class TelaBuscaResultado
    extends JDialog
    implements ActionListener {
        private String tipoSolicitacao;
        private boolean ok = false;
        private JPanel panelBotoes = new JPanel(new FlowLayout(2));
        private JPanel panelCentro = new JPanel(new GridBagLayout());
        private JButton buttonOk = ComponenteFactory.novoJButton("OK", this);
        private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", this);
        private JComboBox comboRelatorio = ComponenteFactory.novoJComboBox(new String[]{"Pr\u00f3ximo relat\u00f3rio", "\u00daltimo relat\u00f3rio", "Primeiro relat\u00f3rio"});

        public TelaBuscaResultado(JPanel pai) {
            this.setTitle("Solicitar Resultado");
            this.setLayout(new BorderLayout());
            this.setLocationRelativeTo(pai);
            this.setModal(true);
            this.buttonOk.setMnemonic('K');
            this.buttonCancelar.setMnemonic('C');
            this.panelBotoes.add(this.buttonOk);
            this.panelBotoes.add(this.buttonCancelar);
            this.comboRelatorio.setPreferredSize(new Dimension(200, 20));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.insets = new Insets(1, 1, 1, 1);
            c.gridx = 0;
            c.gridy = 0;
            this.panelCentro.add((Component)new JLabel("Tipo solicita\u00e7\u00e3o:"), c);
            c.gridx = 1;
            c.gridy = 0;
            this.panelCentro.add((Component)this.comboRelatorio, c);
            c.gridx = 2;
            c.gridy = 0;
            this.add((Component)this.panelCentro, "Center");
            this.add((Component)this.panelBotoes, "South");
            Funcoes.montaEnter((JComponent)this.panelCentro);
            Funcoes.montaEnter((JComponent)this.panelBotoes);
            this.pack();
        }

        public String getTipoSolicitacao() {
            return this.tipoSolicitacao;
        }

        public boolean isOk() {
            return this.ok;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o == this.buttonOk) {
                if (this.comboRelatorio.getSelectedIndex() == 0) {
                    this.tipoSolicitacao = "R";
                } else if (this.comboRelatorio.getSelectedIndex() == 1) {
                    this.tipoSolicitacao = "L";
                } else if (this.comboRelatorio.getSelectedIndex() == 2) {
                    this.tipoSolicitacao = "A";
                }
                this.ok = true;
            } else if (o == this.buttonCancelar) {
                this.ok = false;
            }
            this.setVisible(false);
        }
    }
}

