/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.c560;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.configuracao.EquipamentoFilial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceHl7Listener {
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    public InterfaceListener() {
        super("C560");
    }

    public InterfaceListener(String c560) {
        super(c560);
        this.threadRecebimento.start();
    }

    @Override
    protected void messageOruR01Recebida(MessageOruR01 oruR01) {
        MessageAckR01 ackR01 = new MessageAckR01();
        ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
        ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
        ackR01.getMsa().setTextMessage("Mensagem aceita");
        ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
        this.addListaRecebimento(oruR01);
        this.restartThreadRecebimento();
        this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
    }

    @Override
    public synchronized void dataChanged() {
        String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
        if (!Funcoes.textoVazio(message) && this.messageParser.checkMessage(message)) {
            this.parse(message);
            if (this.getPortaCOM().getInputString().length() > 0) {
                this.dataChanged();
            }
        }
    }

    @Override
    public String parse(String text) {
        try {
            String[] messages = text.split(this.getMsgEnd());
            if (messages.length > 1) {
                for (String m : messages) {
                    m = m + this.getMsgEnd();
                    Message msg = this.messageParser.textToMessage(m);
                    this.mensagemRecebida(msg);
                }
            } else {
                Message message = this.messageParser.textToMessage(text);
                this.mensagemRecebida(message);
            }
        }
        catch (Exception e) {
            e.getStackTrace();
            return "Erro ao efetuar o parse da mensagem";
        }
        return null;
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u001c') + String.valueOf('\r');
    }

    public void addListaRecebimento(MessageOruR01 message) {
        this.threadRecebimento.addListaRecebimento(message);
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento == null || this.threadRecebimento.isInterrupted() || !this.threadRecebimento.isAlive()) {
            if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
                List<MessageOruR01> lista = this.threadRecebimento.getListaRecebimento();
                this.threadRecebimento = new ThreadRecebimento();
                this.threadRecebimento.addListaRecebimentos(lista);
            }
            if (this.threadRecebimento != null) {
                this.threadRecebimento.start();
            }
        }
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "Resultado"}, null);
        String requisicao = JOptionPane.showInputDialog(null, (Object)"Informe o Id da amostra:");
        if (!Funcoes.textoVazio(requisicao)) {
            if (op == 0) {
                StringBuilder tmpQuery = new StringBuilder();
                tmpQuery.append("[SB]MSH|^~\\&|||||20120508104700||QRY^Q02|4|P|2.3.1||||||ASCII|||[CR]");
                tmpQuery.append("QRD|20120508104700|R|D|1|||RD|" + requisicao + "|OTH|||T|[CR]");
                tmpQuery.append("QRF||||||RCT|COR|ALL||[CR]");
                tmpQuery.append("[EB][CR]");
                this.parse(TestesInterface.arruma(tmpQuery.toString()));
            } else if (op == 1) {
                StringBuilder tmpResult = new StringBuilder();
                tmpResult.append("[SB]MSH|^~\\&|||||20120508094822||ORU^R01|1|P|2.3.1||||0||ASCII|||[CR]");
                tmpResult.append("PID|1|1001|||Mike||19851001095133|M|||keshi|||||||||||||||beizhu|||||[CR]");
                tmpResult.append("OBR|1|" + requisicao + "|10|^|Y|20120405193926|20120405193914|20120405193914|||||linchuangzhenduan|20120405193914|serum|lincyisheng|keshi||||||||3|||||||||||||||||||||||[CR]");
                tmpResult.append("OBX|1|NM|2|TBil|100| umol/L |-|N|||F||100|20120405194245||yishen|0|[CR]");
                tmpResult.append("OBX|2|NM|5|ALT|98.2| umol/L |-|N|||F||98.2|20120405194403||yishen|0|[CR]");
                tmpResult.append("OBX|3|NM|6|AST|26.4| umol/L |-|N|||F||26.4|||yishen||[CR]");
                tmpResult.append("[EB][CR]");
                this.parse(TestesInterface.arruma(tmpResult.toString()));
            }
        }
    }

    class ThreadRecebimento
    extends Thread {
        private List<MessageOruR01> listaRecebimento = new ArrayList<MessageOruR01>();

        ThreadRecebimento() {
        }

        public List<MessageOruR01> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(MessageOruR01 message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(List<MessageOruR01> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (!this.listaRecebimento.isEmpty()) {
                    MessageOruR01 message = this.listaRecebimento.remove(0);
                    this.processaMensagem(message);
                    ThreadRecebimento.sleep(450L);
                }
                if (!InterfaceListener.this.equipamento.getStatusFecharInterfaceamento().isExportando()) {
                    InterfaceListener.this.fireAtualizarTabela();
                }
            }
            catch (InterruptedException e) {
                ErrorLogger.mostraMensagem(null, "Falha no processamento da ThreadRecebimento", e.getStackTrace(), "C560.InterfaceListener.ThreadRecebimento");
                Thread.currentThread().interrupt();
            }
        }

        private void processaMensagem(MessageOruR01 oruR01) {
            try {
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                String tuboId = oruR01.getObr().getPlacerOrderNumber();
                if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                    Statement st = Conexao.getStatement();
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
                    if (etiqueta != null) {
                        filCodigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                        reqCodigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                        recCodigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                    }
                    this.processarExames(oruR01, st, filCodigo, reqCodigo, recCodigo);
                    Conexao.arquivaSQL();
                    InterfaceListener.this.fireAtualizarTabela();
                } else {
                    InterfaceListener.this.fireExcecaoEncontrada(String.format("Amostra fora do padr\u00e3o utilizado ou amostra passada manualmente %s", tuboId));
                }
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }

        private void processarExames(MessageOruR01 oruR01, Statement st, String filCodigo, String reqCodigo, String recCodigo) throws Exception {
            for (MessageSegmentObx obx : oruR01.getObxList()) {
                String emiAlternativo = String.valueOf(obx.getObservationId());
                String intCodigo = InterfaceListener.this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                if (intCodigo == null) {
                    intCodigo = this.carregaIntCodigoExamesEmRepeticao(filCodigo, reqCodigo, recCodigo, intCodigo);
                }
                if (intCodigo == null) {
                    InterfaceListener.this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada na interface id %s %s %s alternativo %s", filCodigo, reqCodigo, recCodigo, emiAlternativo));
                    continue;
                }
                ExameMaterial exame = InterfaceListener.this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
                if (exame != null) {
                    HashMap<String, Object> dados = new HashMap<String, Object>();
                    ArrayList<String> flags = new ArrayList<String>();
                    if (obx.getAbnormalFlag() != null) {
                        flags.add(obx.getAbnormalFlag().toString());
                    }
                    int sit = InterfaceListener.this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                    String campo = this.carregarCampo(obx, sit);
                    String resultado = this.carregarResultado(filCodigo, obx, intCodigo, exame);
                    if (sit != 3 && sit != 5 && sit != 1 && sit != 0) continue;
                    dados.put(campo, resultado);
                    InterfaceListener.this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados, flags);
                    continue;
                }
                InterfaceListener.this.fireExcecaoEncontrada(String.format("Exame n\u00e3o localizado ou j\u00e1 exportado na interface id %s %s %s alternativo %s", filCodigo, reqCodigo, recCodigo, emiAlternativo));
            }
        }

        private String carregaIntCodigoExamesEmRepeticao(String filCodigo, String reqCodigo, String recCodigo, String intCodigo) throws SQLException {
            for (ConfiguracaoSerial c : Variaveis.equipamentos) {
                for (EquipamentoFilial f : c.getEquipamentos()) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("select int_codigo from interfaceexamerequisicao ");
                    buf.append("where fil_codigo = ").append(filCodigo);
                    buf.append("  and int_codigo = ").append(f.getEquipamento());
                    buf.append("  and req_codigo = ").append(reqCodigo);
                    buf.append("  and rec_codigo = ").append(recCodigo);
                    buf.append("  and ier_situacao = ").append(3);
                    Statement stTemp = Conexao.getStatement();
                    ResultSet rs = Conexao.executeQuery(stTemp, buf.toString());
                    if (rs.next()) {
                        intCodigo = rs.getString("int_codigo");
                    }
                    Conexao.fecharStatement(stTemp);
                }
            }
            return intCodigo;
        }

        private String carregarCampo(MessageSegmentObx obx, int sit) {
            String campo = "resultado_quantitativo";
            if (obx.getValueType().equals((Object)MessageSegmentObx.ValueType.NUMERIC)) {
                campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
            } else if (obx.getValueType().equals((Object)MessageSegmentObx.ValueType.STRING)) {
                campo = sit < 3 ? "resultado_qualitativo" : "repeticao_qualitativo";
            }
            return campo;
        }

        private String carregarResultado(String filCodigo, MessageSegmentObx obx, String intCodigo, ExameMaterial exame) {
            String resultado = "";
            if (obx.getValueType().equals((Object)MessageSegmentObx.ValueType.NUMERIC)) {
                resultado = obx.getObservationValue();
                resultado = InterfaceListener.this.arrendondaValor(resultado, filCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo);
                resultado = resultado.replace('.', ',');
            } else if (obx.getValueType().equals((Object)MessageSegmentObx.ValueType.STRING)) {
                resultado = obx.getObservationValue();
            }
            return resultado;
        }
    }
}

