/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bt150.util.datarecords;

import jalis.laboratorio.interfaceamento.interfaces.bt150.util.DataRecord;
import jalis.util.Funcoes;
import java.util.ArrayList;
import java.util.List;

public class PrologueDataRecord
implements DataRecord {
    private int numberOfLines;

    public PrologueDataRecord(int numberOfLines) {
        this.numberOfLines = numberOfLines;
    }

    public PrologueDataRecord() {
    }

    public int getNumberOfLines() {
        return this.numberOfLines;
    }

    public void setNumberOfLines(int numberOfLines) {
        this.numberOfLines = numberOfLines;
    }

    @Override
    public List<Integer> getFieldsSize() {
        ArrayList<Integer> sizes = new ArrayList<Integer>(1);
        sizes.add(5);
        return sizes;
    }

    @Override
    public List<Object> getFields() {
        ArrayList<Object> fields = new ArrayList<Object>(1);
        fields.add(this.numberOfLines);
        return fields;
    }

    @Override
    public void setFields(List<String> fields) {
        this.numberOfLines = Integer.parseInt(fields.get(0));
    }

    @Override
    public String dataRecordToString() {
        List<Integer> sizes = this.getFieldsSize();
        List<Object> fields = this.getFields();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < sizes.size(); ++i) {
            String field;
            int size = sizes.get(i);
            String string = field = i < fields.size() && fields.get(i) != null ? fields.get(i).toString() : "";
            if (field.length() > size) {
                field = field.substring(0, size);
            }
            builder.append(Funcoes.preencheVazio(field, sizes.get(i), 1));
        }
        return builder.toString();
    }

    @Override
    public void stringToDataRecord(String string) {
        List<Integer> sizes = this.getFieldsSize();
        ArrayList<String> fields = new ArrayList<String>(sizes.size());
        int percorrido = 0;
        for (int size : sizes) {
            if (percorrido + size > string.length()) {
                fields.add("");
            } else {
                fields.add(string.substring(percorrido, percorrido + size).trim());
            }
            percorrido += size;
        }
        this.setFields(fields);
    }
}

