/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bt150;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.bt150.util.Packet;
import jalis.laboratorio.interfaceamento.interfaces.bt150.util.PacketParser;
import jalis.laboratorio.interfaceamento.interfaces.bt150.util.datarecords.PrologueDataRecord;
import jalis.laboratorio.interfaceamento.interfaces.bt150.util.datarecords.ResultDataRecord;
import jalis.laboratorio.interfaceamento.interfaces.bt150.util.datarecords.WorkDataRecord;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private int linesToReceive = 0;
    private PacketParser packetParser;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    public InterfaceListener() {
        this.packetParser = new PacketParser();
    }

    @Override
    public synchronized String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        try {
            if (acao.equals("C")) {
                return "";
            }
            WorkDataRecord workDataRecord = this.createDataRecord(filCodigo, reqCodigo, recCodigo, mcoCodigo, intCodigo, pacNome, pacSexo, exames);
            ArrayList<WorkDataRecord> workDataRecords = new ArrayList<WorkDataRecord>();
            workDataRecords.add(workDataRecord);
            this.enviaWorkDataRecords(workDataRecords);
            Statement st = Conexao.getStatement();
            String[] stringArray = exames.split(" ");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String exame;
                int atual = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame = stringArray[i], mcoCodigo, recCodigo);
                this.atualizarSituacaoExame(st, filCodigo, reqCodigo, recCodigo, exame, mcoCodigo, intCodigo, null, atual < 2 ? 1 : 3);
            }
            Conexao.arquivaSQL();
            this.firePacienteEnviado(reqCodigo, pacNome, pacSexo, pacIdade, data, hora, exames);
            this.fireAtualizarTabela(0);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return "Erro ao enviar exames: " + e.getMessage();
        }
        return null;
    }

    private void enviaWorkDataRecords(List<WorkDataRecord> workDataRecords) throws IOException {
        if (!workDataRecords.isEmpty()) {
            int numberOfLines = workDataRecords.size();
            PrologueDataRecord prologueDataRecord = new PrologueDataRecord(numberOfLines);
            ArrayList<Packet> packets = new ArrayList<Packet>();
            packets.add(new Packet('P', prologueDataRecord.dataRecordToString()));
            for (WorkDataRecord workDataRecord : workDataRecords) {
                packets.add(new Packet('P', workDataRecord.dataRecordToString()));
            }
            for (Packet packet : packets) {
                this.getPortaCOM().write(this.packetParser.packetToString(packet));
            }
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\r');
    }

    @Override
    public String getMsgStart() {
        return "";
    }

    @Override
    public synchronized String parse(String message) {
        return null;
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public void dataChanged() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    String data = InterfaceListener.this.getPortaCOM().removeInputString(InterfaceListener.this.getMsgEnd());
                    if (data != null && data.endsWith(InterfaceListener.this.getMsgEnd())) {
                        System.out.println("1");
                        InterfaceListener.this.addListaRecebimento(data);
                        InterfaceListener.this.restartThreadRecebimento();
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento", 1, 5000);
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private void resultadoRecebido(ResultDataRecord resultado) throws Exception {
        if (!resultado.isResultOk()) {
            this.fireMensagemEnviada(resultado.getPid() + ": resultado com erro", 1, 5000);
            return;
        }
        int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        String requisicao = resultado.getPid();
        if (requisicao != null && requisicao.length() == digitosCodigoTubo && Funcoes.isNumeric(requisicao)) {
            String emi_alternativo;
            Statement st = Conexao.getStatement();
            String fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
            String int_codigo = this.getIntCodigo(fil_codigo, req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao()), rec_codigo, emi_alternativo = resultado.getTestName());
            ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
            if (exame != null) {
                String valorResultado = resultado.getResult().trim();
                if (valorResultado.endsWith(".")) {
                    valorResultado = valorResultado + "0";
                }
                if (valorResultado.startsWith(".")) {
                    valorResultado = "0" + valorResultado;
                }
                valorResultado = this.arrendondaValor(valorResultado, fil_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo);
                valorResultado = valorResultado.replace('.', ',');
                this.atualizarResultadoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, valorResultado);
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        this.getPortaCOM().clearInputString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmitirLote(List requisicoes, PanelAbaAbstrata aba) {
        int numberOfLines = requisicoes.size();
        ArrayList<WorkDataRecord> listWorkData = new ArrayList<WorkDataRecord>();
        Statement st = Conexao.getStatement();
        try {
            for (Object o : requisicoes) {
                Object[] req = (Object[])o;
                String fil_codigo = req[aba.getColIndice("C\u00f3digo")].toString();
                String req_codigo = fil_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                fil_codigo = fil_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String rec_codigo = req[aba.getColIndice("Tubo")].toString();
                String mco_codigo = req[aba.getColIndice("C\u00f3d. Mat.")].toString();
                String int_codigo = req[aba.getColIndice("Interface")].toString();
                String pac_nome = req[aba.getColIndice("Paciente")].toString();
                String pac_sexo = req[aba.getColIndice("S")].toString();
                String exames = req[aba.getColIndice("Exame")].toString();
                WorkDataRecord workData = this.createDataRecord(fil_codigo, req_codigo, rec_codigo, mco_codigo, int_codigo, pac_nome, pac_sexo, exames);
                if (workData == null) continue;
                listWorkData.add(workData);
                for (String exame : exames.split(" ")) {
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, 1);
                }
                this.firePacienteEnviado(req_codigo, pac_nome, pac_sexo, "", Funcoes.formataData("dd/MM/yyyy", new Date()), Funcoes.formataData("HH:mm", new Date()), exames);
                this.fireAtualizarTabela(0);
                if (listWorkData.size() != 10) continue;
                this.enviaWorkDataRecords(listWorkData);
                listWorkData.clear();
            }
            this.enviaWorkDataRecords(listWorkData);
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            try {
                st.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private WorkDataRecord createDataRecord(String fil_codigo, String req_codigo, String rec_codigo, String mco_codigo, String int_codigo, String pac_nome, String pac_sexo, String exames) {
        try {
            String tuboId = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao()) + Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
            for (String exame : exames.split(" ", 0)) {
                examesDaRequisicao.add(new ExameMaterial(exame, new Integer(mco_codigo)));
            }
            ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
            for (ExameMaterial exame : examesDaRequisicao) {
                if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exame.getString(), mco_codigo)) {
                    List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(fil_codigo, int_codigo, exame.getString(), mco_codigo));
                    examesParaEnviar.addAll(examesFilhos);
                    continue;
                }
                examesParaEnviar.add(exame);
            }
            String[] idade = BDUtil.getIdadeNacimentoPaciente(fil_codigo, req_codigo);
            String pacIdade = idade[0];
            if (Funcoes.textoVazio(pacIdade)) {
                pacIdade = "0";
            }
            HashSet<String> tests = new HashSet<String>();
            for (ExameMaterial exameParaEnviar : examesParaEnviar) {
                String test = BDUtil.getExmCodigoAlternativo(fil_codigo, exameParaEnviar.getNomeExame(), mco_codigo, int_codigo);
                if (test == null || test.trim().isEmpty()) continue;
                tests.add(test);
            }
            WorkDataRecord workDataRecord = new WorkDataRecord(tuboId, StringUtil.removerAcentos(pac_nome), Integer.parseInt(pacIdade), pac_sexo.equalsIgnoreCase("M") ? 1 : 0, 0, tests);
            return workDataRecord;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return null;
        }
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String data = this.listaRecebimento.remove(0);
                    System.out.println("1a");
                    if (data.length() > InterfaceListener.this.getMsgEnd().length()) {
                        System.out.println("2");
                        Packet packet = InterfaceListener.this.packetParser.stringToPacket(data);
                        if (packet != null && packet.getHeadChar() == 'R') {
                            System.out.println("3");
                            if (InterfaceListener.this.linesToReceive == 0) {
                                System.out.println("4");
                                PrologueDataRecord prologueDataRecord = new PrologueDataRecord();
                                prologueDataRecord.stringToDataRecord(packet.getData());
                                if (prologueDataRecord != null) {
                                    System.out.println("5");
                                    InterfaceListener.this.linesToReceive = prologueDataRecord.getNumberOfLines();
                                }
                            } else {
                                System.out.println("6");
                                InterfaceListener.this.linesToReceive--;
                                ResultDataRecord resultDataRecord = new ResultDataRecord();
                                resultDataRecord.stringToDataRecord(packet.getData());
                                if (resultDataRecord != null) {
                                    System.out.println("7");
                                    InterfaceListener.this.resultadoRecebido(resultDataRecord);
                                }
                            }
                        }
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

