/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bs600;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.configuracao.EquipamentoFilial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.bs400.InterfaceListener {
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    public InterfaceListener() {
        super("BS-600");
    }

    @Override
    protected void messageOruR01Recebida(MessageOruR01 oruR01) {
        this.processaMensagem(oruR01);
        MessageAckR01 ackR01 = new MessageAckR01();
        ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
        ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
        ackR01.getMsa().setTextMessage("Mensagem aceita");
        ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
        this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
    }

    private void processaMensagem(MessageOruR01 oruR01) {
        try {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String tuboId = oruR01.getObr().getPlacerOrderNumber();
            if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                Statement st = Conexao.getStatement();
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
                if (etiqueta != null) {
                    filCodigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                    reqCodigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                    recCodigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                }
                for (MessageSegmentObx obx : oruR01.getObxList()) {
                    String emiAlternativo = String.valueOf(obx.getObservationId());
                    String intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                    if (intCodigo == null) {
                        for (ConfiguracaoSerial c : Variaveis.equipamentos) {
                            for (EquipamentoFilial f : c.getEquipamentos()) {
                                System.out.println("Buscando para equipamento: " + f.getEquipamento());
                                StringBuilder buf = new StringBuilder();
                                buf.append("select int_codigo from interfaceexamerequisicao ");
                                buf.append("where fil_codigo = ").append(filCodigo);
                                buf.append("  and int_codigo = ").append(f.getEquipamento());
                                buf.append("  and req_codigo = ").append(reqCodigo);
                                buf.append("  and rec_codigo = ").append(recCodigo);
                                buf.append("  and ier_situacao = ").append(3);
                                Statement stTemp = Conexao.getStatement();
                                ResultSet rs = Conexao.executeQuery(stTemp, buf.toString());
                                if (rs.next()) {
                                    intCodigo = rs.getString("int_codigo");
                                }
                                Conexao.fecharStatement(stTemp);
                            }
                        }
                    }
                    if (intCodigo == null) {
                        this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada na interface id %s %s %s alternativo %s", filCodigo, reqCodigo, recCodigo, emiAlternativo));
                        continue;
                    }
                    ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
                    if (exame != null) {
                        HashMap<String, Object> dados = new HashMap<String, Object>();
                        ArrayList<String> flags = new ArrayList<String>();
                        if (obx.getAbnormalFlag() != null) {
                            flags.add(obx.getAbnormalFlag().toString());
                        }
                        int sit = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                        String campo = "resultado_quantitativo";
                        String resultado = "";
                        if (Funcoes.textoVazio(obx.getUnits())) continue;
                        switch (obx.getValueType()) {
                            case NUMERIC: {
                                campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                                resultado = obx.getObservationValue();
                                resultado = this.arrendondaValor(resultado, filCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo);
                                resultado = resultado.replace('.', ',');
                                break;
                            }
                            case STRING: {
                                campo = sit < 3 ? "resultado_qualitativo" : "repeticao_qualitativo";
                                resultado = obx.getObservationValue();
                            }
                        }
                        System.out.println(String.format("situacao = %s, filCodigo = %s, reqCodigo = %s, recCodigo = %s, exame.getNomeExame() = %s, exame.getCodigoMaterial() = %s, intCodigo = %s, emiAlternativo  = %s", sit, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, emiAlternativo));
                        if (sit != 3 && sit != 5 && sit != 1 && sit != 0) continue;
                        dados.put(campo, resultado);
                        this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados);
                        continue;
                    }
                    this.fireExcecaoEncontrada(String.format("Exame n\u00e3o localizado ou j\u00e1 exportado na interface id %s %s %s alternativo %s", filCodigo, reqCodigo, recCodigo, emiAlternativo));
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            } else {
                this.fireExcecaoEncontrada(String.format("Amostra fora do padr\u00e3o utilizado ou amostra passada manualmente %s", tuboId));
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public void addListaRecebimento(MessageOruR01 message) {
        this.threadRecebimento.addListaRecebimento(message);
    }

    @Override
    public void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<MessageOruR01> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void teste() {
        String[] reqs;
        for (String req : reqs = new String[]{"010005475204"}) {
            this.bs380Result(req, false);
        }
    }

    private void bs380Query(String tubo) {
        StringBuilder tmp = new StringBuilder();
        tmp.append("[SB]MSH|^~\\&|Mindray|BS-200|||20121114174828||QRY^Q02|434|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("QRD|20121114174848|R|D|139|||RD|").append(tubo).append("|OTH|||T|[CR]");
        tmp.append("QRF|BS-200|20121114174828|20121114174828|||RCT|COR|ALL||[CR][EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
        tmp.setLength(0);
        tmp.append("[SB]MSH|^~\\&|Mindray|BS-200|||20121114174828||ACK^Q03|434|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("MSA|AA|434|Message[SP]accepted|||0|[CR]ERR|0|[CR][EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
    }

    private void bs380Result(String tubo, boolean isCurva) {
        StringBuilder tmp = new StringBuilder();
        tmp.setLength(0);
        tmp.append("[SB]MSH|^~\\&|||||20170629101826||ORU^R01|4|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("PID|4|||||||O|||||||||||||||||||||||[CR]");
        tmp.append("OBR|4|" + tubo + "|3|^|N|20170629100552|20170629100449|20170629100449||1^3||||20170629100449|Soro|||||||||||||||||||||||||||||||||[CR]");
        tmp.append("OBX|1|NM|103|ALT[SP]/[SP]TGP[SP]BIOCLIN|54.716337|U/L|-|N|||F||54.716337|20170629101650|||0|[CR]");
        tmp.append("OBX|2|NM|104|AST[SP]/[SP][SP]TGO[SP]BIOCLIN|36.231521|U/L|-|N|||F||36.231521|20170629101656|||0|[CR]");
        tmp.append("OBX|3|NM|108|COLESTEROL[SP]BIOCLIN|180.628363|mg/dL|-|N|||F||180.628363|20170629101756|||0|[CR]");
        tmp.append("OBX|4|NM|113|GAMA[SP]GT[SP]BIOCLIN|45.862417|U/L|-|N|||F||45.862417|20170629101708|||0|[CR]");
        tmp.append("OBX|5|NM|115|HDL[SP]DIALAB|45.559952|mg/dL|-|N|||F||45.559952|20170629101826|||0|[CR]");
        tmp.append("OBX|6|NM|121|TRIGLICERIDIOS[SP]BIOCLIN|97.446762|mg/dL|-|N|||F||97.446762|20170629101814|||0|[CR]");
        tmp.append("OBX|7|NM||LDL|115.600000|mg/dL|-|N|||F||115.600000|||||[CR]");
        tmp.append("OBX|8|NM||LIP[SP]TOTAIS|746.340000|mg/dL|-|N|||F||746.340000|||||[CR]");
        tmp.append("OBX|9|NM||COL[SP]NAO[SP]HDL|135.000000|mg/dL|-|N|||F||135.000000|||||[CR]");
        tmp.append("[EB][CR]");
        if (!isCurva) {
            this.parse(TestesInterface.arruma(tmp.toString()));
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<MessageOruR01> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<MessageOruR01> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(MessageOruR01 message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<MessageOruR01> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    MessageOruR01 message = this.listaRecebimento.remove(0);
                    InterfaceListener.this.processaMensagem(message);
                    ThreadRecebimento.sleep(450L);
                }
                if (!InterfaceListener.this.equipamento.getStatusFecharInterfaceamento().isExportando()) {
                    InterfaceListener.this.fireAtualizarTabela();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

