/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bs400;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.configuracao.EquipamentoFilial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceHl7Listener {
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    public InterfaceListener() {
        super("BS-400");
    }

    public InterfaceListener(String bs600) {
        super(bs600);
        this.threadRecebimento.start();
    }

    @Override
    protected void messageOruR01Recebida(MessageOruR01 oruR01) {
        MessageAckR01 ackR01 = new MessageAckR01();
        ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
        ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
        ackR01.getMsa().setTextMessage("Mensagem aceita");
        ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
        this.addListaRecebimento(oruR01);
        this.restartThreadRecebimento();
        this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
    }

    @Override
    public synchronized void dataChanged() {
        String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
        if (!Funcoes.textoVazio(message) && this.messageParser.checkMessage(message)) {
            this.parse(message);
            if (this.getPortaCOM().getInputString().length() > 0) {
                this.dataChanged();
            }
        }
    }

    @Override
    public String parse(String text) {
        try {
            String[] messages = text.split(this.getMsgEnd());
            if (messages.length > 1) {
                for (String m : messages) {
                    m = m + this.getMsgEnd();
                    Message msg = this.messageParser.textToMessage(m);
                    this.mensagemRecebida(msg);
                }
            } else {
                Message message = this.messageParser.textToMessage(text);
                this.mensagemRecebida(message);
            }
        }
        catch (Exception e) {
            e.getStackTrace();
            return "Erro ao efetuar o parse da mensagem";
        }
        return null;
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u001c') + String.valueOf('\r');
    }

    public void addListaRecebimento(MessageOruR01 message) {
        this.threadRecebimento.addListaRecebimento(message);
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento == null || this.threadRecebimento.isInterrupted() || !this.threadRecebimento.isAlive()) {
            if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
                List<MessageOruR01> lista = this.threadRecebimento.getListaRecebimento();
                this.threadRecebimento = new ThreadRecebimento();
                this.threadRecebimento.addListaRecebimentos(lista);
            }
            if (this.threadRecebimento != null) {
                this.threadRecebimento.start();
            }
        }
    }

    @Override
    public void teste() {
        this.bs400Result();
    }

    private void bs400Result() {
        StringBuilder tmp = new StringBuilder();
        String tubo = JOptionPane.showInputDialog(null, "Informe o Id da amostra?", "010051238938");
        tmp.append("[SB]MSH|^~\\&|Mindray|BS-400|||20171117161318||ORU^R01|518|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("PID|107||||JULIO[SP]CESAR[SP]LIMP[SP]PINHEIRO||19000101000000|M|||||||||||||||||||||||[CR]");
        tmp.append("OBR|107|" + tubo + "|70|Mindray^BS-400|N|||||||||20171117155053|Soro|||||||||||||||||||||||||||||||||[CR]");
        tmp.append("OBX|1|NM|1|GLIC|125.991679|mg/dL|50.000000-99.000000|H|||F||125.991679|||||[CR]");
        tmp.append("OBX|2|NM|2|COL|165.975667|mg/dL|0.000000-200.000000|N|||F||165.975667|||||[CR]");
        tmp.append("OBX|3|NM|3|TRI|145.429575|mg/dL|0.000000-200.000000|N|||F||145.429575|||||[CR]");
        tmp.append("OBX|4|NM|4|HDL|54.370979|mg/dL|35.000000-65.000000|N|||F||54.370979|||||[CR]");
        tmp.append("OBX|5|NM|5|UREA|36.613718|mg/dL|10.000000-45.000000|N|||F||36.613718|||||[CR]");
        tmp.append("OBX|6|NM|6|CRE|1.482866|mg/dL|0.400000-1.400000|H|||F||1.482866|||||[CR]");
        tmp.append("OBX|7|NM|7|URIC|5.195492|mg/dL|2.500000-7.500000|N|||F||5.195492|||||[CR]");
        tmp.append("OBX|8|NM|8|TGO|22.296190|U/L|5.000000-38.000000|N|||F||22.296190|||||[CR]");
        tmp.append("OBX|9|NM|9|TGP|24.012417|U/L|10.000000-40.000000|N|||F||24.012417|||||[CR]");
        tmp.append("OBX|10|NM|13|GGT|25.054650|U/L|12.000000-45.000000|N|||F||25.054650|||||[CR]");
        tmp.append("OBX|11|NM|16|CKT|123.939070|U/L|24.000000-195.000000|N|||F||123.939070|||||[CR]");
        tmp.append("OBX|12|NM|18|FOS|3.797200|mg/dL|2.500000-5.600000|N|||F||3.797200|||||[CR]");
        tmp.append("OBX|13|NM|20|CAL|10.169927|mg/dL|8.800000-11.000000|N|||F||10.169927|||||[CR]");
        tmp.append("OBX|14|NM|23|PROT|7.398629|g/dL|6.000000-8.000000|N|||F||7.398629|||||[CR]");
        tmp.append("OBX|15|NM|24|ALB|5.030171|g/dL|3.500000-5.500000|N|||F||5.030171|||||[CR]");
        tmp.append("[EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
    }

    private void bs400Query(String tubo) {
        StringBuilder tmp = new StringBuilder();
        tmp.append("[SB]MSH|^~\\&|Mindray|BS-200|||20121114174828||QRY^Q02|434|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("QRD|20121114174848|R|D|139|||RD|").append(tubo).append("|OTH|||T|[CR]");
        tmp.append("QRF|BS-200|20121114174828|20121114174828|||RCT|COR|ALL||[CR][EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
        tmp.setLength(0);
        tmp.append("[SB]MSH|^~\\&|Mindray|BS-200|||20121114174828||ACK^Q03|434|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("MSA|AA|434|Message[SP]accepted|||0|[CR]ERR|0|[CR][EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
    }

    private void bs400Result(String tubo, boolean isCurva) {
        StringBuilder tmp = new StringBuilder();
        tubo = JOptionPane.showInputDialog(null, "Informe o Id da amostra?", "0102661704");
        tmp.append("[SB]MSH|^~\\&|Mindray|BS-400|||20171117161318||ORU^R01|518|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("PID|107||||JULIO[SP]CESAR[SP]LIMP[SP]PINHEIRO||19000101000000|M|||||||||||||||||||||||[CR]");
        tmp.append("OBR|107|" + tubo + "|70|Mindray^BS-400|N|||||||||20171117155053|Soro|||||||||||||||||||||||||||||||||[CR]");
        tmp.append("OBX|1|NM|1|GLIC|125.991679|mg/dL|50.000000-99.000000|H|||F||125.991679|||||[CR]");
        tmp.append("OBX|2|NM|2|COL|165.975667|mg/dL|0.000000-200.000000|N|||F||165.975667|||||[CR]");
        tmp.append("OBX|3|NM|3|TRI|145.429575|mg/dL|0.000000-200.000000|N|||F||145.429575|||||[CR]");
        tmp.append("OBX|4|NM|4|HDL|54.370979|mg/dL|35.000000-65.000000|N|||F||54.370979|||||[CR]");
        tmp.append("OBX|5|NM|5|UREA|36.613718|mg/dL|10.000000-45.000000|N|||F||36.613718|||||[CR]");
        tmp.append("OBX|6|NM|6|CRE|1.482866|mg/dL|0.400000-1.400000|H|||F||1.482866|||||[CR]");
        tmp.append("OBX|7|NM|7|URIC|5.195492|mg/dL|2.500000-7.500000|N|||F||5.195492|||||[CR]");
        tmp.append("OBX|8|NM|8|TGO|22.296190|U/L|5.000000-38.000000|N|||F||22.296190|||||[CR]");
        tmp.append("OBX|9|NM|9|TGP|24.012417|U/L|10.000000-40.000000|N|||F||24.012417|||||[CR]");
        tmp.append("OBX|10|NM|13|GGT|25.054650|U/L|12.000000-45.000000|N|||F||25.054650|||||[CR]");
        tmp.append("OBX|11|NM|16|CKT|123.939070|U/L|24.000000-195.000000|N|||F||123.939070|||||[CR]");
        tmp.append("OBX|12|NM|18|FOS|3.797200|mg/dL|2.500000-5.600000|N|||F||3.797200|||||[CR]");
        tmp.append("OBX|13|NM|20|CAL|10.169927|mg/dL|8.800000-11.000000|N|||F||10.169927|||||[CR]");
        tmp.append("OBX|14|NM|23|PROT|7.398629|g/dL|6.000000-8.000000|N|||F||7.398629|||||[CR]");
        tmp.append("OBX|15|NM|24|ALB|5.030171|g/dL|3.500000-5.500000|N|||F||5.030171|||||[CR]");
        tmp.append("[EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
    }

    class ThreadRecebimento
    extends Thread {
        private List<MessageOruR01> listaRecebimento = new ArrayList<MessageOruR01>();

        ThreadRecebimento() {
        }

        public List<MessageOruR01> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(MessageOruR01 message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(List<MessageOruR01> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (!this.listaRecebimento.isEmpty()) {
                    MessageOruR01 message = this.listaRecebimento.remove(0);
                    this.processaMensagem(message);
                    ThreadRecebimento.sleep(450L);
                }
                if (!InterfaceListener.this.equipamento.getStatusFecharInterfaceamento().isExportando()) {
                    InterfaceListener.this.fireAtualizarTabela();
                }
            }
            catch (InterruptedException e) {
                ErrorLogger.mostraMensagem(null, "Falha no processamento da ThreadRecebimento", e.getStackTrace(), "BS400.InterfaceListener.ThreadRecebimento");
                Thread.currentThread().interrupt();
            }
        }

        private void processaMensagem(MessageOruR01 oruR01) {
            try {
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                String tuboId = oruR01.getObr().getPlacerOrderNumber();
                if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                    Statement st = Conexao.getStatement();
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
                    if (etiqueta != null) {
                        filCodigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                        reqCodigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                        recCodigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                    }
                    this.processarExames(oruR01, st, filCodigo, reqCodigo, recCodigo);
                    Conexao.arquivaSQL();
                    InterfaceListener.this.fireAtualizarTabela();
                } else {
                    InterfaceListener.this.fireExcecaoEncontrada(String.format("Amostra fora do padr\u00e3o utilizado ou amostra passada manualmente %s", tuboId));
                }
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }

        private void processarExames(MessageOruR01 oruR01, Statement st, String filCodigo, String reqCodigo, String recCodigo) throws Exception {
            for (MessageSegmentObx obx : oruR01.getObxList()) {
                String emiAlternativo = String.valueOf(obx.getObservationId());
                String intCodigo = InterfaceListener.this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                if (intCodigo == null) {
                    intCodigo = this.carregaIntCodigoExamesEmRepeticao(filCodigo, reqCodigo, recCodigo, intCodigo);
                }
                if (intCodigo == null) {
                    InterfaceListener.this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada na interface id %s %s %s alternativo %s", filCodigo, reqCodigo, recCodigo, emiAlternativo));
                    continue;
                }
                ExameMaterial exame = InterfaceListener.this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
                if (exame != null) {
                    HashMap<String, Object> dados = new HashMap<String, Object>();
                    ArrayList<String> flags = new ArrayList<String>();
                    if (obx.getAbnormalFlag() != null) {
                        flags.add(obx.getAbnormalFlag().toString());
                    }
                    int sit = InterfaceListener.this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                    String campo = this.carregarCampo(obx, sit);
                    String resultado = this.carregarResultado(filCodigo, obx, intCodigo, exame);
                    if (sit != 3 && sit != 5 && sit != 1 && sit != 0) continue;
                    dados.put(campo, resultado);
                    InterfaceListener.this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados);
                    continue;
                }
                InterfaceListener.this.fireExcecaoEncontrada(String.format("Exame n\u00e3o localizado ou j\u00e1 exportado na interface id %s %s %s alternativo %s", filCodigo, reqCodigo, recCodigo, emiAlternativo));
            }
        }

        private String carregaIntCodigoExamesEmRepeticao(String filCodigo, String reqCodigo, String recCodigo, String intCodigo) throws SQLException {
            for (ConfiguracaoSerial c : Variaveis.equipamentos) {
                for (EquipamentoFilial f : c.getEquipamentos()) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("select int_codigo from interfaceexamerequisicao ");
                    buf.append("where fil_codigo = ").append(filCodigo);
                    buf.append("  and int_codigo = ").append(f.getEquipamento());
                    buf.append("  and req_codigo = ").append(reqCodigo);
                    buf.append("  and rec_codigo = ").append(recCodigo);
                    buf.append("  and ier_situacao = ").append(3);
                    Statement stTemp = Conexao.getStatement();
                    ResultSet rs = Conexao.executeQuery(stTemp, buf.toString());
                    if (rs.next()) {
                        intCodigo = rs.getString("int_codigo");
                    }
                    Conexao.fecharStatement(stTemp);
                }
            }
            return intCodigo;
        }

        private String carregarCampo(MessageSegmentObx obx, int sit) {
            String campo = "resultado_quantitativo";
            if (obx.getValueType().equals((Object)MessageSegmentObx.ValueType.NUMERIC)) {
                campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
            } else if (obx.getValueType().equals((Object)MessageSegmentObx.ValueType.STRING)) {
                campo = sit < 3 ? "resultado_qualitativo" : "repeticao_qualitativo";
            }
            return campo;
        }

        private String carregarResultado(String filCodigo, MessageSegmentObx obx, String intCodigo, ExameMaterial exame) {
            String resultado = "";
            if (obx.getValueType().equals((Object)MessageSegmentObx.ValueType.NUMERIC)) {
                resultado = obx.getObservationValue();
                resultado = InterfaceListener.this.arrendondaValor(resultado, filCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo);
                resultado = resultado.replace('.', ',');
            } else if (obx.getValueType().equals((Object)MessageSegmentObx.ValueType.STRING)) {
                resultado = obx.getObservationValue();
            }
            return resultado;
        }
    }
}

