/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bs380;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageDsrQ03;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageQckQ02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageQryQ02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentDsp;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentQak;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceHl7Listener {
    public InterfaceListener() {
        super("BS-380");
    }

    @Override
    protected void messageOruR01Recebida(final MessageOruR01 oruR01) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                    String tuboId = oruR01.getObr().getPlacerOrderNumber();
                    if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                        Statement st = Conexao.getStatement();
                        String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                        String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                        String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                        reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                        DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
                        if (etiqueta != null) {
                            filCodigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                            reqCodigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                            recCodigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                        }
                        for (MessageSegmentObx obx : oruR01.getObxList()) {
                            String emiAlternativo = String.valueOf(obx.getObservationId());
                            String intCodigo = InterfaceListener.this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                            ExameMaterial exame = InterfaceListener.this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
                            if (exame == null) {
                                InterfaceListener.this.fireExcecaoEncontrada(String.format("Etiqueta %s %s %s n\u00e3o localizado nenhum exame para o alternativo %s", filCodigo, reqCodigo, recCodigo, emiAlternativo));
                                continue;
                            }
                            HashMap<String, Object> dados = new HashMap<String, Object>();
                            ArrayList<String> flags = new ArrayList<String>();
                            if (obx.getAbnormalFlag() != null) {
                                flags.add(obx.getAbnormalFlag().toString());
                            }
                            int sit = InterfaceListener.this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                            String campo = "resultado_quantitativo";
                            String resultado = "";
                            switch (obx.getValueType()) {
                                case NUMERIC: {
                                    campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                                    resultado = obx.getObservationValue();
                                    resultado = InterfaceListener.this.arrendondaValor(resultado, filCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo);
                                    resultado = resultado.replace('.', ',');
                                    break;
                                }
                                case STRING: {
                                    campo = sit < 3 ? "resultado_qualitativo" : "repeticao_qualitativo";
                                    resultado = obx.getObservationValue();
                                }
                            }
                            dados.put(campo, resultado);
                            InterfaceListener.this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados);
                        }
                        Conexao.arquivaSQL();
                        InterfaceListener.this.fireAtualizarTabela();
                    } else {
                        InterfaceListener.this.fireExcecaoEncontrada(String.format("Amostra com etiqueta fora do padr\u00e3o da conf. do Jalis %s", tuboId));
                    }
                }
                catch (Exception e) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
            }
        };
        t.setPriority(5);
        t.start();
        MessageAckR01 ackR01 = new MessageAckR01();
        ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
        ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
        ackR01.getMsa().setTextMessage("Mensagem aceita");
        ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
        this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
    }

    @Override
    public void messageQryQ02Recebida(MessageQryQ02 qryQ02) {
        block26: {
            String messageId = qryQ02.getMsh().getMessageControlId();
            MessageQckQ02 qckQ02 = new MessageQckQ02();
            qckQ02.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
            qckQ02.getMsa().setTextMessage("Mensagem aceita");
            qckQ02.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
            qckQ02.getErr().setErrorCode(0);
            qckQ02.getQak().setQueryTag("SR");
            try {
                String tuboId = qryQ02.getQrd().getWhoSubjectFilter();
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (tuboId != null && !tuboId.trim().isEmpty() && tuboId != "null" && Funcoes.isNumeric(tuboId) && tuboId.length() == digitosCodigoTubo) {
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
                    if (etiqueta != null) {
                        filCodigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                        reqCodigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                        recCodigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                    }
                    Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                    PanelAbaAbstrata aba = this.equipamento.getTab(0);
                    String exames = "";
                    StringBuilder examesFilho = new StringBuilder();
                    if (req != null) {
                        exames = (String)req[aba.getColIndice("Exame")];
                    }
                    if (req == null && Funcoes.textoVazio(exames = this.getExames(filCodigo, reqCodigo, recCodigo, req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1), aba = this.equipamento.getTab(1), exames, 1)) && req != null) {
                        if (!Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboFilial()).equals(recCodigo)) {
                            exames = this.getExames(filCodigo, reqCodigo, (String)req[aba.getColIndice("Tubo")], req, aba, exames, 1);
                        }
                    }
                    if (req == null && Funcoes.textoVazio(exames = this.getExames(filCodigo, reqCodigo, recCodigo, req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2), aba = this.equipamento.getTab(2), exames, 2)) && req != null) {
                        if (!Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboFilial()).equals(recCodigo)) {
                            exames = this.getExames(filCodigo, reqCodigo, (String)req[aba.getColIndice("Tubo")], req, aba, exames, 2);
                        }
                    }
                    if (req == null) {
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.NO_DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        return;
                    }
                    String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                    String intCodigo = (String)req[aba.getColIndice("Interface")];
                    String pacNome = (String)req[aba.getColIndice("Paciente")];
                    String pacIdade = (String)req[aba.getColIndice("Ide")];
                    String pacSexo = (String)req[aba.getColIndice("S")];
                    String recTuboPai = (String)req[aba.getColIndice("Tubo")];
                    String data = TempoUtil.getCurrentDateBr();
                    String hora = TempoUtil.getCurrentTime();
                    ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
                    for (String string : exames.trim().split(" ", 0)) {
                        examesDaRequisicao.add(new ExameMaterial(string, new Integer(mcoCodigo)));
                    }
                    Date dataColeta = null;
                    ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                    for (ExameMaterial exameMaterial : examesDaRequisicao) {
                        if (dataColeta == null) {
                            dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        }
                        int n = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo);
                        boolean curva = BDUtil.isExameCurva(filCodigo, intCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                            int sitFilho;
                            List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo));
                            if (!(n != 0 && n != 1 || curva)) {
                                examesParaEnviar.addAll(examesFilhos);
                                continue;
                            }
                            if (curva) {
                                for (ExameMaterial exameFilho : examesFilhos) {
                                    sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recTuboPai, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                    String tuboFilho = BDUtil.getExameDesmembradoTubo(filCodigo, reqCodigo, recTuboPai, intCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                    if (sitFilho != 0 && sitFilho != 1 && sitFilho != 3 || !Funcoes.preencheZero(tuboFilho, ParametrosGerais.getDigitosTuboTubo()).equals(recCodigo)) continue;
                                    examesFilho.append(exameFilho.getNomeExame()).append(" ");
                                    examesParaEnviar.add(exameFilho);
                                }
                                continue;
                            }
                            for (ExameMaterial exameFilho : examesFilhos) {
                                sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                if (sitFilho != 3) continue;
                                examesParaEnviar.add(exameFilho);
                            }
                            continue;
                        }
                        if (n != 0 && n != 1 && n != 3) continue;
                        examesParaEnviar.add(exameMaterial);
                    }
                    HashSet<Integer> tests = new HashSet<Integer>();
                    for (ExameMaterial exameMaterial : examesParaEnviar) {
                        String test = BDUtil.getExmCodigoAlternativo(filCodigo, exameMaterial.getNomeExame(), mcoCodigo, intCodigo);
                        if (test != null && !test.trim().isEmpty()) {
                            if (!Funcoes.isNumeric(test)) {
                                this.fireExcecaoEncontrada(String.format("Amostra com exame configurado errado %s %s %s Alternativo %s corrija o Alternativo", filCodigo, reqCodigo, recCodigo, test));
                                continue;
                            }
                            tests.add(Integer.valueOf(test));
                            continue;
                        }
                        System.out.println("Exames para enviar sem alternativo: " + exameMaterial.getNomeExame());
                    }
                    if (tests.isEmpty()) {
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.NO_DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        this.fireExcecaoEncontrada(tuboId + " - Nenhum exame enviado.");
                    } else {
                        InfoExameRequisicao infoExameRequisicao = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
                        infoExameRequisicao.setInterface(intCodigo);
                        if (!Funcoes.preencheZero(recTuboPai, ParametrosGerais.getDigitosTuboTubo()).equals(recCodigo) && !Funcoes.textoVazio(examesFilho.toString().trim())) {
                            infoExameRequisicao.setTuboPai(recTuboPai);
                            infoExameRequisicao.setExamesFilho(examesFilho.toString().trim());
                            infoExameRequisicao.setCurva(true);
                        }
                        this.examesEnviadosPorSid.put(tuboId, infoExameRequisicao);
                        this.examesEnviadosPorMid.put(messageId, infoExameRequisicao);
                        String string = this.getPacienteDataNascimento(filCodigo, reqCodigo);
                        pacNome = StringUtil.removerAcentos(pacNome);
                        if (!Funcoes.textoVazio(pacNome) && pacNome.length() > 30) {
                            pacNome = pacNome.substring(0, 30);
                        }
                        MessageDsrQ03 dsrQ03 = new MessageDsrQ03();
                        dsrQ03.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
                        dsrQ03.getMsa().setTextMessage("Mensagem aceita");
                        dsrQ03.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
                        dsrQ03.getErr().setErrorCode(0);
                        dsrQ03.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.DATA_FOUND);
                        dsrQ03.getQak().setQueryTag("SR");
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp(pacNome));
                        dsrQ03.addDsp(new MessageSegmentDsp(string));
                        dsrQ03.addDsp(new MessageSegmentDsp(pacSexo));
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp(tuboId));
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        String tmp = "";
                        for (Integer test : tests) {
                            tmp = tmp + test + "^^^";
                            dsrQ03.addDsp(new MessageSegmentDsp(test + "^^^"));
                        }
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        this.enviaMensagem(messageId, dsrQ03);
                    }
                    break block26;
                }
                qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.APPLICATION_REJECT);
                this.enviaMensagem(messageId, qckQ02);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    @Override
    public void teste() {
        this.bs380Result("", false);
    }

    private void bs380Query(String tubo) {
        StringBuilder tmp = new StringBuilder();
        tmp.append("[SB]MSH|^~\\&|Mindray|BS-200|||20121114174828||QRY^Q02|434|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("QRD|20121114174848|R|D|139|||RD|").append(tubo).append("|OTH|||T|[CR]");
        tmp.append("QRF|BS-200|20121114174828|20121114174828|||RCT|COR|ALL||[CR][EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
        tmp.setLength(0);
        tmp.append("[SB]MSH|^~\\&|Mindray|BS-200|||20121114174828||ACK^Q03|434|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("MSA|AA|434|Message[SP]accepted|||0|[CR]ERR|0|[CR][EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
    }

    private void bs380Result(String tubo, boolean isCurva) {
        StringBuilder tmp = new StringBuilder();
        tubo = JOptionPane.showInputDialog(null, "Informe o Id da amostra?", "0102664504");
        tmp.append("[SB]MSH|^~\\&|Mindray|BS-400|||20171117161318||ORU^R01|518|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("PID|107||||JULIO[SP]CESAR[SP]LIMP[SP]PINHEIRO||19000101000000|M|||||||||||||||||||||||[CR]");
        tmp.append("OBR|107|" + tubo + "|70|Mindray^BS-400|N|||||||||20171117155053|Soro|||||||||||||||||||||||||||||||||[CR]");
        tmp.append("OBX|3|NM|35|COL|120.975667|mg/dL|0.000000-200.000000|N|||F||165.975667|||||[CR]");
        tmp.append("OBX|3|NM|120|TRI|70.429575|mg/dL|0.000000-200.000000|N|||F||145.429575|||||[CR]");
        tmp.append("OBX|4|NM|798|HDL|33.370979|mg/dL|35.000000-65.000000|N|||F||54.370979|||||[CR]");
        tmp.append("OBX|5|NM|5|UREA|36.613718|mg/dL|10.000000-45.000000|N|||F||36.613718|||||[CR]");
        tmp.append("[EB][CR]");
        if (!isCurva) {
            this.parse(TestesInterface.arruma(tmp.toString()));
        }
    }
}

