/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bs360e;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckQ03;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageDsrQ03;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageQckQ02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageQryQ02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentDsp;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentQak;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class InterfaceListener
extends InterfaceHl7Listener {
    public InterfaceListener() {
        super("BS-360e");
    }

    @Override
    public String parse(String text) {
        try {
            String[] messages = text.split(this.getMsgEnd());
            if (messages.length > 1) {
                for (String m : messages) {
                    m = m + this.getMsgEnd();
                    Message msg = this.messageParser.textToMessage(m);
                    this.mensagemRecebida(msg);
                }
            } else {
                Message message = this.messageParser.textToMessage(text);
                this.mensagemRecebida(message);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "Erro ao efetuar o parse da mensagem";
        }
        return null;
    }

    @Override
    public void messageQryQ02Recebida(MessageQryQ02 qryQ02) {
        block26: {
            String messageId = qryQ02.getMsh().getMessageControlId();
            MessageQckQ02 qckQ02 = new MessageQckQ02();
            qckQ02.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
            qckQ02.getMsa().setTextMessage("Mensagem aceita");
            qckQ02.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
            qckQ02.getErr().setErrorCode(0);
            qckQ02.getQak().setQueryTag("SR");
            try {
                String tuboId = qryQ02.getQrd().getWhoSubjectFilter();
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (tuboId != null && !tuboId.trim().isEmpty() && !tuboId.equals("null") && Funcoes.isNumeric(tuboId) && tuboId.length() == digitosCodigoTubo) {
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
                    if (etiqueta != null) {
                        filCodigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                        reqCodigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                        recCodigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                    }
                    Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0, false);
                    PanelAbaAbstrata aba = this.equipamento.getTab(0);
                    String exames = "";
                    StringBuilder examesFilho = new StringBuilder();
                    if (req != null) {
                        exames = (String)req[aba.getColIndice("Exame")];
                    }
                    if (req == null && Funcoes.textoVazio(exames = this.getExames(filCodigo, reqCodigo, recCodigo, req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1), aba = this.equipamento.getTab(1), exames, 1)) && req != null) {
                        if (!Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboFilial()).equals(recCodigo)) {
                            exames = this.getExames(filCodigo, reqCodigo, (String)req[aba.getColIndice("Tubo")], req, aba, exames, 1);
                        }
                    }
                    if (req == null && Funcoes.textoVazio(exames = this.getExames(filCodigo, reqCodigo, recCodigo, req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2), aba = this.equipamento.getTab(2), exames, 2)) && req != null) {
                        if (!Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboFilial()).equals(recCodigo)) {
                            exames = this.getExames(filCodigo, reqCodigo, (String)req[aba.getColIndice("Tubo")], req, aba, exames, 2);
                        }
                    }
                    if (req == null) {
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.NO_DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        return;
                    }
                    String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                    String intCodigo = (String)req[aba.getColIndice("Interface")];
                    String pacNome = (String)req[aba.getColIndice("Paciente")];
                    String pacIdade = (String)req[aba.getColIndice("Ide")];
                    String pacSexo = (String)req[aba.getColIndice("S")];
                    String recTuboPai = (String)req[aba.getColIndice("Tubo")];
                    String data = TempoUtil.getCurrentDateBr();
                    String hora = TempoUtil.getCurrentTime();
                    ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
                    for (String string : exames.trim().split(" ", 0)) {
                        examesDaRequisicao.add(new ExameMaterial(string, new Integer(mcoCodigo)));
                    }
                    Date dataColeta = null;
                    ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                    for (ExameMaterial exameMaterial : examesDaRequisicao) {
                        if (dataColeta == null) {
                            dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        }
                        int n = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo);
                        boolean curva = BDUtil.isExameCurva(filCodigo, intCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                            int sitFilho;
                            List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo));
                            if (!(n != 0 && n != 1 || curva)) {
                                examesParaEnviar.addAll(examesFilhos);
                                continue;
                            }
                            if (curva) {
                                for (ExameMaterial exameFilho : examesFilhos) {
                                    sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recTuboPai, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                    if (sitFilho != 0 && sitFilho != 1 && sitFilho != 3) continue;
                                    examesFilho.append(exameFilho.getNomeExame()).append(" ");
                                    examesParaEnviar.add(exameFilho);
                                }
                                continue;
                            }
                            for (ExameMaterial exameFilho : examesFilhos) {
                                sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                if (sitFilho != 3) continue;
                                examesParaEnviar.add(exameFilho);
                            }
                            continue;
                        }
                        if (n != 0 && n != 1 && n != 3) continue;
                        examesParaEnviar.add(exameMaterial);
                    }
                    HashSet<Integer> tests = new HashSet<Integer>();
                    for (ExameMaterial exameMaterial : examesParaEnviar) {
                        String test = BDUtil.getExmCodigoAlternativo(filCodigo, exameMaterial.getNomeExame(), mcoCodigo, intCodigo);
                        if (test != null && !test.trim().isEmpty()) {
                            if (!Funcoes.isNumeric(test)) {
                                this.fireExcecaoEncontrada(String.format("Amostra com exame configurado errado %s %s %s Alternativo %s corrija o Alternativo", filCodigo, reqCodigo, recCodigo, test));
                                continue;
                            }
                            tests.add(Integer.valueOf(test));
                            continue;
                        }
                        System.out.println("Exames para enviar sem alternativo: " + exameMaterial.getNomeExame());
                    }
                    if (tests.isEmpty()) {
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.NO_DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        this.fireExcecaoEncontrada(tuboId + " - Nenhum exame enviado.");
                    } else {
                        InfoExameRequisicao infoExameRequisicao = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
                        infoExameRequisicao.setInterface(intCodigo);
                        if (!Funcoes.preencheZero(recTuboPai, ParametrosGerais.getDigitosTuboTubo()).equals(recCodigo) && !Funcoes.textoVazio(examesFilho.toString().trim())) {
                            infoExameRequisicao.setTuboPai(recTuboPai);
                            infoExameRequisicao.setExamesFilho(examesFilho.toString().trim());
                            infoExameRequisicao.setCurva(true);
                        }
                        this.examesEnviadosPorSid.put(tuboId, infoExameRequisicao);
                        this.examesEnviadosPorMid.put(messageId, infoExameRequisicao);
                        String string = this.getPacienteDataNascimento(filCodigo, reqCodigo);
                        pacNome = StringUtil.removerAcentos(pacNome);
                        if (!Funcoes.textoVazio(pacNome) && pacNome.length() > 30) {
                            pacNome = pacNome.substring(0, 30);
                        }
                        MessageDsrQ03 dsrQ03 = new MessageDsrQ03();
                        dsrQ03.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
                        dsrQ03.getMsa().setTextMessage("Mensagem aceita");
                        dsrQ03.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
                        dsrQ03.getErr().setErrorCode(0);
                        dsrQ03.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.DATA_FOUND);
                        dsrQ03.getQak().setQueryTag("SR");
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp(pacNome));
                        dsrQ03.addDsp(new MessageSegmentDsp(string));
                        dsrQ03.addDsp(new MessageSegmentDsp(pacSexo));
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp(tuboId));
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        for (Integer test : tests) {
                            dsrQ03.addDsp(new MessageSegmentDsp(test + "^^^"));
                        }
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        this.enviaMensagem(messageId, dsrQ03);
                    }
                    break block26;
                }
                qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.APPLICATION_REJECT);
                this.enviaMensagem(messageId, qckQ02);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    @Override
    protected void messageAckQ03Recebida(MessageAckQ03 ackQ03) {
        String messageId = ackQ03.getMsa().getMessageControlId();
        if (messageId != null) {
            switch (ackQ03.getMsa().getAckCode()) {
                case ACCEPTED: {
                    this.alteraSituacaoParaPendentes((InfoExameRequisicao)this.examesEnviadosPorMid.remove(messageId));
                    break;
                }
                case ERROR: 
                case REJECTED: {
                    this.fireExcecaoEncontrada("Erro ao enviar " + ackQ03.toString());
                }
            }
        }
    }

    @Override
    public void teste() {
        StringBuilder tmp = new StringBuilder();
        tmp.append("[SB]MSH|^~\\&|Mindray|BS-200E|||20241219151823||QRY^Q02|12|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("QRD|20241219151818|R|D|12|||RD|010000075804|OTH|||T|[CR]");
        tmp.append("QRF|BS-200E|20241219151823|20241219151823|||RCT|COR|ALL||[CR]");
        tmp.append("[EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
        tmp.setLength(0);
        tmp.append("[SB]MSH|^~\\&|Mindray|BS-200E|||20241219151823||QRY^Q02|12|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("QRD|20241219151818|R|D|13|||RD|010000075806|OTH|||T|[CR]");
        tmp.append("QRF|BS-200E|20241219151823|20241219151823|||RCT|COR|ALL||[CR]");
        tmp.append("[EB][CR]");
        tmp.append("[SB]MSH|^~\\&|Mindray|BS-200E|||20241219151823||ACK^Q03|12|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("MSA|AA|12|Message[SP]accepted|||0|[CR]");
        tmp.append("ERR|0|[CR]");
        tmp.append("[EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
        tmp.setLength(0);
        tmp.append("[SB]MSH|^~\\&|Mindray|BS-200E|||20241219151823||QRY^Q02|13|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("QRD|20241219151818|R|D|14|||RD|010000075807|OTH|||T|[CR]");
        tmp.append("QRF|BS-200E|20241219151823|20241219151823|||RCT|COR|ALL||[CR]");
        tmp.append("[EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
        tmp.setLength(0);
        tmp.append("[SB]MSH|^~\\&|Mindray|BS-200E|||20241219151823||QRY^Q02|13|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("QRD|20241219151818|R|D|15|||RD|010000075805|OTH|||T|[CR]");
        tmp.append("QRF|BS-200E|20241219151823|20241219151823|||RCT|COR|ALL||[CR]");
        tmp.append("[EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
        tmp.setLength(0);
        tmp.append("[SB]MSH|^~\\&|Mindray|BS-200E|||20241219151823||QRY^Q02|13|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("QRD|20241219151818|R|D|16|||RD|010000075810|OTH|||T|[CR]");
        tmp.append("QRF|BS-200E|20241219151823|20241219151823|||RCT|COR|ALL||[CR]");
        tmp.append("[EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
    }
}

