/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bs300;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.bs300.Bs300MessageDsrQ03;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.EncodingCharacters;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageQckQ02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageQryQ02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentDsp;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentQak;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class InterfaceListener
extends InterfaceHl7Listener {
    public InterfaceListener() {
        super("BS-300");
    }

    @Override
    protected void messageOruR01Recebida(final MessageOruR01 oruR01) {
        double id = Math.random();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                    String tuboId = oruR01.getObr().getPlacerOrderNumber();
                    if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                        Statement st = Conexao.getStatement();
                        String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                        String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                        String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                        reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                        for (MessageSegmentObx obx : oruR01.getObxList()) {
                            String emiAlternativo = String.valueOf(obx.getObservationId());
                            String intCodigo = InterfaceListener.this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                            ExameMaterial exame = InterfaceListener.this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
                            if (exame == null) continue;
                            HashMap<String, Object> dados = new HashMap<String, Object>();
                            ArrayList<String> flags = new ArrayList<String>();
                            if (obx.getAbnormalFlag() != null) {
                                flags.add(obx.getAbnormalFlag().toString());
                            }
                            int sit = InterfaceListener.this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                            String campo = "resultado_quantitativo";
                            String resultado = "";
                            switch (obx.getValueType()) {
                                case NUMERIC: {
                                    campo = sit == 4 ? "resultado_quantitativo" : (sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo");
                                    resultado = String.valueOf(obx.getUserDefinedAccessChecks());
                                    resultado = InterfaceListener.this.arrendondaValor(resultado, filCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo);
                                    resultado = resultado.replace('.', ',');
                                    break;
                                }
                                case STRING: {
                                    campo = sit == 4 ? "resultado_qualitativo" : (sit < 3 ? "resultado_qualitativo" : "repeticao_qualitativo");
                                    campo = sit < 3 || sit == 4 ? "resultado_qualitativo" : "repeticao_qualitativo";
                                    resultado = obx.getObservationValue();
                                }
                            }
                            dados.put(campo, resultado);
                            InterfaceListener.this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados);
                        }
                        Conexao.arquivaSQL();
                        InterfaceListener.this.fireAtualizarTabela();
                    }
                }
                catch (Exception e) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
            }
        };
        t.setPriority(5);
        t.start();
        MessageAckR01 ackR01 = new MessageAckR01();
        ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
        ackR01.getMsh().setBs300(true);
        ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
        ackR01.getMsa().setTextMessage("Mensagem aceita");
        ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
        this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
    }

    @Override
    public void messageQryQ02Recebida(MessageQryQ02 qryQ02) {
        block33: {
            String messageId = qryQ02.getMsh().getMessageControlId();
            MessageQckQ02 qckQ02 = new MessageQckQ02();
            qckQ02.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
            qckQ02.getMsa().setTextMessage("Message accepted");
            qckQ02.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
            qckQ02.getErr().setErrorCode(0);
            qckQ02.getQak().setQueryTag("SR");
            try {
                String tuboId = qryQ02.getQrd().getWhoSubjectFilter();
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (tuboId != null && !tuboId.trim().isEmpty() && tuboId != "null" && Funcoes.isNumeric(tuboId) && tuboId.trim().length() == digitosCodigoTubo) {
                    List<Object[]> reqs;
                    tuboId = tuboId.trim();
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    System.out.println("filCodigo: " + filCodigo);
                    System.out.println("reqCodigo: " + reqCodigo);
                    System.out.println("recCodigo: " + recCodigo);
                    Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                    PanelAbaAbstrata aba = this.equipamento.getTab(0);
                    String exames = "";
                    StringBuilder examesFilho = new StringBuilder();
                    if (req != null) {
                        exames = (String)req[aba.getColIndice("Exame")];
                    } else {
                        aba.reloadExames();
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                        aba = this.equipamento.getTab(0);
                        if (req != null) {
                            exames = (String)req[aba.getColIndice("Exame")];
                        }
                    }
                    if (req == null) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                        aba = this.equipamento.getTab(1);
                        if (req != null) {
                            exames = exames + " ";
                            reqs = this.getTodasRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                            for (Object[] r : reqs) {
                                exames = exames + (String)r[aba.getColIndice("Exame")] + " ";
                            }
                            exames = exames.trim();
                        } else {
                            aba = this.equipamento.getTab(1);
                            aba.reloadExames();
                            req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                            if (req != null) {
                                exames = exames + " ";
                                reqs = this.getTodasRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                                for (Object[] r : reqs) {
                                    exames = exames + (String)r[aba.getColIndice("Exame")] + " ";
                                }
                                exames = exames.trim();
                            }
                        }
                    }
                    if (req == null) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
                        aba = this.equipamento.getTab(2);
                        if (req != null) {
                            exames = exames + " ";
                            reqs = this.getTodasRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
                            for (Object[] r : reqs) {
                                exames = exames + (String)r[aba.getColIndice("Exame")] + " ";
                            }
                            exames.trim();
                        }
                    }
                    if (req == null) {
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.NO_DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        this.fireExcecaoEncontrada(String.format("Nenhuma requisi\u00e7\u00e3o encontrada para o tubo (%s). %s-%s-%s %s ", tuboId, filCodigo, reqCodigo, recCodigo, exames));
                        return;
                    }
                    String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                    String intCodigo = (String)req[aba.getColIndice("Interface")];
                    String pacNome = (String)req[aba.getColIndice("Paciente")];
                    String pacIdade = (String)req[aba.getColIndice("Ide")];
                    String pacSexo = (String)req[aba.getColIndice("S")];
                    String recTuboPai = (String)req[aba.getColIndice("Tubo")];
                    String data = TempoUtil.getCurrentDateBr();
                    String hora = TempoUtil.getCurrentTime();
                    ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
                    for (String string : exames.split(" ", 0)) {
                        examesDaRequisicao.add(new ExameMaterial(string, new Integer(mcoCodigo)));
                    }
                    Date dataColeta = null;
                    ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                    for (ExameMaterial exameMaterial : examesDaRequisicao) {
                        if (dataColeta == null) {
                            dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        }
                        int n = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo);
                        if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                            int sitFilho;
                            List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo));
                            if (n == 0 || n == 1) {
                                examesParaEnviar.addAll(examesFilhos);
                                continue;
                            }
                            if (n == -1 && BDUtil.isExameCurva(filCodigo, intCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial())) {
                                for (ExameMaterial exameFilho : examesFilhos) {
                                    sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recTuboPai, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                    String tuboFilho = BDUtil.getExameDesmembradoTubo(filCodigo, reqCodigo, recTuboPai, intCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                    if (sitFilho != 0 && sitFilho != 1 || !Funcoes.preencheZero(tuboFilho, ParametrosGerais.getDigitosTuboTubo()).equals(recCodigo)) continue;
                                    examesFilho.append(exameFilho.getNomeExame()).append(" ");
                                    examesParaEnviar.add(exameFilho);
                                }
                                continue;
                            }
                            for (ExameMaterial exameFilho : examesFilhos) {
                                sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                if (sitFilho != 3) continue;
                                examesParaEnviar.add(exameFilho);
                            }
                            continue;
                        }
                        if (n != 0 && n != 1 && n != 3) continue;
                        examesParaEnviar.add(exameMaterial);
                    }
                    HashSet<String> tests = new HashSet<String>();
                    for (ExameMaterial exameMaterial : examesParaEnviar) {
                        String test = BDUtil.getExmCodigoAlternativo(filCodigo, exameMaterial.getNomeExame(), mcoCodigo, intCodigo);
                        if (test != null && !test.trim().isEmpty()) {
                            tests.add(test);
                            continue;
                        }
                        System.out.println("Exames para enviar sem alternativo: " + exameMaterial.getNomeExame());
                    }
                    if (tests.isEmpty()) {
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.NO_DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        this.fireExcecaoEncontrada(tuboId + " - Nenhum exame enviado.");
                    } else {
                        String string = BDUtil.getExmEquipamentoMaterial(filCodigo, ((ExameMaterial)examesParaEnviar.get(0)).getNomeExame(), mcoCodigo, intCodigo);
                        Date date = BDUtil.getDataNacimentoPaciente(filCodigo, reqCodigo);
                        InfoExameRequisicao exame = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
                        if (!Funcoes.preencheZero(recTuboPai, ParametrosGerais.getDigitosTuboTubo()).equals(recCodigo) && !Funcoes.textoVazio(examesFilho.toString().trim())) {
                            exame.setTuboPai(recTuboPai);
                            exame.setExamesFilho(examesFilho.toString().trim());
                            exame.setCurva(true);
                        }
                        this.examesEnviadosPorSid.put(tuboId, exame);
                        this.examesEnviadosPorMid.put(messageId, exame);
                        String pac_codigo = BDUtil.getCodigoPaciente(filCodigo, reqCodigo);
                        pacNome = StringUtil.removerAcentos(pacNome);
                        if (!Funcoes.textoVazio(pacNome) && pacNome.length() > 30) {
                            pacNome = pacNome.substring(0, 30);
                        }
                        Bs300MessageDsrQ03 dsrQ03 = new Bs300MessageDsrQ03();
                        dsrQ03.getMsh().setSendingApplication("LIS-Server");
                        dsrQ03.getMsh().setBs300(true);
                        dsrQ03.getMsh().setSendingFacility("Laboratorio");
                        dsrQ03.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
                        dsrQ03.getMsa().setTextMessage("Message accepted");
                        dsrQ03.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
                        dsrQ03.getErr().setErrorCode(0);
                        dsrQ03.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.DATA_FOUND);
                        dsrQ03.getQak().setQueryTag("SR");
                        dsrQ03.getQrd().setQueryDate(new Date());
                        dsrQ03.getQrd().setQueryFormatCode("D");
                        dsrQ03.getQrd().setQueryPriority("D");
                        dsrQ03.getQrd().setQueryId(qryQ02.getQrd().getQueryId());
                        dsrQ03.getQrd().setQuantityLimitedRequest("RD");
                        dsrQ03.getQrd().setWhoSubjectFilter(tuboId);
                        dsrQ03.getQrd().setWhatSubjectFilter("OTH");
                        dsrQ03.getQrd().setWhatDepartamentDataCode("");
                        dsrQ03.addDsp(new MessageSegmentDsp(filCodigo + reqCodigo));
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp(pacNome));
                        dsrQ03.addDsp(new MessageSegmentDsp(Funcoes.formataData("yyyy", date)));
                        dsrQ03.addDsp(new MessageSegmentDsp(pacSexo));
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp(tuboId));
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        if (string != null) {
                            dsrQ03.addDsp(new MessageSegmentDsp(string));
                        } else {
                            dsrQ03.addDsp(new MessageSegmentDsp());
                        }
                        dsrQ03.addDsp(new MessageSegmentDsp(""));
                        dsrQ03.addDsp(new MessageSegmentDsp(""));
                        String tmp = "";
                        for (String test : tests) {
                            tmp = tmp + test + "^^^";
                            dsrQ03.addDsp(new MessageSegmentDsp(test + "^^^"));
                        }
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        this.enviaMensagem(messageId, dsrQ03);
                    }
                    break block33;
                }
                qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.APPLICATION_REJECT);
                this.enviaMensagem(messageId, qckQ02);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    @Override
    protected void enviaMensagem(String id, Message mensagem) {
        try {
            mensagem.getMsh().setEncodingCharacters(new EncodingCharacters('^', '~', '\\', '&'));
            mensagem.getMsh().setReceivingApplication("Mindray");
            mensagem.getMsh().setReceivingFacility(this.modelo);
            mensagem.getMsh().setDateTime(new Date());
            mensagem.getMsh().setProcessingId("P");
            mensagem.getMsh().setVersionId("2.3.1");
            mensagem.getMsh().setCharacterSet("");
            mensagem.getMsh().setBs300(true);
            mensagem.setId(id);
            this.ultimaMensagemEnviada = mensagem;
            ++this.tentativasEnvio;
            String msg = this.messageParser.messageToText(mensagem, this.fieldSeparator);
            StringBuilder bui = new StringBuilder();
            if (msg.contains("MSH|")) {
                for (String segment : msg.split(String.valueOf('\r'))) {
                    if (segment.contains("MSH|")) {
                        String[] fields = segment.split("[|]");
                        bui.append(fields[0]).append("|");
                        bui.append(fields[1]).append("|");
                        bui.append(fields[2]).append("|");
                        bui.append(fields[3]).append("|");
                        bui.append(fields[4]).append("|");
                        bui.append(fields[5]).append("|");
                        bui.append(fields[6]).append("|");
                        bui.append(fields[7]).append("|");
                        bui.append(fields[8]).append("|");
                        bui.append(fields[9]).append("|");
                        bui.append(fields[10]).append("|");
                        bui.append(fields[11]).append("|").append('\r');
                        continue;
                    }
                    bui.append(segment).append('\r');
                }
            } else {
                bui.append(msg);
            }
            System.out.println(bui.toString());
            this.getPortaCOM().write(msg);
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o equipamento.", e.getStackTrace());
        }
    }
}

