/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bs200;

import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckQ03;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;

public class InterfaceListener
extends InterfaceHl7Listener {
    public InterfaceListener() {
        super("BS-200");
    }

    @Override
    public String parse(String text) {
        try {
            String[] messages = text.split(this.getMsgEnd());
            if (messages.length > 1) {
                for (String m : messages) {
                    m = m + this.getMsgEnd();
                    Message msg = this.messageParser.textToMessage(m);
                    this.mensagemRecebida(msg);
                }
            } else {
                Message message = this.messageParser.textToMessage(text);
                this.mensagemRecebida(message);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "Erro ao efetuar o parse da mensagem";
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada("Erro ao receber mensagem do equipamento");
            return "Erro ao efetuar o parse da mensagem";
        }
        return null;
    }

    @Override
    protected void messageAckQ03Recebida(MessageAckQ03 ackQ03) {
        String messageId = ackQ03.getMsa().getMessageControlId();
        if (messageId != null) {
            switch (ackQ03.getMsa().getAckCode()) {
                case ACCEPTED: {
                    this.alteraSituacaoParaPendentes((InfoExameRequisicao)this.examesEnviadosPorMid.remove(messageId));
                    break;
                }
                case ERROR: 
                case REJECTED: {
                    this.fireExcecaoEncontrada("Erro ao enviar " + ackQ03.toString());
                }
            }
        }
    }

    @Override
    protected String getPacienteDataNascimento(String filial, String requisicao) {
        System.out.println(new Throwable().getStackTrace()[0]);
        Date nasc = BDUtil.getDataNacimentoPaciente(filial, requisicao);
        if (nasc == null) {
            System.out.println(new Throwable().getStackTrace()[0]);
            return "";
        }
        return Funcoes.formataData("yyyyMMdd", nasc) + "000000";
    }

    @Override
    public void teste() {
        StringBuilder tmp = new StringBuilder();
        tmp.append("[SB]MSH|^~\\&|Mindray|BS-200|||20200703090824||QRY^Q02|12|P|2.3.1||||0||ASCII|||[CR]QRD|20200703090808|R|D|12|||RD|010006500304|OTH|||T|[CR]QRF|BS-200|20200703090824|20200703090824|||RCT|COR|ALL||[CR][EB][CR]");
        this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length());
        tmp.delete(0, tmp.length());
        tmp.append("[SB]MSH|^~\\&|||Mindray|BS-200|20200703090824||QCK^Q02|12|P|2.3.1||||||ASCII|||[CR]MSA|AA|12|Mensagem[SP]aceita|||0|[CR]ERR|0|[CR]QAK|SR|OK|[CR][EB][CR]");
        try {
            this.getPortaCOM().write(this.equipamento.arruma(tmp.toString()));
            tmp.delete(0, tmp.length());
            tmp.append("[SB]MSH|^~\\&|||Mindray|BS-200|20200703090824||DSR^Q03|12|P|2.3.1||||||ASCII|||[CR]MSA|AA|12|Mensagem[SP]aceita|||0|[CR]ERR|0|[CR]QAK|SR|OK|[CR]QRD|||||||||||||[CR]QRF||||||||||[CR]DSP|1|||||[CR]DSP|2|||||[CR]DSP|3||LUISA[SP]HELENA[SP]MOREIRA[SP]QUEIROZ[SP]S|||[CR]DSP|4|||||[CR]DSP|5||F|||[CR]DSP|6|||||[CR]DSP|7|||||[CR]DSP|8|||||[CR]DSP|9|||||[CR]DSP|10|||||[CR]DSP|11|||||[CR]DSP|12|||||[CR]DSP|13|||||[CR]DSP|14|||||[CR]DSP|15|||||[CR]DSP|16|||||[CR]DSP|17|||||[CR]DSP|18|||||[CR]DSP|19|||||[CR]DSP|20|||||[CR]DSP|21||0107541038|||[CR]DSP|22|||||[CR]DSP|23|||||[CR]DSP|24|||||[CR]DSP|25|||||[CR]DSP|26|||||[CR]DSP|27|||||[CR]DSP|28|||||[CR]DSP|29||1^^^|||[CR]DSP|30||2^^^|||[CR]DSP|31||3^^^|||[CR]DSP|32||4^^^|||[CR]DSC||[CR][EB][CR]");
            this.getPortaCOM().write(this.equipamento.arruma(tmp.toString()));
            tmp.delete(0, tmp.length());
            tmp.append("[SB]MSH|^~\\&|Mindray|BS-200|||20200703090824||ACK^Q03|12|P|2.3.1||||0||ASCII|||[CR]MSA|AA|12|Message[SP]accepted|||0|[CR]ERR|0|[CR][EB][CR]");
            this.getPortaCOM().read(this.equipamento.arruma(tmp.toString()), this.equipamento.arruma(tmp.toString()).length() - 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuilder message = new StringBuilder();
        message.append("[SB]MSH|^~|Mindray|BS-200E|||20150106153717||ORU^R01|148|P|2.3.1||||0||ASCII|||[CR]");
        message.append("PID|117||||INES[SP]GOULART[SP]DA[SP]SILVA||||||||||||||||||||||||||[CR]");
        message.append("OBR|1|010006500304|23|Mindray^BS-200E|N||20150106115447||||||||Soro|||||||||||||||||||||||||||||||||[CR]");
        message.append("OBX|1|NM|2|Triglicerides|98.800000|mg/dL|-|Normal|||F||98.842508|20150106115447||||[CR]");
        message.append("[EB][CR]");
        this.parse(this.equipamento.arruma(message.toString()));
    }
}

