/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bravo;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EventObject;
import java.util.HashMap;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    public static final int QTDE_EXAMES_TOTAL_RACK = 59;
    public static final int QTDE_EXAMES_ENVIO_RACK = 35;
    public static Connection connWorklist;
    public static Connection connResults;

    public InterfaceListener() {
        try {
            ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
            String fonteWorklist = c.getFonteOdbcWorklist();
            String fonteResults = c.getFonteOdbcResultados();
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            connWorklist = DriverManager.getConnection("jdbc:odbc:" + fonteWorklist, "", "");
            connWorklist.setAutoCommit(false);
            connWorklist.setTransactionIsolation(2);
            connResults = DriverManager.getConnection("jdbc:odbc:" + fonteResults, "", "");
            connResults.setAutoCommit(false);
            connResults.setTransactionIsolation(2);
        }
        catch (ClassNotFoundException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Bravo:Interfacelistener:23");
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Bravo:Interfacelistener:37");
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public void dataChanged() {
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public String getMsgEnd() {
        return null;
    }

    @Override
    public String getMsgStart() {
        return null;
    }

    @Override
    public String parse(String message) {
        return null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            req_codigo = StringUtil.preencheString(req_codigo, ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo).append(rec_codigo);
            StringBuilder sql = new StringBuilder();
            StringBuilder values = new StringBuilder();
            sql.append("insert into worklist (");
            values.append(" ) values (");
            sql.append("id ");
            values.append("'").append(codigo.toString()).append("'");
            sql.append(",name ");
            values.append(",'").append(pac_nome).append("'");
            if (!Funcoes.textoVazio(pac_sexo)) {
                sql.append(",category");
                if (pac_sexo.equalsIgnoreCase("F")) {
                    values.append(",'woman'");
                } else {
                    values.append(",'man'");
                }
            }
            sql.append(",posit");
            values.append(",'").append(rackposition).append("'");
            sql.append(",dilution");
            values.append(", null");
            String[] temp = exames.split(" ", 0);
            ExameMaterial[] exa_lista = new ExameMaterial[temp.length];
            int i = -1;
            for (String t : temp) {
                exa_lista[++i] = new ExameMaterial(t, new Integer(mco_codigo));
            }
            exa_lista = ExamesUtil.anexarCodigoMaterial(temp, mco_codigo);
            for (i = 0; i < exa_lista.length; ++i) {
                ExameMaterial exa = exa_lista[i];
                String exa_alternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exa.getNomeExame(), mco_codigo, int_codigo);
                sql.append(",method").append(i + 1);
                values.append(",'").append(exa_alternativo).append("'");
            }
            sql.append(values.toString()).append(")");
            Statement st = connWorklist.createStatement(1004, 1007);
            st.execute(sql.toString());
            connWorklist.commit();
            st = Conexao.getStatement();
            String[] stringArray = temp;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String exame;
                int atual = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame = stringArray[j], mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, atual < 2 ? 1 : 3);
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(0);
            return "Exame enviado com sucesso para " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    public void buscarResultados() {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("select sampleid, methodid, result, [abs result] from list order by sampleid, methodid");
            Statement stResults = connResults.createStatement(1004, 1007);
            ResultSet rs = stResults.executeQuery(sql.toString());
            Statement st = Conexao.getStatement();
            while (rs.next()) {
                String req_codigo = rs.getString("sampleid");
                String alternativo = rs.getString("methodid");
                String resultado = rs.getString("result");
                StringBuilder r = new StringBuilder();
                for (char c : resultado.toCharArray()) {
                    if (!Character.isDigit(c) && c != '-' && c != '.') break;
                    if (c == '.') {
                        r.append(",");
                        continue;
                    }
                    r.append(c);
                }
                resultado = r.toString();
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                String rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                String int_codigo = this.getIntCodigo(fil_codigo, req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao()), rec_codigo, alternativo);
                if (int_codigo == null) {
                    this.fireExcecaoEncontrada("Interfaceamento do exame " + alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    continue;
                }
                ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, alternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    continue;
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                int sit = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
                resultado = this.arrendondaValor(resultado, fil_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo);
                String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                dados.put(campo, resultado);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, null, sit < 3 ? 2 : 4);
                this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
        }
    }
}

