/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.bravo;

import jalis.comum.Conexao;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultProntos;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.DialogUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.TempoUtil;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ExamesProntos
extends AbaDefaultProntos {
    public static final String PRIORIDADE_ROUTINE = "R";
    public static final String PRIORIDADE_STAT = "M";

    public ExamesProntos(JFrame parent, AbstractInterfaceamento equip) {
        super(parent, equip);
    }

    @Override
    public void transmiteExames(int row) {
        if (row >= 0 && this.tabelaExames.getRowCount() > 0) {
            try {
                String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
                String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Tubo"));
                String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat."));
                String pac_sexo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("S"));
                String pac_idade = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Ide"));
                String pac_nome = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Paciente"));
                String pac_exames = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame"));
                String fil_codigo = req_codigo.substring(0, 2);
                String xml_valores = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Valores"));
                String rack = null;
                String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
                if (xml_valores != null) {
                    Map<String, Object> valores = StringUtil.getMapDeXML(xml_valores);
                    rack = (String)valores.get("rack_position");
                }
                DialogRackPriori dlg = new DialogRackPriori(rack);
                DialogUtil.centerAndShow(dlg, true, true);
                String prioridade = dlg.getPrioridadeEscolhida();
                rack = dlg.getRackDigitada();
                if (prioridade == null) {
                    return;
                }
                String tpos = StringUtil.removeZerosEsquerda(rack.substring(2));
                String track = StringUtil.removeZerosEsquerda(rack.substring(0, 2));
                if (!ExamesProntos.isRackPosicaoValida(fil_codigo, int_codigo, track, tpos)) {
                    Funcoes.showErro(null, "A posi\u00e7\u00e3o da rack digitada n\u00e3o \u00e9 v\u00e1lida!");
                    return;
                }
                String hora = TempoUtil.getCurrentTime();
                String data = TempoUtil.getCurrentDateBr();
                String resposta = this.equipamento.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, "A");
                if (resposta != null) {
                    this.equipamento.novaMensagem(resposta, 0, resposta.startsWith("Erro") ? 5000 : 10000);
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    public static boolean isRackPosicaoValida(String fil_codigo, String int_codigo, String codigo, String valor) throws SQLException {
        Statement st = Conexao.getStatement();
        System.out.println("Check rack - " + TempoUtil.getCurrentMoment());
        String tamanho = BDUtil.getRackValor(fil_codigo, int_codigo, codigo);
        if (tamanho == null) {
            return false;
        }
        return Integer.parseInt(valor) > 0 && Integer.parseInt(valor) <= Integer.parseInt(tamanho);
    }

    class DialogRackPriori
    extends JDialog {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JTextField fieldRack = new TTextField(4, 1);
        JButton botaoStat = new BotaoNavegavel("STAT", 'T');
        JButton botaoRoutine = new BotaoNavegavel("Routine", 'R');
        JButton botaoCancelar = new BotaoNavegavel("Cancelar", 'C');
        JLabel labelRack = new JLabel("Digite a posi\u00e7\u00e3o na rack:");
        String prioridade = null;
        String rack = null;

        public DialogRackPriori(String rack_anterior) {
            if (rack_anterior != null) {
                this.fieldRack.setText(rack_anterior);
                this.fieldRack.selectAll();
            }
            this.setPreferredSize(new Dimension(275, 90));
            this.setSize(new Dimension(275, 90));
            this.setTitle("Repeti\u00e7\u00e3o de exame");
            this.setResizable(false);
            this.fieldRack.setPreferredSize(new Dimension(40, 21));
            this.buttonPanel.add(this.botaoStat);
            this.buttonPanel.add(this.botaoRoutine);
            this.buttonPanel.add(this.botaoCancelar);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.mainPanel.add((Component)this.labelRack, c);
            c.fill = 0;
            c.weightx = 0.0;
            c.gridx = 1;
            c.anchor = 17;
            c.insets = new Insets(0, 5, 0, 0);
            this.mainPanel.add((Component)this.fieldRack, c);
            c.fill = 1;
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 2;
            c.ipadx = 0;
            c.anchor = 10;
            c.insets = new Insets(0, 0, 0, 0);
            this.mainPanel.add((Component)this.buttonPanel, c);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.fieldRack.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogRackPriori.this.fieldRack.transferFocus();
                }
            });
            this.botaoStat.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogRackPriori.this.prioridade = ExamesProntos.PRIORIDADE_STAT;
                    DialogRackPriori.this.rack = StringUtil.preencheString(DialogRackPriori.this.fieldRack.getText(), 4, '0', 1);
                    DialogRackPriori.this.dispose();
                }
            });
            this.botaoRoutine.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogRackPriori.this.prioridade = ExamesProntos.PRIORIDADE_ROUTINE;
                    DialogRackPriori.this.rack = StringUtil.preencheString(DialogRackPriori.this.fieldRack.getText(), 4, '0', 1);
                    DialogRackPriori.this.dispose();
                }
            });
            this.botaoCancelar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogRackPriori.this.dispose();
                }
            });
        }

        public String getPrioridadeEscolhida() {
            return this.prioridade;
        }

        public String getRackDigitada() {
            return this.rack;
        }
    }
}

