/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.biosystemsa25;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.interfaces.biosystemsa25.ExameRequisicaoArquivo;
import jalis.laboratorio.interfaceamento.interfaces.biosystemsa25.ExameRequisicaoFilhoArquivo;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import java.util.ArrayList;
import java.util.List;

public class RequisicaoArquivo {
    private String filCodigo;
    private String reqCodigo;
    private String recCodigo;
    private String mcoCodigo;
    private String intCodigo;
    private DescritorCodigoEtiqueta etiquetaApoiado = null;
    private List<ExameRequisicaoArquivo> exames;

    public RequisicaoArquivo(String filCodigo, String reqCodigo, String recCodigo, String mcoCodigo, String intCodigo) {
        this.filCodigo = filCodigo;
        this.reqCodigo = reqCodigo;
        this.recCodigo = recCodigo;
        this.mcoCodigo = mcoCodigo;
        this.intCodigo = intCodigo;
        this.exames = new ArrayList<ExameRequisicaoArquivo>();
    }

    public RequisicaoArquivo(String filCodigo, String reqCodigo, String recCodigo, String mcoCodigo, String intCodigo, DescritorCodigoEtiqueta etiquetaApoiado) {
        this.filCodigo = filCodigo;
        this.reqCodigo = reqCodigo;
        this.recCodigo = recCodigo;
        this.mcoCodigo = mcoCodigo;
        this.intCodigo = intCodigo;
        this.exames = new ArrayList<ExameRequisicaoArquivo>();
        this.etiquetaApoiado = etiquetaApoiado;
    }

    public void addExame(ExameRequisicaoArquivo exame) {
        this.exames.add(exame);
    }

    public String getTexto() throws Exception {
        StringBuilder texto = new StringBuilder();
        StringBuilder sid = new StringBuilder();
        if (this.etiquetaApoiado != null) {
            sid.append(Funcoes.preencheVazio(this.etiquetaApoiado.getFilialApoio(), "0", ParametrosGerais.getDigitosTuboFilial(), 1));
            sid.append(Funcoes.preencheVazio(this.etiquetaApoiado.getRequisicaoApoiado(), "0", ParametrosGerais.getDigitosTuboRequisicao(), 1));
        } else {
            sid.append(Funcoes.preencheVazio(this.filCodigo, "0", ParametrosGerais.getDigitosTuboFilial(), 1));
            sid.append(Funcoes.preencheVazio(this.reqCodigo, "0", ParametrosGerais.getDigitosTuboRequisicao(), 1));
        }
        ArrayList<ExameRequisicaoFilhoArquivo> enviados = new ArrayList<ExameRequisicaoFilhoArquivo>();
        for (ExameRequisicaoArquivo exame : this.exames) {
            for (ExameRequisicaoFilhoArquivo exameFilho : exame.getExamesFilhos()) {
                if (enviados.contains(exameFilho) || Funcoes.textoVazio(exameFilho.getCodigoAlternativo())) continue;
                enviados.add(exameFilho);
                texto.append("N").append("\t");
                texto.append(exameFilho.getMaterial()).append("\t");
                texto.append((CharSequence)sid);
                texto.append(Funcoes.preencheVazio(exameFilho.getTubo(), "0", ParametrosGerais.getDigitosTuboTubo(), 1));
                texto.append("\t");
                texto.append(exameFilho.getCodigoAlternativo()).append("\t");
                texto.append("T15").append("\n");
            }
        }
        return texto.toString();
    }

    public String getFilCodigo() {
        return this.filCodigo;
    }

    public String getReqCodigo() {
        return this.reqCodigo;
    }

    public String getRecCodigo() {
        return this.recCodigo;
    }

    public String getMcoCodigo() {
        return this.mcoCodigo;
    }

    public String getIntCodigo() {
        return this.intCodigo;
    }

    public List<ExameRequisicaoArquivo> getExames() {
        return this.exames;
    }

    public void setEtiquetaApoiado(DescritorCodigoEtiqueta etiquetaApoiado) {
        this.etiquetaApoiado = etiquetaApoiado;
    }
}

